/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;

public class CheckReportItem {
    private final String key;
    private final String[] msgs;
    private final int state;
    private final int level;
    private final IMetaDataPK pk;
    private final BOSObjectType bosType;
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int FATAL = 2;
    public static final int SUCCEED = 0;
    public static final int REF_OBJECT_NOT_EXIST = 1;
    public static final int REF_OBJECT_NOT_INTEGRETY = 2;
    public static final int REF_OBJECT_TYPE_MISMATCH = 3;
    public static final int REF_CHILDOBJECT_NOT_EXIST = 4;
    public static final int OBJECT_NOT_EXIST = 5;
    public static final int XML_SCHEMA_ERROR = 6;
    public static final int XML_SCHEMA_WARNING = 7;
    public static final int XML_SCHEMA_FATAL = 8;
    public static final int CANNOT_LOAD_OBJECT_METADATA = 9;
    public static final int CANNOT_LOAD_OBJECT = 10;
    public static final int OBJECT_VALIDATE_FAILURE = 11;
    public static final int DUBLICATE_BOSTYPE = 12;

    public CheckReportItem(int level, IMetaDataPK pk, BOSObjectType bosType, String key, int state, String[] msgs) {
        this.key = key;
        this.state = state;
        this.msgs = msgs;
        this.pk = pk;
        this.level = level;
        this.bosType = bosType;
    }

    public String getKey() {
        return this.key;
    }

    public int getState() {
        return this.state;
    }

    public int getLevel() {
        return this.level;
    }

    public IMetaDataPK getMetaDataPK() {
        return this.pk;
    }

    public BOSObjectType getMetaDataType() {
        return this.bosType;
    }

    public String[] getMessages() {
        return this.msgs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("key=").append(this.key).append(";");
        sb.append("level=").append(this.level).append(";");
        sb.append("pk=").append(this.pk.getFullName()).append(";");
        sb.append("bosType=").append(this.bosType.toString()).append(";");
        sb.append("state=").append(this.convertSateEnum2String()).append(";");
        sb.append("message=").append(StringUtils.arrayToString((Object[])this.msgs, (String)",")).append(";");
        return sb.toString();
    }

    private String convertSateEnum2String() {
        switch (this.state) {
            case 10: {
                return "CANNOT_LOAD_OBJECT";
            }
            case 9: {
                return "CANNOT_LOAD_OBJECT_METADATA";
            }
            case 12: {
                return "DUBLICATE_BOSTYPE";
            }
            case 5: {
                return "OBJECT_NOT_EXIST";
            }
            case 11: {
                return "OBJECT_VALIDATE_FAILURE";
            }
            case 4: {
                return "REF_CHILDOBJECT_NOT_EXIST";
            }
            case 1: {
                return "REF_OBJECT_NOT_EXIST";
            }
            case 2: {
                return "REF_OBJECT_NOT_INTEGRETY";
            }
            case 3: {
                return "REF_OBJECT_TYPE_MISMATCH";
            }
            case 0: {
                return "SUCCEED";
            }
            case 6: {
                return "XML_SCHEMA_ERROR";
            }
            case 8: {
                return "XML_SCHEMA_FATAL";
            }
            case 7: {
                return "XML_SCHEMA_WARNING";
            }
        }
        return "";
    }

    public String getStateDescription() {
        return this.toString();
    }
}

