/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.xml.CheckReportFilter;
import com.kingdee.bos.dao.xml.CheckReportItem;
import com.kingdee.bos.dao.xml.ICheckReport;
import com.kingdee.bos.dao.xml.XMLChecker;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import java.io.OutputStream;
import java.io.PrintStream;

abstract class Checker {
    protected final BOSObjectType type;
    protected final IObjectPK pk;
    protected final AbstractMetaDataValue vo;
    protected final CheckReportFilter filter;
    protected final ICheckReport report;
    protected final OutputStream os;
    protected final XMLChecker checker;

    Checker(XMLChecker checker, BOSObjectType type, IObjectPK pk, CheckReportFilter filter, ICheckReport report, OutputStream os) {
        this.pk = pk;
        this.vo = null;
        this.checker = checker;
        this.type = type;
        this.filter = filter;
        this.report = report;
        this.os = os;
    }

    Checker(XMLChecker checker, BOSObjectType type, AbstractMetaDataValue ui, CheckReportFilter filter, ICheckReport report, OutputStream os) {
        this.pk = MetaDataPK.create(ui.getFullName());
        this.vo = ui;
        this.checker = checker;
        this.type = type;
        this.filter = filter;
        this.report = report;
        this.os = os;
    }

    void doCheck() {
        CheckReportItem[] items = this.check();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (this.filter != null && !this.filter.accept(items[i])) continue;
                assert (this.os != null || this.report != null) : "OutputStream and Report cannot both be null!";
                if (this.report != null) {
                    this.report.addItem(items[i]);
                }
                if (this.os == null) continue;
                PrintStream ps = new PrintStream(this.os);
                ps.println("CheckObject: " + items[i].getKey() + "\tState: " + items[i].getState());
                if (items[i].getMessages() == null) continue;
                String[] msgs = items[i].getMessages();
                for (int j = 0; j < msgs.length; ++j) {
                    ps.println("    " + msgs[j]);
                }
            }
        }
    }

    abstract CheckReportItem[] check();
}

