/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.MemoryTools;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.upgrade.FileUtil;
import com.kingdee.bos.metadata.upgrade.Solution;
import com.kingdee.bos.metadata.upgrade.SolutionTravel;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;

public class TestMetadataLoaderBaseline {
    public static void main(String[] args) throws Exception {
        String metapath;
        File file;
        if (args.length != 1) {
            System.err.println("Need Metadata Path.");
            System.exit(-1);
        }
        if (!(file = new File(metapath = args[0])).exists()) {
            System.err.println("Metadata Path[" + metapath + "] not exist.");
            System.exit(1);
        }
        System.out.println("\nMetadata Path = " + file.getCanonicalPath());
        String mmExample = "/metametadata/entity/entityObject.entity";
        URL mmUrl = TestMetadataLoaderBaseline.class.getResource("/metametadata/entity/entityObject.entity");
        System.out.println("URL for Metameta example path = " + mmUrl.toString());
        long memoryMark = MemoryTools.getUsedMemory();
        System.out.println("\nPrepare Context ... ");
        Context ctx = new Context();
        Locale l = new Locale("l2");
        ctx.put((Object)"METADATAPATH", (Object)metapath);
        ctx.setLocale(l);
        ContextUtils.setLocaleToEnv(l);
        ContextManager.setContext(ctx);
        MetaDataLoaderFactory.setClientMetaDataPath(metapath);
        long start = 0L;
        start = System.currentTimeMillis();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        System.out.println("Prepare Loader and Load Metameta used " + (System.currentTimeMillis() - start) + " ms.");
        start = System.currentTimeMillis();
        Solution s = new Solution(metapath);
        System.out.println("Prepare Solution used " + (System.currentTimeMillis() - start) + " ms.");
        System.out.println("\nStart metadat load ... ");
        int numCount = 0;
        start = System.currentTimeMillis();
        Enumeration en = s.getEntrys();
        while (en.hasMoreElements()) {
            String entry = (String)en.nextElement();
            if (StringUtils.isEmpty((String)entry) || entry.endsWith("/") || entry.indexOf("CVS/") != -1 || entry.endsWith(".properties") || entry.endsWith(".txt") || entry.endsWith("/MANIFEST.MF") || entry.indexOf("/.") != -1) continue;
            try {
                IMetaDataPK pk = FileUtil.entry2PK(entry);
                BOSObjectType type = SolutionTravel.getMetaBOSObjectType(entry);
                IObjectValue value = loader.get(type, pk);
                ((AbstractMetaDataValue)value).getAlias();
                if (++numCount % 100 != 0) continue;
                System.out.print(numCount + " . ");
            }
            catch (Exception _) {
                System.err.println("Entry[" + entry + "] load error.");
                _.printStackTrace();
            }
        }
        System.out.println("\nTotal loaded metadat count = " + numCount);
        System.out.println("Load Metadata used " + (System.currentTimeMillis() - start) + " ms.");
        System.out.println("Metadata Memory used " + (MemoryTools.getUsedMemory() - memoryMark) + " bytes.");
    }
}

