/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.config.DynamicMetadataCollection;
import com.kingdee.bos.config.DynamicMetadataInfo;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.PKIndexs;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.DynamicMetadataProviderManager;
import com.kingdee.bos.metadata.configure.IDBConfigMDDownloader;
import com.kingdee.bos.metadata.configure.IDynamicMetadataProvider;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.util.XmlUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Document;

public class DBConfigureResourceLoader {
    private static Logger logger = Logger.getLogger(DBConfigureResourceLoader.class);
    private static IDBConfigMDDownloader mdd;

    public static InputStream[] getResourceAsStream(IMetaDataPK pk, BOSObjectType type) throws BOSException {
        return DBConfigureResourceLoader.getResourceAsStream(pk, type, null);
    }

    private static IDBConfigMDDownloader getMDDownloader() {
        if (mdd == null) {
            String url = ORMRPCServiceLocator.getCurrentServiceURL();
            if (url == null) {
                url = "tcp://localhost";
            }
            mdd = (IDBConfigMDDownloader)BOSObjectFactory.getRemoteBOSObjectFactory(url).getSession().createObject("com.kingdee.bos.metadata.configure.DBConfigMDDownloader", IDBConfigMDDownloader.class);
        }
        return mdd;
    }

    private static IDBConfigMDDownloader regetMDDownloader() {
        mdd = null;
        return DBConfigureResourceLoader.getMDDownloader();
    }

    public static List getDynamicMetadatas(IMetaDataPK pk, BOSObjectType type, Project.Projects depends) throws BOSException {
        if (pk == null || type == null) {
            return null;
        }
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return null;
        }
        if (!MDContextFactory.getSystemMDContext().pkIndexs.isExistInDB(type, pk, depends)) {
            return null;
        }
        if (ConfigMDUtil.isClient()) {
            List orderedDmi = null;
            try {
                orderedDmi = DBConfigureResourceLoader.getMDDownloader().getResource(pk, type, depends);
            }
            catch (Exception e) {
                orderedDmi = DBConfigureResourceLoader.regetMDDownloader().getResource(pk, type, depends);
            }
            return orderedDmi;
        }
        depends = Project.Projects.getProjects(depends);
        Project[] prjs = depends.getAssartValue();
        if (depends.isExluedeAwaysOn() && Project.Projects.isEmpty(prjs)) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(pk.getFullName());
        StringBuffer oql = new StringBuffer();
        oql.append("where FmetaDataPK=");
        oql.append(" ? ");
        oql.append(" and FbosType ");
        oql.append(DBConfigureResourceLoader.getCondition(type, params));
        oql.append(" and FprojectID in (");
        if (!depends.isExluedeAwaysOn()) {
            oql.append("'");
            oql.append("always_on");
            oql.append("',");
        }
        if (prjs != null && prjs.length > 0) {
            for (int i = 0; i < prjs.length; ++i) {
                oql.append("'");
                oql.append(prjs[i].getId());
                oql.append("',");
            }
        }
        oql.replace(oql.length() - 1, oql.length(), ")");
        Context ctx = ConfigMDUtil.getContext();
        StringBuffer sb = new StringBuffer("SELECT \"T0\".\"FID\" \"id\", \"T0\".\"FMETADATAPK\" \"metaDataPK\", \"T0\".\"FBOSTYPE\" \"bosType\", \"T0\".\"FSEGMENT\" \"segment\", \"T0\".\"FPROJECTID\" \"projectID\", \"T0\".\"FISAFFECTMDBVIEW\" \"isAffectMdbview\" FROM \"T_CON_DYNAMICMETADATA\" \"T0\" ");
        sb.append(oql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params.toArray());
        DynamicMetadataCollection dmc = new DynamicMetadataCollection();
        try {
            Blob segment = null;
            while (rs.next()) {
                DynamicMetadataInfo dmi = new DynamicMetadataInfo();
                dmi.setId(BOSUuid.read((String)rs.getString("id")));
                dmi.setMetaDataPK(rs.getString("metaDataPK"));
                dmi.setBosType(rs.getString("bosType"));
                segment = rs.getBlob("segment");
                if (segment != null) {
                    dmi.setSegment(segment.getBytes(1L, (int)segment.length()));
                }
                dmi.setProjectID(rs.getString("projectID"));
                dmi.setIsAffectMdbview(rs.getBoolean("isAffectMdbview"));
                dmc.add(dmi);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (dmc == null || dmc.size() == 0) {
            return null;
        }
        ArrayList<DynamicMetadataInfo> orderedDmi = new ArrayList<DynamicMetadataInfo>();
        if (Project.Projects.isEmpty(prjs)) {
            for (int j = 0; j < dmc.size(); ++j) {
                DynamicMetadataInfo dmi = dmc.get(j);
                orderedDmi.add(dmi);
            }
        } else {
            for (int j = 0; j < dmc.size(); ++j) {
                DynamicMetadataInfo dmi = dmc.get(j);
                if (!"always_on".equals(dmi.getProjectID())) continue;
                orderedDmi.add(dmi);
                break;
            }
            block8: for (int i = 0; i < prjs.length; ++i) {
                for (int j = 0; j < dmc.size(); ++j) {
                    DynamicMetadataInfo dmi = dmc.get(j);
                    if (!prjs[i].getId().equals(dmi.getProjectID())) continue;
                    orderedDmi.add(dmi);
                    continue block8;
                }
            }
        }
        return orderedDmi;
    }

    public static InputStream[] getResourceAsStream(IMetaDataPK pk, BOSObjectType type, Project.Projects depends) throws BOSException {
        return DBConfigureResourceLoader.transform(DBConfigureResourceLoader.getDynamicMetadatas(pk, type, depends));
    }

    private static InputStream[] transform(List orderedDmi) {
        if (orderedDmi == null) {
            return null;
        }
        InputStream[] rtv = new InputStream[orderedDmi.size()];
        for (int i = 0; i < rtv.length; ++i) {
            byte[] segment = ((DynamicMetadataInfo)orderedDmi.get(i)).getSegment();
            try {
                byte[] temp = new String(segment, "utf-8").getBytes("utf-8");
                segment = temp;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            rtv[i] = new ByteArrayInputStream(segment);
        }
        return rtv;
    }

    public static Map getMetaDataPKs() throws BOSException {
        return DBConfigureResourceLoader.getMetaDataPKs(null);
    }

    public static Map getMetaDataPKs(Project.Projects depends) throws BOSException {
        return DBConfigureResourceLoader.getMetaDataPKs(depends, false);
    }

    public static Map getMetaDataPKs(Project.Projects depends, boolean onlyDepends) throws BOSException {
        if (ConfigMDUtil.isClient()) {
            try {
                return DBConfigureResourceLoader.getMDDownloader().getMetaDataPKs(depends);
            }
            catch (Exception e) {
                return DBConfigureResourceLoader.regetMDDownloader().getMetaDataPKs(depends);
            }
        }
        Project.Projects prjs = Project.Projects.getProjects(depends);
        Project[] ps = onlyDepends ? prjs.getValue() : prjs.getAssartValue();
        StringBuffer oql = new StringBuffer();
        oql.append("select FmetaDataPK,FbosType from T_CON_DYNAMICMETADATA where FprojectID in (");
        oql.append("'");
        oql.append("always_on");
        oql.append("',");
        if (ps != null) {
            for (int i = 0; i < ps.length; ++i) {
                String id = ps[i].getId();
                if (id == null) continue;
                oql.append("'");
                oql.append(id);
                oql.append("',");
            }
        }
        oql.replace(oql.length() - 1, oql.length(), ")");
        Context ctx = ConfigMDUtil.getContext();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        HashMap<BOSObjectType, HashSet<MetaDataPK>> typeToPks = new HashMap<BOSObjectType, HashSet<MetaDataPK>>();
        try {
            while (rs.next()) {
                BOSObjectType type = BOSObjectType.create((String)rs.getString("FbosType"));
                HashSet<MetaDataPK> pks = (HashSet<MetaDataPK>)typeToPks.get(type);
                if (pks == null) {
                    pks = new HashSet<MetaDataPK>();
                    typeToPks.put(type, pks);
                }
                pks.add(MetaDataPK.create(rs.getString("FmetaDataPK")));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
        return typeToPks.size() == 0 ? null : typeToPks;
    }

    public static Map getMetaDataPKsAffectMdbview() throws BOSException {
        return DBConfigureResourceLoader.getMetaDataPKsAffectMdbview(null);
    }

    public static Map getMetaDataPKsAffectMdbview(Project.Projects depends) throws BOSException {
        if (ConfigMDUtil.isClient()) {
            try {
                return DBConfigureResourceLoader.getMDDownloader().getMetaDataPKsAffectMdbview(depends);
            }
            catch (Exception e) {
                return DBConfigureResourceLoader.regetMDDownloader().getMetaDataPKsAffectMdbview(depends);
            }
        }
        Project.Projects prjs = Project.Projects.getProjects(depends);
        Project[] ps = prjs.getAssartValue();
        StringBuffer oql = new StringBuffer();
        oql.append("select metaDataPK,bosType where isAffectMdbview=1 and projectID in (");
        oql.append("'");
        oql.append("always_on");
        oql.append("',");
        if (ps != null) {
            for (int i = 0; i < ps.length; ++i) {
                String id = ps[i].getId();
                if (id == null) continue;
                oql.append("'");
                oql.append(id);
                oql.append("',");
            }
        }
        oql.replace(oql.length() - 1, oql.length(), ")");
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return null;
        }
        DynamicMetadataCollection dmc = dmp.getCollection(oql.toString());
        if (dmc == null || dmc.size() == 0) {
            return null;
        }
        HashMap<BOSObjectType, HashSet<MetaDataPK>> typeToPks = new HashMap<BOSObjectType, HashSet<MetaDataPK>>();
        for (int j = 0; j < dmc.size(); ++j) {
            DynamicMetadataInfo dmi = dmc.get(j);
            BOSObjectType type = BOSObjectType.create((String)dmi.getBosType());
            HashSet<MetaDataPK> pks = (HashSet<MetaDataPK>)typeToPks.get(type);
            if (pks == null) {
                pks = new HashSet<MetaDataPK>();
                typeToPks.put(type, pks);
            }
            pks.add(MetaDataPK.create(dmi.getMetaDataPK()));
        }
        return typeToPks;
    }

    public static String getResource(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        if (p == null || pk == null || type == null) {
            return "";
        }
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return "";
        }
        if (ConfigMDUtil.isClient()) {
            try {
                return DBConfigureResourceLoader.getMDDownloader().getResource(p, pk, type);
            }
            catch (Exception e) {
                return DBConfigureResourceLoader.regetMDDownloader().getResource(p, pk, type);
            }
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where projectID in ('");
        oql.append(p.getId());
        oql.append("')");
        oql.append(" and bosType ");
        oql.append(DBConfigureResourceLoader.getCondition(type));
        oql.append(" and metaDataPK='");
        oql.append(pk.getFullName());
        oql.append("'");
        DynamicMetadataCollection dmc = dmp.getCollection(oql.toString());
        if (dmc == null || dmc.size() == 0) {
            return "";
        }
        ArrayList<DynamicMetadataInfo> orderedDmi = new ArrayList<DynamicMetadataInfo>();
        for (int j = 0; j < dmc.size(); ++j) {
            DynamicMetadataInfo dmi = dmc.get(j);
            orderedDmi.add(dmi);
        }
        InputStream[] iss = DBConfigureResourceLoader.transform(orderedDmi);
        Document doc = XMLParser.parseXML((InputStream)iss[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtils.output(doc, baos);
        return baos.toString("UTF-8");
    }

    public static String getCondition(BOSObjectType type) {
        List<BOSObjectType> types = PKIndexs.getPolymType(type);
        int size = types.size();
        if (size == 1) {
            return "='" + type + "'";
        }
        StringBuffer c = new StringBuffer("in (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                c.append(",");
            }
            c.append("'");
            c.append(types.get(i));
            c.append("'");
        }
        c.append(")");
        return c.toString();
    }

    private static String getCondition(BOSObjectType type, List<Object> params) {
        List<BOSObjectType> types = PKIndexs.getPolymType(type);
        int size = types.size();
        if (size == 1) {
            params.add(type.toString());
            return "= ? ";
        }
        StringBuffer c = new StringBuffer("in (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                c.append(",");
            }
            params.add(types.get(i).toString());
            c.append(" ? ");
        }
        c.append(")");
        return c.toString();
    }

    public static void deleteMetadata(Project p, IMetaDataPK pk, BOSObjectType type) throws Exception {
        if (p == null || pk == null || type == null) {
            return;
        }
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return;
        }
        if (ConfigMDUtil.isClient()) {
            try {
                DBConfigureResourceLoader.getMDDownloader().deleteMetadata(p, pk, type);
            }
            catch (Exception e) {
                DBConfigureResourceLoader.regetMDDownloader().deleteMetadata(p, pk, type);
            }
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where metaDataPK='");
        oql.append(pk.getFullName());
        oql.append("'");
        oql.append(" and bosType ");
        oql.append(DBConfigureResourceLoader.getCondition(type));
        oql.append(" and projectID in ('");
        oql.append(p.getId());
        oql.append("')");
        dmp.deleteDynamicMetadata(oql.toString());
    }

    public static void saveResource(Project p, IMetaDataPK pk, BOSObjectType type, String xml) throws Exception {
        if (p == null || pk == null || type == null) {
            return;
        }
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return;
        }
        if (ConfigMDUtil.isClient()) {
            try {
                DBConfigureResourceLoader.getMDDownloader().saveResource(p, pk, type, xml);
            }
            catch (Exception e) {
                DBConfigureResourceLoader.regetMDDownloader().saveResource(p, pk, type, xml);
            }
            return;
        }
        if (StringUtils.isEmpty((String)xml)) {
            DBConfigureResourceLoader.deleteMetadata(p, pk, type);
            return;
        }
        XmlUtils.verify(xml);
        StringBuffer oql = new StringBuffer();
        oql.append("where metaDataPK='");
        oql.append(pk.getFullName());
        oql.append("'");
        oql.append(" and bosType ");
        oql.append(DBConfigureResourceLoader.getCondition(type));
        oql.append(" and projectID in ('");
        oql.append(p.getId());
        oql.append("')");
        DynamicMetadataInfo dmi = new DynamicMetadataInfo();
        dmi.setMetaDataPK(pk.getFullName());
        dmi.setBosType(type.toString());
        dmi.setSegment(xml.getBytes("UTF-8"));
        dmi.setProjectID(p.getId());
        dmi.setIsAffectMdbview(true);
        boolean exist = dmp.exists(oql.toString());
        if (exist) {
            DynamicMetadataInfo existDmi = dmp.getValue(oql.toString());
            dmi.setId(existDmi.getId());
            dmp.update(new ObjectUuidPK(existDmi.getId()), dmi);
        } else {
            dmp.addnew(dmi);
        }
    }
}

