/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.BOSRuntimeEnv;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.ConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.Current;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.DocumentStateEnum;
import com.kingdee.bos.dao.xml.impl.DynamicStateManager;
import com.kingdee.bos.dao.xml.impl.ILoaderProvider;
import com.kingdee.bos.dao.xml.impl.IMDCache;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.InnerMDLoader;
import com.kingdee.bos.dao.xml.impl.InnerMDLoaderFacade;
import com.kingdee.bos.dao.xml.impl.MDCache;
import com.kingdee.bos.dao.xml.impl.MDFinderFacade;
import com.kingdee.bos.dao.xml.impl.MDParser;
import com.kingdee.bos.dao.xml.impl.MDSmartCache;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataResourceLoader;
import com.kingdee.bos.dao.xml.impl.MetametaInitializer;
import com.kingdee.bos.dao.xml.impl.StateProxyManager;
import com.kingdee.bos.hotdeploy.WatchDog;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.HostType;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MDPath;
import com.kingdee.bos.metadata.MDSetting;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.clientprefetch.IMetaDataVistor;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom.Element;

public final class MDLoader {
    private static final Logger logger = Logger.getLogger(MDLoader.class);
    private final IBuddyObject buddy;
    final long metametadataLoadTime;
    long metadataLoadTime = 0L;
    boolean useCache = false;
    XMLLoader metaLoader;
    IMDCache binaryCache;
    MDParser parser;
    public MetaDataClassLoader cl;
    private Current current;
    private InnerMDLoaderFacade innerMDLoader;
    private MDFinderFacade mdDefiner;
    private IMetaDataVistor vistor;
    private static volatile MDLoader loader = null;
    public final MDSetting mdSetting;

    public void setMetaDataVistor(IMetaDataVistor vistor) {
        this.vistor = vistor;
    }

    public Current getCurrent() {
        return this.current;
    }

    public void setCurrent(Current current) {
        this.current = current;
    }

    public static synchronized MDLoader createInstance(Context ctx) {
        if (loader == null) {
            loader = new MDLoader(ctx);
        }
        return loader;
    }

    public static MDLoader getInstance() {
        if (loader == null) {
            throw new IllegalStateException("call createInstance(Context ctx) first.");
        }
        return loader;
    }

    private MDLoader(Context ctx) {
        logger.info((Object)"Init metadata setting ... ");
        if (ConfigMDUtil.isClient()) {
            ctx.put(HostType.class, (Object)MDHostType.RUNTIME_CLIENT);
            ContextManager.setContext(ctx);
        } else {
            ctx.put(HostType.class, (Object)MDHostType.RUNTIME_SERVER);
        }
        this.mdSetting = MDSetting.synchronize(ctx);
        MDPath mdPath = this.mdSetting.getMetadataPath();
        logger.info((Object)("Metadata Paths= " + mdPath.source));
        long time = System.currentTimeMillis();
        this.cl = new MetadataResourceLoader(this.mdSetting);
        logger.info((Object)("MetaData classloader inited. spent " + (System.currentTimeMillis() - time) + " ms."));
        LowTimer timer = new LowTimer();
        Context foo = new Context();
        foo.put((Object)"METADATAPATH", (Object)"");
        logger.info((Object)"Init MetaMetaData Engine ... ");
        this.metaLoader = new XMLLoader(foo, new MetaDataClassLoader(true));
        this.initCacheConfig(mdPath.source, mdPath.paths);
        this.metametadataLoadTime = timer.msValue();
        this.parser = new MDParser(this);
        InnerLoaderProvider loaderProvider = new InnerLoaderProvider();
        this.innerMDLoader = InnerMDLoaderFacade.getInstance(loaderProvider);
        this.mdDefiner = MDFinderFacade.getInstance(loaderProvider);
        if (BOSRuntimeEnv.PERMISSION_AUTO_DEPLOY) {
            try {
                String path = this.getStatagePath();
                if (!StringUtils.isEmpty((String)path)) {
                    WatchDog dog = new WatchDog(this.getStatagePath(), this, 5000L);
                    dog.start();
                    logger.info((Object)"Auto Deployer Watch Dog Started.");
                }
            }
            catch (Exception _) {
                // empty catch block
            }
        }
        MDContextFactory.clearRemoteInstance();
        this.buddy = BuddyObjectFactory.getInstance((Object)this);
        this.buddy.initialize();
    }

    private void initCacheConfig(String origPath, String[] metadataPaths) {
        long time = System.currentTimeMillis();
        String useCacheCfg = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty("metadata.cache.enabled");
                }
                catch (Exception _) {
                    return null;
                }
            }
        });
        File cacheDir = null;
        try {
            if ("true".equalsIgnoreCase(useCacheCfg)) {
                cacheDir = this.getCacheDir(origPath);
                File metaCacheDir = new File(cacheDir, ".meta");
                File metaCacheFile = null;
                try {
                    Map metameta;
                    metaCacheFile = new File(metaCacheDir, "metameta.cache");
                    ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(metaCacheFile)));
                    this.metaLoader.metas = metameta = (Map)ois.readObject();
                    ois.close();
                }
                catch (Exception _) {
                    this.initMetameta();
                    try {
                        if (!metaCacheDir.exists()) {
                            metaCacheDir.mkdirs();
                        }
                        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(metaCacheFile)));
                        oos.writeObject(this.metaLoader.metas);
                        oos.flush();
                        oos.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex, (Throwable)ex);
                    }
                }
                this.useCache = true;
            } else {
                this.initMetameta();
            }
            logger.info((Object)("MetaMetaData Inited. spent " + (System.currentTimeMillis() - time) + " ms."));
        }
        catch (Exception _) {
            logger.error((Object)"Meta(Meta)Data Engine init error.", (Throwable)_);
        }
        if (this.useCache) {
            logger.info((Object)("MDCache dir is: " + cacheDir.getAbsolutePath()));
            logger.info((Object)"Start MDCache ... ");
            time = System.currentTimeMillis();
            boolean useSmartCache = false;
            try {
                File pathFile = new File(metadataPaths[0]);
                if (pathFile.isDirectory()) {
                    useSmartCache = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (useSmartCache) {
                try {
                    File srcFile = new File(metadataPaths[0]);
                    MDSmartCache sc = new MDSmartCache(cacheDir, srcFile, this);
                    this.binaryCache = sc;
                    sc.start();
                }
                catch (Exception e) {
                    this.binaryCache = null;
                }
            }
            if (this.binaryCache == null) {
                try {
                    this.binaryCache = new MDCache(cacheDir, this.cl);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.binaryCache != null) {
                logger.info((Object)("MDCache started. spent" + (System.currentTimeMillis() - time) + " ms."));
            }
        }
    }

    private void initMetameta() {
        MetametaInitializer.init(this.metaLoader);
    }

    private String getStatagePath() {
        return System.getProperty("bos.hotdeploy.dir");
    }

    private File getCacheDir(String path) {
        try {
            URL mdmdurl = this.metaLoader.getMetaDataClassLoader().getResource("/metametadata/entity/entityObject.entity");
            int hc = mdmdurl.toURI().hashCode() + path.hashCode();
            final String hcstr = Integer.toHexString(hc);
            File cacheDir = AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    String tmp = System.getProperty("java.io.tmpdir");
                    File tt = new File(new File(tmp), "BOSMDCache/" + hcstr);
                    if (!tt.exists()) {
                        if (tt.mkdirs()) {
                            return tt;
                        }
                        logger.error((Object)("Create Metadata Cache Dir[" + tt.getPath() + "] FALSE."));
                        return null;
                    }
                    return tt;
                }
            });
            if (cacheDir != null) {
                return cacheDir.getCanonicalFile();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can NOT create a Metadata Cache Dir.", (Throwable)e);
        }
        return null;
    }

    public XMLLoader getMetametaLoader() {
        return this.metaLoader;
    }

    public ConfigureResourceLoader getConfigureResourceLoader() {
        return ConfigureResourceLoader.getInstance(ConfigMDUtil.getContext());
    }

    public AbstractMetaDataValue loadMD(MetaDataPK2 pk2) {
        if (this.vistor != null) {
            this.vistor.visit(pk2.getURI());
        }
        return this.innerMDLoader.loadMD(pk2);
    }

    public AbstractMetaDataValue preFetchMD(MetaDataPK2 pk2) {
        return this.innerMDLoader.loadMD(pk2);
    }

    public AbstractMetaDataValue loadMDNoConfigure(MetaDataPK2 pk2) {
        return this.innerMDLoader.loadMDNoConfigure(pk2);
    }

    public AbstractMetaDataValue loadMDConfigure(MetaDataPK2 pk2) {
        return this.innerMDLoader.loadMDConfigure(pk2);
    }

    public AbstractMetaDataValue loadMD(MetaDataPK2 pk2, Project.Projects depends) {
        return this.innerMDLoader.loadMD(pk2, depends);
    }

    public IStateManager findMD(MetaDataPK2 pk2) throws DataAccessException {
        return this.findMD(pk2, DocumentStateEnum.WHOLE, null);
    }

    public IStateManager findMD(MetaDataPK2 pk2, DocumentStateEnum docState, Project.Projects projects) throws DataAccessException {
        IStateManager sm;
        if (this.vistor != null) {
            this.vistor.visit(pk2.getURI());
        }
        if (this.binaryCache != null && (sm = this.binaryCache.getEntry(pk2.getKey())) != null) {
            return sm;
        }
        LowTimer timer = new LowTimer();
        IStateManager parsedSM = this.mdDefiner.findMD(pk2, docState, projects);
        if (this.binaryCache != null) {
            this.binaryCache.forcePutEntry(pk2.getKey(), parsedSM);
        }
        this.metadataLoadTime += timer.msValue();
        return parsedSM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStateManager findMD4Mdbview(MetaDataPK2 pk2) throws DataAccessException {
        String path = pk2.getPath();
        InputStream is = this.cl.getResourceAsStream(path);
        BOSObjectType type = BOSObjectType.create((String)pk2.getType());
        IStateManager parsedSM = null;
        try {
            EntityObjectInfo meta = this.metaLoader.loadMeta(type);
            Element root = null;
            if (is != null) {
                root = XMLParser.parseXML((InputStream)is).getRootElement();
            } else {
                InputStream[] iss = DBConfigureResourceLoader.getResourceAsStream(pk2, BOSObjectType.create((String)pk2.getType()));
                if (iss != null && iss.length > 0) {
                    root = XMLParser.parseXML((InputStream)iss[0]).getRootElement();
                }
            }
            if (root == null) {
                logger.error((Object)("OnLoad CAN NOT find file for metadata[" + pk2.getKey() + "]"));
                IStateManager iStateManager = null;
                return iStateManager;
            }
            parsedSM = this.parser.parseMDFromDOM4Mdbview(meta, root);
        }
        catch (DataAccessException _) {
            logger.error((Object)("Can NOT find MetaMeta for BOSType[" + type + "]"), (Throwable)((Object)_));
            throw _;
        }
        catch (Exception e) {
            logger.error((Object)("Parse(while find) Entry error. metadata key=" + path), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        return parsedSM;
    }

    void loadDBConfig(DynamicStateManager dsm) throws Exception {
        MetaDataPK2 pk2 = dsm.getPk();
        if (!ConfigMDUtil.isNeedLoadConfig(pk2.getType(), pk2.getFullName())) {
            return;
        }
        BOSObjectType type = BOSObjectType.create((String)pk2.getType());
        EntityObjectInfo meta = null;
        try {
            meta = this.metaLoader.loadMeta(type);
        }
        catch (DataAccessException _) {
            logger.error((Object)("Can NOT find MetaMeta for BOSType[" + type + "]"), (Throwable)((Object)_));
            throw _;
        }
        boolean hasEx = false;
        InputStream[] iss = null;
        try {
            iss = DBConfigureResourceLoader.getResourceAsStream(pk2, BOSObjectType.create((String)pk2.getType()), dsm.getProjects());
        }
        catch (Exception e) {
            logger.error((Object)pk2, (Throwable)e);
            if (e instanceof NullPointerException) {
                throw e;
            }
            hasEx = true;
        }
        if (!hasEx) {
            String ais = ConfigMDUtil.getAIS();
            IStateManager temp = null;
            if (iss != null && iss.length > 0) {
                InputStream is = null;
                if (DocumentStateEnum.WHOLE.equals((Object)dsm.getDocState())) {
                    is = this.cl.getResourceAsStream(pk2.getPath());
                }
                temp = this.parser.parseMDFromStream(meta, is, iss, dsm.getProjects());
            }
            dsm.addSlaver(ais, temp);
        }
    }

    public EntityObjectInfo getObjectValueMeta(IObjectValue ov) throws DataAccessException {
        return this.metaLoader.loadMeta(ov.getBOSType(), ov);
    }

    public IObjectValue loadMDMeta(IObjectPK metaPK) throws DataAccessException {
        return this.metaLoader.loadMetametaData(metaPK);
    }

    public IObjectValue loadMDMeta(BOSObjectType bosType) throws DataAccessException {
        return this.metaLoader.loadMeta(bosType);
    }

    InputStream getSolutionStream() {
        IMetaDataPK[] pks = this.cl.getMDContext().pkIndexs.getMetaDataPKs(MetaDataTypeList.SOLUTION);
        assert (pks != null && pks.length > 0);
        if (pks == null || pks.length == 0) {
            if (MDHostType.RUNTIME_CLIENT.isSameType(this.mdSetting.getHostType())) {
                pks = new IMetaDataPK[]{MetaDataPK.create("eas")};
            } else {
                logger.error((Object)"Can NOT find xxx.solution metadata. Metadata can NOT init.");
                throw new IllegalArgumentException("Can NOT find xxx.solution metadata.");
            }
        }
        String rsName = null;
        rsName = pks[0].getPackage() == null ? "/" + pks[0].toString() + "." + "solution" : "/" + pks[0].getPackage().replace('.', '/') + '/' + pks[0].getName() + "." + "solution";
        InputStream is = this.cl.getResourceAsStream(rsName);
        if (is == null) {
            logger.error((Object)("Can NOT find solution metadata. Solution:" + pks[0]));
        }
        assert (is != null);
        return is;
    }

    public IObjectCollection getCollection(BOSObjectType bosType, String pkg, boolean deep) {
        return this.getCollection(bosType, pkg, deep, false);
    }

    public IObjectCollection getCollection(BOSObjectType bosType, String pkg, boolean deep, boolean validPackageAndName) {
        try {
            EntityObjectInfo meta = this.metaLoader.loadMeta(bosType);
            String ovClassName = meta.getObjectValueClass();
            Class<?> ovClazz = Class.forName(ovClassName);
            String ocClassName = meta.getObjectCollectionClass();
            Class<?> ocClazz = Class.forName(ocClassName);
            IObjectCollection rtv = (IObjectCollection)ocClazz.newInstance();
            String suffix = Utils.getMetaDataSuffix(bosType);
            bosType = BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix));
            IMetaDataPK[] pks = this.cl.getMDContext().pkIndexs.getMetaDataPKs(bosType, pkg, deep);
            for (int i = 0; i < pks.length; ++i) {
                AbstractMetaDataValue md;
                IMetaDataPK pk = pks[i];
                MetaDataPK2 pk2 = null;
                try {
                    pk2 = new MetaDataPK2(pk.getPackage(), pk.getName(), bosType.toString());
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                    pk2 = null;
                }
                if (pk2 == null || !ovClazz.isInstance(md = this.loadMD(pk2))) continue;
                if (!validPackageAndName) {
                    rtv.addObjectDirect(md);
                    continue;
                }
                String rp = md.getRealPackage();
                String rn = md.getRealName();
                if (pk2.getPackage().equals(rp) && pk2.getName().equals(rn)) {
                    rtv.addObjectDirect(md);
                    continue;
                }
                String fn = md.getString("name");
                if (!StringUtils.isEmpty((String)rp)) {
                    fn = rp + "." + fn;
                }
                logger.warn((Object)(fn + " in package: " + pk2.getPackage() + ", packageName or name is not matched!"));
            }
            rtv.updateIndex();
            return rtv;
        }
        catch (Exception _) {
            logger.fatal((Object)("Create CollectionInstance for type[" + bosType + "] error!"), (Throwable)_);
            return null;
        }
    }

    public IObjectCollection getCollectionExcludePackage(BOSObjectType bosType, List pkgs) {
        try {
            EntityObjectInfo meta = this.metaLoader.loadMeta(bosType);
            String ovClassName = meta.getObjectValueClass();
            Class<?> ovClazz = Class.forName(ovClassName);
            String ocClassName = meta.getObjectCollectionClass();
            Class<?> ocClazz = Class.forName(ocClassName);
            IObjectCollection rtv = (IObjectCollection)ocClazz.newInstance();
            String suffix = Utils.getMetaDataSuffix(bosType);
            bosType = BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix));
            IMetaDataPK[] pks = this.cl.getMDContext().pkIndexs.getMetaDataPKsExcludePackage(bosType, pkgs, null);
            for (int i = 0; i < pks.length; ++i) {
                IMetaDataPK pk = pks[i];
                MetaDataPK2 pk2 = new MetaDataPK2(pk.getPackage(), pk.getName(), bosType.toString());
                AbstractMetaDataValue md = this.loadMD(pk2);
                if (!ovClazz.isInstance(md)) continue;
                rtv.addObjectDirect(md);
            }
            rtv.updateIndex();
            return rtv;
        }
        catch (Exception _) {
            logger.fatal((Object)("Create CollectionInstance for type[" + bosType + "] error!"), (Throwable)_);
            return null;
        }
    }

    public IObjectCollection getConfigureCollection(BOSObjectType bosType, String pkg, boolean deep) {
        try {
            EntityObjectInfo meta = this.metaLoader.loadMeta(bosType);
            String ovClassName = meta.getObjectValueClass();
            Class<?> ovClazz = Class.forName(ovClassName);
            String ocClassName = meta.getObjectCollectionClass();
            Class<?> ocClazz = Class.forName(ocClassName);
            IObjectCollection rtv = (IObjectCollection)ocClazz.newInstance();
            String suffix = Utils.getMetaDataSuffix(bosType);
            bosType = BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix));
            IMetaDataPK[] pks = this.getConfigureResourceLoader().getMetaDataPKsByType(bosType, pkg, deep);
            for (int i = 0; i < pks.length; ++i) {
                IMetaDataPK pk = pks[i];
                MetaDataPK2 pk2 = new MetaDataPK2(pk.getPackage(), pk.getName(), bosType.toString());
                AbstractMetaDataValue md = this.loadMDConfigure(pk2);
                if (!ovClazz.isInstance(md)) continue;
                rtv.addObjectDirect(md);
            }
            rtv.updateIndex();
            return rtv;
        }
        catch (Exception _) {
            logger.fatal((Object)("Create CollectionInstance for type[" + bosType + "] error!"), (Throwable)_);
            return null;
        }
    }

    public void clearOv(String ovPath) {
        InnerMDLoader.clearOv(ovPath);
    }

    public void clearOv(String pk, String type) {
        InnerMDLoader.clearOv(pk, type);
    }

    public void clear(MetaDataPK2 pk2) {
        this.clear(pk2.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(String key) {
        MDLoader mDLoader = this;
        synchronized (mDLoader) {
            InnerMDLoader.clear(key);
            StateProxyManager.getInstance().remove(key);
            if (this.binaryCache != null) {
                this.binaryCache.clearEntry(key);
            }
        }
        MetadataCleaner.clear(key);
    }

    public void clear(BOSObjectType bosType) {
        InnerMDLoader.clear(bosType, new InnerMDLoader.Cleaner(){

            @Override
            public void clear(String key) {
                MDLoader.this.clear(key);
            }
        });
    }

    public int docSize() {
        return InnerMDLoader.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        MDLoader mDLoader = this;
        synchronized (mDLoader) {
            StateProxyManager.getInstance().clear();
            InnerMDLoader.clearAll();
            this.cl.getMDContext().clearAll();
            if (this.binaryCache != null) {
                this.binaryCache.clearAll();
            }
        }
        MetadataCleaner.clearAll();
    }

    public synchronized void close() {
        this.cl.close();
        loader = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private class InnerLoaderProvider
    implements ILoaderProvider {
        private InnerLoaderProvider() {
        }

        @Override
        public MDContext getMDContext() {
            return MDLoader.this.cl.getMDContext();
        }

        @Override
        public MetaDataClassLoader getMetaDataClassLoader() {
            return MDLoader.this.cl;
        }

        @Override
        public XMLLoader getMetaLoader() {
            return MDLoader.this.metaLoader;
        }

        @Override
        public String getSolutionName() {
            return MDLoader.this.parser.solutionName;
        }

        public boolean useCache() {
            return MDLoader.this.useCache;
        }

        @Override
        public ConfigureResourceLoader getConfigureResourceLoader() {
            return MDLoader.this.getConfigureResourceLoader();
        }

        @Override
        public MDParser getMDParser() {
            return MDLoader.this.parser;
        }
    }
}

