/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.impl.SortedProperties;
import com.kingdee.bos.util.XMLParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class MetadataIndexer {
    private static Set ALL_SUFFIXS = new HashSet();
    private static Logger logger;

    public static void index(File baseDir, String outDir) throws Exception {
        SortedProperties rtv = new SortedProperties();
        File[] jars = baseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".jar");
            }
        });
        MetadataIndexer.indexFiles(jars, rtv);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outDir, "index.lst")));
        rtv.store(os, "Metadata and BO Index");
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    public static void index(File[] paths, String outDir) throws Exception {
        SortedProperties rtv = new SortedProperties();
        MetadataIndexer.indexFiles(paths, rtv);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outDir, "index.lst")));
        rtv.store(os, "Metadata and BO Index");
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
    }

    private static void indexFiles(File[] sources, Properties result) throws Exception {
        for (int i = 0; i < sources.length; ++i) {
            File file = sources[i];
            if (file.isDirectory()) {
                MetadataIndexer.indexDir(file, result);
                continue;
            }
            if (!file.isFile()) continue;
            try {
                MetadataIndexer.indexJar(file, result);
                continue;
            }
            catch (IOException e) {
                logger.error((Object)("file: " + file.getAbsolutePath()));
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static void indexJar(File file, Properties result) throws IOException {
        BufferedInputStream is;
        ZipEntry jarEntry;
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> ee = jar.entries();
        while (ee.hasMoreElements()) {
            String suffix;
            JarEntry entry = ee.nextElement();
            String entryName = entry.getName();
            int pos = entryName.lastIndexOf(".");
            if (pos == -1 || !ALL_SUFFIXS.contains(suffix = entryName.substring(pos)) || result.containsKey(entryName)) continue;
            result.put(entryName, "NULL");
        }
        try {
            jarEntry = jar.getEntry("entity_pkmapping.properties");
            if (jarEntry != null) {
                is = new BufferedInputStream(jar.getInputStream(jarEntry));
                MetadataIndexer.overrideBO(is, result, ".entity");
            }
        }
        catch (Exception _) {
            logger.error((Object)_, (Throwable)_);
        }
        try {
            jarEntry = jar.getEntry("facade_pkmapping.properties");
            if (jarEntry != null) {
                is = new BufferedInputStream(jar.getInputStream(jarEntry));
                MetadataIndexer.overrideBO(is, result, ".facade");
            }
        }
        catch (Exception _) {
            logger.error((Object)_, (Throwable)_);
        }
        try {
            jar.close();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private static void indexDir(File file, Properties result) {
        BufferedInputStream is;
        Stack paths = new Stack();
        MetadataIndexer.indexDir0(file, result, paths);
        File temp = new File(file, "entity_pkmapping.properties");
        if (temp.exists()) {
            try {
                is = new BufferedInputStream(new FileInputStream(temp));
                MetadataIndexer.overrideBO(is, result, ".entity");
            }
            catch (Exception _) {
                logger.warn((Object)_, (Throwable)_);
            }
        }
        if ((temp = new File(file, "facade_pkmapping.properties")).exists()) {
            try {
                is = new BufferedInputStream(new FileInputStream(temp));
                MetadataIndexer.overrideBO(is, result, ".facade");
            }
            catch (Exception _) {
                logger.warn((Object)_, (Throwable)_);
            }
        }
    }

    private static void indexDir0(File file, Properties result, Stack paths) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File item = files[i];
            String name = item.getName();
            if (item.isFile()) {
                int pos = name.lastIndexOf(".");
                if (pos == -1) continue;
                String suffix = name.substring(pos + 1);
                String entryName = MetadataIndexer.paths2path(paths) + name;
                if (!ALL_SUFFIXS.contains(suffix) || result.containsKey(entryName)) continue;
                result.put(entryName, "NULL");
                continue;
            }
            if (!item.isDirectory()) continue;
            paths.push(name);
            MetadataIndexer.indexDir0(item, result, paths);
            paths.pop();
        }
    }

    private static String paths2path(Stack paths) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < paths.size(); ++i) {
            buff.append(paths.get(i));
            buff.append("/");
        }
        return buff.toString();
    }

    private static void overrideBO(InputStream is, Properties result, String suffix) throws IOException {
        Properties temp = new Properties();
        temp.load(is);
        is.close();
        for (Map.Entry<Object, Object> item : temp.entrySet()) {
            String type = (String)item.getKey();
            String pk = (String)item.getValue();
            result.put(pk.replaceAll("\\.", "/") + suffix, type);
        }
    }

    public static void main(String[] args) throws Exception {
        File dir = new File("D:/mdupgrade/upgrade/mn");
        String out = "e:\\";
        MetadataIndexer.processBOIndex(dir, out);
    }

    public static void processBOIndex(File mdDir, String outDir) throws Exception {
        logger.info((Object)"Start processBOIndex ...");
        SortedProperties entity = new SortedProperties();
        SortedProperties facade = new SortedProperties();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().equalsIgnoreCase("demo") || pathname.getName().endsWith(".entity") || pathname.getName().endsWith(".facade");
            }
        };
        MetadataIndexer.processBOIndex0(mdDir, filter, entity, facade);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(outDir, "entity_pkmapping.properties")));
        entity.store(os, "Entity pk <==> bosType");
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        os = new BufferedOutputStream(new FileOutputStream(new File(outDir, "facade_pkmapping.properties")));
        facade.store(os, "Facade pk <==> bosType");
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        logger.info((Object)"End processBOIndex.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processBOIndex0(File mdDir, FileFilter filter, Properties entity, Properties facade) {
        File[] children = mdDir.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            if (child.isDirectory()) {
                MetadataIndexer.processBOIndex0(child, filter, entity, facade);
                continue;
            }
            FileInputStream is = null;
            Element root = null;
            try {
                is = new FileInputStream(child);
                root = XMLParser.parseXML((InputStream)is).getRootElement();
                Namespace ns = root.getNamespace();
                String pkg = root.getChildText("package", ns);
                String name = root.getChildText("name", ns);
                String fullName = pkg + "." + name;
                String bosType = root.getChildText("bosType", ns);
                if (child.getName().endsWith("entity")) {
                    entity.put(bosType, fullName);
                    continue;
                }
                if (!child.getName().endsWith("facade")) continue;
                facade.put(bosType, fullName);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
    }

    static {
        ALL_SUFFIXS.add(".table");
        ALL_SUFFIXS.add(".relation");
        ALL_SUFFIXS.add(".solution");
        ALL_SUFFIXS.add(".bizdatatype");
        ALL_SUFFIXS.add(".enum");
        ALL_SUFFIXS.add(".exception");
        ALL_SUFFIXS.add(".resource");
        ALL_SUFFIXS.add(".imageresource");
        ALL_SUFFIXS.add(".query");
        ALL_SUFFIXS.add(".facade");
        ALL_SUFFIXS.add(".function");
        ALL_SUFFIXS.add(".rule");
        ALL_SUFFIXS.add(".ui");
        ALL_SUFFIXS.add(".ruleset");
        ALL_SUFFIXS.add(".bizunit");
        ALL_SUFFIXS.add(".datax");
        ALL_SUFFIXS.add(".biztemplate");
        ALL_SUFFIXS.add(".bizfieldtemplateset");
        ALL_SUFFIXS.add(".report");
        ALL_SUFFIXS.add(".entity");
        ALL_SUFFIXS.add(".integration");
        ALL_SUFFIXS.add(".eapp");
        ALL_SUFFIXS.add(".appnode");
        ALL_SUFFIXS.add(".appview");
        ALL_SUFFIXS.add(".service");
        ALL_SUFFIXS.add(".wfrole");
        ALL_SUFFIXS.add(".kdwf");
        ALL_SUFFIXS.add(".mutex");
        ALL_SUFFIXS.add(".permission");
        ALL_SUFFIXS.add(".mdquery");
        ALL_SUFFIXS.add(".log");
        ALL_SUFFIXS.add(".botmapping");
        ALL_SUFFIXS.add(".package");
        ALL_SUFFIXS.add(".mdbview");
        ALL_SUFFIXS.add(".event");
        ALL_SUFFIXS.add(".templateset");
        ALL_SUFFIXS.add(".webui");
        logger = Logger.getLogger(MetadataIndexer.class);
    }
}

