/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.xml.impl;

import com.kingdee.bos.dao.xml.impl.AccessQueue;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.MDMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class StateProxyManager {
    private static final StateProxyManager inst = new StateProxyManager();
    private final LRUMap proxys = new LRUMap();
    private final AccessQueue<IStateManager> queue = new AccessQueue();

    public static StateProxyManager getInstance() {
        return inst;
    }

    private StateProxyManager() {
        final SizeThreshold threshold = new SizeThreshold(new SizeThreshold.SizeGetter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int size() {
                LRUMap lRUMap = StateProxyManager.this.proxys;
                synchronized (lRUMap) {
                    return StateProxyManager.this.proxys.size();
                }
            }
        }, new SizeThreshold.MaxSizeChangedListener(){

            @Override
            public void larger() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void less() {
                LRUMap lRUMap = StateProxyManager.this.proxys;
                synchronized (lRUMap) {
                    StateProxyManager.this.proxys.clearPartial();
                }
            }
        });
        final DocProxyStateCleaner cleaner = new DocProxyStateCleaner();
        this.proxys.setHold(threshold);
        this.proxys.setCleaner(cleaner);
        MDMonitor.getInstance().addMonitor(new Runnable(){

            @Override
            public void run() {
                threshold.adjustByMemory();
                cleaner.finalClear();
            }
        }, 5000L);
        MDMonitor.getInstance().addMonitor(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccessQueue.Entry getter = StateProxyManager.this.queue.clear();
                while (getter != null) {
                    LRUMap lRUMap = StateProxyManager.this.proxys;
                    synchronized (lRUMap) {
                        IStateManager state = (IStateManager)StateProxyManager.this.proxys.get(getter.key);
                        if (state == null) {
                            StateProxyManager.this.proxys.put(getter.key, getter.value);
                        }
                    }
                    getter = getter.previous;
                }
            }
        }, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String uri, IStateManager state) {
        LRUMap lRUMap = this.proxys;
        synchronized (lRUMap) {
            this.proxys.put(uri, state);
        }
    }

    void get(String uri, IStateManager state) {
        this.queue.access(uri, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IStateManager remove(String uri) {
        LRUMap lRUMap = this.proxys;
        synchronized (lRUMap) {
            return (IStateManager)this.proxys.remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        LRUMap lRUMap = this.proxys;
        synchronized (lRUMap) {
            this.proxys.clear();
        }
    }

    int size() {
        return this.proxys.size();
    }

    static class LRUMap
    extends LinkedHashMap<String, IStateManager> {
        private static final long serialVersionUID = -2950495032806871521L;
        private Threshold hold;
        private IStateCleaner cleaner;

        LRUMap() {
            this(null, null);
        }

        LRUMap(Threshold hold, IStateCleaner cleaner) {
            super(16, 0.75f, true);
            this.hold = hold;
            this.cleaner = cleaner;
        }

        Threshold getHold() {
            return this.hold;
        }

        void setHold(Threshold hold) {
            this.hold = hold;
        }

        IStateCleaner getCleaner() {
            return this.cleaner;
        }

        void setCleaner(IStateCleaner cleaner) {
            this.cleaner = cleaner;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, IStateManager> arg0) {
            if (this.hold == null || this.cleaner == null) {
                return false;
            }
            if (this.hold.isExceed()) {
                this.cleaner.clear(arg0.getValue());
                return true;
            }
            return false;
        }

        void clearPartial() {
            int toRemove = this.hold.getUnit();
            while (this.hold.isExceed()) {
                Iterator ite = this.entrySet().iterator();
                for (int i = 0; ite.hasNext() && i < toRemove; ++i) {
                    Map.Entry entry = ite.next();
                    ite.remove();
                    this.cleaner.clear((IStateManager)entry.getValue());
                }
            }
        }
    }

    static interface Threshold {
        public boolean isExceed();

        public int getUnit();
    }

    static interface IStateCleaner {
        public void clear(IStateManager var1);
    }

    static class SizeThreshold
    implements Threshold {
        private static final int MIN = 1500;
        private static final int MAX = 50000;
        private static final float memoryMinSize = 0.2f;
        private static final float memoryMaxSize = 0.7f;
        private volatile float unitSize = 0.1f;
        private volatile int maxSize = 3000;
        private int unit;
        private final SizeGetter getter;
        private final MaxSizeChangedListener listener;

        SizeThreshold(SizeGetter getter, MaxSizeChangedListener listener) {
            this.getter = getter;
            this.listener = listener;
            this.computeUnit();
        }

        public void setMaxSize(int max) {
            boolean isLarger;
            boolean bl = isLarger = max > this.maxSize;
            this.maxSize = max < 1500 ? 1500 : (max > 50000 ? 50000 : max);
            if (max != 100000 && max != 750) {
                this.computeUnit();
            }
            if (isLarger) {
                if (this.maxSize != 50000) {
                    this.listener.larger();
                }
            } else if (this.maxSize != 1500) {
                this.listener.less();
            }
        }

        public void setUnitSize(float unit) {
            this.unitSize = unit;
            this.computeUnit();
        }

        @Override
        public boolean isExceed() {
            return this.getter.size() > this.maxSize;
        }

        @Override
        public synchronized int getUnit() {
            return this.unit;
        }

        private synchronized void computeUnit() {
            float f = (float)this.maxSize * this.unitSize;
            this.unit = new Float(f).intValue();
        }

        public void adjustByMemory() {
            long free = Runtime.getRuntime().freeMemory();
            long total = Runtime.getRuntime().totalMemory();
            long max = Runtime.getRuntime().maxMemory();
            float occupancy = (float)(max - total + free) / (float)max;
            if (occupancy < 0.2f) {
                this.setMaxSize(this.maxSize >> 1);
            } else if (occupancy > 0.7f) {
                this.setMaxSize(this.maxSize << 1);
            }
        }

        static interface MaxSizeChangedListener {
            public void larger();

            public void less();
        }

        static interface SizeGetter {
            public int size();
        }
    }

    static class DocProxyStateCleaner
    implements IStateCleaner {
        IStateCleaner next = null;
        private final List<IStateManager> lstToClear = new ArrayList<IStateManager>();

        DocProxyStateCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear(IStateManager proxy) {
            if (proxy != null) {
                List<IStateManager> list = this.lstToClear;
                synchronized (list) {
                    this.lstToClear.add(proxy);
                }
            }
            if (this.next != null) {
                this.next.clear(proxy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalClear() {
            if (this.lstToClear.size() > 0) {
                IStateManager[] sms;
                List<IStateManager> list = this.lstToClear;
                synchronized (list) {
                    sms = this.lstToClear.toArray(new IStateManager[0]);
                    this.lstToClear.clear();
                }
                for (int i = 0; i < sms.length; ++i) {
                    sms[i].clear();
                }
            }
        }
    }
}

