/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import com.kingdee.bos.engine.difftool.FileMetaInfo;
import com.kingdee.bos.engine.difftool.PathEntry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarPath
implements PathEntry {
    private final JarFile jar;
    private Map entrys = new HashMap();

    public JarPath(File file) throws IOException {
        this.jar = new JarFile(file);
    }

    @Override
    public void init() {
        Map seen = this.entrys;
        Enumeration<JarEntry> e = this.jar.entries();
        String entryName = null;
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            entryName = entry.getName();
            FileMetaInfo fmi = new FileMetaInfo();
            fmi.entryName = entryName;
            fmi.loader = this;
            fmi.length = entry.getSize();
            fmi.st = entry.getTime();
            seen.put(entryName, fmi);
        }
    }

    @Override
    public Map getEntrysMap() {
        return this.entrys;
    }

    @Override
    public InputStream getEntryInputStream(String name) throws IOException {
        ZipEntry entry = this.jar.getEntry(name);
        if (entry != null) {
            return new BufferedInputStream(this.jar.getInputStream(entry));
        }
        return null;
    }
}

