/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.difftool;

import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.difftool.FileMetaInfo;
import com.kingdee.bos.engine.difftool.KVItem;
import com.kingdee.bos.engine.difftool.LazyElement;
import com.kingdee.bos.engine.difftool.Log;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class XMLDiffer {
    private static final Logger logger = Logger.getLogger((String)"bos.metadata.diff.XMLDiff");
    private Log diffLog;
    private XMLLoader metaLoader;
    static final String DIFF_ATTR_KEY = "_DIFF_RESULT";
    static final String DIFF_VALUE_ATTR_KEY = "_DIFF_OLD_VALUE";
    static final String DIFF_ATTR_VALUE_A = "ADD";
    static final String DIFF_ATTR_VALUE_M = "MODIFY";
    static final String DIFF_ATTR_VALUE_D = "DELETE";

    private static JDOMFactory getJDOMFactory() {
        return new DefaultJDOMFactory();
    }

    XMLDiffer(XMLLoader metaLoader, Log log) {
        this.metaLoader = metaLoader;
        this.diffLog = log;
    }

    public boolean diff(FileMetaInfo fmi, Document dev, Document base) {
        String name = fmi.entryName;
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            String suffix = name.substring(pos + 1);
            String type = Utils.getBOSTypeBySuffix(suffix);
            BOSObjectType bostype = BOSObjectType.create((String)type);
            try {
                EntityObjectInfo meta = this.metaLoader.loadMeta(bostype);
                Document rtv = this.diff(meta, dev, base);
                if (rtv != null) {
                    this.diffLog.logFile(name, rtv);
                    return true;
                }
            }
            catch (MissingDAOMetaDataException e) {
                logger.error((Object)("\u65e0\u6cd5\u88c5\u5728\u5143\u6570\u636e\u7684\u5143\u5143\u6570\u636eFile: " + name), (Throwable)((Object)e));
            }
            catch (IOException e) {
                logger.error((Object)("\u8bb0\u5f55\u5143\u6570\u636ediff\u51fa\u73b0IO\u9519\u8befFile: " + name), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)("\u6bd4\u8f83\u5143\u6570\u636e\u9519\u8befFile: " + name), (Throwable)e);
            }
        }
        return false;
    }

    public Document diff(EntityObjectInfo meta, Document doc, Document base) throws Exception {
        TreeSet<KVItem> lkvs;
        boolean done = false;
        JDOMFactory domFactory = XMLDiffer.getJDOMFactory();
        Element baseRoot = base.getRootElement();
        Element mergedRoot = doc.getRootElement();
        Element pluginRoot = domFactory.element(baseRoot.getName(), baseRoot.getNamespace());
        LazyElement noLazyElement = new LazyElement();
        noLazyElement.node = pluginRoot;
        noLazyElement.lkvs = lkvs = new TreeSet<KVItem>();
        Element tempEle = null;
        String pkg = baseRoot.getChildTextTrim("package", baseRoot.getNamespace());
        tempEle = domFactory.element("package", pluginRoot.getNamespace());
        tempEle.setText(pkg);
        pluginRoot.addContent(tempEle);
        lkvs.add(new KVItem("package", pkg));
        String name = baseRoot.getChildTextTrim("name", baseRoot.getNamespace());
        tempEle = domFactory.element("name", pluginRoot.getNamespace());
        tempEle.setText(name);
        pluginRoot.addContent(tempEle);
        lkvs.add(new KVItem("name", name));
        Document rtvDom = domFactory.document(pluginRoot);
        EntityObjectInfo realMeta = this.reLocationMeta(meta, baseRoot.getName());
        Stack<LazyElement> parseCtx = new Stack<LazyElement>();
        parseCtx.push(noLazyElement);
        done |= this.diffVO(domFactory, realMeta, baseRoot, mergedRoot, parseCtx);
        parseCtx.pop();
        if (pluginRoot.getChild("resource", pluginRoot.getNamespace()) == null) {
            pluginRoot.addContent(domFactory.element("resource", pluginRoot.getNamespace()));
        } else {
            Element rss = pluginRoot.getChild("resource", pluginRoot.getNamespace());
            pluginRoot.removeChild("resource", pluginRoot.getNamespace());
            pluginRoot.addContent(rss);
        }
        if (done |= this.diffRS(domFactory, baseRoot, pluginRoot, mergedRoot)) {
            return rtvDom;
        }
        return null;
    }

    private boolean diffCollection(JDOMFactory factory, RelationshipInfo relation, Element ele0, Element eleN, Stack stack) {
        Element plugin;
        Element subEleN;
        Set lkValues;
        Element addedSub;
        Element plugin2;
        Element subEle0;
        Set lkValues2;
        boolean done = false;
        List subElesN = eleN.getChildren();
        EntityObjectInfo meta = relation.getSupplierObject();
        RelationshipType rt = relation.getType();
        if (RelationshipType.COMPOSITION.equals((Object)rt)) {
            for (Element subEleN2 : subElesN) {
                lkValues2 = this.parseLK(subEleN2, meta);
                subEle0 = this.findInElementsByLKV(ele0.getChildren(), meta, lkValues2);
                if (subEle0 == null) {
                    plugin2 = LazyElement.generateElments(factory, stack);
                    addedSub = (Element)subEleN2.clone();
                    addedSub.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_A);
                    plugin2.addContent(addedSub);
                    done = true;
                    continue;
                }
                EntityObjectInfo realMeta = this.reLocationMeta(meta, subEle0.getName());
                LazyElement lazyElement = new LazyElement();
                lazyElement.nodeName = subEle0.getName();
                lazyElement.lkvs = this.parseLK(subEle0, realMeta);
                stack.push(lazyElement);
                done |= this.diffVO(factory, realMeta, subEle0, subEleN2, stack);
                stack.pop();
            }
        } else {
            for (Element subEleN2 : subElesN) {
                lkValues2 = this.parseKV(subEleN2);
                subEle0 = this.findInElementsByKVEquals(ele0.getChildren(), lkValues2);
                if (subEle0 != null) continue;
                plugin2 = LazyElement.generateElments(factory, stack);
                addedSub = factory.element(subEleN2.getName(), plugin2.getNamespace());
                this.saveKV(factory, addedSub, lkValues2);
                addedSub.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_A);
                plugin2.addContent(addedSub);
                done = true;
            }
        }
        List subEles0 = ele0.getChildren();
        if (RelationshipType.COMPOSITION.equals((Object)rt)) {
            for (Element subEle02 : subEles0) {
                lkValues = this.parseLK(subEle02, meta);
                subEleN = this.findInElementsByLKV(eleN.getChildren(), meta, lkValues);
                if (subEleN != null) continue;
                plugin = LazyElement.generateElments(factory, stack);
                Element deledSub = (Element)subEle02.clone();
                deledSub.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_D);
                plugin.addContent(deledSub);
                done = true;
            }
        } else {
            for (Element subEle02 : subEles0) {
                lkValues = this.parseKV(subEle02);
                subEleN = this.findInElementsByKVEquals(eleN.getChildren(), lkValues);
                if (subEleN != null) continue;
                plugin = LazyElement.generateElments(factory, stack);
                Element deledSub = factory.element(subEle02.getName(), plugin.getNamespace());
                this.saveKV(factory, deledSub, lkValues);
                deledSub.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_D);
                plugin.addContent(deledSub);
                done = true;
            }
        }
        return done;
    }

    private boolean diffRS(JDOMFactory factory, Element baseRoot, Element pluginRoot, Element mergedRoot) {
        Element baseRssRoot = baseRoot.getChild("resource", baseRoot.getNamespace());
        Element pluginRssRoot = pluginRoot.getChild("resource", pluginRoot.getNamespace());
        Element mergedRssRoot = mergedRoot.getChild("resource", mergedRoot.getNamespace());
        boolean done = false;
        List rsElesN = mergedRssRoot.getChildren("rs", mergedRssRoot.getNamespace());
        for (Element rsN : rsElesN) {
            String key = rsN.getAttributeValue("key");
            Element rs0 = this.findInRssByKey(baseRssRoot, key);
            if (rs0 == null) {
                Element addedRs = (Element)rsN.clone();
                addedRs.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_A);
                pluginRssRoot.addContent(addedRs);
                done = true;
                continue;
            }
            Element rs1 = this.findInRssByKey(pluginRssRoot, key);
            List localesN = rsN.getChildren("lang", rsN.getNamespace());
            for (Element localeN : localesN) {
                String localeName = localeN.getAttributeValue("locale");
                String localeValueN = localeN.getAttributeValue("value");
                Element locale0 = this.findInRsByLocale(rs0, localeName);
                if (locale0 == null) {
                    if (rs1 == null) {
                        rs1 = factory.element("rs", pluginRssRoot.getNamespace());
                        rs1.setAttribute("key", key);
                        pluginRssRoot.addContent(rs1);
                    }
                    this.recordLang(factory, rs1, localeName, localeValueN, null, DIFF_ATTR_VALUE_A);
                    done = true;
                    continue;
                }
                String localeValue0 = locale0.getAttributeValue("value");
                if (this.valueEquals(localeValueN, localeValue0)) continue;
                if (rs1 == null) {
                    rs1 = factory.element("rs", pluginRssRoot.getNamespace());
                    rs1.setAttribute("key", key);
                    pluginRssRoot.addContent(rs1);
                }
                this.recordLang(factory, rs1, localeName, localeValueN, localeValue0, DIFF_ATTR_VALUE_M);
                done = true;
            }
            List locales0 = rs0.getChildren("lang", rs0.getNamespace());
            for (Element locale0 : locales0) {
                String localeName = locale0.getAttributeValue("locale");
                String localeValue0 = locale0.getAttributeValue("value");
                Element localeN = this.findInRsByLocale(rsN, localeName);
                if (localeN != null) continue;
                if (rs1 == null) {
                    rs1 = factory.element("rs", pluginRssRoot.getNamespace());
                    rs1.setAttribute("key", key);
                    pluginRssRoot.addContent(rs1);
                }
                this.recordLang(factory, rs1, localeName, localeValue0, null, DIFF_ATTR_VALUE_D);
                done = true;
            }
        }
        List rsEles0 = baseRssRoot.getChildren("rs", baseRssRoot.getNamespace());
        for (Element rs0 : rsEles0) {
            String key = rs0.getAttributeValue("key");
            Element rsN = this.findInRssByKey(mergedRssRoot, key);
            if (rsN != null) continue;
            Element deledRs = (Element)rs0.clone();
            deledRs.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_D);
            pluginRssRoot.addContent(deledRs);
            done = true;
        }
        return done;
    }

    private boolean diffVO(JDOMFactory factory, EntityObjectInfo meta, Element base, Element merged, Stack stack) {
        boolean done = false;
        List elementsN = merged.getChildren();
        for (Object item : elementsN) {
            if (item instanceof Element) {
                Element eleN = (Element)item;
                String eleName = eleN.getName();
                PropertyInfo prop = meta.getPropertyByNameRuntime(eleName);
                if (prop == null) continue;
                Element ele0 = base.getChild(eleName, base.getNamespace());
                if (ele0 == null) {
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element ele1 = (Element)eleN.clone();
                    ele1.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_A);
                    plugin.addContent(ele1);
                    done = true;
                    continue;
                }
                if (prop instanceof OwnPropertyInfo) {
                    String value0;
                    String valueN;
                    OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                    if (ownProp.isMultilingual() || this.valueEquals(valueN = eleN.getTextTrim(), value0 = ele0.getTextTrim())) continue;
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element changedProp = factory.element(eleName, plugin.getNamespace());
                    changedProp.setText(valueN);
                    changedProp.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_M);
                    changedProp.setAttribute(DIFF_VALUE_ATTR_KEY, value0);
                    plugin.addContent(changedProp);
                    done = true;
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = linkProp.getRelationship();
                CardinalityType ct = relation.getSupplierCardinality();
                if (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ct) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)ct)) {
                    LazyElement lazyElement = new LazyElement();
                    lazyElement.nodeName = eleName;
                    stack.push(lazyElement);
                    done |= this.diffCollection(factory, relation, ele0, eleN, stack);
                    stack.pop();
                    continue;
                }
                RelationshipType rt = relation.getType();
                if (RelationshipType.ASSOCIATION.equals((Object)rt)) {
                    Set lks0 = this.parseKV(ele0);
                    Set lksN = this.parseKV(eleN);
                    if (this.valueEquals(lksN, lks0)) continue;
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element changedProp = factory.element(eleName, plugin.getNamespace());
                    this.saveKV(factory, changedProp, lksN);
                    changedProp.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_M);
                    changedProp.setAttribute(DIFF_VALUE_ATTR_KEY, this.toStringKV(lks0));
                    plugin.addContent(changedProp);
                    done = true;
                    continue;
                }
                EntityObjectInfo eleMeta = relation.getSupplierObject();
                LazyElement lazyElement = new LazyElement();
                lazyElement.nodeName = eleName;
                lazyElement.lkvs = this.parseLK(ele0, eleMeta);
                stack.push(lazyElement);
                done |= this.diffVO(factory, eleMeta, ele0, eleN, stack);
                stack.pop();
                continue;
            }
            logger.warn((Object)("\u9047\u5230\u975eElement\u8282\u70b9\u3002" + item));
        }
        List elements0 = base.getChildren();
        for (Object item : elements0) {
            if (item instanceof Element) {
                Element eleN;
                Element ele0 = (Element)item;
                String eleName = ele0.getName();
                PropertyInfo prop = meta.getPropertyByNameRuntime(eleName);
                if (prop == null || (eleN = merged.getChild(eleName, merged.getNamespace())) != null) continue;
                Element plugin = LazyElement.generateElments(factory, stack);
                Element ele1 = (Element)ele0.clone();
                ele1.setAttribute(DIFF_ATTR_KEY, DIFF_ATTR_VALUE_D);
                plugin.addContent(ele1);
                done = true;
                continue;
            }
            logger.warn((Object)("\u9047\u5230\u975eElement\u8282\u70b9\u3002" + item));
        }
        return done;
    }

    private Element findInElementsByKVEquals(List elements, Set keys) {
        for (Element ele : elements) {
            Set kvsTemp = this.parseKV(ele);
            if (!this.valueEquals(keys, kvsTemp)) continue;
            return ele;
        }
        return null;
    }

    private Element findInElementsByLKV(List elements, EntityObjectInfo meta, Set keys) {
        for (Element ele : elements) {
            Set kvsTemp = this.parseLK(ele, meta);
            if (!((Object)keys).equals(kvsTemp)) continue;
            return ele;
        }
        return null;
    }

    private Element findInRsByLocale(Element rs, String locale) {
        List langs = rs.getChildren("lang", rs.getNamespace());
        for (Element lang : langs) {
            if (!locale.equals(lang.getAttributeValue("locale"))) continue;
            return lang;
        }
        return null;
    }

    private Element findInRssByKey(Element rssRoot, String key) {
        List rss = rssRoot.getChildren("rs", rssRoot.getNamespace());
        for (Element rs : rss) {
            if (!key.equals(rs.getAttributeValue("key"))) continue;
            return rs;
        }
        return null;
    }

    private Set parseKV(Element ele) {
        TreeSet<KVItem> rtv = new TreeSet<KVItem>();
        List keys = ele.getChildren("key", ele.getNamespace());
        for (Element item : keys) {
            String key = item.getAttributeValue("name");
            String value = item.getAttributeValue("value");
            rtv.add(new KVItem(key, value));
        }
        return rtv;
    }

    private Set parseLK(Element ele, EntityObjectInfo meta) {
        TreeSet<KVItem> rtv = new TreeSet<KVItem>();
        PropertyCollection props = meta.getLogicalKey().getKeyPropertys();
        for (int i = 0; i < props.size(); ++i) {
            PropertyInfo prop = props.get(i);
            String name = prop.getName();
            Element keyElement = ele.getChild(name, ele.getNamespace());
            if (keyElement == null) continue;
            String value = keyElement.getTextTrim();
            rtv.add(new KVItem(name, value));
        }
        return rtv;
    }

    private void recordLang(JDOMFactory factory, Element rs, String locale, String value, String oldvalue, String diff) {
        Element addedLang = factory.element("lang", rs.getNamespace());
        addedLang.setAttribute("locale", locale);
        addedLang.setAttribute("value", value);
        addedLang.setAttribute(DIFF_ATTR_KEY, diff);
        if (oldvalue != null) {
            addedLang.setAttribute(DIFF_VALUE_ATTR_KEY, oldvalue);
        }
        rs.addContent(addedLang);
    }

    private EntityObjectInfo reLocationMeta(EntityObjectInfo meta, String eleName) {
        String metaName = meta.getName();
        if (eleName.equals(metaName)) {
            return meta;
        }
        String metaPackage = meta.getPackage();
        MetaDataPK newPK = MetaDataPK.create(metaPackage, eleName);
        try {
            return (EntityObjectInfo)this.metaLoader.loadMetametaData(newPK);
        }
        catch (DataAccessException e) {
            logger.warn((Object)("\u5143\u5143\u6570\u636e\u591a\u6001\u67e5\u627e\u9519\u8bef\u3002OldType=" + meta.getFullName() + ",NewName=" + eleName));
            return meta;
        }
    }

    private void saveKV(JDOMFactory factory, Element container, Set kvs) {
        container.removeChildren();
        for (KVItem item : kvs) {
            Element key = factory.element("key", container.getNamespace());
            key.setAttribute("name", item.key);
            key.setAttribute("value", item.value);
            container.addContent(key);
        }
    }

    private boolean valueEquals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private String toStringKV(Set kvs) {
        StringBuffer buff = new StringBuffer();
        for (KVItem kv : kvs) {
            buff.append(kv.key);
            buff.append("=");
            buff.append(kv.value);
            buff.append(";");
        }
        return buff.toString();
    }
}

