/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.engine.DevMDError;
import com.kingdee.bos.engine.MDParseError;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.log4j.Logger;

public class BOSTypeHelper {
    private static final Logger logger = Logger.getLogger(BOSTypeHelper.class);
    private XMLLoader loader;
    private Map subTypes = new HashMap();
    Set allTypes = new HashSet();
    public Set allSuffixs = new HashSet();
    Map seenTypes = new HashMap();
    private static final String TEST_METAMETA = "metametadata/entity/entityObject.entity";
    private static final String FILE_PREFIX = "file:";
    private static final String ENTITY_SUFFIX = Utils.getMetaDataSuffix(MetaDataTypeList.ENTITY);
    private static final String[] METAMETA_PKS = new String[]{"metametadata.bizrule.action", "metametadata.bizrule.baseExpression", "metametadata.bizrule.baseRule", "metametadata.bizrule.computationRule", "metametadata.bizrule.condition", "metametadata.bizrule.conditionRule", "metametadata.bizrule.constraintRule", "metametadata.bizrule.groupExpression", "metametadata.bizrule.method", "metametadata.bizrule.parameter", "metametadata.bizrule.property", "metametadata.bizrule.ruleSet", "metametadata.bizrule.simpleExpression", "metametadata.bizunit.bizField", "metametadata.bizunit.bizFieldTemplateSet", "metametadata.bizunit.bizFieldView", "metametadata.bizunit.bizTemplate", "metametadata.bizunit.bizUnit", "metametadata.bo.businessObject", "metametadata.bo.method", "metametadata.bo.paramAssociation", "metametadata.bo.parameter", "metametadata.bo.strategy", "metametadata.bot.BOTDelRevRule", "metametadata.bot.BOTDelRevRuleSegment", "metametadata.bot.BOTGrouping", "metametadata.bot.BOTMapping", "metametadata.bot.BOTRelation", "metametadata.bot.BOTRelationEntry", "metametadata.bot.BOTRevRule", "metametadata.bot.BOTRevRuleSegment", "metametadata.bot.BOTRule", "metametadata.bot.BOTRuleSegment", "metametadata.common.abstractMeta", "metametadata.common.constraint", "metametadata.data.abstractTable", "metametadata.data.column", "metametadata.data.crossTable", "metametadata.data.dataTable", "metametadata.data.extendedTable", "metametadata.data.fkColumnPair", "metametadata.data.foreignKey", "metametadata.data.index", "metametadata.data.indexColumn", "metametadata.data.keyMap", "metametadata.data.primaryKey", "metametadata.data.primaryKeyColumn", "metametadata.data.tableMap", "metametadata.datax.dataX", "metametadata.eai.Activity", "metametadata.eai.Adapter", "metametadata.eai.Application", "metametadata.eai.ApplicationNode", "metametadata.eai.DataExchange", "metametadata.eai.DataSource", "metametadata.eai.Integration", "metametadata.eai.RoutePolicy", "metametadata.eai.ServicesRequire", "metametadata.eai.Task", "metametadata.entity.baseProperty", "metametadata.entity.constraint", "metametadata.entity.defaultView", "metametadata.entity.entityObject", "metametadata.entity.extendedField", "metametadata.entity.filter", "metametadata.entity.filterItem", "metametadata.entity.linkProperty", "metametadata.entity.logicalKey", "metametadata.entity.numericConstraint", "metametadata.entity.ownProperty", "metametadata.entity.regexConstraint", "metametadata.entity.relationship", "metametadata.entity.scriptConstraint", "metametadata.entity.selectorItem", "metametadata.entity.sorterItem", "metametadata.event.event", "metametadata.event.eventMethod", "metametadata.event.formalParameter", "metametadata.event.parameterMapping", "metametadata.facade.facade", "metametadata.function.functionObject", "metametadata.function.operation", "metametadata.function.uiActionRef", "metametadata.management.application.application", "metametadata.management.application.appview", "metametadata.management.application.dependence", "metametadata.management.application.metadata", "metametadata.management.application.referSubSystem", "metametadata.management.application.subSystem", "metametadata.management.baseTemplateRef", "metametadata.management.baseTemplateRefSet", "metametadata.management.deployOption", "metametadata.management.language", "metametadata.management.package", "metametadata.management.solution", "metametadata.management.suffix", "metametadata.mdquery.configItem", "metametadata.mdquery.cube", "metametadata.mdquery.dataSource", "metametadata.mdquery.dimension", "metametadata.mdquery.dimensionUsage", "metametadata.mdquery.hierarchy", "metametadata.mdquery.level", "metametadata.mdquery.mdQuery", "metametadata.mdquery.measure", "metametadata.mdquery.property", "metametadata.query.baseQuery", "metametadata.query.join", "metametadata.query.joinItem", "metametadata.query.joinQuery", "metametadata.query.parameter", "metametadata.query.propertyRef", "metametadata.query.propertyUnit", "metametadata.query.queryField", "metametadata.query.queryFilter", "metametadata.query.queryFilterItem", "metametadata.query.queryPK", "metametadata.query.querySorterItem", "metametadata.query.subEntity", "metametadata.query.subObject", "metametadata.query.subQuery", "metametadata.query.unionQuery", "metametadata.query.virtualField", "metametadata.query.virtualQuery", "metametadata.report.linkUI", "metametadata.report.parameter", "metametadata.report.parameterMapping", "metametadata.report.report", "metametadata.report.template", "metametadata.resource.bizDataType", "metametadata.resource.bizEnum", "metametadata.resource.bizException", "metametadata.resource.bizExceptionSubItem", "metametadata.resource.enumValue", "metametadata.resource.i18nResource", "metametadata.resource.imageResource", "metametadata.resource.resource", "metametadata.resource.resourceItem", "metametadata.rule.rule", "metametadata.rule.ruleMethod", "metametadata.rule.ruleProperty", "metametadata.service.log.item", "metametadata.service.log.log", "metametadata.service.log.logBizRef", "metametadata.service.log.methodRef", "metametadata.service.mutex.item", "metametadata.service.mutex.mutex", "metametadata.service.param", "metametadata.service.permission.bizProperty", "metametadata.service.permission.bizRef", "metametadata.service.permission.dependence", "metametadata.service.permission.entityObjectRef", "metametadata.service.permission.permission", "metametadata.service.permission.permissionItem", "metametadata.service.permission.refPermissionItem", "metametadata.service.service", "metametadata.ui.action", "metametadata.ui.component", "metametadata.ui.dataObject", "metametadata.ui.eventBinding", "metametadata.ui.layout", "metametadata.ui.property", "metametadata.ui.propertyBinding", "metametadata.ui.status", "metametadata.ui.statusItem", "metametadata.ui.uiObject", "metametadata.view.metaDataBrief", "metametadata.view.metaDataBriefView", "metametadata.workflow.wfRole", "metametadata.workflow.workFlow", "metametadata.webui.webUIObject", "metametadata.webpage.webPageObject", "metametadata.webcomponent.webComponentObject", "metametadata.webcontrol.webControlObject", "metametadata.webrule.webRule", "metametadata.webmacro.webMacro"};

    public BOSTypeHelper(XMLLoader loader) {
        this.loader = loader;
        this.initial();
    }

    public boolean isSubType(BOSObjectType base, BOSObjectType sub) {
        BOSObjectType current = sub;
        try {
            while (true) {
                BOSObjectType parent;
                if (base.equals((Object)(parent = this.loader.loadMeta(current).getBaseEntity().getType()))) {
                    return true;
                }
                current = parent;
            }
        }
        catch (Exception _) {
            return false;
        }
    }

    public BOSObjectType[] getSubTypes(BOSObjectType base) {
        HashSet result = new HashSet();
        HashSet temps = new HashSet();
        HashSet<Object> todos = new HashSet<Object>();
        todos.add(base);
        do {
            temps.clear();
            for (BOSObjectType bOSObjectType : todos) {
                Set currentSubs = (Set)this.subTypes.get(bOSObjectType);
                if (currentSubs == null) continue;
                temps.addAll(currentSubs);
            }
            result.addAll(temps);
            todos.clear();
            todos.addAll(temps);
        } while (todos.size() != 0);
        return result.toArray(new BOSObjectType[result.size()]);
    }

    EntityObjectInfo getMetaByType(BOSObjectType type) {
        try {
            EntityObjectInfo meta = this.loader.loadMeta(type);
            if (meta != null) {
                return meta;
            }
            throw new MDParseError("NO defind BOSType[" + type + "]");
        }
        catch (MissingDAOMetaDataException e) {
            throw new MDParseError("NO defind BOSType[" + type + "]", (Throwable)((Object)e));
        }
    }

    public EntityObjectInfo getRealMeta(EntityObjectInfo meta, String subName) {
        try {
            MetaDataPK newPK = MetaDataPK.create(meta.getPackage(), subName);
            EntityObjectInfo subMeta = (EntityObjectInfo)this.loader.loadMetametaData(newPK);
            if (subMeta != null) {
                return subMeta;
            }
            throw new MDParseError("NO defind BOSType[" + meta.getFullName() + "],subName[" + subName + "]");
        }
        catch (DataAccessException e) {
            throw new MDParseError("NO defind BOSType[" + meta.getFullName() + "],subName[" + subName + "]", (Throwable)((Object)e));
        }
    }

    BOSObjectType getRealType(EntityObjectInfo meta, String subName) {
        return this.getRealMeta(meta, subName).getType();
    }

    AbstractMDValue getRealVO(EntityObjectInfo meta, String subName) {
        EntityObjectInfo subMeta = this.getRealMeta(meta, subName);
        return this.getRealVO(subMeta);
    }

    public AbstractMDValue getRealVO(EntityObjectInfo meta) {
        String name = meta.getObjectValueClassRuntime();
        try {
            return (AbstractMDValue)Class.forName(name).newInstance();
        }
        catch (Throwable e) {
            throw new MDParseError("Can NOT getVOInstance " + name + " for BOSType[" + meta.getFullName() + "]", e);
        }
    }

    private void initial() {
        URL test = this.loader.getMetaDataClassLoader().getResource(TEST_METAMETA);
        if (test == null) {
            throw new DevMDError("Metametadata can NOT Found");
        }
        String path = test.getPath();
        if ("jar".equals(test.getProtocol())) {
            int pos = path.lastIndexOf("!/metametadata/entity/entityObject.entity");
            if ((path = path.substring(0, pos)).startsWith(FILE_PREFIX)) {
                path = path.substring(FILE_PREFIX.length());
            }
            try {
                File jar = new File(path);
                this.processJar(jar);
            }
            catch (Exception _) {
                throw new DevMDError("Process Metametadata jar ERROR", _);
            }
        } else if ("file".equals(test.getProtocol())) {
            try {
                File dir = new File(path);
                dir = dir.getParentFile().getParentFile().getParentFile();
                this.processDir(dir);
            }
            catch (Exception _) {
                throw new DevMDError("Process Metametadata dir ERROR", _);
            }
        } else {
            this.initial1();
        }
    }

    private void initial1() {
        for (int i = 0; i < METAMETA_PKS.length; ++i) {
            MetaDataPK pk = MetaDataPK.create(METAMETA_PKS[i]);
            this.add2cache(pk);
        }
    }

    private void processJar(File file) {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> e = jar.entries();
            String entryName = null;
            while (e.hasMoreElements()) {
                entryName = e.nextElement().toString();
                if (!entryName.endsWith(ENTITY_SUFFIX)) continue;
                entryName = entryName.substring(0, entryName.length() - ENTITY_SUFFIX.length());
                MetaDataPK pk = MetaDataPK.create(entryName.replaceAll("/", "."));
                this.add2cache(pk);
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error Metametadata Jar:" + file.getAbsolutePath() + ". Cause:" + ioe.getMessage());
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private void processDir(File dir) {
        Stack paths = new Stack();
        this.processDir0(dir, paths);
    }

    private void processDir0(File dir, Stack paths) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String name;
            File file = files[i];
            if (file.isDirectory()) {
                paths.push(file.getName());
                this.processDir0(file, paths);
                paths.pop();
                continue;
            }
            if (!file.isFile() || !(name = file.getName()).endsWith(ENTITY_SUFFIX)) continue;
            name = name.substring(0, name.length() - ENTITY_SUFFIX.length());
            String pkg = this.joinPkgName(paths);
            MetaDataPK pk = MetaDataPK.create(pkg, name);
            this.add2cache(pk);
        }
    }

    private String joinPkgName(Stack paths) {
        StringBuffer buff = new StringBuffer();
        boolean notStart = false;
        for (int i = 0; i < paths.size(); ++i) {
            String path = (String)paths.get(i);
            if (notStart) {
                buff.append(".");
            } else {
                notStart = true;
            }
            buff.append(path);
        }
        return buff.toString();
    }

    private void add2cache(IMetaDataPK metaPK) {
        try {
            EntityObjectInfo baseMeta;
            EntityObjectInfo meta = (EntityObjectInfo)this.loader.loadMetametaData(metaPK);
            BOSObjectType bostype = meta.getType();
            if (this.seenTypes.containsKey(bostype)) {
                logger.error((Object)"\u5143\u5143\u6570\u636e\u5b9a\u4e49\u91cd\u590dtype.");
                logger.error((Object)("old pk = " + this.seenTypes.get(bostype)));
                logger.error((Object)("new pk = " + metaPK));
                logger.error((Object)("bos ty = " + bostype));
            }
            this.seenTypes.put(bostype, metaPK);
            this.allTypes.add(bostype);
            String suffix = Utils.getMetaDataSuffix(bostype);
            if (suffix != null && suffix.length() > 0) {
                this.allSuffixs.add(suffix);
            }
            if ((baseMeta = meta.getBaseEntity()) != null) {
                BOSObjectType key = baseMeta.getType();
                HashSet<BOSObjectType> subs = (HashSet<BOSObjectType>)this.subTypes.get(key);
                if (subs == null) {
                    subs = new HashSet<BOSObjectType>();
                    this.subTypes.put(key, subs);
                }
                subs.add(bostype);
            }
        }
        catch (DataAccessException _) {
            logger.warn((Object)("Can NOT load metametadata PK=" + metaPK.getFullName()));
        }
    }

    public static void main(String[] args) throws Exception {
        Context ctx = new Context();
        ctx.put((Object)"METADATAPATH", (Object)"");
        XMLLoader xmlLoader = null;
        long start = System.currentTimeMillis();
        xmlLoader = new XMLLoader(ctx, new String[0]);
        System.out.println("used " + (System.currentTimeMillis() - start) + " ms");
        BOSTypeHelper helper = new BOSTypeHelper(xmlLoader);
        System.out.println("used " + (System.currentTimeMillis() - start) + " ms");
        BOSObjectType[] types = helper.getSubTypes(MetaDataTypeList.ABSTRACTTABLE);
        System.out.println("used " + (System.currentTimeMillis() - start) + " ms");
        for (int i = 0; i < types.length; ++i) {
            System.out.println(types[i]);
        }
        System.out.println(helper.isSubType(MetaDataTypeList.BASEQUERY, MetaDataTypeList.JOINQUERY));
        System.out.println(helper.isSubType(MetaDataTypeList.UNIONQUERY, MetaDataTypeList.JOINQUERY));
        System.out.println("used " + (System.currentTimeMillis() - start) + " ms");
    }
}

