/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.impl.IResBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class JarResBase
implements IResBase {
    private static final Logger logger = Logger.getLogger(JarResBase.class);
    private File root;
    private JarFile jarRoot;

    public JarResBase(File jar) {
        this.root = jar;
        try {
            this.jarRoot = new JarFile(jar);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean entryExist(String entryName) {
        try {
            return this.jarRoot.getEntry(entryName) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public long entryLastModified(String entryName) throws MDNotFoundException {
        try {
            ZipEntry entry = this.jarRoot.getEntry(entryName);
            return entry.getTime();
        }
        catch (Exception e) {
            throw new MDNotFoundException("\u65e0\u6cd5\u5728jar[" + this.root.getPath() + "]\u6587\u4ef6\u4e2d\u627e\u5230entry[" + entryName + "]");
        }
    }

    @Override
    public void deleteEntry(String entryName) throws IOException {
        throw new IOException("Jar\u6587\u4ef6\u53ea\u80fd\u8bfb\u53d6\uff0c\u4e0d\u80fd\u5220\u9664entry[" + entryName + "]");
    }

    @Override
    public File getBase() {
        return this.root;
    }

    @Override
    public InputStream getInputStream(String entryName) throws IOException {
        ZipEntry entry = this.jarRoot.getEntry(entryName);
        InputStream is = this.jarRoot.getInputStream(entry);
        return new BufferedInputStream(is);
    }

    @Override
    public OutputStream getOutputStream(String entryName) throws IOException {
        throw new IOException("Jar\u6587\u4ef6\u53ea\u80fd\u8bfb\u53d6\uff0c\u4e0d\u80fd\u4fee\u6539entry[" + entryName + "]");
    }

    public String toString() {
        try {
            return this.root.getCanonicalPath();
        }
        catch (IOException e) {
            return "\u83b7\u53d6\u8d44\u6e90\u5e93\u7684\u8def\u5f84\u5f02\u5e38\u3002";
        }
    }

    @Override
    public void clean() throws IOException {
        throw new IOException("Jar\u7cfb\u7edf\u53ea\u8bfb\uff0c\u4e0d\u80fd\u591f\u5220\u9664\u3002");
    }

    @Override
    public void setEntryLastModified(String entryName, long ts) throws MDNotFoundException {
    }

    @Override
    public long entryLength(String entryName) {
        ZipEntry entry = this.jarRoot.getEntry(entryName);
        return entry.getSize();
    }

    @Override
    public void close() {
        try {
            if (this.jarRoot != null) {
                this.jarRoot.close();
                this.jarRoot = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

