/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.dao.xml.impl.ContainerHolder;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.dao.xml.impl.MapStateManager;
import com.kingdee.bos.dao.xml.impl.ObjectHelper;
import com.kingdee.bos.dao.xml.impl.PathStack;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.MDParseError;
import com.kingdee.bos.engine.impl.Loader2;
import com.kingdee.bos.engine.impl.Saver2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class MDParser2 {
    private static final Logger logger = Logger.getLogger(MDParser2.class);
    private Loader2 loader;

    public MDParser2(Loader2 loader) {
        this.loader = loader;
    }

    void parseMDFromDOM(AbstractMetaDataValue docVO, EntityObjectInfo meta, Element dom) throws MDNotFoundException {
        Element root = dom;
        Map<String, Map<String, String>> resource = this.prepareResource(root);
        PathStack stack = new PathStack();
        ArrayList appended = new ArrayList();
        this.parse0(meta, docVO, root, resource, stack, appended);
    }

    private void parse0(EntityObjectInfo meta, AbstractMDValue shell, Element element, Map resource, PathStack stack, List appended) throws MDNotFoundException {
        String propName;
        PropertyInfo prop;
        int i;
        PropertyCollection props;
        IStateManager sm = shell.getStateManager();
        if (sm == null) {
            sm = new MapStateManager();
            shell.setStateManager(sm);
        }
        String eleName = element.getName();
        PathStack.Entry entry = new PathStack.Entry(eleName, meta.getType().toString(), shell);
        stack.push(entry);
        try {
            props = meta.getLogicalKey().getKeyPropertys();
            for (i = 0; i < props.size(); ++i) {
                prop = props.get(i);
                propName = prop.getName();
                String propValue = element.getChildTextTrim(propName, element.getNamespace());
                sm.setStateValue(propName, propValue);
            }
        }
        catch (Throwable t) {
            throw new MDParseError("Can NOT parser LogicalKey's value", t);
        }
        this.processExtendedProperty(sm, element, resource);
        props = meta.getInheritedPropertiesRuntime();
        for (i = 0; i < props.size(); ++i) {
            prop = props.get(i);
            propName = prop.getName();
            Element childElement = element.getChild(propName, element.getNamespace());
            if (childElement == null) continue;
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                String propValue = childElement.getTextTrim();
                if (ownProp.isMultilingual()) {
                    this.processLocaleValue(sm, propName, propValue, resource);
                    continue;
                }
                if (propValue == null || propValue.length() <= 0) continue;
                sm.setStateValue(propName, propValue);
                continue;
            }
            if (!(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relation = linkProp.getRelationship();
            EntityObjectInfo childMeta = relation.getSupplierObject();
            CardinalityType car = relation.getSupplierCardinality();
            if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)car) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)car)) {
                this.processCollection(relation, sm, propName, childMeta, childElement, resource, stack, appended);
                continue;
            }
            RelationshipType type = relation.getType();
            if (RelationshipType.COMPOSITION.equals((Object)type)) {
                AbstractMDElement subShell = (AbstractMDElement)this.loader.typeHelper.getRealVO(childMeta);
                sm.setStateValue(propName, subShell);
                this.parse0(childMeta, subShell, childElement, resource, stack, appended);
                continue;
            }
            String xpath = relation.getString("xmlNodeRelationship");
            if (StringUtils.isEmpty((String)xpath)) {
                if (childElement.getChildren().size() == 0 && childElement.getAttributes().size() == 0) {
                    sm.setStateValue(propName, null);
                }
                sm.setStateValue(propName, this.getDocumentRef(childMeta, childElement));
                continue;
            }
            sm.setStateValue(propName, this.getElementRef(new ContainerHolder(sm, propName), childMeta, childElement, xpath, stack, appended));
        }
        stack.pop();
        sm.trimToSize();
    }

    private void processCollection(RelationshipInfo relation, IStateManager target, String propName, EntityObjectInfo childMeta, Element collElement, Map resource, PathStack stack, List appended) throws MDNotFoundException {
        IObjectCollection coll = this.getCollectionByMeta(childMeta);
        target.setStateValue(propName, coll);
        assert (propName.equals(collElement.getName()));
        PathStack.Entry entry = new PathStack.Entry(propName, childMeta.getType().toString(), coll);
        stack.push(entry);
        boolean isComp = RelationshipType.COMPOSITION.equals((Object)relation.getType());
        List eles = collElement.getChildren();
        if (isComp) {
            for (int i = 0; i < eles.size(); ++i) {
                Element element = (Element)eles.get(i);
                EntityObjectInfo subMeta1 = childMeta;
                subMeta1 = this.loader.typeHelper.getRealMeta(childMeta, element.getName());
                AbstractMDValue subObject = this.loader.typeHelper.getRealVO(subMeta1);
                coll.addObjectDirect(subObject);
                this.parse0(subMeta1, subObject, element, resource, stack, appended);
            }
        } else {
            for (int i = 0; i < eles.size(); ++i) {
                Element element = (Element)eles.get(i);
                String xpath = relation.getString("xmlNodeRelationship");
                if (StringUtils.isEmpty((String)xpath)) {
                    AbstractMetaDataValue refDocument = this.getDocumentRef(childMeta, element);
                    coll.addObject(refDocument);
                    continue;
                }
                coll.addObject(this.getElementRef(new ContainerHolder(coll), childMeta, element, xpath, stack, appended));
            }
        }
        stack.pop();
        coll.updateIndex();
        coll.trimToSize();
    }

    private AbstractMetaDataValue getDocumentRef(EntityObjectInfo refMeta, Element subElement) throws MDNotFoundException {
        String pkg = null;
        String name = null;
        List keys = subElement.getChildren("key", subElement.getNamespace());
        for (int i = 0; i < keys.size(); ++i) {
            Element key = (Element)keys.get(i);
            String kname = key.getAttributeValue("name");
            String kvalue = key.getAttributeValue("value");
            if ("package".equals(kname)) {
                pkg = kvalue;
                continue;
            }
            if (!"name".equals(kname)) continue;
            name = kvalue;
        }
        MetaDataPK pk = MetaDataPK.create(pkg, name);
        BOSObjectType realType = refMeta.getType();
        try {
            return this.loader.loadMetadata(realType, pk, false);
        }
        catch (MDNotFoundException e) {
            throw new MDNotFoundException("\u88ab\u5f15\u7528\u7684\u5143\u6570\u636e[pk=" + pk + ", type=" + realType + "]\u6ca1\u6709\u627e\u5230\u3002\ndetailMessage is : " + e.getMessage());
        }
    }

    private AbstractMDValue getElementRef(ContainerHolder holder, EntityObjectInfo targetMeta, Element currentNode, String xpath, PathStack stack, List appended) throws MDNotFoundException {
        StringTokenizer token = new StringTokenizer(xpath, "$");
        String docDesc = token.nextToken();
        String docType = token.nextToken();
        String eleDesc = token.nextToken();
        Element docElement = this.getPathElement(currentNode, docDesc);
        AbstractMetaDataValue doc = null;
        try {
            doc = this.getDocObjectInChain(docElement, docType);
        }
        catch (MDNotFoundException e) {
            if (doc == null && docType.startsWith("(uioj)")) {
                doc = (AbstractMetaDataValue)stack.firstEntry().obj;
            }
            throw e;
        }
        PathStack path = new PathStack();
        AbstractMDValue findElementRef = this.processElementPath(doc, targetMeta, currentNode, eleDesc, path);
        return findElementRef;
    }

    private AbstractMDValue processElementPath(AbstractMetaDataValue refDoc, EntityObjectInfo targetMeta, Element node, String xpath, PathStack paths) {
        Object currentObject = refDoc;
        StringTokenizer token = new StringTokenizer(xpath, "/");
        while (token.hasMoreTokens()) {
            String elePath;
            Element eleElement;
            String refPropName;
            String path = token.nextToken();
            EntityObjectInfo meta = targetMeta;
            int pos = path.indexOf(40);
            if (pos != -1) {
                String chainType = path.substring(1, 5);
                try {
                    meta = this.loader.metametaLoader.loadMeta(BOSObjectType.create((String)chainType));
                }
                catch (MissingDAOMetaDataException e) {
                    throw new MDParseError("\u65e0\u6cd5\u89e3\u6790\u5143\u5143\u6570\u636e\u7c7b\u578b[" + chainType + "]", (Throwable)((Object)e));
                }
                path = path.substring(6);
            }
            if ("properties".equals(refPropName = path.substring(0, path.indexOf(91))) && currentObject instanceof EntityObjectInfo) {
                currentObject = ((EntityObjectInfo)currentObject).getInheritedPropertyFromSelf();
            } else if ("methods".equals(refPropName) && currentObject instanceof BusinessObjectInfo) {
                currentObject = ((BusinessObjectInfo)currentObject).getAllMethods();
            } else if (currentObject != null) {
                currentObject = ((AbstractMDValue)currentObject).get(refPropName);
            }
            if (currentObject instanceof IObjectCollection && (eleElement = this.getPathElement(node, elePath = path.substring(path.indexOf(91) + 1, path.indexOf(93)))) != null) {
                HashMap<String, String> childElementKeys = new HashMap<String, String>();
                List keys = eleElement.getChildren("key", eleElement.getNamespace());
                for (int i = 0; i < keys.size(); ++i) {
                    Element key = (Element)keys.get(i);
                    childElementKeys.put(key.getAttributeValue("name"), key.getAttributeValue("value"));
                }
                currentObject = ObjectHelper.findObjectFromCollectionByContext((IObjectCollection)currentObject, meta, childElementKeys);
            }
            if (currentObject != null) continue;
            List keys = node.getChildren("key", node.getNamespace());
            AbstractMDValue foo = this.loader.typeHelper.getRealVO(targetMeta);
            for (int i = 0; i < keys.size(); ++i) {
                Element key = (Element)keys.get(i);
                foo.put(key.getAttributeValue("name"), key.getAttributeValue("value"));
            }
            foo.put("_state_", "true");
            return foo;
        }
        return (AbstractMDValue)currentObject;
    }

    private AbstractMetaDataValue getDocObjectInChain(Element docElement, String type) throws MDNotFoundException {
        type = type.substring(1, 5);
        if (docElement == null) {
            return null;
        }
        String pkg = docElement.getChildTextTrim("package", docElement.getNamespace());
        String name = docElement.getChildTextTrim("name", docElement.getNamespace());
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)pkg)) {
            List keys = docElement.getChildren("key", docElement.getNamespace());
            for (int i = 0; i < keys.size(); ++i) {
                Element item = (Element)keys.get(i);
                String keyName = item.getAttributeValue("name");
                if (StringUtils.isEmpty((String)name) && "name".equals(keyName)) {
                    name = item.getAttributeValue("value");
                }
                if (!StringUtils.isEmpty((String)pkg) || !"package".equals(keyName)) continue;
                pkg = item.getAttributeValue("value");
            }
        }
        MetaDataPK pk = MetaDataPK.create(pkg, name);
        try {
            return this.loader.loadMetadata(BOSObjectType.create((String)type), pk, false);
        }
        catch (MDNotFoundException e) {
            throw new MDNotFoundException("\u88ab\u5f15\u7528\u7684\u5143\u6570\u636e[pk=" + pk + ", type=" + BOSObjectType.create((String)type) + "]\u6ca1\u6709\u627e\u5230\u3002\ndetailMessage is : " + e.getMessage());
        }
    }

    private Element getPathElement(Element node, String script) {
        Element elem = node;
        StringTokenizer token = new StringTokenizer(script, ".");
        String temp = null;
        while (token.hasMoreElements()) {
            temp = token.nextToken();
            if (temp.equalsIgnoreCase("root")) {
                elem = elem.getDocument().getRootElement();
            } else if (temp.equalsIgnoreCase("parent")) {
                elem = elem.getParent();
            } else if (!temp.equalsIgnoreCase("this")) {
                elem = elem.getChild(temp, elem.getNamespace());
            }
            if (elem != null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("can NOT find Document's Desc Element for Path[" + script + "]"));
            }
            return null;
        }
        return elem;
    }

    private void processLocaleValue(IStateManager target, String propName, String key, Map<String, Map<String, String>> resource) {
        for (String locale : this.loader.localeNames) {
            String value = resource.get(locale).get(key);
            if (value == null) continue;
            target.setLocaleValue(propName, value, locale);
        }
    }

    private void processExtendedProperty(IStateManager target, Element root, Map resource) {
        String epKey = Saver2.getMutlilingualKey(root);
        Map exs = (Map)resource.get(epKey);
        if (exs == null) {
            epKey = Saver2.getMutlilingualKey2(root);
            exs = (Map)resource.get(epKey);
        }
        if (exs != null) {
            target.getExtendedProperties().putAll(exs);
        }
    }

    private IObjectCollection getCollectionByMeta(EntityObjectInfo meta) {
        String clazzName = meta.getObjectCollectionClass();
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                clazz = Class.forName(clazzName);
            }
            Object obj = clazz.newInstance();
            if (!(obj instanceof IObjectCollection)) {
                clazz = Class.forName(clazzName);
                obj = clazz.newInstance();
            }
            return (IObjectCollection)obj;
        }
        catch (Throwable _) {
            return null;
        }
    }

    private Map<String, Map<String, String>> prepareResource(Element rootEleement) {
        HashMap<String, Map<String, String>> rtv = new HashMap<String, Map<String, String>>(3);
        for (String name : this.loader.localeNames) {
            HashMap localeBag = new HashMap(30);
            rtv.put(name, localeBag);
        }
        Element resource = rootEleement.getChild("resource", rootEleement.getNamespace());
        List rss = resource.getChildren("rs", rootEleement.getNamespace());
        for (int i = 0; i < rss.size(); ++i) {
            Element item = (Element)rss.get(i);
            this.processResource(rtv, item);
        }
        return rtv;
    }

    private void processResource(Map<String, Map<String, String>> bag, Element rs) {
        String key = rs.getAttributeValue("key");
        List langs = rs.getChildren("lang", rs.getNamespace());
        int pos = key.indexOf("extendedProperty.");
        if (pos != -1) {
            Element lang;
            String componentName = key.substring(0, pos);
            String exKey = key.substring(pos + 17, key.length());
            Map<String, String> ex = bag.get(componentName);
            if (ex == null) {
                ex = new HashMap<String, String>(3);
                bag.put(componentName, ex);
            }
            String value = null;
            for (int i = 0; i < langs.size() && "null".equals(value = (lang = (Element)langs.get(i)).getAttributeValue("value")); ++i) {
            }
            if (!"null".equals(value)) {
                ex.put(exKey, value);
            }
        } else {
            for (int i = 0; i < langs.size(); ++i) {
                String value;
                Element lang = (Element)langs.get(i);
                String lname = lang.getAttributeValue("locale");
                if (!this.loader.localeNames.contains(lname) || "null".equals(value = lang.getAttributeValue("value"))) continue;
                bag.get(lname).put(key, value);
            }
        }
    }
}

