/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.impl.IXMLAssembler;
import com.kingdee.bos.engine.impl.KVItem;
import com.kingdee.bos.engine.impl.LazyElement;
import com.kingdee.bos.engine.impl.RS;
import com.kingdee.bos.engine.impl.XMLException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.upgrade.FormatXmlMerger;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;

public class MetadataXMLAssembler
implements IXMLAssembler {
    private static final Logger logger = Logger.getLogger(MetadataXMLAssembler.class);
    private XMLLoader metaLoader;
    private boolean plugin = true;

    public MetadataXMLAssembler(XMLLoader loader) {
        this.metaLoader = loader;
    }

    @Override
    public Document merge(EntityObjectInfo meta, Document base, Document plugin) throws XMLException {
        if (plugin == null) {
            return base;
        }
        if (base == null) {
            return plugin;
        }
        try {
            boolean done = false;
            JDOMFactory domFactory = MetadataXMLAssembler.getJDOMFactory();
            Document rtvDom = (Document)base.clone();
            Element baseRoot = base.getRootElement();
            Element pluginRoot = plugin.getRootElement();
            Element mergedRoot = rtvDom.getRootElement();
            done |= this.mergeRS(domFactory, baseRoot, pluginRoot, mergedRoot);
            EntityObjectInfo realMeta = this.reLocationMeta(meta, baseRoot.getName());
            Stack parseCtx = new Stack();
            if (done |= this.mergeVO(domFactory, realMeta, baseRoot, pluginRoot, mergedRoot, parseCtx)) {
                Element rss = mergedRoot.getChild("resource", mergedRoot.getNamespace());
                if (rss != null) {
                    mergedRoot.removeChild("resource", mergedRoot.getNamespace());
                    mergedRoot.addContent(rss);
                }
                return rtvDom;
            }
            return base;
        }
        catch (Exception _) {
            throw new XMLException(_);
        }
    }

    private boolean mergeVO(JDOMFactory factory, EntityObjectInfo meta, Element base, Element plugin, Element merged, Stack stack) {
        boolean done = false;
        List elements1 = plugin.getChildren();
        for (Object item : elements1) {
            if (item instanceof Element) {
                Element eleN;
                Element ele1 = (Element)item;
                String eleName = ele1.getName();
                PropertyInfo prop = meta.getPropertyByNameRuntime(eleName);
                if (prop == null) continue;
                Element ele0 = base.getChild(eleName, base.getNamespace());
                if (ele0 == null) {
                    eleN = (Element)ele1.clone();
                    merged.addContent(eleN);
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u5408\u5e76\u4e00\u4e2a\u65b0\u589e\u7684\u5c5e\u6027\u3002PropName=" + eleName));
                    continue;
                }
                eleN = merged.getChild(eleName, merged.getNamespace());
                if (prop instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                    if (!ownProp.isMultilingual()) {
                        String value0;
                        String value1 = ele1.getTextTrim();
                        if (this.valueEquals(value1, value0 = ele0.getTextTrim())) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("\u57fa\u672c\u5c5e\u6027\u503c\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u987b\u5408\u5e76\u3002PropName=" + eleName));
                            continue;
                        }
                        eleN.setText(value1);
                        done = true;
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("\u5408\u5e76\u4fee\u6539\u4e86\u57fa\u672c\u5c5e\u6027\u503c\u3002PropName=" + eleName + ",OldValue=" + value0 + ",NewValue=" + value1));
                        continue;
                    }
                    if (!this.plugin) continue;
                    logger.debug((Object)("\u591a\u8bed\u8a00\u5c5e\u6027\u7684key\u503c\u4e0d\u53ef\u80fd\u53d1\u751f\u53d8\u5316\uff0c\u53ef\u80fd\u5dee\u5f02\u6bd4\u8f83\u9519\u8bef\uff01PropName=" + eleName));
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = linkProp.getRelationship();
                CardinalityType ct = relation.getSupplierCardinality();
                if (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ct) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)ct)) {
                    done |= this.mergeCollection(factory, relation, ele0, ele1, eleN, stack);
                    continue;
                }
                RelationshipType rt = relation.getType();
                if (RelationshipType.ASSOCIATION.equals((Object)rt)) {
                    Set lks1 = this.parseKV(ele1);
                    this.saveKV(factory, eleN, lks1);
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u5408\u5e76\u4e00\u5bf9\u4e00\u5173\u8054\u5c5e\u6027\u503c\u3002PropName=" + eleName + ",keyvalues=" + lks1));
                    continue;
                }
                EntityObjectInfo eleMeta = relation.getSupplierObject();
                done |= this.mergeVO(factory, eleMeta, ele0, ele1, eleN, stack);
                continue;
            }
            logger.warn((Object)("\u9047\u5230\u975eElement\u8282\u70b9\u3002" + item));
        }
        return done;
    }

    private boolean mergeCollection(JDOMFactory factory, RelationshipInfo relation, Element ele0, Element ele1, Element eleN, Stack stack) {
        boolean done = false;
        List subEles1 = ele1.getChildren();
        EntityObjectInfo meta = relation.getSupplierObject();
        RelationshipType rt = relation.getType();
        if (RelationshipType.COMPOSITION.equals((Object)rt)) {
            for (Element subEle1 : subEles1) {
                Set lkValues = this.parseLK(subEle1, meta);
                Element subEle0 = this.findInElementsByLKV(ele0.getChildren(), meta, lkValues);
                if (subEle0 == null) {
                    eleN.addContent((Element)subEle1.clone());
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u65b0\u589e\u4e86\u4e00\u4e2a\u7ec4\u5408\u5bf9\u8c61\u3002\u6807\u8bc6\u503c\u4e3a " + subEle1));
                    continue;
                }
                Element subEleN = this.findInElementsByLKV(eleN.getChildren(), meta, lkValues);
                EntityObjectInfo realMeta = this.reLocationMeta(meta, subEle1.getName());
                done |= this.mergeVO(factory, realMeta, subEle0, subEle1, subEleN, stack);
            }
        } else {
            for (Element subEle1 : subEles1) {
                Set lkValues = this.parseLK(subEle1, meta);
                Element subEle0 = this.findInElementsByLKV(ele0.getChildren(), meta, lkValues);
                if (subEle0 != null) continue;
                eleN.addContent((Element)subEle1.clone());
                done = true;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\u65b0\u589e\u4e86\u4e00\u4e2a\u5173\u8054\u5bf9\u8c61\u3002\u6807\u8bc6\u503c\u4e3a " + subEle1));
            }
        }
        return done;
    }

    private Set parseLK(Element ele, EntityObjectInfo meta) {
        TreeSet<KVItem> rtv = new TreeSet<KVItem>();
        PropertyCollection props = meta.getLogicalKey().getKeyPropertys();
        for (int i = 0; i < props.size(); ++i) {
            String value;
            PropertyInfo prop = props.get(i);
            String name = prop.getName();
            Element keyElement = ele.getChild(name, ele.getNamespace());
            if (keyElement != null) {
                value = keyElement.getTextTrim();
                rtv.add(new KVItem(name, value));
                continue;
            }
            keyElement = ele.getChild("key", ele.getNamespace());
            if (keyElement == null) continue;
            value = keyElement.getAttributeValue("value");
            rtv.add(new KVItem(name, value));
        }
        return rtv;
    }

    private Set parseKV(Element ele) {
        TreeSet<KVItem> rtv = new TreeSet<KVItem>();
        List keys = ele.getChildren("key", ele.getNamespace());
        for (Element item : keys) {
            String key = item.getAttributeValue("name");
            String value = item.getAttributeValue("value");
            rtv.add(new KVItem(key, value));
        }
        return rtv;
    }

    private void saveKV(JDOMFactory factory, Element container, Set kvs) {
        container.removeChildren();
        for (KVItem item : kvs) {
            Element key = factory.element("key", container.getNamespace());
            key.setAttribute("name", item.key);
            key.setAttribute("value", item.value);
            container.addContent(key);
        }
    }

    private boolean mergeRS(JDOMFactory factory, Element baseRoot, Element pluginRoot, Element mergedRoot) {
        Element baseRssRoot = baseRoot.getChild("resource", baseRoot.getNamespace());
        Element pluginRssRoot = pluginRoot.getChild("resource", pluginRoot.getNamespace());
        Element mergedRssRoot = mergedRoot.getChild("resource", mergedRoot.getNamespace());
        boolean done = false;
        if (pluginRssRoot == null) {
            return false;
        }
        if (baseRssRoot == null) {
            if (mergedRssRoot == null) {
                Element addedRss = (Element)pluginRssRoot.clone();
                mergedRoot.addContent(addedRss);
                return true;
            }
            logger.error((Object)"\u62f7\u8d1dDOM\u7684<resources>\u8282\u70b9\u9519\u8bef\u3002");
            return false;
        }
        List rsEles1 = pluginRssRoot.getChildren("rs", pluginRssRoot.getNamespace());
        for (Element rs1 : rsEles1) {
            String key = rs1.getAttributeValue("key");
            Element rs0 = this.findInRssByKey(baseRssRoot, key);
            if (rs0 == null) {
                Element addedRs = (Element)rs1.clone();
                mergedRssRoot.addContent(addedRs);
                done = true;
                continue;
            }
            Element rsN = this.findInRssByKey(mergedRssRoot, key);
            List locales1 = rs1.getChildren("lang", rs1.getNamespace());
            for (Element locale1 : locales1) {
                String localeName = locale1.getAttributeValue("locale");
                String localeValue1 = locale1.getAttributeValue("value");
                Element locale0 = this.findInRsByLocale(rs0, localeName);
                if (locale0 == null) {
                    Element addedLang = factory.element("lang", locale1.getNamespace());
                    addedLang.setAttribute("locale", localeName);
                    addedLang.setAttribute("value", localeValue1);
                    rsN.addContent(addedLang);
                    done = true;
                    continue;
                }
                String localeValue0 = locale0.getAttributeValue("value");
                if (!this.valueEquals(localeValue1, localeValue0)) {
                    Element localeN = this.findInRsByLocale(rsN, localeName);
                    String merged = localeValue1;
                    if (key.endsWith(".property[formatXml].value")) {
                        merged = FormatXmlMerger.merge2(localeValue0, localeValue1);
                    } else if (key.endsWith(".extendedProperty.dynExtendPropertyList") || key.endsWith(".extendedProperty.dynpropertybinds")) {
                        merged = this.mergeStringbySeperator(localeValue1, localeValue0, "|");
                    } else if (key.endsWith(".extendedProperty.extend_formatxml")) {
                        merged = this.mergeStringbySeperator(localeValue1, localeValue0, ";");
                    }
                    localeN.setAttribute("value", merged);
                    done = true;
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\u76f8\u540c\u7684\u591a\u8bed\u8a00\u503c\u65e0\u9700\u5408\u5e76\u3002key=" + key + ",locale=" + localeName + ",value=" + localeValue1));
            }
        }
        return done;
    }

    private Object findInSet(Set set, Object obj) {
        for (Object other : set) {
            if (!obj.equals(other)) continue;
            return other;
        }
        return null;
    }

    private KVItem findInKVSet(Set set, KVItem kv) {
        for (KVItem other : set) {
            if (!this.valueEquals(kv.key, other.key)) continue;
            return other;
        }
        return null;
    }

    private Element findInElementsByLKV(List elements, EntityObjectInfo meta, Set keys) {
        for (Element ele : elements) {
            Set kvsTemp = this.parseLK(ele, meta);
            if (!((Object)keys).equals(kvsTemp)) continue;
            return ele;
        }
        return null;
    }

    private Element findInElementsByKVEquals(List elements, Set keys) {
        for (Element ele : elements) {
            Set kvsTemp = this.parseKV(ele);
            if (!this.valueEquals(keys, kvsTemp)) continue;
            return ele;
        }
        return null;
    }

    private Element findInRssByKey(Element rssRoot, String key) {
        List rss = rssRoot.getChildren("rs", rssRoot.getNamespace());
        for (Element rs : rss) {
            if (!key.equals(rs.getAttributeValue("key"))) continue;
            return rs;
        }
        return null;
    }

    private Element findInRsByLocale(Element rs, String locale) {
        List langs = rs.getChildren("lang", rs.getNamespace());
        for (Element lang : langs) {
            if (!locale.equals(lang.getAttributeValue("locale"))) continue;
            return lang;
        }
        return null;
    }

    @Override
    public Document diff(EntityObjectInfo meta, Document doc, Document base) throws XMLException {
        return this.diff(meta, doc, base, true);
    }

    public Document diff(EntityObjectInfo meta, Document doc, Document base, boolean addPIExtend) throws XMLException {
        try {
            TreeSet<KVItem> lkvs;
            boolean done = false;
            JDOMFactory domFactory = MetadataXMLAssembler.getJDOMFactory();
            Element baseRoot = base.getRootElement();
            Element mergedRoot = doc.getRootElement();
            Element pluginRoot = domFactory.element(baseRoot.getName(), baseRoot.getNamespace());
            LazyElement noLazyElement = new LazyElement();
            noLazyElement.node = pluginRoot;
            noLazyElement.lkvs = lkvs = new TreeSet<KVItem>();
            Element tempEle = null;
            String pkg = baseRoot.getChildTextTrim("package", baseRoot.getNamespace());
            tempEle = domFactory.element("package", pluginRoot.getNamespace());
            tempEle.setText(pkg);
            pluginRoot.addContent(tempEle);
            lkvs.add(new KVItem("package", pkg));
            String name = baseRoot.getChildTextTrim("name", baseRoot.getNamespace());
            tempEle = domFactory.element("name", pluginRoot.getNamespace());
            tempEle.setText(name);
            pluginRoot.addContent(tempEle);
            lkvs.add(new KVItem("name", name));
            String alias = baseRoot.getChildTextTrim("alias", baseRoot.getNamespace());
            tempEle = domFactory.element("alias", pluginRoot.getNamespace());
            tempEle.setText(alias);
            pluginRoot.addContent(tempEle);
            String rootName = baseRoot.getName();
            Document rtvDom = domFactory.document(pluginRoot);
            EntityObjectInfo realMeta = this.reLocationMeta(meta, baseRoot.getName());
            Stack<LazyElement> parseCtx = new Stack<LazyElement>();
            parseCtx.push(noLazyElement);
            done |= this.diffVO(domFactory, realMeta, baseRoot, mergedRoot, parseCtx, addPIExtend);
            parseCtx.pop();
            if (pluginRoot.getChild("resource", pluginRoot.getNamespace()) == null) {
                pluginRoot.addContent(domFactory.element("resource", pluginRoot.getNamespace()));
            } else {
                Element rss = pluginRoot.getChild("resource", pluginRoot.getNamespace());
                pluginRoot.removeChild("resource", pluginRoot.getNamespace());
                pluginRoot.addContent(rss);
            }
            if (done |= this.diffRS(domFactory, baseRoot, pluginRoot, mergedRoot)) {
                if (addPIExtend) {
                    String pk = MetaDataPK.create(pkg, name).getFullName();
                    String key = rootName + "[" + pk + "].extendedProperty." + "PI_Extend";
                    this.addRsNoDupi(domFactory, pluginRoot, key, "true");
                    this.addRsNoDupi(domFactory, mergedRoot, key, "true");
                }
                return rtvDom;
            }
            return null;
        }
        catch (Exception _) {
            throw new XMLException(_);
        }
    }

    private boolean diffVO(JDOMFactory factory, EntityObjectInfo meta, Element base, Element merged, Stack stack, boolean addPIExtend) {
        boolean done = false;
        List elementsN = merged.getChildren();
        for (Object item : elementsN) {
            if (item instanceof Element) {
                Element eleN = (Element)item;
                String eleName = eleN.getName();
                PropertyInfo prop = meta.getPropertyByNameRuntime(eleName);
                if (prop == null) continue;
                Element ele0 = base.getChild(eleName, base.getNamespace());
                if (ele0 == null) {
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element ele1 = (Element)eleN.clone();
                    plugin.addContent(ele1);
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u6709\u4e00\u4e2a\u65b0\u589e\u7684\u5c5e\u6027\u3002PropName=" + eleName));
                    continue;
                }
                if (prop instanceof OwnPropertyInfo) {
                    String value0;
                    String valueN;
                    OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                    if (ownProp.isMultilingual() || this.valueEquals(valueN = eleN.getTextTrim(), value0 = ele0.getTextTrim())) continue;
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element changedProp = factory.element(eleName, plugin.getNamespace());
                    changedProp.setText(valueN);
                    plugin.addContent(changedProp);
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u57fa\u672c\u5c5e\u6027\u503c\u53d1\u751f\u53d8\u5316\u3002PropName=" + eleName + ",value=" + valueN));
                    continue;
                }
                if (!(prop instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = linkProp.getRelationship();
                CardinalityType ct = relation.getSupplierCardinality();
                if (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ct) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)ct)) {
                    LazyElement lazyElement = new LazyElement();
                    lazyElement.nodeName = eleName;
                    stack.push(lazyElement);
                    done |= this.diffCollection(factory, relation, ele0, eleN, stack, addPIExtend);
                    stack.pop();
                    continue;
                }
                RelationshipType rt = relation.getType();
                if (RelationshipType.ASSOCIATION.equals((Object)rt)) {
                    Set lks0 = this.parseKV(ele0);
                    Set lksN = this.parseKV(eleN);
                    if (this.valueEquals(lksN, lks0)) continue;
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element changedProp = factory.element(eleName, plugin.getNamespace());
                    this.saveKV(factory, changedProp, lksN);
                    plugin.addContent(changedProp);
                    done = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\u4e00\u5bf9\u4e00\u5173\u8054\u5c5e\u6027\u503c\u53d1\u751f\u53d8\u5316\u3002PropName=" + eleName + ",keyvalues=" + lksN));
                    }
                    done = true;
                    continue;
                }
                EntityObjectInfo eleMeta = relation.getSupplierObject();
                LazyElement lazyElement = new LazyElement();
                lazyElement.nodeName = eleName;
                lazyElement.lkvs = this.parseLK(ele0, eleMeta);
                stack.push(lazyElement);
                done |= this.diffVO(factory, eleMeta, ele0, eleN, stack, addPIExtend);
                stack.pop();
                continue;
            }
            logger.warn((Object)("\u9047\u5230\u975eElement\u8282\u70b9\u3002" + item));
        }
        return done;
    }

    private void addRsNoDupi(JDOMFactory factory, Element root, String key, String value) {
        Element rss = root.getChild("resource", root.getNamespace());
        if (rss == null) {
            rss = factory.element("resource", root.getNamespace());
            root.addContent(rss);
        }
        Element findRs = null;
        List rsEles = rss.getChildren("rs", rss.getNamespace());
        for (int i = 0; i < rsEles.size(); ++i) {
            Element rsEle = (Element)rsEles.get(i);
            if (!key.equals(rsEle.getAttributeValue("key"))) continue;
            findRs = rsEle;
            break;
        }
        if (findRs == null) {
            findRs = factory.element("rs", rss.getNamespace());
            findRs.setAttribute("key", key);
            rss.addContent(findRs);
        } else {
            findRs.removeChildren();
        }
        String[] locales = new String[]{"en_US", "zh_CN", "zh_TW"};
        for (int i = 0; i < locales.length; ++i) {
            Element lang = factory.element("lang", findRs.getNamespace());
            lang.setAttribute("locale", locales[i]);
            lang.setAttribute("value", value);
            findRs.addContent(lang);
        }
    }

    private boolean diffCollection(JDOMFactory factory, RelationshipInfo relation, Element ele0, Element eleN, Stack stack, boolean addPIExtend) {
        boolean done = false;
        List subElesN = eleN.getChildren();
        EntityObjectInfo meta = relation.getSupplierObject();
        RelationshipType rt = relation.getType();
        if (RelationshipType.COMPOSITION.equals((Object)rt)) {
            for (Element subEleN : subElesN) {
                Set lkValues = this.parseLK(subEleN, meta);
                Element subEle0 = this.findInElementsByLKV(ele0.getChildren(), meta, lkValues);
                if (subEle0 == null) {
                    String rootName;
                    Element root;
                    Element plugin = LazyElement.generateElments(factory, stack);
                    Element addedSub = (Element)subEleN.clone();
                    plugin.addContent(addedSub);
                    if ("methods".equals(eleN.getName()) && "method".equals(subEleN.getName()) && addPIExtend && (root = eleN.getParent()).getParent() == null && ("entityObject".equals(rootName = root.getName()) || "facade".equals(rootName))) {
                        String pkg = root.getChildTextTrim("package", root.getNamespace());
                        String name = root.getChildTextTrim("name", root.getNamespace());
                        String pk = MetaDataPK.create(pkg, name).getFullName();
                        String methodName = subEleN.getChildTextTrim("name", ele0.getNamespace());
                        String key = rootName + "[" + pk + "].methods.method[" + methodName + "].extendedProperty." + "PI_Extend";
                        this.addRsNoDupi(factory, plugin.getParent(), key, "true");
                        this.addRsNoDupi(factory, eleN.getParent(), key, "true");
                    }
                    done = true;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u65b0\u589e\u4e86\u4e00\u4e2a\u7ec4\u5408\u5bf9\u8c61\u3002\u6807\u8bc6\u503c\u4e3a " + subEleN));
                    continue;
                }
                EntityObjectInfo realMeta = this.reLocationMeta(meta, subEle0.getName());
                LazyElement lazyElement = new LazyElement();
                lazyElement.nodeName = subEle0.getName();
                lazyElement.lkvs = this.parseLK(subEle0, realMeta);
                stack.push(lazyElement);
                done |= this.diffVO(factory, realMeta, subEle0, subEleN, stack, addPIExtend);
                stack.pop();
            }
        } else {
            for (Element subEleN : subElesN) {
                Set lkValues = this.parseKV(subEleN);
                Element subEle0 = this.findInElementsByKVEquals(ele0.getChildren(), lkValues);
                if (subEle0 != null) continue;
                Element plugin = LazyElement.generateElments(factory, stack);
                Element addedSub = factory.element(subEleN.getName(), plugin.getNamespace());
                this.saveKV(factory, addedSub, lkValues);
                plugin.addContent(addedSub);
                done = true;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\u65b0\u589e\u4e86\u4e00\u4e2a\u5173\u8054\u96c6\u5408\u5143\u7d20\u5b50\u5bf9\u8c61\u3002\u6807\u8bc6\u503c\u4e3a " + subEleN));
            }
        }
        return done;
    }

    private boolean diffRS(JDOMFactory factory, Element baseRoot, Element pluginRoot, Element mergedRoot) {
        Element baseRssRoot = baseRoot.getChild("resource", baseRoot.getNamespace());
        Element pluginRssRoot = pluginRoot.getChild("resource", pluginRoot.getNamespace());
        Element mergedRssRoot = mergedRoot.getChild("resource", mergedRoot.getNamespace());
        boolean done = false;
        List rsElesN = mergedRssRoot.getChildren("rs", mergedRssRoot.getNamespace());
        for (Element rsN : rsElesN) {
            String key = rsN.getAttributeValue("key");
            Element rs0 = this.findInRssByKey(baseRssRoot, key);
            if (rs0 == null) {
                Element addedRs = (Element)rsN.clone();
                pluginRssRoot.addContent(addedRs);
                done = true;
                continue;
            }
            Element rs1 = this.findInRssByKey(pluginRssRoot, key);
            List localesN = rsN.getChildren("lang", rsN.getNamespace());
            for (Element localeN : localesN) {
                String localeName = localeN.getAttributeValue("locale");
                String localeValueN = localeN.getAttributeValue("value");
                Element locale0 = this.findInRsByLocale(rs0, localeName);
                if (locale0 == null) {
                    if (rs1 == null) {
                        rs1 = factory.element("rs", pluginRssRoot.getNamespace());
                        rs1.setAttribute("key", key);
                        pluginRssRoot.addContent(rs1);
                    }
                    this.recordLang(factory, rs1, localeName, localeValueN);
                    done = true;
                    continue;
                }
                String localeValue0 = locale0.getAttributeValue("value");
                if (this.valueEquals(localeValueN, localeValue0)) continue;
                if (rs1 == null) {
                    rs1 = factory.element("rs", pluginRssRoot.getNamespace());
                    rs1.setAttribute("key", key);
                    pluginRssRoot.addContent(rs1);
                }
                String diff = localeValueN;
                if (key.endsWith(".property[formatXml].value")) {
                    diff = FormatXmlMerger.diff2(localeValue0, localeValueN);
                } else if (key.endsWith(".extendedProperty.dynExtendPropertyList") || key.endsWith(".extendedProperty.dynpropertybinds")) {
                    diff = this.diffStringbySeperator(localeValueN, localeValue0, "|");
                } else if (key.endsWith(".extendedProperty.extend_formatxml")) {
                    diff = this.diffStringbySeperator(localeValueN, localeValue0, ";");
                }
                this.recordLang(factory, rs1, localeName, diff);
                done = true;
            }
        }
        return done;
    }

    private void recordLang(JDOMFactory factory, Element rs, String locale, String value) {
        Element addedLang = factory.element("lang", rs.getNamespace());
        addedLang.setAttribute("locale", locale);
        addedLang.setAttribute("value", value);
        rs.addContent(addedLang);
    }

    private String diffStringbySeperator(String plugin, String base, String seperator) {
        if (StringUtils.isEmpty((String)plugin)) {
            return "";
        }
        if (StringUtils.isEmpty((String)base)) {
            return plugin;
        }
        String[] plugins = StringUtils.split((String)plugin, (String)seperator);
        List<String> bases = Arrays.asList(StringUtils.split((String)base, (String)seperator));
        StringBuilder build = new StringBuilder();
        int count = 0;
        for (int i = 0; i < plugins.length; ++i) {
            if (bases.contains(plugins[i])) continue;
            if (count != 0) {
                build.append(seperator);
            }
            build.append(plugins[i]);
            ++count;
        }
        return build.toString();
    }

    private String mergeStringbySeperator(String plugin, String base, String seperator) {
        if (StringUtils.isEmpty((String)plugin)) {
            return base;
        }
        if (StringUtils.isEmpty((String)base)) {
            return plugin;
        }
        String[] plugins = StringUtils.split((String)plugin, (String)seperator);
        List<String> bases = Arrays.asList(StringUtils.split((String)base, (String)seperator));
        StringBuilder build = new StringBuilder(base);
        for (String str : plugins) {
            if (bases.contains(str)) continue;
            build.append(seperator);
            build.append(str);
        }
        return build.toString();
    }

    private boolean valueEquals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private EntityObjectInfo reLocationMeta(EntityObjectInfo meta, String eleName) {
        String metaName = meta.getName();
        if (eleName.equals(metaName)) {
            return meta;
        }
        String metaPackage = meta.getPackage();
        MetaDataPK newPK = MetaDataPK.create(metaPackage, eleName);
        try {
            return (EntityObjectInfo)this.metaLoader.loadMetametaData(newPK);
        }
        catch (DataAccessException e) {
            logger.warn((Object)("\u5143\u5143\u6570\u636e\u591a\u6001\u67e5\u627e\u9519\u8bef\u3002OldType=" + meta.getFullName() + ",NewName=" + eleName));
            return meta;
        }
    }

    private static JDOMFactory getJDOMFactory() {
        return new DefaultJDOMFactory();
    }

    private boolean mergeRSOld(JDOMFactory factory, Element base, Element plugin, Element merged) {
        Element baseRssEle = base.getChild("resource", base.getNamespace());
        Element pluginRssEle = plugin.getChild("resource", plugin.getNamespace());
        Element mergedRssEle = merged.getChild("resource", merged.getNamespace());
        Set baseRss = this.parseRSCollection(baseRssEle);
        Set pluginRss = this.parseRSCollection(pluginRssEle);
        Set mergedRss = this.parseRSCollection(mergedRssEle);
        boolean done = false;
        for (RS rs1 : pluginRss) {
            if (baseRss.contains(rs1)) {
                RS rs0 = (RS)this.findInSet(baseRss, rs1);
                RS rsN = (RS)this.findInSet(mergedRss, rs1);
                for (KVItem loc1 : rs1.locales) {
                    if (rs0.locales.contains(loc1)) {
                        KVItem loc0 = this.findInKVSet(rs0.locales, loc1);
                        if (this.valueEquals(loc1.value, loc0.value)) continue;
                        KVItem locN = this.findInKVSet(rsN.locales, loc1);
                        locN.value = loc1.value;
                        done = true;
                        continue;
                    }
                    rsN.locales.add(loc1);
                    done = true;
                }
                continue;
            }
            mergedRss.add(rs1);
            done = true;
        }
        if (done) {
            this.saveResource(factory, mergedRssEle, mergedRss);
        }
        return done;
    }

    private Set parseRSCollection(Element rss) {
        TreeSet<RS> rtv = new TreeSet<RS>();
        if (rss != null) {
            List eles = rss.getChildren("rs", rss.getNamespace());
            for (Element ele : eles) {
                rtv.add(this.parseRS(ele));
            }
        }
        return rtv;
    }

    private RS parseRS(Element rs) {
        if (rs != null) {
            String key = rs.getAttributeValue("key");
            return new RS(key, this.parseLocaleKVCollection(rs));
        }
        return null;
    }

    private KVItem parseLocaleKVItem(Element ele) {
        String key = ele.getAttributeValue("locale");
        String value = ele.getAttributeValue("value");
        return new KVItem(key, value);
    }

    private Set parseLocaleKVCollection(Element ele) {
        TreeSet<KVItem> rtv = new TreeSet<KVItem>();
        List keys = ele.getChildren("lang", ele.getNamespace());
        for (Element item : keys) {
            rtv.add(this.parseLocaleKVItem(item));
        }
        return rtv;
    }

    private void saveResource(JDOMFactory factory, Element rssEle, Set rss) {
        rssEle.removeChildren();
        for (RS rs : rss) {
            Element rsEle = factory.element("rs", rssEle.getNamespace());
            rsEle.setAttribute("key", rs.key);
            for (KVItem locale : rs.locales) {
                Element locEle = factory.element("lang", rsEle.getNamespace());
                locEle.setAttribute("locale", locale.key);
                locEle.setAttribute("value", locale.value);
                rsEle.addContent(locEle);
            }
            rssEle.addContent(rsEle);
        }
    }

    public void setPlugin(boolean plugin) {
        this.plugin = plugin;
    }

    public static void main(String[] args) throws Exception {
        TreeSet<KVItem> set1 = new TreeSet<KVItem>();
        set1.add(new KVItem("name", "getValue"));
        set1.add(new KVItem("innerID", "612296b7-00fb-1000-e000-0011c0a812d2"));
        TreeSet<KVItem> set2 = new TreeSet<KVItem>();
        set2.add(new KVItem("name", ""));
        set2.add(new KVItem("innerID", "-00fb-1000-e000-0010a812d2"));
        if (((Object)set1).equals(set2)) {
            System.out.println("==");
        } else {
            System.out.println("!=");
        }
    }
}

