/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.engine.impl;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.ConditionCollection;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionCollection;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.GroupExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.MethodInfo;
import com.kingdee.bos.metadata.bizrule.common.ParameterCollection;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.Hashtable;

public class UILoader {
    static void afterLoad(UIObjectInfo info) {
        ConditionCollection conditions;
        String expressionID;
        RuleSetInfo rsInfo = info.getRuleSet();
        if (rsInfo == null || rsInfo.getBoolean("_hasReConstruct")) {
            return;
        }
        ExpressionCollection expCol = (ExpressionCollection)rsInfo.get("expressions");
        if (expCol == null) {
            expCol = new ExpressionCollection();
        }
        Hashtable expTable = UILoader.transToHashtable(expCol);
        int n = expCol.size();
        for (int i = 0; i < n; ++i) {
            UILoader.setExpressionsToExp(expCol.get(i), expCol, expTable);
        }
        ActionCollection actions = (ActionCollection)rsInfo.get("actions");
        if (actions != null) {
            int n2 = actions.size();
            for (int i = 0; i < n2; ++i) {
                ActionInfo action = actions.get(i);
                expressionID = action.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                action.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        if ((conditions = (ConditionCollection)rsInfo.get("conditions")) != null) {
            int n3 = conditions.size();
            for (int i = 0; i < n3; ++i) {
                ConditionInfo condition = conditions.get(i);
                expressionID = condition.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                condition.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        rsInfo.setBoolean("_hasReConstruct", true);
    }

    private static void setExpressionsToExp(AbstractExpressionInfo expInfo, ExpressionCollection expCol, Hashtable table) {
        String id = expInfo.getString("id");
        if (expInfo instanceof GroupExpressionInfo) {
            GroupExpressionInfo geInfo = (GroupExpressionInfo)expInfo;
            geInfo.getExpressions().clear();
            int n = expCol.size();
            for (int i = 0; i < n; ++i) {
                String parentID = expCol.get(i).getString("parentID");
                if (!id.equals(parentID)) continue;
                geInfo.getExpressions().add(expCol.get(i));
            }
        } else if (expInfo instanceof SimpleExpressionInfo) {
            String ownerID;
            SimpleExpressionInfo seInfo = (SimpleExpressionInfo)expInfo;
            if (seInfo.getType() == ExpressionType.METHODINVOKE) {
                String ownerID2;
                if (seInfo.getMethod() != null && !StringUtils.isEmpty((String)(ownerID2 = seInfo.getMethod().getString("ownerID")))) {
                    seInfo.getMethod().setOwner((SimpleExpressionInfo)table.get(ownerID2));
                }
                UILoader.setExpressionsToMethod(seInfo.getMethod(), expCol, table);
            } else if (seInfo.getType() == ExpressionType.PROPERTYACCESS && seInfo.getProperty() != null && !StringUtils.isEmpty((String)(ownerID = seInfo.getProperty().getString("ownerID")))) {
                seInfo.getProperty().setOwner((SimpleExpressionInfo)table.get(ownerID));
            }
        }
    }

    private static void setExpressionsToMethod(MethodInfo methodInfo, ExpressionCollection expCol, Hashtable table) {
        if (methodInfo == null) {
            return;
        }
        ParameterCollection paramCol = methodInfo.getParameters();
        int m = paramCol.size();
        for (int i = 0; i < m; ++i) {
            String expressionID = paramCol.get(i).getString("expressionID");
            paramCol.get(i).setExpression((AbstractExpressionInfo)table.get(expressionID));
        }
    }

    private static Hashtable transToHashtable(IObjectCollection col) {
        Hashtable<String, IObjectValue> table = new Hashtable<String, IObjectValue>();
        if (col != null) {
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                String id = UILoader.getObjectID(col.getObject(j));
                table.put(id, col.getObject(j));
            }
        }
        return table;
    }

    private static String getObjectID(IObjectValue info) {
        if (info == null) {
            return null;
        }
        String id = info.getString("id");
        if (StringUtils.isEmpty((String)id)) {
            id = Uuid.create().toString();
            info.setString("id", id);
        }
        return id;
    }
}

