/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.config;

import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.framework.config.AISDeployInfo;
import com.kingdee.bos.framework.config.AbstractDeployInfoManager;
import com.kingdee.bos.framework.config.AppServerDeployInfo;
import com.kingdee.bos.framework.config.DestinationInfo;
import com.kingdee.bos.framework.config.ListenerInfo;
import com.kingdee.bos.framework.config.MsgServerDeployInfo;
import com.kingdee.bos.framework.config.ORMServiceLocationInfo;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BOSDeployInfoManager
extends AbstractDeployInfoManager {
    private static final String SOLUTIONINFO = "SolutionInfo";
    private static final String AISINFO = "AISInfo";
    private static final String USERDATA = "UserData";
    private static final String EJBSERVICE = "EJBService";
    private static final String CONTEXTFACTORY = "contextFactory";
    private static final String JNDIURL = "jndiURL";
    private static final String SECURITYCREDENTIAL = "securityCredential";
    private static final String SECURITYPRINCIPAL = "securityPrincipal";
    private static final String DATASOURCE = "datasource";
    private static final String METADATAPATH = "MetaDataPath";
    private static final String CONCURRENTCONFIGPATH = "ConcurrentConfigPath";
    private static final String DEBUGOPTIONS = "DebugOptions";
    private static final String CACHELAZYLOAD = "cacheLazyLoad";
    private static final String NONEJB = "nonejb";
    private static final String CRITICALCOLLECTION = "criticalCollection";
    private static final String CRITICALCOLLECTION4LOG = "criticalCollectionAlarm";
    private static final String CRITICALIDLIST = "criticalIDList";
    private static final String CRITICALQUERYPKS = "criticalQueryPKs";
    private static final String CRITICALSETSIZE = "criticalSetSize";
    private static final String GETREALROWCOUNT = "getRealRowCount";
    private static final String QUERYSERVER = "QueryServer";
    private static final String LICENSEFILE = "LicenseFile";
    private static final String LICENSEFILEFILEREADER = "LicenseFileReader";
    private static final String SOFTWARENAME = "SoftwareName";
    private static final String SERIALNUMBER = "SerialNumber";
    private static final String DMC = "DMC";
    private static final String URL = "url";
    private static final String USERNAME = "UserName";
    private static final String PASSWORD = "Password";
    private static final String MESSAGE = "MessageService";
    private static final String SERVICETYPE = "serviceType";
    private static final String DEFAULTDESTINATION = "defaultDestination";
    private static final String LISTENERS = "listeners";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String DOMAIN = "domain";
    private static final String FILTER = "filter";
    private static final String DESTINATIONS = "Destinations";
    private static final String DRIVERCLASSNAME = "driverClassName";
    private static final String PROPERTIES = "properties";
    private static final String CONNECTIONFACTORYJNDINAME = "connectionFactoryJNDIName";
    private static final String ORMSERVICE = "ORMServiceLocation";
    private static final String SERVICEURL = "serviceURL";
    private static final String WORKFLOW = "Workflow";
    private static final String ISENABLESCHEDULER = "isEnableScheduler";
    private static final String SCHEDULERIDLEWAITETIME = "schedulerIdleWaiteTime";
    private static final String SCHEDULERTHREADPOOLSIZE = "schedulerThreadPoolSize";
    private static final String WORKFLOWTRANSQUEUETIME = "workflowTransQueueTime";
    private static final String ISINITWFSERVICE = "isInitWfService";
    private static final String WORKFLOWSERVERKEY = "workflowServerKey";
    private static final String LOGCOINFIG = "LogConfig";
    private static final String PROVIDER = "provider";
    private static final String CONCURRENT = "Concurrent";
    private final String bosConfigFilePath;
    private Configuration config;
    private static final String USE_SELECT_CACHE = "useSelectCache";
    private static final String JDBC_SETTING = "JDBCSetting";

    public BOSDeployInfoManager() {
        this.bosConfigFilePath = null;
        this.config = Configuration.getInstance();
        this.load();
    }

    private BOSDeployInfoManager(String bosConfigFilePath) {
        this.bosConfigFilePath = bosConfigFilePath;
        this.config = Configuration.getInstance((String)bosConfigFilePath);
        this.load();
    }

    @Override
    public void refreshConfig(String bosConfigFilePath) {
        this.config = StringUtils.isEmpty((String)bosConfigFilePath) ? Configuration.getInstance() : Configuration.getInstance((String)bosConfigFilePath);
        if (this.config != null) {
            this.loadSolution();
        }
    }

    private void loadSolution() {
        ConfigurationItem slns = this.config.getConfigItem(SOLUTIONINFO);
        if (slns == null) {
            return;
        }
        this.configItems.put(SOLUTIONINFO, slns);
        Iterator it = slns.getAllChildren().iterator();
        ConfigurationItem slnConfigItem = null;
        SolutionDeployInfo slnDeployInfo = null;
        while (it.hasNext()) {
            ConfigurationItem aisConfigItems;
            slnConfigItem = (ConfigurationItem)it.next();
            if (slnConfigItem.getName().equalsIgnoreCase(USERDATA)) {
                this.properties = slnConfigItem.getProperties();
                break;
            }
            slnDeployInfo = new SolutionDeployInfo();
            slnDeployInfo.setName(slnConfigItem.getName());
            String strBinary = slnConfigItem.getProperty("useBinaryMetadata");
            if ("true".equalsIgnoreCase(strBinary)) {
                XMLAccessEngine.useBinaryMetadata = true;
            }
            slnDeployInfo.setMetaDataPath(slnConfigItem.getProperty(METADATAPATH));
            slnDeployInfo.setConcurrentConfigPath(slnConfigItem.getProperty(CONCURRENTCONFIGPATH));
            ConfigurationItem propsConfigItems = slnConfigItem.getChild(USERDATA);
            if (propsConfigItems != null) {
                slnDeployInfo.properties = propsConfigItems.getProperties();
            }
            if ((aisConfigItems = slnConfigItem.getChild(AISINFO)) == null) continue;
            Iterator aisIT = aisConfigItems.getAllChildren().iterator();
            AISDeployInfo aisDeployInfo = null;
            ConfigurationItem aisConfigItem = null;
            while (aisIT.hasNext()) {
                List list;
                aisConfigItem = (ConfigurationItem)aisIT.next();
                aisDeployInfo = new AISDeployInfo();
                aisDeployInfo.setName(aisConfigItem.getName());
                aisDeployInfo.setQueryServer(aisConfigItem.getProperty(QUERYSERVER));
                ConfigurationItem aisPropsConfigItem = aisConfigItem.getChild(USERDATA);
                if (aisPropsConfigItem != null) {
                    aisDeployInfo.properties = aisPropsConfigItem.getProperties();
                }
                if ((list = aisConfigItem.getAllChildren()) == null) break;
                ConfigurationItem aisEJBConfigItem = null;
                for (ConfigurationItem tmp : list) {
                    if (!tmp.getName().equalsIgnoreCase(EJBSERVICE)) continue;
                    aisEJBConfigItem = tmp;
                    AppServerDeployInfo appInfo = new AppServerDeployInfo();
                    appInfo.setContextFactory(aisEJBConfigItem.getProperty(CONTEXTFACTORY));
                    appInfo.setDatasource(aisEJBConfigItem.getProperty(DATASOURCE));
                    if (aisEJBConfigItem.getProperty(JNDIURL) != null) {
                        appInfo.setJndiURL(aisEJBConfigItem.getProperty(JNDIURL));
                    }
                    appInfo.setSecurityCredential(aisEJBConfigItem.getProperty(SECURITYCREDENTIAL));
                    appInfo.setSecurityPrincipal(aisEJBConfigItem.getProperty(SECURITYPRINCIPAL));
                    aisDeployInfo.addServerInfo(appInfo);
                }
                slnDeployInfo.addAISInfo(aisDeployInfo);
            }
            this.solutionDeployInfos.put(slnDeployInfo.getName(), slnDeployInfo);
        }
        ConfigurationItem debugOption = this.config.getConfigItem(DEBUGOPTIONS);
        this.configItems.put(DEBUGOPTIONS, debugOption);
        if (debugOption == null) {
            return;
        }
        String flag = debugOption.getProperty(CACHELAZYLOAD, "false");
        this.setLazyLoadMetaData(Boolean.valueOf(flag));
        String nonejb = debugOption.getProperty(NONEJB, "false");
        this.setNonEJB(Boolean.valueOf(nonejb));
        String collection = debugOption.getProperty(CRITICALCOLLECTION, "0");
        this.setCriticalCollection(Integer.parseInt(collection));
        String collection4Log = debugOption.getProperty(CRITICALCOLLECTION4LOG, "0");
        this.setCriticalCollection4Log(Integer.parseInt(collection4Log));
        String idList = debugOption.getProperty(CRITICALIDLIST, "0");
        this.setCriticalIDList(Integer.parseInt(idList));
        String queryPKs = debugOption.getProperty(CRITICALQUERYPKS, idList);
        this.setCriticalQueryPKs(Integer.parseInt(queryPKs));
        String idSet = debugOption.getProperty(CRITICALSETSIZE, "0");
        String setSize = debugOption.getProperty(CRITICALSETSIZE, idSet);
        this.setCriticalSetSize(Integer.parseInt(setSize));
        String useSelectCache = debugOption.getProperty(USE_SELECT_CACHE, "true");
        this.setUseSelectCache(Boolean.valueOf(useSelectCache));
        String realRowCount = debugOption.getProperty(GETREALROWCOUNT, "true");
        this.setRealRowCount(Boolean.valueOf(realRowCount));
    }

    private void loadLicense() {
        ConfigurationItem license = this.config.getConfigItem(LICENSEFILE);
        if (license == null) {
            return;
        }
        this.configItems.put(LICENSEFILE, license);
        ConfigurationItem propsConfigItems = license.getChild(USERDATA);
        if (propsConfigItems != null) {
            this.license.properties = propsConfigItems.getProperties();
        }
        this.license.setLicenseFileReader(license.getProperty(LICENSEFILEFILEREADER));
        this.license.setSoftwareName(license.getProperty(SOFTWARENAME));
        this.license.setSerialNumber(license.getProperty(SERIALNUMBER));
    }

    private void loadDMC() {
        ConfigurationItem dmc = this.config.getConfigItem(DMC);
        if (dmc == null) {
            return;
        }
        this.configItems.put(DMC, dmc);
        ConfigurationItem propsConfigItems = dmc.getChild(USERDATA);
        if (propsConfigItems != null) {
            this.dmc.properties = propsConfigItems.getProperties();
        }
        this.dmc.setURL(dmc.getProperty(URL));
        this.dmc.setUserName(dmc.getProperty(USERNAME));
        this.dmc.setPassword(dmc.getProperty(PASSWORD));
    }

    private void loadMessage() {
        ConfigurationItem message = this.config.getConfigItem(MESSAGE);
        if (message == null) {
            return;
        }
        this.configItems.put(MESSAGE, message);
        this.message.setServiceType(message.getProperty(SERVICETYPE));
        this.message.setDefaultDestination(message.getProperty(DEFAULTDESTINATION));
        ConfigurationItem propsConfigItems = message.getChild(USERDATA);
        if (propsConfigItems != null) {
            this.message.properties = propsConfigItems.getProperties();
        }
        ConfigurationItem listenerConfigItems = message.getChild(LISTENERS);
        ConfigurationItem destinationConfigItems = message.getChild(DESTINATIONS);
        if (listenerConfigItems != null) {
            Iterator listenIT = listenerConfigItems.getAllChildren().iterator();
            ListenerInfo listen = null;
            ConfigurationItem listenConfigItem = null;
            while (listenIT.hasNext()) {
                listenConfigItem = (ConfigurationItem)listenIT.next();
                listen = new ListenerInfo();
                listen.setName(listenConfigItem.getName());
                ConfigurationItem listenPropsConfigItem = listenConfigItem.getChild(USERDATA);
                if (listenPropsConfigItem != null) {
                    listen.properties = listenPropsConfigItem.getProperties();
                }
                listen.setClassName(listenConfigItem.getProperty(NAME));
                listen.setFullName(listenConfigItem.getProperty(CLASS));
                listen.setDomin(listenConfigItem.getProperty(DOMAIN));
                listen.setFilter(listenConfigItem.getProperty(FILTER));
                this.message.addListenerInfo(listen);
            }
        }
        if (destinationConfigItems != null) {
            Iterator desIT = destinationConfigItems.getAllChildren().iterator();
            DestinationInfo destination = null;
            ConfigurationItem desConfigItem = null;
            while (desIT.hasNext()) {
                desConfigItem = (ConfigurationItem)desIT.next();
                destination = new DestinationInfo();
                destination.setName(desConfigItem.getName());
                ConfigurationItem desPropsConfigItem = desConfigItem.getChild(USERDATA);
                if (desPropsConfigItem != null) {
                    destination.properties = desPropsConfigItem.getProperties();
                }
                destination.setDriverClassName(desConfigItem.getProperty(DRIVERCLASSNAME));
                destination.setURL(desConfigItem.getProperty(URL));
                List list = desConfigItem.getAllChildren();
                if (list == null) break;
                ConfigurationItem desPropConfigItem = null;
                for (ConfigurationItem tmp : list) {
                    if (!tmp.getName().equalsIgnoreCase(PROPERTIES)) continue;
                    desPropConfigItem = tmp;
                    MsgServerDeployInfo msgInfo = new MsgServerDeployInfo();
                    msgInfo.setContextFactory(desPropConfigItem.getProperty(CONTEXTFACTORY));
                    msgInfo.setConnectionFactoryJNDIName(desPropConfigItem.getProperty(CONNECTIONFACTORYJNDINAME));
                    msgInfo.setJndiURL(desPropConfigItem.getProperty(JNDIURL));
                    msgInfo.setSecurityCredential(desPropConfigItem.getProperty(SECURITYCREDENTIAL));
                    msgInfo.setSecurityPrincipal(desPropConfigItem.getProperty(SECURITYPRINCIPAL));
                    destination.addServerInfo(msgInfo);
                }
                this.message.addDestinationInfo(destination);
            }
        }
    }

    private void loadORMService() {
        ConfigurationItem services = this.config.getConfigItem(ORMSERVICE);
        if (services == null) {
            return;
        }
        this.configItems.put(ORMSERVICE, services);
        Iterator it = services.getAllChildren().iterator();
        ConfigurationItem serviceConfigItem = null;
        ORMServiceLocationInfo serviceInfo = null;
        while (it.hasNext()) {
            serviceConfigItem = (ConfigurationItem)it.next();
            serviceInfo = new ORMServiceLocationInfo();
            serviceInfo.setName(serviceConfigItem.getName());
            serviceInfo.setServiceURL(serviceConfigItem.getProperty(SERVICEURL));
            ConfigurationItem propsConfigItems = serviceConfigItem.getChild(USERDATA);
            if (propsConfigItems != null) {
                serviceInfo.properties = propsConfigItems.getProperties();
            }
            this.ORMServices.put(serviceInfo.getName(), serviceInfo);
        }
    }

    private void loadWorkflow() {
        ConfigurationItem workflow = this.config.getConfigItem(WORKFLOW);
        if (workflow == null) {
            return;
        }
        this.configItems.put(WORKFLOW, workflow);
        ConfigurationItem propsConfigItems = workflow.getChild(USERDATA);
        if (propsConfigItems != null) {
            this.workflow.properties = propsConfigItems.getProperties();
        }
        this.workflow.setIsEnableScheduler(Boolean.valueOf(workflow.getProperty(ISENABLESCHEDULER, "true")));
        this.workflow.setSchedulerIdleWaiteTime(Integer.parseInt(workflow.getProperty(SCHEDULERIDLEWAITETIME, "500")));
        this.workflow.setSchedulerThreadPoolSize(Integer.parseInt(workflow.getProperty(SCHEDULERTHREADPOOLSIZE, "15")));
        this.workflow.setWorkflowTransQueueTime(Integer.parseInt(workflow.getProperty(WORKFLOWTRANSQUEUETIME, "500")));
        this.workflow.setIsInitWfService(Boolean.valueOf(workflow.getProperty(ISINITWFSERVICE, "true")));
        this.workflow.setWorkflowServerKey(workflow.getProperty(WORKFLOWSERVERKEY));
        Iterator it = workflow.getAllChildren().iterator();
        ConfigurationItem workflowConfigItem = null;
        while (it.hasNext()) {
            workflowConfigItem = (ConfigurationItem)it.next();
            if (StringUtils.equalsIgnoreCase((String)workflowConfigItem.getName(), (String)LOGCOINFIG)) {
                Map logConfigs = workflowConfigItem.getProperties();
                Iterator logIT = logConfigs.keySet().iterator();
                while (logIT.hasNext()) {
                    String key = logIT.next().toString();
                    this.workflow.addLogConfig(key, logConfigs.get(key).toString());
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)workflowConfigItem.getName(), (String)CONCURRENT)) {
                ConfigurationItem ciWfTransEvent = workflowConfigItem.getChild("WfTransEvent");
                this.workflow.addTransConcurrentConfig("EnablePriorityPolicy", ciWfTransEvent.getProperty("EnablePriorityPolicy"));
                ConfigurationItem ciPriorityCapability = ciWfTransEvent.getChild("PriorityCapability");
                Map mapPriorityCapability = ciPriorityCapability.getProperties();
                Iterator itCapability = mapPriorityCapability.keySet().iterator();
                while (itCapability.hasNext()) {
                    String key = itCapability.next().toString();
                    this.workflow.addTransConcurrentConfig(key, ciPriorityCapability.getProperty(key).toString());
                }
                continue;
            }
            this.workflow.addProvider(workflowConfigItem.getName(), workflowConfigItem.getProperty(PROVIDER));
        }
    }

    private void loadJDBCSetting() {
        ConfigurationItem jdbcConfig = this.config.getConfigItem(JDBC_SETTING);
        if (jdbcConfig == null) {
            return;
        }
        this.configItems.put(JDBC_SETTING, jdbcConfig);
    }

    @Override
    public void load() {
        this.loadWorkflow();
        this.loadORMService();
        this.loadMessage();
        this.loadDMC();
        this.loadLicense();
        this.loadSolution();
        this.loadJDBCSetting();
    }

    @Override
    public void storeDebugOption() {
        String strRealRowCount;
        String strUseSelectCache;
        String setSize;
        String queryPKs;
        String idList;
        String collection4Log;
        String collection;
        String nonejb;
        ConfigurationItem debugOption = this.config.getConfigItem(DEBUGOPTIONS);
        if (debugOption == null) {
            return;
        }
        String cacheLazyLoad = debugOption.getProperty(CACHELAZYLOAD, "false");
        if (!cacheLazyLoad.equals(String.valueOf(this.isLazyLoadMetaData))) {
            debugOption.setProperty(CACHELAZYLOAD, String.valueOf(this.isLazyLoadMetaData));
        }
        if (!(nonejb = debugOption.getProperty(NONEJB, "false")).equals(String.valueOf(this.isNonEJB))) {
            debugOption.setProperty(NONEJB, String.valueOf(this.isNonEJB));
        }
        if (!(collection = debugOption.getProperty(CRITICALCOLLECTION, "0")).equals(String.valueOf(this.criticalCollection))) {
            debugOption.setProperty(CRITICALCOLLECTION, String.valueOf(this.criticalCollection));
        }
        if (!(collection4Log = debugOption.getProperty(CRITICALCOLLECTION4LOG, "0")).equals(String.valueOf(this.criticalCollection4Log))) {
            debugOption.setProperty(CRITICALCOLLECTION4LOG, String.valueOf(this.criticalCollection4Log));
        }
        if (!(idList = debugOption.getProperty(CRITICALIDLIST, "0")).equals(String.valueOf(this.criticalIDList))) {
            debugOption.setProperty(CRITICALIDLIST, String.valueOf(this.criticalIDList));
        }
        if (!(queryPKs = debugOption.getProperty(CRITICALQUERYPKS, "0")).equals(String.valueOf(this.criticalQueryPKs))) {
            debugOption.setProperty(CRITICALQUERYPKS, String.valueOf(this.criticalQueryPKs));
        }
        if (!(setSize = debugOption.getProperty(CRITICALSETSIZE, "0")).equals(String.valueOf(this.criticalSetSize))) {
            debugOption.setProperty(CRITICALSETSIZE, String.valueOf(this.criticalSetSize));
        }
        if (!(strUseSelectCache = debugOption.getProperty(USE_SELECT_CACHE, "true")).equals(String.valueOf(this.useSelectCache))) {
            debugOption.setProperty(USE_SELECT_CACHE, String.valueOf(this.useSelectCache));
        }
        if (!(strRealRowCount = debugOption.getProperty(GETREALROWCOUNT, "true")).equals(String.valueOf(this.realRowCount))) {
            debugOption.setProperty(GETREALROWCOUNT, String.valueOf(this.realRowCount));
        }
        this.config.store();
    }

    @Override
    public void storeSolution() {
        ConfigurationItem slnInfoItem = this.saftyGetConf(this.config, SOLUTIONINFO);
        Iterator slnsIT = this.getSolutionDeployInfos().iterator();
        SolutionDeployInfo slnDeployInfo = null;
        ConfigurationItem slnDeployItem = null;
        while (slnsIT.hasNext()) {
            slnDeployInfo = (SolutionDeployInfo)slnsIT.next();
            slnDeployItem = this.saftyGetChild(slnInfoItem, slnDeployInfo.getName());
            Iterator aisIT = slnDeployInfo.getAISInfos().iterator();
            AISDeployInfo aisDeployInfo = null;
            AppServerDeployInfo appDeployInfo2 = null;
            ConfigurationItem aisDeployItem = null;
            ConfigurationItem aisEJBItem = null;
            ConfigurationItem aisesDeployItem = this.saftyGetChild(slnDeployItem, AISINFO);
            while (aisIT.hasNext()) {
                aisDeployInfo = (AISDeployInfo)aisIT.next();
                aisDeployItem = this.saftyGetChild(aisesDeployItem, aisDeployInfo.getName());
                AppServerDeployInfo[] appDeployInfos = aisDeployInfo.getServerInfos();
                if (appDeployInfos != null && appDeployInfos.length != 0) {
                    for (AppServerDeployInfo appDeployInfo2 : appDeployInfos) {
                        aisEJBItem = this.saftyGetChild(aisDeployItem, EJBSERVICE);
                        aisEJBItem.setProperty(CONTEXTFACTORY, appDeployInfo2.getContextFactory());
                        if (appDeployInfo2.getJndiURL() != null) {
                            aisEJBItem.setProperty(JNDIURL, appDeployInfo2.getJndiURL());
                        }
                        if (appDeployInfo2.getSecurityCredential() != null) {
                            aisEJBItem.setProperty(SECURITYCREDENTIAL, appDeployInfo2.getSecurityCredential());
                        }
                        if (appDeployInfo2.getSecurityPrincipal() != null) {
                            aisEJBItem.setProperty(SECURITYPRINCIPAL, appDeployInfo2.getSecurityPrincipal());
                        }
                        aisEJBItem.setProperty(DATASOURCE, appDeployInfo2.getDatasource());
                    }
                }
                if (!StringUtils.isEmpty((String)aisDeployInfo.getQueryServer())) {
                    aisDeployItem.setProperty(QUERYSERVER, aisDeployInfo.getQueryServer());
                }
                if (aisDeployInfo.properties.size() == 0) continue;
                ConfigurationItem userData = this.saftyGetChild(aisDeployItem, USERDATA);
                for (String key : aisDeployInfo.properties.keySet()) {
                    userData.setProperty(key, (String)aisDeployInfo.properties.get(key));
                }
            }
            if (slnDeployInfo.properties.size() != 0) {
                ConfigurationItem userData = this.saftyGetChild(slnDeployItem, USERDATA);
                for (String key : slnDeployInfo.properties.keySet()) {
                    userData.setProperty(key, (String)slnDeployInfo.properties.get(key));
                }
            }
            slnDeployItem.setProperty(METADATAPATH, slnDeployInfo.getMetaDataPath());
            slnDeployItem.setProperty(CONCURRENTCONFIGPATH, slnDeployInfo.getConcurrentConfigPath());
        }
        if (this.properties.size() != 0) {
            ConfigurationItem userData = this.saftyGetChild(slnInfoItem, USERDATA);
            for (String key : this.properties.keySet()) {
                userData.setProperty(key, (String)this.properties.get(key));
            }
        }
        this.config.store();
    }

    @Override
    public void storeLicense() {
        if (this.license == null) {
            return;
        }
        ConfigurationItem licInfoItem = this.saftyGetConf(this.config, LICENSEFILE);
        licInfoItem.setProperty(LICENSEFILEFILEREADER, this.license.getLicenseFileReader());
        licInfoItem.setProperty(SOFTWARENAME, this.license.getSoftwareName());
        licInfoItem.setProperty(SERIALNUMBER, this.license.getSerialNumber());
        if (this.license.properties.size() != 0) {
            ConfigurationItem userData = this.saftyGetChild(licInfoItem, USERDATA);
            for (String key : this.properties.keySet()) {
                userData.setProperty(key, (String)this.properties.get(key));
            }
        }
        this.config.store();
    }

    @Override
    public void storeDMC() {
        if (this.dmc == null) {
            return;
        }
        ConfigurationItem dmcInfoItem = this.saftyGetConf(this.config, DMC);
        dmcInfoItem.setProperty(URL, this.dmc.getURL());
        dmcInfoItem.setProperty(USERNAME, this.dmc.getUserName());
        dmcInfoItem.setProperty(PASSWORD, this.dmc.getPassword());
        if (this.dmc.properties.size() != 0) {
            ConfigurationItem userData = this.saftyGetChild(dmcInfoItem, USERDATA);
            for (String key : this.properties.keySet()) {
                userData.setProperty(key, (String)this.properties.get(key));
            }
        }
        this.config.store();
    }

    @Override
    public void storeMessage() {
        ConfigurationItem userData;
        if (this.message == null) {
            return;
        }
        ConfigurationItem messageInfoItem = this.saftyGetConf(this.config, MESSAGE);
        Iterator listenerIT = this.message.getListenerInfos().iterator();
        Iterator destinationIT = this.message.getDestinationInfos().iterator();
        ListenerInfo listenerInfo = null;
        DestinationInfo destinationInfo = null;
        MsgServerDeployInfo msgDeployInfo2 = null;
        ConfigurationItem listenerItem = null;
        ConfigurationItem destinationItem = null;
        ConfigurationItem msgServerItem = null;
        ConfigurationItem listenersItem = this.saftyGetChild(messageInfoItem, LISTENERS);
        ConfigurationItem destinationsItem = this.saftyGetChild(messageInfoItem, DESTINATIONS);
        while (listenerIT.hasNext()) {
            listenerInfo = (ListenerInfo)listenerIT.next();
            listenerItem = this.saftyGetChild(listenersItem, listenerInfo.getName());
            listenerItem.setProperty(NAME, listenerInfo.getClassName());
            listenerItem.setProperty(CLASS, listenerInfo.getFullName());
            listenerItem.setProperty(DOMAIN, listenerInfo.getDomain());
            listenerItem.setProperty(FILTER, listenerInfo.getFilter());
            if (listenerInfo.properties.size() == 0) continue;
            userData = this.saftyGetChild(listenerItem, USERDATA);
            for (String key : listenerInfo.properties.keySet()) {
                userData.setProperty(key, (String)listenerInfo.properties.get(key));
            }
        }
        while (destinationIT.hasNext()) {
            destinationInfo = (DestinationInfo)destinationIT.next();
            destinationItem = this.saftyGetChild(destinationsItem, destinationInfo.getName());
            destinationItem.setProperty(DRIVERCLASSNAME, destinationInfo.getDriverClassName());
            destinationItem.setProperty(URL, destinationInfo.getURL());
            MsgServerDeployInfo[] appDeployInfos = destinationInfo.getServerInfos();
            if (appDeployInfos != null && appDeployInfos.length != 0) {
                for (MsgServerDeployInfo msgDeployInfo2 : appDeployInfos) {
                    msgServerItem = this.saftyGetChild(destinationItem, PROPERTIES);
                    msgServerItem.setProperty(CONTEXTFACTORY, msgDeployInfo2.getContextFactory());
                    msgServerItem.setProperty(JNDIURL, msgDeployInfo2.getJndiURL());
                    msgServerItem.setProperty(SECURITYCREDENTIAL, msgDeployInfo2.getSecurityCredential());
                    msgServerItem.setProperty(SECURITYPRINCIPAL, msgDeployInfo2.getSecurityPrincipal());
                    msgServerItem.setProperty(CONNECTIONFACTORYJNDINAME, msgDeployInfo2.getConnectionFactoryJNDIName());
                }
            }
            if (destinationInfo.properties.size() == 0) continue;
            ConfigurationItem userData2 = this.saftyGetChild(destinationItem, USERDATA);
            for (String key : destinationInfo.properties.keySet()) {
                userData2.setProperty(key, (String)destinationInfo.properties.get(key));
            }
        }
        if (this.message.properties.size() != 0) {
            userData = this.saftyGetChild(messageInfoItem, USERDATA);
            for (String key : this.message.properties.keySet()) {
                userData.setProperty(key, (String)this.message.properties.get(key));
            }
        }
        messageInfoItem.setProperty(SERVICETYPE, this.message.getServiceType());
        messageInfoItem.setProperty(DEFAULTDESTINATION, this.message.getDefaultDestination());
        this.config.store();
    }

    @Override
    public void storeORMService() {
        ConfigurationItem ORMServiceInfoItem = this.saftyGetConf(this.config, ORMSERVICE);
        Iterator ormIT = this.getORMServiceLocationInfos().iterator();
        ORMServiceLocationInfo ormInfo = new ORMServiceLocationInfo();
        ConfigurationItem ormItem = null;
        while (ormIT.hasNext()) {
            ormInfo = (ORMServiceLocationInfo)ormIT.next();
            ormItem = this.saftyGetChild(ORMServiceInfoItem, ormInfo.getName());
            ormItem.setProperty(SERVICEURL, ormInfo.getServiceURL());
            if (ormInfo.properties.size() == 0) continue;
            ConfigurationItem userData = this.saftyGetChild(ormItem, USERDATA);
            for (String key : ormInfo.properties.keySet()) {
                userData.setProperty(key, (String)ormInfo.properties.get(key));
            }
        }
        this.config.store();
    }

    @Override
    public void storeWorkflow() {
        if (this.workflow == null) {
            return;
        }
        ConfigurationItem workflowItem = this.saftyGetConf(this.config, WORKFLOW);
        workflowItem.setProperty(ISENABLESCHEDULER, Boolean.toString(this.workflow.isIsEnableScheduler()));
        workflowItem.setProperty(SCHEDULERIDLEWAITETIME, Integer.toString(this.workflow.getSchedulerIdleWaiteTime()));
        workflowItem.setProperty(SCHEDULERTHREADPOOLSIZE, Integer.toString(this.workflow.getSchedulerThreadPoolSize()));
        workflowItem.setProperty(WORKFLOWTRANSQUEUETIME, Integer.toString(this.workflow.getWorkflowTransQueueTime()));
        workflowItem.setProperty(ISINITWFSERVICE, Boolean.toString(this.workflow.isIsInitWfService()));
        workflowItem.setProperty(WORKFLOWSERVERKEY, this.workflow.getWorkflowServerKey());
        Iterator logIT = this.workflow.getLogConfigs().keySet().iterator();
        ConfigurationItem logItem = this.saftyGetChild(workflowItem, LOGCOINFIG);
        while (logIT.hasNext()) {
            String key = logIT.next().toString();
            logItem.setProperty(key, this.workflow.getLogConfigs().get(key).toString());
        }
        ConfigurationItem ciConcurrent = this.saftyGetChild(workflowItem, CONCURRENT);
        ConfigurationItem ciWfTransEvent = this.saftyGetChild(ciConcurrent, "WfTransEvent");
        ciWfTransEvent.setProperty("EnablePriorityPolicy", (String)this.workflow.getTransConcurrentConfigs().get("EnablePriorityPolicy"));
        ConfigurationItem ciPriorityCapability = this.saftyGetChild(ciWfTransEvent, "PriorityCapability");
        ciPriorityCapability.setProperty("Lowest", this.workflow.getTransConcurrentConfig("Lowest"));
        ciPriorityCapability.setProperty("Low", this.workflow.getTransConcurrentConfig("Low"));
        ciPriorityCapability.setProperty("Lower", this.workflow.getTransConcurrentConfig("Lower"));
        ciPriorityCapability.setProperty("Medium", this.workflow.getTransConcurrentConfig("Medium"));
        ciPriorityCapability.setProperty("Higher", this.workflow.getTransConcurrentConfig("Higher"));
        ciPriorityCapability.setProperty("High", this.workflow.getTransConcurrentConfig("High"));
        ciPriorityCapability.setProperty("Highest", this.workflow.getTransConcurrentConfig("Highest"));
        Iterator providerIT = this.workflow.getProviders().keySet().iterator();
        while (providerIT.hasNext()) {
            String key = providerIT.next().toString();
            ConfigurationItem providerItem = this.saftyGetChild(workflowItem, key);
            providerItem.setProperty(PROVIDER, this.workflow.getProviders().get(key).toString());
        }
        if (this.workflow.properties.size() != 0) {
            ConfigurationItem userData = this.saftyGetChild(workflowItem, USERDATA);
            for (String key : this.workflow.properties.keySet()) {
                userData.setProperty(key, (String)this.message.properties.get(key));
            }
        }
        this.config.store();
    }

    public String toString() {
        return null;
    }

    public static void main(String[] args) {
        System.out.println("Test begin...........................\r\n\r\n");
        BOSDeployInfoManager bos = new BOSDeployInfoManager("E:\\bosconfig.xml");
        bos.setLazyLoadMetaData(false);
        bos.setNonEJB(true);
        bos.setCriticalCollection(200);
        bos.setCriticalCollection4Log(100);
        bos.setCriticalIDList(500);
        bos.setCriticalQueryPKs(500);
        bos.storeDebugOption();
        bos.removeAISDeployInfo("eas", "DBDemo1");
        ConfigurationItem item = bos.getConfigItem(WORKFLOW);
        System.out.println(item.getProperty(ISENABLESCHEDULER));
        SolutionDeployInfo s = bos.getSolutionDeployInfo("eas");
        s.setMetaDataPath("adf1111asdfa");
        bos.storeSolution();
        System.out.println("\r\nTest end..............................");
    }

    private ConfigurationItem saftyGetConf(Configuration conf, String name) {
        ConfigurationItem childItem = conf.getConfigItem(name);
        if (childItem == null) {
            childItem = new ConfigurationItem(name);
            conf.addConfigItem(childItem);
        }
        return childItem;
    }

    private ConfigurationItem saftyGetChild(ConfigurationItem confItem, String name) {
        ConfigurationItem childItem = confItem.getChild(name);
        if (childItem == null) {
            childItem = new ConfigurationItem(name);
            confItem.addChild(childItem);
        }
        return childItem;
    }
}

