/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginListener;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoginListenerManager {
    private static Logger logger = Logger.getLogger(LoginListenerManager.class);
    private static ListenerException[] le;
    private static LoginListener[] loginListeners;

    private static void init() {
        if (loginListeners != null) {
            return;
        }
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("loginListeners");
        if (ci == null) {
            return;
        }
        Map map = ci.getProperties();
        le = new ListenerException[map.size()];
        loginListeners = new LoginListener[map.size()];
        int i = 0;
        for (String className : map.values()) {
            LoginListenerManager.le[i] = new ListenerException(className, null);
            try {
                Class<?> c = Class.forName(className);
                LoginListenerManager.loginListeners[i] = (LoginListener)c.newInstance();
                ++i;
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                LoginListenerManager.le[i].e = e;
            }
        }
    }

    public static void beforeLogin(LoginContext context) {
        if (loginListeners != null) {
            for (int i = 0; i < loginListeners.length; ++i) {
                LoginListener listener = loginListeners[i];
                if (listener == null) {
                    throw new RuntimeException("Can't load " + LoginListenerManager.le[i].className + " ! Please check loginListeners config in bosconfig.xml.", LoginListenerManager.le[i].e);
                }
                listener.beforeLogin(context);
            }
        }
    }

    public static void afterLogin(LoginContext context, Context ctx) {
        if (loginListeners != null) {
            for (int i = 0; i < loginListeners.length; ++i) {
                LoginListener listener = loginListeners[i];
                listener.afterLogin(context, ctx);
            }
        }
    }

    static {
        LoginListenerManager.init();
    }

    private static class ListenerException {
        String className;
        Exception e;

        public ListenerException(String className, Exception e) {
            this.className = className;
            this.e = e;
        }
    }
}

