/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.config.SolutionDeployInfo;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginContextInterceptor;
import com.kingdee.bos.framework.session.LoginListenerManager;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.PassiveCallbackHandler;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.log4j.Logger;

public class LoginModule
extends ORMObject
implements ILoginModule {
    protected static final String APPLICATION_NAME = "eas";
    public static final String LOGIN_TYPE = "LOGIN_TYPE";
    private Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.session.LoginModule");
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"lgin");

    public LoginModule() {
        this.registerInterface(ILoginModule.class, this);
    }

    public LoginModule(IORMModel _owner) {
        super(_owner);
        this.registerInterface(ILoginModule.class, this);
    }

    public LoginModule(Context ctx) {
        this.registerInterface(ILoginModule.class, this);
    }

    @Override
    public String login(LoginContext ctx) throws BOSLoginException {
        Context userContext = this.fullLogin(ctx);
        return userContext.getContextID();
    }

    @Override
    public Context fullLogin(LoginContext ctx) throws BOSLoginException {
        if (ctx.getClientHostIP() == null || ctx.getClientHostIP().trim().length() < 1) {
            ctx.put("ClientIP", "0.0.0.0");
            this.logger.error((Object)"ClientIP:0.0.0.0");
        }
        if (ctx == null || ctx.getUserName() == null || ctx.getUserPass() == null) {
            throw new IllegalArgumentException("LoginContext/UserName/UserPass cannot be null.");
        }
        LoginListenerManager.beforeLogin(ctx);
        Configuration orignal = null;
        try {
            orignal = Configuration.getConfiguration();
            AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(APPLICATION_NAME);
            if (entries == null || entries.length == 0) {
                this.logger.error((Object)"get eas error!");
                throw new BOSLoginException("get eas error!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSLoginException(e);
        }
        SolutionDeployInfo slnDeployInfo = DeployInfoManagerFactory.getDeployInfoManager().getSolutionDeployInfo(ctx.getSlnName());
        if (slnDeployInfo == null) {
            throw new BOSLoginException("Invalid solution name: " + ctx.getSlnName());
        }
        Context userContext = new Context(null, ctx.getSlnName(), ctx.getAis(), ctx.getOriginLocale(), ctx.getContextID());
        userContext.setUserName(ctx.getUserName());
        this.fillContext(ctx, userContext);
        javax.security.auth.login.LoginContext lCtx = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("the user " + ctx.getUserName() + " want to login."));
        }
        PassiveCallbackHandler cbh = new PassiveCallbackHandler(ctx, userContext);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            lCtx = new javax.security.auth.login.LoginContext(APPLICATION_NAME, cbh);
            lCtx.login();
        }
        catch (Exception le) {
            if (le instanceof BOSLoginException) {
                throw (BOSLoginException)le;
            }
            throw new BOSLoginException(le);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        assert (userContext.getCaller() != null) : "LoginModule didn't initialize the callerPK";
        String sessionID = userContext.getContextID();
        SessionInfo session = new SessionInfo(userContext);
        session.put("LoginContext", lCtx);
        IServerSession rpc = ServerSessionContainer.getCurrentSession();
        SessionManager.getInstance().setSession(sessionID, session, rpc);
        if (orignal != null) {
            Configuration.setConfiguration(orignal);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SessionID: " + sessionID + " login!"));
        }
        LoginContextInterceptor.doFilters(userContext);
        LoginListenerManager.afterLogin(ctx, userContext);
        return userContext;
    }

    @Override
    public Context getContext() {
        return null;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public boolean logout(String sessionID) throws BOSLoginException {
        try {
            SessionInfo session = SessionManager.getInstance().getSession(sessionID);
            if (session != null) {
                Context ctx = session.getContext();
                IUserMonitor iUserMonitor = UserMonitorFactory.getLocalInstance((Context)ctx);
                iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, Boolean.valueOf(true));
            }
        }
        catch (Exception le) {
            throw new BOSLoginException(le);
        }
        return true;
    }

    @Override
    public boolean isOnline(String sessionID) {
        String bos_sessionid;
        boolean isExist;
        IServerSession rpc = ServerSessionContainer.getCurrentSession();
        boolean bl = isExist = SessionManager.getInstance().getSession(sessionID) != null;
        if (isExist && rpc != null && ((bos_sessionid = (String)rpc.get((Object)"bos_sessionid")) == null || SessionManager.getInstance().getSession(bos_sessionid) == null)) {
            rpc.put((Object)"bos_sessionid", (Object)sessionID);
        }
        return isExist;
    }

    @Override
    public boolean bindingRpcSession(String sessionID) {
        boolean isExist;
        IServerSession rpc = ServerSessionContainer.getCurrentSession();
        SessionInfo session = SessionManager.getInstance().getSession(sessionID);
        boolean bl = isExist = session != null;
        if (isExist && rpc != null && !sessionID.equals(rpc.get((Object)"bos_sessionid"))) {
            SessionManager.getInstance().setSession(sessionID, session, rpc);
        }
        return isExist;
    }

    private void fillContext(LoginContext lgCtx, Context ctx) {
        Iterator it = lgCtx.items.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            ctx.put(entry.getKey(), entry.getValue());
        }
        LoginType loginType = lgCtx.getLoginType();
        this.logger.debug((Object)("\u7528\u6237:" + lgCtx.getUserName() + ",\u767b\u9646\u7c7b\u578b:" + (Object)((Object)loginType)));
        this.logger.debug((Object)("\u662f\u5426portal\u767b\u9646\uff1a" + (loginType == LoginType.PORTAL)));
        if (null != loginType) {
            ctx.put((Object)LOGIN_TYPE, (Object)loginType);
        } else {
            ctx.put((Object)LOGIN_TYPE, null);
            String debugMsg = "\u672a\u8bbe\u7f6e\u767b\u9646\u7c7b\u578b:" + lgCtx.getUserName() + "," + lgCtx.getClientHostIP();
            this.logger.error((Object)debugMsg);
        }
    }

    @Override
    public Context getContextBySessionID(String sessionID) throws BOSException {
        SessionInfo session = SessionManager.getInstance().getSession(sessionID);
        if (session == null) {
            throw new IllegalSessionStateException("Cannot found session info! sessionID is " + sessionID);
        }
        return session.getContext();
    }

    static class InnerConfiguation
    extends Configuration {
        InnerConfiguation() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (appName.equals(LoginModule.APPLICATION_NAME)) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("debug", "true");
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.kingdee.bos.framework.session.template.DemoLoginModule", AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, map)};
            }
            return new AppConfigurationEntry[0];
        }

        @Override
        public void refresh() {
        }
    }
}

