/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.Context;
import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PassiveCallbackHandler
implements CallbackHandler {
    private String username;
    private Context userContext = null;
    private LoginContext lc = null;
    char[] password;

    public PassiveCallbackHandler(LoginContext lc, Context userContext) {
        this.username = lc.getUserName();
        this.lc = lc;
        this.userContext = userContext;
        if (!StringUtils.isEmpty((String)lc.getUserPass())) {
            this.password = lc.getUserPass().toCharArray();
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                ((PasswordCallback)callbacks[i]).setPassword(this.password);
                continue;
            }
            if (callbacks[i] instanceof UserContextCallback) {
                UserContextCallback userCallback = (UserContextCallback)callbacks[i];
                userCallback.setUserContext(this.userContext);
                userCallback.setUserName(this.username);
                userCallback.setClientHostIP(this.lc.getClientHostIP());
                userCallback.setClientHostName(this.lc.getClientHostName());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "Callback class not supported");
        }
    }

    public void clearPassword() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
    }
}

