/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.framework.session.ApplicationInfo;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.RPCSessionShutdown;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionListener;
import com.kingdee.bos.framework.session.SessionListener2;
import com.kingdee.bos.framework.session.SessionNotFoundException;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.IServerSessionListener;
import com.kingdee.util.objbuddy.BuddyObjectFactory;
import com.kingdee.util.objbuddy.IBuddyObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SessionManager
implements ISessionManager {
    static final Logger logger = Logger.getLogger(SessionManager.class);
    private static final ISessionManager manager = new SessionManager();
    private static final List<SessionListener> sessionListeners = Collections.synchronizedList(new ArrayList(4));
    private static final Set<IServerSessionListener> serverSessionlisteners = new HashSet<IServerSessionListener>(2);
    static final Map<String, SessionInfo> sessions = new HashMap<String, SessionInfo>();
    static final Map<String, ApplicationInfo> applications = new HashMap<String, ApplicationInfo>();
    private Map<String, IServerSession> serverSessions = new HashMap<String, IServerSession>();
    private final IBuddyObject buddy = BuddyObjectFactory.getInstance((Object)this);

    public static ISessionManager getInstance() {
        return manager;
    }

    private SessionManager() {
        this.buddy.initialize();
    }

    @Override
    public SessionInfo getSession(String sessionID) {
        SessionInfo session = sessions.get(sessionID);
        return session;
    }

    private synchronized SessionInfo synGetSession(String sessionID) {
        return sessions.get(sessionID);
    }

    @Override
    public SessionInfo getSessionWithException(String sessionID) throws SessionNotFoundException {
        SessionInfo session = sessions.get(sessionID);
        if (session == null) {
            session = this.synGetSession(sessionID);
        }
        if (session == null) {
            throw new SessionNotFoundException("sessionID is " + sessionID);
        }
        return session;
    }

    @Override
    public synchronized void removeSession(String sessionID) {
        int i;
        SessionInfo session = sessions.get(sessionID);
        SessionListener[] listeners = sessionListeners.toArray(new SessionListener[0]);
        for (i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof SessionListener2)) continue;
            ((SessionListener2)listeners[i]).beforeDestory(sessionID, session);
        }
        session = sessions.remove(sessionID);
        if (session == null) {
            logger.info((Object)("Remove session failed. Can't find session! sessionID is " + sessionID));
            return;
        }
        for (i = 0; i < listeners.length; ++i) {
            listeners[i].destory(sessionID, session);
        }
        this.buddy.operationPerformed("removeSession", (Object[])new String[]{sessionID});
    }

    @Override
    public void removeSession(IServerSession serverSession) {
        if (serverSession == null) {
            return;
        }
        String sessionID = (String)serverSession.get((Object)"bos_sessionid");
        if (sessionID == null) {
            return;
        }
        if (this.getServerSession(sessionID) == serverSession) {
            this.removeSession(sessionID);
        }
        this.removeServerSession(sessionID);
    }

    @Override
    public synchronized void setSession(String sessionID, SessionInfo session) {
        sessions.put(sessionID, session);
        SessionListener[] listeners = sessionListeners.toArray(new SessionListener[0]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].create(sessionID, session);
        }
        this.buddy.operationPerformed("createSession", (Object[])new String[]{sessionID});
    }

    @Override
    public void setSession(String sessionID, SessionInfo session, IServerSession rpc) {
        if (rpc != null) {
            this.setServerSession(sessionID, rpc);
            rpc.put((Object)"bos_sessionid", (Object)sessionID);
            rpc.addEventListener((IServerSessionListener)RPCSessionShutdown.getInstance());
            IServerSessionListener[] lsts = serverSessionlisteners.toArray(new IServerSessionListener[0]);
            for (int i = 0; i < lsts.length; ++i) {
                rpc.addEventListener(lsts[i]);
            }
        }
        this.setSession(sessionID, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerSession(String sessionID, IServerSession rpc) {
        Map<String, IServerSession> map = this.serverSessions;
        synchronized (map) {
            this.serverSessions.put(sessionID, rpc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServerSession getServerSession(String sessionID) {
        Map<String, IServerSession> map = this.serverSessions;
        synchronized (map) {
            return this.serverSessions.get(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServerSession(String sessionID) {
        Map<String, IServerSession> map = this.serverSessions;
        synchronized (map) {
            this.serverSessions.remove(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SessionInfo> getSessionList() {
        SessionInfo[] ss;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            ss = sessions.values().toArray(new SessionInfo[0]);
        }
        ArrayList<SessionInfo> list = new ArrayList<SessionInfo>();
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationInfo getApplication(String ais) {
        assert (ais != null);
        ApplicationInfo app = applications.get(ais);
        if (app == null) {
            Map<String, ApplicationInfo> map = applications;
            synchronized (map) {
                app = applications.get(ais);
                if (app == null) {
                    app = new ApplicationInfo();
                    applications.put(ais, app);
                }
            }
            return app;
        }
        return app;
    }

    public static void addSessionListener(SessionListener listener) {
        sessionListeners.add(listener);
    }

    public static void removeSessionListener(SessionListener listener) {
        sessionListeners.remove(listener);
    }

    public static List<SessionListener> getSessionListeners() {
        return sessionListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServerSessionListener(IServerSessionListener listener) {
        Set<IServerSessionListener> set = serverSessionlisteners;
        synchronized (set) {
            serverSessionlisteners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServerSessionListener(IServerSessionListener listener) {
        Set<IServerSessionListener> set = serverSessionlisteners;
        synchronized (set) {
            serverSessionlisteners.remove(listener);
        }
    }
}

