/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session;

import com.kingdee.bos.Context;
import com.kingdee.bos.MemoryTools;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.rpc.RPCServerSession;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.login.LoginContext;

public class TestSession {
    private static Set hook = new HashSet();

    public static void main(String[] args) throws Exception {
        int num = 1000;
        long memoryMark = MemoryTools.getUsedMemory();
        TestSession.addSessions(num);
        System.out.println(num + " Sessions Used memory " + (MemoryTools.getUsedMemory() - memoryMark) + " bytes.");
        int testFactor = 100;
        long start = System.currentTimeMillis();
        for (int i = 0; i < testFactor; ++i) {
            TestSession.iterateSessions();
        }
        System.out.println(num + " Sessions access Used " + (System.currentTimeMillis() - start) / (long)testFactor + " ms.");
    }

    private static void iterateSessions() {
        ISessionManager manager = SessionManager.getInstance();
        List<SessionInfo> sessions = manager.getSessionList();
        Iterator<SessionInfo> it = sessions.iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    private static SessionInfo newSession() throws Exception {
        Context ctx = new Context(null, "eas", "anyAIS", new Locale("any"));
        SessionInfo sess = new SessionInfo(ctx);
        try {
            LoginContext login = new LoginContext("eas");
            sess.put("LoginContext", login);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sess;
    }

    private static void addSessions(int num) throws Exception {
        for (int i = 0; i < num; ++i) {
            SessionInfo session = TestSession.newSession();
            String sessionID = String.valueOf(i);
            RPCServerSession rpcSession = new RPCServerSession(){

                protected void finalClose() throws Throwable {
                }
            };
            hook.add(rpcSession);
            rpcSession.putContext((Object)"bos_sessionid", (Object)sessionID);
            SessionManager.getInstance().setSession(sessionID, session);
        }
    }
}

