/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.session.template;

import com.kingdee.bos.UserContextCallback;
import com.kingdee.bos.framework.session.BOSLoginException;
import com.kingdee.bos.framework.session.LoginModuleListenerManager;
import com.kingdee.bos.framework.session.PassiveCallbackHandler;
import com.kingdee.bos.framework.session.template.Credential;
import com.kingdee.bos.framework.session.template.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.log4j.Logger;

public abstract class AbstractLoginModule
implements LoginModule {
    private Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.session.template.AbstractLoginModule");
    CallbackHandler callbackHandler;
    Subject subject;
    Map sharedState;
    Map options;
    Vector tempCredentials = new Vector();
    Vector tempPrincipals = new Vector();
    boolean success = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.sharedState = sharedState;
        this.options = options;
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        Callback[] cb = new Callback[3];
        try {
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new UserContextCallback("UserContext: ")};
            this.callbackHandler.handle(callbacks);
            cb[0] = callbacks[0];
            cb[1] = callbacks[1];
            cb[2] = callbacks[2];
            LoginModuleListenerManager.beforeLogin(cb);
            String username = ((NameCallback)callbacks[0]).getName();
            char[] innerPass = ((PasswordCallback)callbacks[1]).getPassword();
            String password = null;
            password = innerPass != null ? new String(innerPass) : null;
            UserContextCallback userCtxCallback = (UserContextCallback)callbacks[2];
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.success = this.verifyUserAndPassword(userCtxCallback, username, password);
            callbacks[0] = null;
            callbacks[1] = null;
            callbacks[2] = null;
            if (!this.success) {
                throw new LoginException("Authentication failed: Password does not match");
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            this.success = false;
            throw new BOSLoginException(ex);
        }
        finally {
            LoginModuleListenerManager.afterLogin(cb, this.success);
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            if (this.subject.isReadOnly()) {
                throw new LoginException("Subject is Readonly");
            }
            try {
                Iterator it = this.tempPrincipals.iterator();
                while (it.hasNext()) {
                    this.logger.info((Object)("[LoginModule] Principal: " + it.next().toString()));
                }
                this.subject.getPrincipals().addAll(this.tempPrincipals);
                this.subject.getPublicCredentials().addAll(this.tempCredentials);
                this.tempPrincipals.clear();
                this.tempCredentials.clear();
                if (this.callbackHandler instanceof PassiveCallbackHandler) {
                    ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
                }
                return true;
            }
            catch (Exception ex) {
                throw new BOSLoginException(ex);
            }
        }
        this.tempPrincipals.clear();
        this.tempCredentials.clear();
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.success = false;
        this.tempPrincipals.clear();
        this.tempCredentials.clear();
        if (this.callbackHandler instanceof PassiveCallbackHandler) {
            ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
        }
        this.logout();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.tempPrincipals.clear();
        this.tempCredentials.clear();
        if (this.callbackHandler instanceof PassiveCallbackHandler) {
            ((PassiveCallbackHandler)this.callbackHandler).clearPassword();
        }
        for (Principal p : this.subject.getPrincipals(Principal.class)) {
            this.logger.info((Object)("[LoginModule] removing principal " + p.toString()));
            this.subject.getPrincipals().remove(p);
        }
        for (Credential c : this.subject.getPublicCredentials(Credential.class)) {
            this.logger.info((Object)("[LoginModule] removing credential " + c.toString()));
            this.subject.getPrincipals().remove(c);
        }
        return true;
    }

    protected boolean verifyUserAndPassword(UserContextCallback userCtxCallback, String user, String pass) throws Exception {
        this._setUserPK(userCtxCallback, user);
        return this._verifyUserAndPassword(userCtxCallback, user, pass);
    }

    protected abstract boolean _verifyUserAndPassword(UserContextCallback var1, String var2, String var3) throws Exception;

    protected abstract void _setUserPK(UserContextCallback var1, String var2) throws Exception;
}

