/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.hotdeploy;

import com.kingdee.bos.hotdeploy.HotDeployException;
import com.kingdee.bos.hotdeploy.HotDeployerClient;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileNotifyHotDeployerClient
implements HotDeployerClient {
    private String notifyDirPath;

    FileNotifyHotDeployerClient(String notifyDirPath) {
        this.notifyDirPath = notifyDirPath;
    }

    @Override
    public void redeployMetadata(String fullName, String type, boolean reload) throws HotDeployException {
        long timestemp = System.currentTimeMillis();
        String s = fullName + "," + type + "," + reload;
        String requestFileName = "hotdeploy" + timestemp;
        File requestFile = new File(this.notifyDirPath, requestFileName);
        try {
            requestFile.createNewFile();
        }
        catch (IOException e) {
            throw new HotDeployException("hotdeploy error:cannot create file!", e);
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(requestFile);
            writer.write(s);
        }
        catch (Exception e) {
            throw new HotDeployException("hotdeploy error:write file error!", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

