/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.MissingDAOMetaDataException;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.dao.xml.impl.DBConfigureResourceLoader;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDReferenceFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectCollection;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.CrossTableCollection;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.DataTableCollection;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableCollection;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.application.AppViewInfo;
import com.kingdee.bos.metadata.mdquery.MDQueryCollection;
import com.kingdee.bos.metadata.mdquery.MDQueryInfo;
import com.kingdee.bos.metadata.query.QueryCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumCollection;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.rule.RuleCollection;
import com.kingdee.bos.metadata.rule.RuleInfo;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefCollection;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewInfo;
import com.kingdee.bos.metadata.view.listeners.MdbviewListenerManager;
import com.kingdee.bos.service.log.define.LogInfo;
import com.kingdee.bos.service.mutex.MutexInfo;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public abstract class AbstractMetaDataCache
implements IMetaDataLoader {
    protected Context ctx;
    protected static final Logger logger = Logger.getLogger(AbstractMetaDataCache.class);
    protected MDLoader loader;

    AbstractMetaDataCache(Context ctx) {
        this.ctx = ctx;
        this.loader = MDLoader.createInstance(ctx);
    }

    @Override
    public AppViewInfo getAppView() {
        return (AppViewInfo)this.get(MetaDataTypeList.APPVIEW, MetaDataPK.create(null, "bos"));
    }

    @Override
    public BusinessObjectInfo getBusinessObject(BOSObjectType bosType) {
        MDContext mdContext = this.loader.cl.getMDContext();
        IMetaDataPK pk = mdContext.entityMapping.getProperty(bosType);
        if (pk != null) {
            return (BusinessObjectInfo)this.get(MetaDataTypeList.ENTITY, pk);
        }
        pk = mdContext.facadeMapping.getProperty(bosType);
        if (pk != null) {
            return (BusinessObjectInfo)this.get(MetaDataTypeList.FACADE, pk);
        }
        throw new MetaDataNotFoundException("Cannot found BusinessObject bosType[" + bosType + "] in cache!");
    }

    @Override
    public BusinessObjectInfo getBusinessObject(IMetaDataPK pk) {
        MDContext mdContext = this.loader.cl.getMDContext();
        if (mdContext.entityMapping.contains(pk)) {
            return (BusinessObjectInfo)this.get(MetaDataTypeList.ENTITY, pk);
        }
        if (mdContext.facadeMapping.contains(pk)) {
            return (BusinessObjectInfo)this.get(MetaDataTypeList.FACADE, pk);
        }
        throw new MetaDataNotFoundException("Cannot found BusinessObject MetaDataPK[" + pk + "] in cache!");
    }

    @Override
    public BusinessObjectCollection getBusinessObjectCollection() {
        BusinessObjectCollection bos = new BusinessObjectCollection();
        EntityObjectCollection entites = this.getEntityCollection();
        FacadeCollection facades = this.getFacadeCollection();
        bos.addObjectCollection(entites);
        bos.addObjectCollection(facades);
        return bos;
    }

    protected void setContext(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Context getContext() {
        return this.ctx;
    }

    @Override
    public CrossTableInfo getCrossTable(IMetaDataPK pk) {
        return (CrossTableInfo)this.get(MetaDataTypeList.CROSSTABLE, pk);
    }

    @Override
    public CrossTableCollection getCrossTableCollection() {
        return (CrossTableCollection)this.getCollection(MetaDataTypeList.CROSSTABLE);
    }

    @Override
    public DataTableInfo getDataTable(IMetaDataPK pk) {
        return (DataTableInfo)this.get(MetaDataTypeList.DATATABLE, pk);
    }

    @Override
    public DataTableCollection getDataTableCollection() {
        return (DataTableCollection)this.getCollection(MetaDataTypeList.DATATABLE);
    }

    @Override
    public EntityObjectInfo getEntity(BOSObjectType bosType) {
        try {
            return (EntityObjectInfo)this.get(MetaDataTypeList.ENTITY, this.getEntityObjectPK(bosType));
        }
        catch (Exception ex) {
            IMetaDataPK pk = this.getEntityObjectPK(bosType);
            if (pk == null) {
                throw new MetaDataNotFoundException("Cannot find entity by BOSType[" + bosType + "]. Because cannot find BOSType[" + bosType + "] in index!");
            }
            throw new MetaDataNotFoundException("Cannot find entity by BOSType[" + bosType + "]", ex);
        }
    }

    @Override
    public EntityObjectInfo getEntity(IMetaDataPK pk) {
        Exception ex = null;
        try {
            return (EntityObjectInfo)this.get(MetaDataTypeList.ENTITY, pk);
        }
        catch (Exception ignore) {
            ex = ignore;
            try {
                return (EntityObjectInfo)this.loader.loadMDMeta(pk);
            }
            catch (Exception ignore2) {
                ex = ignore2;
                logger.debug((Object)("load entity error pk=" + pk), (Throwable)ex);
                throw new MetaDataNotFoundException("Cannot find entity by PK[" + pk + "]");
            }
        }
    }

    @Override
    public EntityObjectCollection getEntityCollection() {
        return (EntityObjectCollection)this.getCollection(MetaDataTypeList.ENTITY);
    }

    @Override
    public ExtendedTableInfo getExtendedTable(IMetaDataPK pk) {
        return (ExtendedTableInfo)this.get(MetaDataTypeList.EXTENDEDTABLE, pk);
    }

    @Override
    public ExtendedTableCollection getExtendedTableCollection() {
        return (ExtendedTableCollection)this.getCollection(MetaDataTypeList.EXTENDEDTABLE);
    }

    @Override
    public FacadeInfo getFacade(BOSObjectType bostype) {
        return (FacadeInfo)this.get(MetaDataTypeList.FACADE, this.getFacadePK(bostype));
    }

    @Override
    public FacadeInfo getFacade(IMetaDataPK pk) {
        return (FacadeInfo)this.get(MetaDataTypeList.FACADE, pk);
    }

    @Override
    public FacadeCollection getFacadeCollection() {
        return (FacadeCollection)this.getCollection(MetaDataTypeList.FACADE);
    }

    @Override
    public FunctionObjectInfo getFunction(IMetaDataPK pk) {
        return (FunctionObjectInfo)this.get(MetaDataTypeList.FUNCTION, pk);
    }

    @Override
    public FunctionObjectCollection getFunctions() {
        return (FunctionObjectCollection)this.getCollection(MetaDataTypeList.FUNCTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogInfo getLog() {
        try {
            LogInfo logInfo = MDReferenceFactory.getLog();
            return logInfo;
        }
        finally {
            MDReferenceFactory.releaseLog();
        }
    }

    @Override
    public MutexInfo getMutex() {
        return (MutexInfo)this.get(MetaDataTypeList.MUTEX, MetaDataPK.create(null, "service"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo getPermission() {
        try {
            PermissionInfo permissionInfo = MDReferenceFactory.getPermission();
            return permissionInfo;
        }
        finally {
            MDReferenceFactory.releasePermission();
        }
    }

    @Override
    public MDQueryInfo getMDQuery(IMetaDataPK pk) {
        return (MDQueryInfo)this.get(MetaDataTypeList.MDQUERY, pk);
    }

    @Override
    public MDQueryCollection getMDQueryCollection() {
        return (MDQueryCollection)this.getCollection(MetaDataTypeList.MDQUERY);
    }

    @Override
    public BizEnumInfo getEnum(IMetaDataPK pk) {
        return (BizEnumInfo)this.get(MetaDataTypeList.BIZENUM, pk);
    }

    @Override
    public BizEnumCollection getEnumCollection() {
        return (BizEnumCollection)this.getCollection(MetaDataTypeList.BIZENUM);
    }

    @Override
    public QueryInfo getQuery(IMetaDataPK pk) {
        return (QueryInfo)this.get(MetaDataTypeList.BASEQUERY, pk);
    }

    @Override
    public QueryCollection getQueryCollection() {
        return (QueryCollection)this.getCollection(MetaDataTypeList.BASEQUERY);
    }

    @Override
    public RuleInfo getRule(IMetaDataPK pk) {
        return (RuleInfo)this.get(MetaDataTypeList.RULE, pk);
    }

    @Override
    public RuleCollection getRuleCollection() {
        return (RuleCollection)this.getCollection(MetaDataTypeList.RULE);
    }

    @Override
    public SolutionInfo getSolution() {
        return (SolutionInfo)this.get(MetaDataTypeList.SOLUTION, null);
    }

    @Override
    public BusinessObjectBriefView getBusinessObjectBriefView(IMetaDataPK pk) {
        MetaDataBriefViewInfo info = (MetaDataBriefViewInfo)this.get(MetaDataTypeList.METADATABRIEFVIEW, pk);
        MetaDataPK2[] mdPk1 = this.loader.cl.getMDContext().pkIndexs.getAddNewPKs(null);
        MetaDataPK2[] mdPk2 = this.getMetaDataPKsAffectMdbview();
        if (mdPk1 != null && mdPk1.length > 0 || mdPk2 != null && mdPk2.length > 0) {
            MetaDataBriefViewInfo info2 = new MetaDataBriefViewInfo();
            MetaDataBriefCollection mdbc = info.getMetaDataBriefs();
            if (mdbc != null) {
                int len = mdbc.size();
                for (int i = 0; i < len; ++i) {
                    info2.getMetaDataBriefs().add(mdbc.get(i));
                }
            }
            info2.setRoot(info.getRoot());
            MdbviewListenerManager.addNew(pk, info2, mdPk1, null);
            MdbviewListenerManager.modify(pk, info2, mdPk2, null);
            info = info2;
        }
        return new BusinessObjectBriefView(this.getRoot(info, pk), this.createMetaDataResource());
    }

    private IBriefViewTreeNode getRoot(MetaDataBriefViewInfo view, IMetaDataPK pk) {
        MetaDataBriefCollection metas = view.getMetaDataBriefs();
        if (metas == null) {
            throw new NullPointerException("Can't load " + pk);
        }
        this.processAlias(metas);
        LinkedHashMap<String, BriefViewTreeNode> tree = new LinkedHashMap<String, BriefViewTreeNode>();
        LinkedList<BriefViewTreeNode> listTmp = new LinkedList<BriefViewTreeNode>();
        MetaDataBriefInfo info = null;
        BriefViewTreeNode node = null;
        BriefViewTreeNode root = null;
        IBriefViewTreeNode parent = null;
        int size = metas.size();
        for (int i = 0; i < size; ++i) {
            info = metas.get(i);
            node = new BriefViewTreeNode(info);
            if (root == null && StringUtils.isEmpty((String)info.getParent())) {
                root = node;
            }
            if (info.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
                tree.put(info.getFullName(), node);
            }
            if ((parent = (IBriefViewTreeNode)tree.get(info.getParent())) != null) {
                ((DefaultMutableTreeNode)((Object)parent)).add(node);
                continue;
            }
            if (root == node) continue;
            listTmp.add(node);
        }
        int len = listTmp.size();
        if (len > 0) {
            ArrayList treeList = new ArrayList(tree.entrySet());
            for (int i = len - 1; i >= 0; --i) {
                BriefViewTreeNode tn = (BriefViewTreeNode)listTmp.get(i);
                Object uo = tn.getUserObject();
                if (!(uo instanceof MetaDataBriefInfo)) continue;
                MetaDataBriefInfo mdbi = (MetaDataBriefInfo)uo;
                String fn = mdbi.getFullName();
                ListIterator iterator = treeList.listIterator(tree.size());
                while (iterator.hasPrevious()) {
                    Map.Entry entry = (Map.Entry)iterator.previous();
                    BriefViewTreeNode tempNode = (BriefViewTreeNode)entry.getValue();
                    if (fn.indexOf(tempNode.getPackageName()) < 0 || tempNode.equals(tn)) continue;
                    parent = tempNode;
                    tempNode.insert(tn, 0);
                    break;
                }
                if (parent != null) continue;
                logger.error((Object)("fail to find parent node,mdbi:" + mdbi.getFullName() + " parent:" + mdbi.getParent()));
            }
            listTmp.clear();
        }
        listTmp = null;
        return root;
    }

    private Map createMetaDataResource() {
        HashMap<BOSObjectType, MetaDataBriefInfo> resource = new HashMap<BOSObjectType, MetaDataBriefInfo>();
        resource.put(MetaDataTypeList.ENTITY, this.createMetaDataResource(MetaDataTypeList.ENTITY));
        resource.put(MetaDataTypeList.FACADE, this.createMetaDataResource(MetaDataTypeList.FACADE));
        resource.put(MetaDataTypeList.FUNCTION, this.createMetaDataResource(MetaDataTypeList.FUNCTION));
        resource.put(MetaDataTypeList.UIOBJECT, this.createMetaDataResource(MetaDataTypeList.UIOBJECT));
        resource.put(MetaDataTypeList.PACKAGE, this.createMetaDataResource(MetaDataTypeList.PACKAGE));
        return resource;
    }

    private MetaDataBriefInfo createMetaDataResource(BOSObjectType bosType) {
        try {
            MetaDataBriefInfo meta = new MetaDataBriefInfo();
            meta.setMetaDataType(MetaDataTypeList.PACKAGE);
            SolutionInfo slnInfo = this.getSolution();
            EntityObjectInfo entity = (EntityObjectInfo)this.loader.loadMDMeta(bosType);
            Locale[] locales = slnInfo.getSupportedLocales();
            meta.setName(entity.getName());
            int len = locales.length;
            for (int i = 0; i < len; ++i) {
                meta.setAlias(entity.getAlias(locales[i]), locales[i]);
                meta.setDescription(entity.getDescription(locales[i]), locales[i]);
            }
            return meta;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            assert (false);
            return null;
        }
    }

    @Override
    public IMetaDataPK getEntityObjectPK(BOSObjectType bosType) {
        if (bosType == null) {
            return null;
        }
        MDContext mdContext = this.loader.cl.getMDContext();
        return mdContext.entityMapping.getProperty(bosType);
    }

    @Override
    public IMetaDataPK getFacadePK(BOSObjectType bosType) {
        MDContext mdContext = this.loader.cl.getMDContext();
        IMetaDataPK pk = mdContext.facadeMapping.getProperty(bosType);
        if (pk == null) {
            logger.warn((Object)("Cannot load facade[" + bosType + "] in index!"));
        }
        return pk;
    }

    @Override
    public void refreshBOIndex() {
    }

    @Override
    public EntityObjectInfo loadMetameta(BOSObjectType bosType) throws MissingDAOMetaDataException {
        return this.loader.getMetametaLoader().loadMeta(bosType);
    }

    @Override
    public EntityObjectInfo getEntityNoConfigure(IMetaDataPK pk) {
        Exception ex = null;
        try {
            return (EntityObjectInfo)this.getNoConfigure(MetaDataTypeList.ENTITY, pk);
        }
        catch (Exception ignore) {
            ex = ignore;
            try {
                return (EntityObjectInfo)this.loader.loadMDMeta(pk);
            }
            catch (Exception ignore2) {
                ex = ignore2;
                logger.debug((Object)("load entity error pk=" + pk), (Throwable)ex);
                throw new MetaDataNotFoundException("Cannot find entity by PK[" + pk + "]");
            }
        }
    }

    @Override
    public QueryInfo getQueryNoConfigure(IMetaDataPK pk) {
        return (QueryInfo)this.getNoConfigure(MetaDataTypeList.BASEQUERY, pk);
    }

    public XMLLoader getMetametaLoader() {
        return this.loader.getMetametaLoader();
    }

    public void close() {
        this.loader.close();
    }

    private void processAlias(MetaDataBriefCollection metas) {
        InputStream is = this.loader.getConfigureResourceLoader().getResourceAsStream("dynamic-configure.xml");
        if (is != null) {
            try {
                Document dc = XMLParser.parseXML((InputStream)is);
                is.close();
                Element root = dc.getRootElement();
                List mds = root.getChildren("metadata", root.getNamespace());
                if (mds.size() == 0) {
                    return;
                }
                ArrayList<String> pks = new ArrayList<String>(mds.size());
                for (Element md : mds) {
                    String pk = md.getAttributeValue("pk");
                    pks.add(pk);
                }
                SolutionInfo solution = this.getSolution();
                Locale[] ls = solution.getSupportedLocales();
                MetaDataBriefInfo info = null;
                int size = metas.size();
                for (int i = 0; i < size; ++i) {
                    info = metas.get(i);
                    String tmp = info.getFullName().replace('.', '/') + Utils.getMetaDataSuffix(info.getMetaDataType());
                    if (!pks.contains(tmp)) continue;
                    AbstractMetaDataValue amv = (AbstractMetaDataValue)this.getConfigure(info.getMetaDataType(), MetaDataPK.create(info.getPackgeName(), info.getName()));
                    for (int j = 0; j < ls.length; ++j) {
                        String alias = amv.getAlias(ls[j]);
                        if (StringUtils.isEmpty((String)alias) || alias.equals(info.getAlias(ls[j]))) continue;
                        info.setAlias(alias, ls[j]);
                        info.setConfigured(true);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private MetaDataPK2[] getMetaDataPKsAffectMdbview() {
        return this.getMetaDataPKsAffectMdbview(null);
    }

    private MetaDataPK2[] getMetaDataPKsAffectMdbview(Project.Projects depends) {
        Map typeToPks = null;
        try {
            typeToPks = DBConfigureResourceLoader.getMetaDataPKsAffectMdbview(depends);
        }
        catch (BOSException e) {
            logger.info((Object)e, (Throwable)e);
        }
        if (typeToPks == null) {
            return null;
        }
        ArrayList<MetaDataPK2> rtv = new ArrayList<MetaDataPK2>();
        for (Map.Entry entry : typeToPks.entrySet()) {
            BOSObjectType type = (BOSObjectType)entry.getKey();
            Set pks = (Set)entry.getValue();
            for (MetaDataPK pk : pks) {
                rtv.add(new MetaDataPK2(pk.getFullName(), type.toString()));
            }
        }
        return rtv.toArray(new MetaDataPK2[0]);
    }

    @Override
    public BusinessObjectBriefView getBusinessObjectBriefView(IMetaDataPK pk, Project.Projects depends) {
        MetaDataBriefViewInfo info = (MetaDataBriefViewInfo)this.get(MetaDataTypeList.METADATABRIEFVIEW, pk);
        MetaDataPK2[] mdPk1 = this.loader.cl.getMDContext().pkIndexs.getAddNewPKs(depends);
        MetaDataPK2[] mdPk2 = this.getMetaDataPKsAffectMdbview(depends);
        if (mdPk1 != null && mdPk1.length > 0 || mdPk2 != null && mdPk2.length > 0) {
            MetaDataBriefViewInfo info2 = new MetaDataBriefViewInfo();
            MetaDataBriefCollection mdbc = info.getMetaDataBriefs();
            int len = mdbc.size();
            for (int i = 0; i < len; ++i) {
                info2.getMetaDataBriefs().add(mdbc.get(i));
            }
            info2.setRoot(info.getRoot());
            MdbviewListenerManager.addNew(pk, info2, mdPk1, depends);
            MdbviewListenerManager.modify(pk, info2, mdPk2, depends);
            info = info2;
        }
        return new BusinessObjectBriefView(this.getRoot(info, pk), this.createMetaDataResource());
    }

    @Override
    public boolean isEntity(BOSObjectType bosType) {
        return MDContextFactory.getSystemMDContext().entityMapping.getProperty(bosType) != null;
    }

    @Override
    public boolean isFacade(BOSObjectType bosType) {
        return MDContextFactory.getSystemMDContext().facadeMapping.getProperty(bosType) != null;
    }
}

