/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDSetting;
import com.kingdee.bos.metadata.MetaDataClassLoader;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.SourceFiles;
import com.kingdee.bos.util.BOSObjectType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;

public final class MDContextFactory {
    private static final Logger logger = Logger.getLogger(MDContextFactory.class);
    private static MDContext remoteMDContext = null;

    public static MDContext getInstance() {
        MDContext mdCtx = new MDContext();
        new SourceFiles(mdCtx);
        return mdCtx;
    }

    public static synchronized MDContext getInstance(MetaDataClassLoader loader, MDSetting setting) {
        MDContext mdCtx = new MDContext();
        new SourceFiles(mdCtx, setting);
        loader.setMDContext(mdCtx);
        MDContextFactory.initPKMapping(mdCtx, loader);
        MDContextFactory.initEntityAndFacadeIndex(mdCtx, loader);
        MDContextFactory.initMetaVersion(mdCtx, loader);
        return mdCtx;
    }

    public static MDContext getRemoteInstance() {
        MDContext mdCtx;
        if (remoteMDContext != null) {
            return remoteMDContext;
        }
        try {
            mdCtx = MDContextFactory.getSystemMDContext();
        }
        catch (Exception e) {
            mdCtx = new MDContext();
            MDContextFactory.initPKMapping(mdCtx, MDContext.class.getClassLoader());
        }
        remoteMDContext = mdCtx;
        return mdCtx;
    }

    public static void clearRemoteInstance() {
        remoteMDContext = null;
    }

    public static MDContext getSystemMDContext() {
        return MDLoader.getInstance().cl.getMDContext();
    }

    private static void initPKMapping(MDContext mdCtx, ClassLoader loader) {
        mdCtx.entityMapping.putToBase("12CA0900", "com.kingdee.bos.config.app.MetadataRef");
        mdCtx.entityMapping.putToBase("E52E4D71", "com.kingdee.bos.config.app.MetadataRefDetail");
        mdCtx.entityMapping.putToBase("225AE52B", "com.kingdee.bos.config.app.DynamicMetadata");
        mdCtx.entityMapping.putToBase("D552B4D0", "com.kingdee.bos.config.app.EntityPKMapping");
        mdCtx.entityMapping.putToBase("76763796", "com.kingdee.bos.config.app.FacadePKMapping");
        try {
            InputStream is = loader.getResourceAsStream("index.lst");
            if (is != null) {
                Properties temp = new Properties();
                temp.load(is);
                is.close();
                for (Map.Entry<Object, Object> entry : temp.entrySet()) {
                    String bo;
                    String fname = (String)entry.getKey();
                    int pos = fname.lastIndexOf(".");
                    if (pos == -1) continue;
                    String suffix = fname.substring(pos + 1);
                    BOSObjectType type = BOSObjectType.create((String)Utils.getBOSTypeBySuffix(suffix));
                    String pkStr = fname.substring(0, pos).replaceAll("/", ".");
                    mdCtx.pkIndexs.putToBase(type, MetaDataPK.create(pkStr));
                    if (MetaDataTypeList.ENTITY.equals((Object)type)) {
                        bo = (String)entry.getValue();
                        mdCtx.entityMapping.putToBase(bo, pkStr);
                    }
                    if (!MetaDataTypeList.FACADE.equals((Object)type)) continue;
                    bo = (String)entry.getValue();
                    mdCtx.facadeMapping.putToBase(bo, pkStr);
                }
            } else {
                logger.info((Object)"Init pk mapping. Can't find index.lst");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Init pk mapping error.", (Throwable)e);
        }
    }

    private static void initMetaVersion(MDContext mdCtx, ClassLoader loader) {
        try {
            InputStream is = loader.getResourceAsStream(".version");
            if (is != null) {
                Properties prop = new Properties();
                prop.load(is);
                is.close();
                mdCtx.metaVersion = prop.getProperty("metaVersion");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void initEntityAndFacadeIndex(MDContext mdContext, ClassLoader loader) {
        List tempList = MDContextFactory.getProperties(loader, "entity_pkmapping.properties");
        mdContext.entityMapping.clearFileConfig();
        for (Properties temp : tempList) {
            mdContext.entityMapping.putToFileConfig(temp);
        }
        mdContext.facadeMapping.clearFileConfig();
        tempList = MDContextFactory.getProperties(loader, "facade_pkmapping.properties");
        for (Properties temp : tempList) {
            mdContext.facadeMapping.putToFileConfig(temp);
        }
    }

    private static List getProperties(ClassLoader loader, String name) {
        ArrayList<Properties> tempList = new ArrayList<Properties>();
        try {
            Enumeration<URL> e = loader.getResources(name);
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                try {
                    InputStream is = url.openStream();
                    Properties temp = new Properties();
                    temp.load(is);
                    is.close();
                    tempList.add(0, temp);
                }
                catch (IOException ioe) {
                    Exception ex = new Exception(url.toString(), ioe);
                    String path = url.getPath();
                    ZipFile jf = null;
                    try {
                        jf = new JarFile(path.substring(path.indexOf(58) + 1, path.indexOf(33)));
                        ZipEntry entry = ((JarFile)jf).getEntry(path.substring(path.indexOf(33) + 2));
                        InputStream is = ((JarFile)jf).getInputStream(entry);
                        Properties temp = new Properties();
                        temp.load(is);
                        is.close();
                        tempList.add(0, temp);
                    }
                    catch (Exception e1) {
                        logger.error((Object)("Get properties error. url:" + url), (Throwable)ex);
                        logger.error((Object)("Get properties error. path:" + url.getPath()), (Throwable)e1);
                        throw ex;
                    }
                    finally {
                        try {
                            if (jf == null) continue;
                            jf.close();
                        }
                        catch (Exception e2) {}
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MetaDataNotFoundException("Cannot load metadata index file[" + name + "].", e);
        }
        return tempList;
    }

    public static void addSource(MDContext mdContext, String jarFile) throws IOException {
        mdContext.getSourceFiles().addSource(jarFile);
        JarFile jf = new JarFile(jarFile);
        ZipEntry entry = jf.getEntry("entity_pkmapping.properties");
        InputStream is = jf.getInputStream(entry);
        Properties temp = new Properties();
        temp.load(is);
        is.close();
        mdContext.entityMapping.putToBase(temp);
        entry = jf.getEntry("facade_pkmapping.properties");
        is = jf.getInputStream(entry);
        temp = new Properties();
        temp.load(is);
        is.close();
        mdContext.facadeMapping.putToBase(temp);
    }
}

