/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MDPath;
import com.kingdee.bos.metadata.MDSetting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class MetaDataClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(MetaDataClassLoader.class);
    public static final String INDEX_NAME = "index.lst";
    private MDContext mdContext;
    private static List<MetaDataClassLoader> instances = new ArrayList<MetaDataClassLoader>(2);

    public MetaDataClassLoader(boolean isMetadmeta) {
        this.mdContext = MDContextFactory.getInstance();
        this.mdContext.require();
    }

    public MetaDataClassLoader(String[] sources) {
        this(MDSetting.newInstance(null, new MDPath(null, sources)));
    }

    public MetaDataClassLoader(MDSetting setting) {
        super(null);
        this.mdContext = MDContextFactory.getInstance(this, setting);
        this.mdContext.require();
        instances.add(this);
    }

    void setMDContext(MDContext mdContext) {
        this.mdContext = mdContext;
    }

    public MDContext getMDContext() {
        return this.mdContext;
    }

    protected String fixName(String name) {
        if (!name.startsWith("/")) {
            return "/" + name;
        }
        return name;
    }

    @Override
    public URL findResource(String name) {
        try {
            URL url = this.findResourceByClassLoader(name);
            if (url != null) {
                return url;
            }
            return this.findResourceInLocal(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void log(String name, URL url) {
        if (name.endsWith(".mdbview")) {
            logger.info((Object)("MetaDataClassLoader load " + name + " from " + url));
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("MetaDataClassLoader load " + name + " from " + url));
        }
    }

    protected URL findResourceByClassLoader(String name) {
        name = this.fixName(name);
        String nameForClassLoader = name.substring(1);
        URL url = null;
        if (Thread.currentThread().getContextClassLoader() != null) {
            url = Thread.currentThread().getContextClassLoader().getResource(nameForClassLoader);
        }
        if (url != null) {
            this.log(name, url);
            return url;
        }
        url = MetaDataClassLoader.class.getResource(name);
        if (url != null) {
            return url;
        }
        return null;
    }

    protected URL findResourceInLocal(String name) {
        name = this.fixName(name);
        name = name.substring(1);
        try {
            File[] innerSrcs = this.mdContext.getSourceFiles().getInnerSrcs();
            JarFile[] jarSrcs = this.mdContext.getSourceFiles().getJarSrcs();
            Set<File> isFileInnerSrcs = this.mdContext.getSourceFiles().getIsFileInnerSrcs();
            int len = innerSrcs.length;
            for (int i = 0; i < len; ++i) {
                URL url = null;
                if (isFileInnerSrcs.contains(innerSrcs[i])) {
                    JarFile jar = jarSrcs[i];
                    JarEntry entry = null;
                    String rsName = null;
                    rsName = name.indexOf(47) == 0 ? name.substring(1, name.length()) : name;
                    entry = this.getJarEntry(jar, rsName, innerSrcs[i]);
                    if (entry != null) {
                        url = new URL(new URL("jar:" + innerSrcs[i].getCanonicalFile().toURL().toString() + "!/"), entry.toString());
                    }
                } else {
                    File file = new File(innerSrcs[i], name);
                    if (file.exists()) {
                        url = file.toURL();
                    }
                }
                if (url == null) continue;
                this.log(name, url);
                return url;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    protected Enumeration findResources(String name) throws IOException {
        Vector<URL> urls = new Vector<URL>();
        try {
            File[] innerSrcs = this.mdContext.getSourceFiles().getInnerSrcs();
            JarFile[] jarSrcs = this.mdContext.getSourceFiles().getJarSrcs();
            int len = innerSrcs.length;
            for (int i = 0; i < len; ++i) {
                ZipEntry entry;
                File srcFile = innerSrcs[i];
                if (srcFile.isDirectory()) {
                    File file = new File(innerSrcs[i], name.replace('/', File.separatorChar));
                    if (!file.exists()) continue;
                    urls.add(file.getCanonicalFile().toURL());
                    continue;
                }
                File cf = srcFile.getCanonicalFile();
                JarFile jar = jarSrcs[i];
                if (jar == null || (entry = jar.getEntry(name)) == null) continue;
                URL url = new URL("jar:" + cf.toURL().toString() + "!/" + name);
                urls.add(url);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Load Resource Error. Resource name:" + name), (Throwable)e);
        }
        return urls.elements();
    }

    public long lastModified(String key2) throws IOException {
        String path = new MetaDataPK2(key2).getPath2();
        try {
            File[] innerSrcs = this.mdContext.getSourceFiles().getInnerSrcs();
            JarFile[] jarSrcs = this.mdContext.getSourceFiles().getJarSrcs();
            int len = innerSrcs.length;
            for (int i = 0; i < len; ++i) {
                File srcFile = innerSrcs[i];
                if (srcFile.isDirectory()) {
                    File file = new File(innerSrcs[i], path.replace('/', File.separatorChar));
                    if (!file.exists()) continue;
                    return file.lastModified();
                }
                JarFile jar = jarSrcs[i];
                ZipEntry entry = jar.getEntry(path);
                if (entry == null) continue;
                return entry.getTime();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Get Resource state Error. Resource name:" + key2), (Throwable)e);
        }
        try {
            URL url = this.findResource(path);
            if (url != null) {
                if ("jar".equals(url.getProtocol())) {
                    String name = url.getPath();
                    int pos = name.lastIndexOf("!/");
                    if ((name = name.substring(0, pos)).startsWith("file:")) {
                        name = name.substring(5);
                    }
                    JarFile jf = new JarFile(name);
                    ZipEntry entry = jf.getEntry(path);
                    return entry.getTime();
                }
                if ("file".equals(url.getProtocol())) {
                    File file = new File(url.getPath());
                    return file.lastModified();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name);
        if (is == null) {
            is = this.getInputStream(name);
        }
        if (is == null) {
            return null;
        }
        return new BufferedInputStream(is);
    }

    public void close() {
        this.mdContext.release();
        instances.remove(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public static synchronized void closeAll() {
        logger.info((Object)"MetaDataClassLoader closeAll.");
        for (int i = instances.size() - 1; i >= 0; --i) {
            instances.get(i).close();
        }
    }

    public InputStream getInputStream(String name) {
        try {
            File[] innerSrcs = this.mdContext.getSourceFiles().getInnerSrcs();
            JarFile[] jarSrcs = this.mdContext.getSourceFiles().getJarSrcs();
            Set<File> isFileInnerSrcs = this.mdContext.getSourceFiles().getIsFileInnerSrcs();
            int len = innerSrcs.length;
            for (int i = 0; i < len; ++i) {
                if (isFileInnerSrcs.contains(innerSrcs[i])) {
                    JarFile jar = jarSrcs[i];
                    JarEntry entry = null;
                    String rsName = null;
                    rsName = name.indexOf(47) == 0 ? name.substring(1, name.length()) : name;
                    entry = this.getJarEntry(jar, rsName, innerSrcs[i]);
                    if (entry == null) continue;
                    return jar.getInputStream(entry);
                }
                File file = new File(innerSrcs[i], name);
                if (!file.exists()) continue;
                return new BufferedInputStream(new FileInputStream(file));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    private JarFile checkJarFile(JarFile jar, String rsName, File jFile) {
        if (jar == null) {
            return null;
        }
        try {
            jar.getJarEntry(rsName);
        }
        catch (Exception e) {
            try {
                jar = new JarFile(jFile);
            }
            catch (IOException ee) {
                throw new IllegalArgumentException("Error Meta Jar:" + jFile.getAbsolutePath() + ". Cause:" + ee.getMessage());
            }
        }
        return jar;
    }

    private JarEntry getJarEntry(JarFile jar, String rsName, File jFile) {
        if (jar == null) {
            return null;
        }
        JarEntry entry = null;
        try {
            entry = jar.getJarEntry(rsName);
        }
        catch (Exception e) {
            try {
                jar = new JarFile(jFile);
                entry = jar.getJarEntry(rsName);
            }
            catch (IOException ee) {
                throw new IllegalArgumentException("Error Meta Jar:" + jFile.getAbsolutePath() + ". Cause:" + ee.getMessage());
            }
        }
        return entry;
    }
}

