/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.AbstractMetaDataCache;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.util.List;

public class MetaDataLazyLoadCache
extends AbstractMetaDataCache {
    public MetaDataLazyLoadCache(Context ctx) {
        super(ctx);
    }

    @Override
    public IObjectValue get(BOSObjectType bosType, IMetaDataPK pk) {
        if (pk == null && !bosType.equals((Object)MetaDataTypeList.SOLUTION)) {
            throw new IllegalArgumentException("Metadata's pk cannot be null!");
        }
        return this.loadMD(bosType, pk);
    }

    @Override
    public IObjectCollection getCollection(BOSObjectType bosType) {
        return this.loader.getCollection(bosType, null, true);
    }

    @Override
    public IObjectCollection getAllObjectByPackage(BOSObjectType bosType, String pkg) {
        return this.loader.getCollection(bosType, pkg, true);
    }

    @Override
    public IObjectCollection getAllObjectByPackage(BOSObjectType bosType, String pkg, boolean validPackageName) {
        return this.loader.getCollection(bosType, pkg, true, validPackageName);
    }

    @Override
    public IObjectCollection getDirectObjectByPackage(BOSObjectType bosType, String pkg) {
        return this.loader.getCollection(bosType, pkg, false);
    }

    private IObjectValue loadMD(BOSObjectType bosType, IMetaDataPK pk) {
        if (pk == null) {
            pk = new MetaDataPK();
            pk.setKeyValue("name", "any");
        }
        return this.loader.loadMD(MetaDataPK2.createPK2(pk.getPackage(), pk.getName(), bosType.toString()));
    }

    @Override
    public void refreshBOIndex() {
        MDContextFactory.initEntityAndFacadeIndex(this.loader.cl.getMDContext(), this.loader.cl);
    }

    @Override
    public void clear(BOSObjectType bosType, IMetaDataPK pk) {
        this.loader.clear(MetaDataPK2.createPK2(pk.getPackage(), pk.getName(), bosType.toString()));
    }

    @Override
    public void clear(BOSObjectType bosType) {
        this.loader.clear(bosType);
    }

    @Override
    public void clearAll() {
        this.loader.clearAll();
    }

    @Override
    public IObjectValue getNoConfigure(BOSObjectType bosType, IMetaDataPK pk) {
        if (pk == null && !bosType.equals((Object)MetaDataTypeList.SOLUTION)) {
            throw new IllegalArgumentException("Metadata's pk cannot be null!");
        }
        return this.loadMDNoConfigure(bosType, pk);
    }

    private IObjectValue loadMDNoConfigure(BOSObjectType bosType, IMetaDataPK pk) {
        if (pk == null) {
            pk = new MetaDataPK();
            pk.setKeyValue("name", "any");
        }
        return this.loader.loadMDNoConfigure(MetaDataPK2.createPK2(pk.getPackage(), pk.getName(), bosType.toString()));
    }

    @Override
    public IObjectValue getConfigure(BOSObjectType bosType, IMetaDataPK pk) {
        if (pk == null && !bosType.equals((Object)MetaDataTypeList.SOLUTION)) {
            throw new IllegalArgumentException("Metadata's pk can't be null!");
        }
        return this.loadMDConfigure(bosType, pk);
    }

    private IObjectValue loadMDConfigure(BOSObjectType bosType, IMetaDataPK pk) {
        if (pk == null) {
            pk = new MetaDataPK();
            pk.setKeyValue("name", "any");
        }
        return this.loader.loadMDConfigure(MetaDataPK2.createPK2(pk.getPackage(), pk.getName(), bosType.toString()));
    }

    @Override
    public IObjectCollection getConfigureCollection(BOSObjectType bosType) {
        return this.loader.getConfigureCollection(bosType, null, true);
    }

    @Override
    public IObjectCollection getAllObjectExcludePackage(BOSObjectType bosType, List pkgs) {
        return this.loader.getCollectionExcludePackage(bosType, pkgs);
    }

    @Override
    public IObjectValue get(BOSObjectType bosType, IMetaDataPK pk, Project.Projects depends) {
        if (pk == null) {
            pk = new MetaDataPK();
            pk.setKeyValue("name", "any");
        }
        return this.loader.loadMD(MetaDataPK2.createPK2(pk.getPackage(), pk.getName(), bosType.toString()), depends);
    }

    @Override
    public EntityObjectInfo getEntity(BOSObjectType bosType, Project.Projects depends) {
        IMetaDataPK pk = super.getEntityObjectPK(bosType);
        return (EntityObjectInfo)this.get(MetaDataTypeList.ENTITY, pk, depends);
    }
}

