/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMDReference;
import com.kingdee.bos.metadata.MDEvent;
import com.kingdee.bos.metadata.MDListener;
import com.kingdee.bos.metadata.MDProvider;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiMDReference<T extends AbstractMetaDataValue>
implements IMDReference<T> {
    private final Map<String, T> mds = new HashMap<String, T>(2);
    private final Map<String, T> configureMDs = new HashMap<String, T>(2);
    private final MDProvider<T> provider;
    private volatile int count = 0;
    private final List<MDListener> listeners = new ArrayList<MDListener>(2);

    MultiMDReference(MDProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("MDProvider can not be null.");
        }
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.count = 0;
        Map<String, T> map = this.mds;
        synchronized (map) {
            this.mds.clear();
            this.configureMDs.clear();
            this.provider.clear();
            this.fireClearEvent();
        }
    }

    @Override
    public T get() {
        ++this.count;
        return this.getMD(false);
    }

    @Override
    public T getConfigure() {
        ++this.count;
        return this.getMD(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        if (this.count <= 0) {
            Map<String, T> map = this.mds;
            synchronized (map) {
                this.mds.clear();
                this.configureMDs.clear();
                this.provider.clear();
            }
        }
    }

    @Override
    public void release() {
        if (this.count > 0) {
            --this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getMD(boolean isConfigure) {
        String ais;
        Map<String, T> cache = isConfigure ? this.mds : this.configureMDs;
        AbstractMetaDataValue md = (AbstractMetaDataValue)cache.get(ais = ConfigMDUtil.getAIS());
        if (md != null) {
            return (T)md;
        }
        Map<String, T> map = cache;
        synchronized (map) {
            if (cache.containsKey(ais)) {
                return (T)((AbstractMetaDataValue)cache.get(ais));
            }
            md = isConfigure ? this.provider.loadConfigureMD() : this.provider.loadMD();
            cache.put(ais, md);
            return (T)md;
        }
    }

    @Override
    public void addMDListener(MDListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    private void fireClearEvent() {
        MDEvent e = new MDEvent(0);
        for (MDListener l : this.listeners) {
            l.performed(e);
        }
    }
}

