/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.config.EntityPKMappingCollection;
import com.kingdee.bos.config.EntityPKMappingInfo;
import com.kingdee.bos.config.FacadePKMappingCollection;
import com.kingdee.bos.config.FacadePKMappingInfo;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContext;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.DynamicMetadataProviderManager;
import com.kingdee.bos.metadata.configure.IDynamicMetadataProvider;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PKMappings {
    private static final Logger logger = Logger.getLogger(PKMappings.class);
    public static final int ENTITY_TYPE = 0;
    public static final int FACADE_TYPE = 1;
    private final int type;
    private final Map<String, String> base = new HashMap<String, String>();
    private final Map<String, String> baseIndex = new HashMap<String, String>();
    private final Map<String, String> fileConfig = new HashMap<String, String>();
    private final Map<String, String> fileConfigIndex = new HashMap<String, String>();
    private final Map<String, Map<String, String>> dbConfig = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> dbConfigIndex = new HashMap<String, Map<String, String>>();

    PKMappings(int type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putToBase(String type, String fullName) {
        Map<String, String> map = this.base;
        synchronized (map) {
            this.base.put(type, fullName);
            this.baseIndex.put(fullName, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putToBase(Properties p) {
        Map<String, String> map = this.base;
        synchronized (map) {
            PKMappings.putAll(this.base, this.baseIndex, p);
        }
    }

    private static void putAll(Map<String, String> map, Map<String, String> reverseMap, Properties p) {
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            map.put((String)e.getKey(), (String)e.getValue());
            if (reverseMap == null) continue;
            reverseMap.put((String)e.getValue(), (String)e.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putToFileConfig(Properties p) {
        Map<String, String> map = this.fileConfig;
        synchronized (map) {
            PKMappings.putAll(this.fileConfig, this.fileConfigIndex, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFileConfig() {
        Map<String, String> map = this.fileConfig;
        synchronized (map) {
            this.fileConfig.clear();
            this.fileConfigIndex.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDBConfig(boolean isAll) {
        Map<String, Map<String, String>> map = this.dbConfig;
        synchronized (map) {
            if (isAll) {
                this.dbConfig.clear();
                this.dbConfigIndex.clear();
            } else {
                MDContext.clearAis(this.dbConfig, false);
                MDContext.clearAis(this.dbConfigIndex, false);
            }
        }
    }

    private String getKey() {
        if (!ConfigMDUtil.checkAIS()) {
            return null;
        }
        String ais = ConfigMDUtil.getAIS();
        return ais;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDBConfig(String key) {
        if (key == null) {
            return;
        }
        Map<String, String> props = this.dbConfig.get(key);
        if (props == null) {
            Map<String, Map<String, String>> map = this.dbConfig;
            synchronized (map) {
                if (!this.dbConfig.containsKey(key)) {
                    this.loadDBConfig(key);
                }
            }
        }
    }

    private Map<String, String> getReverseMap(Map<String, String> origin) {
        HashMap<String, String> map = new HashMap<String, String>(origin.size());
        for (Map.Entry<String, String> entry : origin.entrySet()) {
            map.put(entry.getValue(), entry.getKey());
        }
        return map;
    }

    private void loadDBConfig(String key) {
        Map<String, String> newProps = null;
        try {
            newProps = this.getPKMapping();
        }
        catch (Exception e) {
            logger.error((Object)"METADATA: Load Entity or Facade PKMapping from DB error.", (Throwable)e);
        }
        if (newProps != null) {
            this.dbConfig.put(key, newProps);
            this.dbConfigIndex.put(key, this.getReverseMap(newProps));
        } else {
            this.dbConfig.put(key, new HashMap(1));
            this.dbConfigIndex.put(key, new HashMap(1));
        }
    }

    private Map<String, String> getPKMapping() throws BOSException {
        if (this.type == 0) {
            return PKMappings.getEntityPKMapping();
        }
        if (this.type == 1) {
            return PKMappings.getFacadePKMapping();
        }
        return null;
    }

    public Map<String, String> getReversePKMapping() {
        HashMap<String, String> reverse = new HashMap<String, String>();
        Map<String, String> dbmapping = this.getIndexsFromDB();
        if (dbmapping != null) {
            reverse.putAll(dbmapping);
        }
        reverse.putAll(this.fileConfigIndex);
        reverse.putAll(this.baseIndex);
        return reverse;
    }

    private static Map<String, String> getEntityPKMapping() throws BOSException {
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        EntityPKMappingCollection emc = ConfigMDUtil.isClient() ? dmp.getRemoteEPKMCollection() : dmp.getEPKMCollection();
        for (int i = 0; i < emc.size(); ++i) {
            EntityPKMappingInfo emi = emc.get(i);
            props.put(emi.getBosType(), emi.getMetaDataPK());
        }
        return props;
    }

    private static Map<String, String> getFacadePKMapping() throws BOSException {
        IDynamicMetadataProvider dmp = DynamicMetadataProviderManager.getProvider();
        if (dmp == null) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        FacadePKMappingCollection fmc = ConfigMDUtil.isClient() ? dmp.getRemoteFPKMCollection() : dmp.getFPKMCollection();
        for (int i = 0; i < fmc.size(); ++i) {
            FacadePKMappingInfo fmi = fmc.get(i);
            props.put(fmi.getBosType(), fmi.getMetaDataPK());
        }
        return props;
    }

    private Map<String, String> getPropsFromDB() {
        String key = this.getKey();
        if (key == null) {
            return null;
        }
        this.initDBConfig(key);
        return this.dbConfig.get(key);
    }

    private Map<String, String> getIndexsFromDB() {
        String key = this.getKey();
        if (key == null) {
            return null;
        }
        this.initDBConfig(key);
        return this.dbConfigIndex.get(key);
    }

    private String getPropertyFromDB(String type) {
        Map<String, String> props = this.getPropsFromDB();
        if (props != null) {
            return props.get(type);
        }
        return null;
    }

    private String getPropertyFromDBIndex(String type) {
        Map<String, String> props = this.getIndexsFromDB();
        if (props != null) {
            return props.get(type);
        }
        return null;
    }

    private boolean containsInDB(String key) {
        Map<String, String> indexs = this.getIndexsFromDB();
        if (indexs != null) {
            return indexs.containsKey(key);
        }
        return false;
    }

    public BOSObjectType getProperty(String fullName) {
        String tmpType = this.baseIndex.get(fullName);
        if (tmpType == null && (tmpType = this.fileConfigIndex.get(fullName)) == null) {
            tmpType = this.getPropertyFromDBIndex(fullName);
        }
        if (tmpType != null) {
            return BOSObjectType.create((String)tmpType);
        }
        return null;
    }

    public IMetaDataPK getProperty(BOSObjectType bosType) {
        String type = bosType.toString();
        String tmpPK = this.base.get(type);
        if (tmpPK == null && (tmpPK = this.fileConfig.get(type)) == null) {
            tmpPK = this.getPropertyFromDB(type);
        }
        if (tmpPK != null) {
            return MetaDataPK.create(tmpPK);
        }
        return null;
    }

    public boolean contains(IMetaDataPK pk) {
        String pkName = pk.getFullName();
        if (!this.baseIndex.containsKey(pkName) && !this.fileConfigIndex.containsKey(pkName)) {
            return this.containsInDB(pkName);
        }
        return true;
    }

    private void addnewPKMapping(BOSObjectType type, IMetaDataPK pk) throws BOSException {
        if (this.type == 0) {
            this.addnewEntityPKMapping(type, pk);
        } else if (this.type == 1) {
            this.addnewFacadePKMapping(type, pk);
        }
    }

    private void addnewEntityPKMapping(BOSObjectType type, IMetaDataPK pk) throws BOSException {
        IDynamicMetadataProvider dmp;
        if (!ConfigMDUtil.isClient() && (dmp = DynamicMetadataProviderManager.getProvider()) != null) {
            EntityPKMappingInfo epmi = new EntityPKMappingInfo();
            epmi.setBosType(type.toString());
            epmi.setMetaDataPK(pk.getFullName());
            dmp.addnew(epmi);
        }
    }

    private void addnewFacadePKMapping(BOSObjectType type, IMetaDataPK pk) throws BOSException {
        IDynamicMetadataProvider dmp;
        if (!ConfigMDUtil.isClient() && (dmp = DynamicMetadataProviderManager.getProvider()) != null) {
            FacadePKMappingInfo epmi = new FacadePKMappingInfo();
            epmi.setBosType(type.toString());
            epmi.setMetaDataPK(pk.getFullName());
            dmp.addnew(epmi);
        }
    }

    public void addPKMapping(BOSObjectType type, IMetaDataPK pk) throws BOSException {
        this.addPKMapping(type, pk, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPKMapping(BOSObjectType type, IMetaDataPK pk, boolean addToDB) throws BOSException {
        Map<String, String> props = this.getPropsFromDB();
        if (props != null) {
            Map<String, Map<String, String>> map = this.dbConfig;
            synchronized (map) {
                props.put(type.toString(), pk.getFullName());
            }
            if (addToDB) {
                this.addnewPKMapping(type, pk);
            }
        }
    }
}

