/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.DocumentProxyStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.ResourceListener;
import com.kingdee.bos.metadata.ResourceProvider;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.IResourceProvider;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.ResourceProviderManager;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResourceListenerManager {
    private static final String EMPTY_STRING = "";
    private static Logger logger = Logger.getLogger(ResourceListenerManager.class);
    private static final List<ResourceListener> listeners = new ArrayList<ResourceListener>(2);
    private static Context defaultContext = null;

    private static void init() {
        String fileName;
        if (ConfigMDUtil.isClient()) {
            try {
                Class<?> uiconfig = Class.forName("com.kingdee.eas.base.uiframe.client.UIConfig");
                Method m = uiconfig.getMethod("getConfigItemByPath", String.class);
                ConfigurationItem ci = (ConfigurationItem)m.invoke(null, "resourceListeners");
                ResourceListenerManager.processConfigItem(ci);
                return;
            }
            catch (Throwable e) {
                logger.debug((Object)e, e);
            }
        }
        if (!new File(fileName = System.getProperty("bos.config", "bosconfig.xml")).exists()) {
            logger.warn((Object)(fileName + " not exist!"));
            return;
        }
        Configuration config = Configuration.getInstance();
        ConfigurationItem ci = config.getConfigItem("resourceListeners");
        ResourceListenerManager.processConfigItem(ci);
    }

    private static void processConfigItem(ConfigurationItem ci) {
        if (ci == null) {
            logger.info((Object)"Can't find resourceListeners configItem");
            return;
        }
        Map map = ci.getProperties();
        for (Map.Entry entry : map.entrySet()) {
            String value = (String)entry.getValue();
            try {
                Class<?> c = Class.forName(value);
                ResourceListener lis = (ResourceListener)c.newInstance();
                listeners.add(lis);
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public static synchronized void register(ResourceListener listener) {
        listeners.add(listener);
    }

    public static synchronized void unregister(ResourceListener listener) {
        listeners.remove(listener);
    }

    public static synchronized void register(String className) {
        try {
            Class<?> c = Class.forName(className);
            ResourceListener lis = (ResourceListener)c.newInstance();
            listeners.add(lis);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public static void deploy(IMetaDataPK pk, BOSObjectType bosType, LanguageInfo lan, String key, String value, boolean formatXml) {
        for (int i = 0; i < listeners.size(); ++i) {
            ResourceListener lis = listeners.get(i);
            lis.deploy(pk, bosType, lan, key, value, formatXml);
        }
    }

    public static void deploy(IMetaDataPK pk, BOSObjectType bosType, LanguageInfo lan, Map kvs) {
        for (int i = 0; i < listeners.size(); ++i) {
            ResourceListener lis = listeners.get(i);
            lis.deploy(pk, bosType, lan, kvs);
        }
    }

    public static String getString(IMetaDataPK pk, BOSObjectType bosType, LanguageInfo lan, String key) {
        Context ctx = ConfigMDUtil.getContext();
        if (pk == null || !ConfigMDUtil.isNeedLoadConfigPK(pk.getFullName()) || MetaDataTypeList.SOLUTION.equals((Object)bosType) || ctx == null) {
            return EMPTY_STRING;
        }
        if (!DocumentProxyStateManager.isRepeatLog()) {
            return EMPTY_STRING;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            ResourceListener lis = listeners.get(i);
            try {
                String rtv = lis.getString(pk, bosType, lan, key, ResourceListenerManager.getContext(ctx, lis.getDefaultAis()));
                if (StringUtils.isEmpty((String)rtv)) continue;
                return rtv;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return EMPTY_STRING;
    }

    public static String getString(IMetaDataPK pk, BOSObjectType bosType, Locale l, String key) {
        LanguageInfo lan = BOSLocaleUtil.getLanguage(ResourceListenerManager.getLocale(l));
        return ResourceListenerManager.getString(pk, bosType, lan, key);
    }

    private static Locale getLocale(Locale l) {
        if (l == null) {
            Context ctx = ConfigMDUtil.getContext();
            if (ctx != null) {
                l = ctx.getOriginLocale();
            }
            if (l == null) {
                l = LocaleUtils.getDefaultOriginLocale();
            }
        }
        return l;
    }

    public static Map getRemoteWebResource(String packageName, String resFileName, Locale l) {
        l = ResourceListenerManager.getLocale(l);
        if (!DocumentProxyStateManager.isRepeatLog()) {
            return null;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            ResourceListener lis = listeners.get(i);
            try {
                Map rtv = lis.getRemoteWebResource(packageName, resFileName, l);
                if (rtv == null) continue;
                return rtv;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public static Map getRemoteWebPageResource(String packageName, String resFileName, Locale l) {
        l = ResourceListenerManager.getLocale(l);
        if (!DocumentProxyStateManager.isRepeatLog()) {
            return null;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            ResourceListener lis = listeners.get(i);
            try {
                Map rtv = lis.getRemoteWebPageResource(packageName, resFileName, l);
                if (rtv == null) continue;
                return rtv;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isMultiLanguages() {
        return listeners.size() > 0;
    }

    private static Context getContext(Context ctx, String ais) {
        if (!StringUtils.isEmpty((String)ctx.getAIS())) {
            return ctx;
        }
        if (StringUtils.isEmpty((String)ais)) {
            return null;
        }
        if (defaultContext == null) {
            defaultContext = new Context(ctx.getCaller(), ctx.getSolution(), ais, ctx.getLocale());
        }
        return defaultContext;
    }

    static {
        try {
            ResourceListenerManager.init();
            ResourceProviderManager.setProvider((IResourceProvider)new ResourceProvider());
        }
        catch (Throwable e) {
            logger.warn((Object)e, e);
        }
    }
}

