/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.access.ISelectHandler;
import com.kingdee.bos.metadata.access.ResultSet;
import com.kingdee.bos.metadata.access.Select;
import com.kingdee.bos.metadata.access.SelectConstants;
import com.kingdee.bos.metadata.access.SelectContext;

public abstract class AbstractSelectHandler<S extends Select, T, M>
implements ISelectHandler<S, T, M> {
    private ISelectHandler<S, T, M> next;

    public AbstractSelectHandler(ISelectHandler<S, T, M> next) {
        this.next = next;
    }

    public AbstractSelectHandler() {
        this.next = null;
    }

    @Override
    public void handle(SelectContext ctx, S select, ResultSet<T, M> result) throws BOSException {
        if (result.getMetadata() == null || result.getSelectData() == null) {
            return;
        }
        this.innerHandle(ctx, select, result);
        if (this.next != null) {
            this.next.handle(ctx, select, result);
        }
    }

    protected abstract void innerHandle(SelectContext var1, S var2, ResultSet<T, M> var3) throws BOSException;

    public void setNext(ISelectHandler<S, T, M> next) {
        this.next = next;
    }

    public ISelectHandler<S, T, M> next() {
        return this.next;
    }

    protected boolean isSelectAll(String[] columns) {
        boolean isAll;
        boolean bl = isAll = columns == SelectConstants.SELECT_ALL;
        if (!isAll) {
            isAll = columns.length == 1 && "*".equals(columns[0]);
        }
        return isAll;
    }
}

