/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access;

import com.kingdee.bos.framework.KeyFactory;
import com.kingdee.bos.metadata.access.IMetaDataAccess;
import com.kingdee.bos.metadata.access.Mergeable;
import com.kingdee.bos.metadata.access.Select;
import com.kingdee.bos.metadata.access.SelectKey;
import com.kingdee.bos.metadata.access.SimpleValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MetaDataAccessInterceptor
implements InvocationHandler {
    private final IMetaDataAccess access;
    private static final MapWrapper cache = new MapWrapper(new LRUMap<Object, SimpleValue>(2000));

    MetaDataAccessInterceptor(IMetaDataAccess access) {
        this.access = access;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args != null && args.length == 1) {
            if (args[0] instanceof Select[]) {
                Select[] selects = (Select[])args[0];
                SimpleValue[] result = new SimpleValue[selects.length];
                ArrayList<Select> notHit = new ArrayList<Select>();
                for (int i = 0; i < selects.length; ++i) {
                    Object key = selects[i].getIdentity();
                    SimpleValue r = cache.get(key);
                    if (r != null) {
                        result[i] = r;
                        continue;
                    }
                    notHit.add(selects[i]);
                }
                if (notHit.size() > 0) {
                    Select[] newSelects;
                    args[0] = newSelects = notHit.toArray(new Select[0]);
                    SimpleValue[] newResults = (SimpleValue[])method.invoke((Object)this.access, args);
                    int j = 0;
                    for (int i = 0; i < newSelects.length; ++i) {
                        while (result[j] != null) {
                            ++j;
                        }
                        result[j] = newResults[i];
                        cache.put(newSelects[i].getIdentity(), newResults[i]);
                    }
                }
                return result;
            }
            if (args[0] instanceof Select) {
                Object key = ((Select)args[0]).getIdentity();
                SimpleValue result = cache.get(key);
                if (result != null) {
                    return result;
                }
                result = (SimpleValue)method.invoke((Object)this.access, args);
                cache.put(key, result);
                return result;
            }
        }
        return method.invoke((Object)this.access, args);
    }

    static void clear() {
        cache.clear();
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int size;
        private String sessionID = null;

        LRUMap(int size) {
            this.size = size;
        }

        @Override
        public synchronized V get(Object key) {
            String currentSessionID = KeyFactory.getClientCacheKey().get();
            if (this.sessionID != currentSessionID) {
                if (this.sessionID != null) {
                    this.clear();
                }
                this.sessionID = currentSessionID;
                return null;
            }
            return super.get(key);
        }

        @Override
        public synchronized V put(K key, V value) {
            return super.put(key, value);
        }

        @Override
        public synchronized void clear() {
            super.clear();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.size;
        }
    }

    private static class MapWrapper {
        private final Map<Object, SimpleValue> map;
        private static final LRUMap<String, List<SelectKey>> index = new LRUMap(300);

        public MapWrapper(Map<Object, SimpleValue> map) {
            this.map = map;
        }

        public synchronized SimpleValue get(Object key) {
            SimpleValue result = this.map.get(key);
            if (result == null && key instanceof SelectKey) {
                SelectKey sk = (SelectKey)key;
                String uri = sk.getUri();
                List<SelectKey> uriSets = index.get(uri);
                if (uriSets == null) {
                    return null;
                }
                for (SelectKey k : uriSets) {
                    SimpleValue r;
                    if (!k.contains(sk) || (r = this.map.get(k)) == null) continue;
                    return r;
                }
            }
            return result;
        }

        public synchronized SimpleValue put(Object key, SimpleValue value) {
            if (key instanceof SelectKey && value instanceof Mergeable) {
                SelectKey sk = (SelectKey)key;
                String uri = sk.getUri();
                List<SelectKey> uriSets = index.get(uri);
                if (uriSets == null) {
                    uriSets = new ArrayList<SelectKey>();
                    uriSets.add(sk);
                    index.put(uri, uriSets);
                } else {
                    SelectKey[] keys = uriSets.toArray(new SelectKey[0]);
                    ArrayList<SelectKey> newList = new ArrayList<SelectKey>();
                    boolean isMerged = false;
                    for (int i = 0; i < keys.length; ++i) {
                        SimpleValue r;
                        if (!keys[i].canMerge(sk) || (r = this.map.remove(keys[i])) == null) continue;
                        ((Mergeable)((Object)r)).merge(value);
                        keys[i].merge(sk);
                        newList.add(keys[i]);
                        this.map.put(keys[i], r);
                        value = r;
                        isMerged = true;
                    }
                    if (!isMerged) {
                        newList.add(sk);
                    }
                    index.put(uri, newList);
                }
            }
            return this.map.put(key, value);
        }

        public synchronized void clear() {
            this.map.clear();
            index.clear();
        }
    }
}

