/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access.entity;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.access.AbstractSelectHandler;
import com.kingdee.bos.metadata.access.ResultSet;
import com.kingdee.bos.metadata.access.SelectContext;
import com.kingdee.bos.metadata.access.SimpleSelectHandler;
import com.kingdee.bos.metadata.access.entity.EntityAccess;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.LinkType;
import com.kingdee.bos.metadata.access.entity.PropertySelect;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.util.enums.Enum;
import java.util.Locale;

public class PropertySelectHandler
extends AbstractSelectHandler<PropertySelect, SimpleProperty, PropertyInfo> {
    private final EntityObjectInfo entity;

    public PropertySelectHandler(EntityObjectInfo entity) {
        this.entity = entity;
    }

    @Override
    protected void innerHandle(SelectContext ctx, PropertySelect select, ResultSet<SimpleProperty, PropertyInfo> result) throws BOSException {
        LinkPropertyInfo linkProp;
        EntityObjectInfo subEntity;
        EntitySelect entitySelect;
        SimpleProperty sp = result.getSelectData();
        PropertyInfo p = result.getMetadata();
        sp.setString("name", p.getName());
        boolean isOwnProperty = p instanceof OwnPropertyInfo;
        sp.setOwnProperty(isOwnProperty);
        String[] attributes = select.attributeSelected();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                if (!isOwnProperty ? this.handleLinkProperty(attributes[i], sp, (LinkPropertyInfo)p) != 0 : this.handleOwnProperty(attributes[i], sp, (OwnPropertyInfo)p) != 0) continue;
                Locale locale = select.localeSelected();
                if (locale != null && ("alias".equals(attributes[i]) || "description".equals(attributes[i]))) {
                    sp.put(attributes[i], p.get(attributes[i], locale));
                    continue;
                }
                sp.put(attributes[i], p.get(attributes[i]));
            }
        }
        if (!isOwnProperty && (entitySelect = select.relatedEntitySelected()) != null && (subEntity = PropertySelectHandler.getEntity(this.entity, linkProp = (LinkPropertyInfo)p)) != null) {
            entitySelect.setFullName(subEntity.getFullName());
            EntityAccess ec = new EntityAccess(ctx.getBOSContext());
            sp.setRelatedEntity(ec.create(entitySelect));
        }
        new SimpleSelectHandler<PropertySelect, SimpleProperty, PropertyInfo>().handle(ctx, select, result);
    }

    private int handleOwnProperty(String attribute, SimpleProperty sp, OwnPropertyInfo prop) {
        if ("constraint".equals(attribute)) {
            sp.put("constraint", prop.getConstraint());
            return 1;
        }
        if ("enumType".equals(attribute)) {
            sp.setEnumType(prop.getEnumType(MDHostType.RUNTIME));
            return 1;
        }
        if ("dataType".equals(attribute)) {
            DataType dt = prop.getDataType();
            sp.setDataType(dt);
            if (dt != null) {
                String javaType = dt.getJavaTypeName();
                if (Enum.class.getName().equals(javaType)) {
                    javaType = prop.getMetaDataRef();
                }
                sp.setRefTypeInfo(javaType);
            }
            return 1;
        }
        return 0;
    }

    private int handleLinkProperty(String attribute, SimpleProperty sp, LinkPropertyInfo prop) {
        if ("linkType".equals(attribute) && this.entity != null) {
            RelationshipInfo relation = prop.getRelationship();
            boolean isClient = this.entity.equals(relation.getClientObject());
            sp.setLinkType(new LinkType(isClient, relation.getLinkType(this.entity), relation.getParentCardinality(this.entity), relation.getChildCardinality(this.entity)));
            return 1;
        }
        if ("dataType".equals(attribute)) {
            RelationshipInfo relation = prop.getRelationship();
            CardinalityType ctype = relation.getSupplierCardinality();
            if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)ctype) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)ctype)) {
                sp.setDataType(DataType.OBJECTCOLLECTION);
                sp.setRefTypeInfo(relation.getSupplierObject().getObjectCollectionClassRuntime());
            } else {
                sp.setDataType(DataType.OBJECTVALUE);
                sp.setRefTypeInfo(relation.getSupplierObject().getObjectValueClassRuntime());
            }
            return 1;
        }
        return 0;
    }

    static EntityObjectInfo getEntity(EntityObjectInfo parent, LinkPropertyInfo prop) {
        if (parent == null || prop == null) {
            return null;
        }
        return prop.getRelationship().getChildObject(parent);
    }
}

