/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.access.ui;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.access.AbstractSelectHandler;
import com.kingdee.bos.metadata.access.ResultSet;
import com.kingdee.bos.metadata.access.SelectContext;
import com.kingdee.bos.metadata.access.SimpleSelectHandler;
import com.kingdee.bos.metadata.access.ui.ComponentSelect;
import com.kingdee.bos.metadata.access.ui.PropertyBindingSelect;
import com.kingdee.bos.metadata.access.ui.SimpleComponent;
import com.kingdee.bos.metadata.access.ui.SimpleComponentCollection;
import com.kingdee.bos.metadata.access.ui.SimpleDataObject;
import com.kingdee.bos.metadata.access.ui.SimplePropertyBinding;
import com.kingdee.bos.metadata.access.ui.SimplePropertyBindingCollection;
import com.kingdee.bos.metadata.access.ui.SimpleUI;
import com.kingdee.bos.metadata.access.ui.UISelect;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import java.util.Locale;

public class UISelectHandler
extends AbstractSelectHandler<UISelect, SimpleUI, UIObjectInfo> {
    @Override
    protected void innerHandle(SelectContext ctx, UISelect select, ResultSet<SimpleUI, UIObjectInfo> result) throws BOSException {
        DataObjectCollection objects;
        SimpleUI sui = result.getSelectData();
        UIObjectInfo ui = result.getMetadata();
        if (select.dataObjectsSelected() && (objects = ui.getDataObjects()) != null) {
            SimpleDataObject[] dos = new SimpleDataObject[objects.size()];
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                dos[i] = new SimpleDataObject();
                dos[i].setName(objects.get(i).getName());
                dos[i].setType(objects.get(i).getType());
                dos[i].setObjectType(objects.get(i).getObjectType());
                dos[i].setHerited(objects.get(i).isHerited());
            }
            sui.setDataObjects(dos);
        }
        ComponentSelect compSelect = select.componentSelected();
        while (compSelect != null) {
            String[] names;
            if (sui.components() == null) {
                sui.setComponents(new SimpleComponentCollection());
            }
            if ((names = compSelect.nameSelected()) == null) {
                compSelect = (ComponentSelect)compSelect.next();
                continue;
            }
            ComponentCollection compCol = ui.getComponents();
            if (this.isSelectAll(names)) {
                int size = compCol.size();
                for (int i = 0; i < size; ++i) {
                    SimpleComponent scomp = new SimpleComponent();
                    this.handleComponent(ctx, compSelect, scomp, compCol.get(i));
                    sui.components().add(scomp);
                }
                break;
            }
            for (int i = 0; i < names.length; ++i) {
                ComponentInfo comp = compCol.getComponentInfo(names[i]);
                if (comp == null) continue;
                SimpleComponent scomp = new SimpleComponent();
                this.handleComponent(ctx, compSelect, scomp, comp);
                sui.components().add(scomp);
            }
            compSelect = (ComponentSelect)compSelect.next();
        }
    }

    private void handleComponent(SelectContext ctx, ComponentSelect select, SimpleComponent scomp, ComponentInfo comp) throws BOSException {
        PropertyBindingCollection propBindCol;
        PropertyBindingSelect propBindSelect;
        scomp.setName(comp.getName());
        Locale locale = select.localeSelected();
        String[] attributes = select.attributeSelected();
        if (attributes != null) {
            for (int i = 0; i < attributes.length; ++i) {
                if (locale != null && "alias".equals(attributes[i])) {
                    scomp.put(attributes[i], comp.get(attributes[i], locale));
                    continue;
                }
                scomp.put(attributes[i], comp.get(attributes[i]));
            }
        }
        if ((propBindSelect = select.propertyBindingSelected()) != null && (propBindCol = comp.getPropertyBindings()) != null) {
            attributes = propBindSelect.attributeSelected();
            scomp.setPropertyBindings(new SimplePropertyBindingCollection());
            int size = propBindCol.size();
            for (int i = 0; i < size; ++i) {
                SimplePropertyBinding spropBind = new SimplePropertyBinding();
                PropertyBindingInfo propBind = propBindCol.get(i);
                for (int j = 0; j < attributes.length; ++j) {
                    spropBind.put(attributes[j], propBind.get(attributes[j]));
                }
                scomp.propertyBindings().add(spropBind);
            }
        }
        new SimpleSelectHandler<ComponentSelect, SimpleComponent, ComponentInfo>().handle(ctx, select, new ResultSet<SimpleComponent, ComponentInfo>(scomp, comp));
    }
}

