/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.IXMLDAO;
import com.kingdee.bos.metadata.AbstractMetaDataCtrl;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.IRuleSetCtrl;
import com.kingdee.bos.metadata.bizrule.RuleSetCollection;
import com.kingdee.bos.metadata.bizrule.RuleSetInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.ConditionCollection;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionCollection;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.GroupExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.MethodInfo;
import com.kingdee.bos.metadata.bizrule.common.ParameterCollection;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class RuleSetCtrl
extends AbstractMetaDataCtrl
implements IRuleSetCtrl {
    public RuleSetCtrl(Context ctx) {
        super(ctx);
        super.registerInterface(IRuleSetCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "simpleExpression"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "groupExpression"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "constraintRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "computationRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "conditionRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "ruleSet"));
    }

    public RuleSetCtrl() {
        super.registerInterface(IRuleSetCtrl.class, (Object)this);
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "simpleExpression"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "groupExpression"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "constraintRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "computationRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "conditionRule"));
        this.loadSelfMetametaData(MetaDataPK.create("metametadata.bizrule", "ruleSet"));
    }

    @Override
    public BOSObjectType getType() {
        return MetaDataTypeList.BIZRULESET;
    }

    @Override
    public void addnew(IMetaDataPK pk, RuleSetInfo ruleSetInfo) throws BOSException {
        RuleSetCtrl.beforeSave(ruleSetInfo);
        this.getDAO().addnew(pk, ruleSetInfo);
    }

    @Override
    public IMetaDataPK addnew(RuleSetInfo ruleSetInfo) throws BOSException {
        RuleSetCtrl.beforeSave(ruleSetInfo);
        IMetaDataPK metaDataPK = (IMetaDataPK)this.getDAO().addnew(ruleSetInfo);
        return metaDataPK;
    }

    @Override
    public void remove(IMetaDataPK metaType) throws BOSException {
        this.getDAO().delete(metaType);
    }

    @Override
    public void update(IMetaDataPK metaType, RuleSetInfo ruleSetInfo) throws BOSException {
        RuleSetCtrl.beforeSave(ruleSetInfo);
        this.getDAO().update(metaType, ruleSetInfo);
    }

    @Override
    public boolean exists(IMetaDataPK metaType) throws BOSException {
        return this.getDAO().exists(metaType);
    }

    @Override
    public RuleSetInfo getValue(IMetaDataPK metaType) throws BOSException {
        RuleSetInfo ruleSetInfo = (RuleSetInfo)this.getDAO().getValue(metaType);
        RuleSetCtrl.afterLoad(ruleSetInfo);
        return ruleSetInfo;
    }

    @Override
    public IObjectValue load(InputStream is) throws DataAccessException {
        RuleSetInfo ruleSet = (RuleSetInfo)super.load(is);
        RuleSetCtrl.afterLoad(ruleSet);
        return ruleSet;
    }

    public RuleSetCollection getCollection() throws BOSException {
        RuleSetCollection bizRuleSets = (RuleSetCollection)this.getDAO().getCollection();
        int n = bizRuleSets.size();
        for (int i = 0; i < n; ++i) {
            RuleSetCtrl.afterLoad(bizRuleSets.get(i));
        }
        return bizRuleSets;
    }

    public RuleSetCollection getCollection(String pgName) throws BOSException {
        RuleSetCollection bizRuleSets = (RuleSetCollection)((IXMLDAO)this.getDAO()).getCollection(pgName);
        int n = bizRuleSets.size();
        for (int i = 0; i < n; ++i) {
            RuleSetCtrl.afterLoad(bizRuleSets.get(i));
        }
        return bizRuleSets;
    }

    @Override
    public IMetaDataPK[] getPKList() throws BOSException {
        return (IMetaDataPK[])this.getDAO().getPKList();
    }

    @Override
    public IMetaDataPK[] getPKList(String pgName) throws BOSException {
        return (IMetaDataPK[])((IXMLDAO)this.getDAO()).getPKList(pgName);
    }

    private static String getObjectID(IObjectValue info) {
        if (info == null) {
            return null;
        }
        String id = info.getString("id");
        if (StringUtils.isEmpty((String)id)) {
            id = Uuid.create().toString();
            info.setString("id", id);
        }
        return id;
    }

    private static Hashtable transToHashtable(IObjectCollection col) {
        Hashtable<String, IObjectValue> table = new Hashtable<String, IObjectValue>();
        if (col != null) {
            int m = col.size();
            for (int j = 0; j < m; ++j) {
                String id = RuleSetCtrl.getObjectID(col.getObject(j));
                table.put(id, col.getObject(j));
            }
        }
        return table;
    }

    private static void addExpressionsFromMethod(MethodInfo methodInfo, ExpressionCollection expCol) {
        if (methodInfo == null) {
            return;
        }
        ParameterCollection paramCol = methodInfo.getParameters();
        int m = paramCol.size();
        for (int i = 0; i < m; ++i) {
            paramCol.get(i).setString("expressionID", RuleSetCtrl.getObjectID(paramCol.get(i).getExpression()));
            RuleSetCtrl.addExpressionsFromExp(paramCol.get(i).getExpression(), expCol);
        }
    }

    private static void addExpressionsFromExp(AbstractExpressionInfo expInfo, ExpressionCollection expCol) {
        block5: {
            String id;
            block3: {
                SimpleExpressionInfo seInfo;
                block4: {
                    id = RuleSetCtrl.getObjectID(expInfo);
                    expCol.add(expInfo);
                    if (!(expInfo instanceof SimpleExpressionInfo)) break block3;
                    seInfo = (SimpleExpressionInfo)expInfo;
                    if (seInfo.getType() != ExpressionType.METHODINVOKE) break block4;
                    if (seInfo.getMethod() != null && seInfo.getMethod().getOwner() != null) {
                        seInfo.getMethod().setString("ownerID", RuleSetCtrl.getObjectID(seInfo.getMethod().getOwner()));
                        RuleSetCtrl.addExpressionsFromExp(seInfo.getMethod().getOwner(), expCol);
                    }
                    RuleSetCtrl.addExpressionsFromMethod(seInfo.getMethod(), expCol);
                    break block5;
                }
                if (seInfo.getType() != ExpressionType.PROPERTYACCESS || seInfo.getProperty() == null || seInfo.getProperty().getOwner() == null) break block5;
                seInfo.getProperty().setString("ownerID", RuleSetCtrl.getObjectID(seInfo.getProperty().getOwner()));
                RuleSetCtrl.addExpressionsFromExp(seInfo.getProperty().getOwner(), expCol);
                break block5;
            }
            if (expInfo instanceof GroupExpressionInfo) {
                GroupExpressionInfo geInfo = (GroupExpressionInfo)expInfo;
                int m = geInfo.getExpressions().size();
                for (int i = 0; i < m; ++i) {
                    geInfo.getExpressions().get(i).setString("parentID", id);
                    RuleSetCtrl.addExpressionsFromExp(geInfo.getExpressions().get(i), expCol);
                }
            }
        }
    }

    private static void setExpressionsToMethod(MethodInfo methodInfo, ExpressionCollection expCol, Hashtable table) {
        if (methodInfo == null) {
            return;
        }
        ParameterCollection paramCol = methodInfo.getParameters();
        int m = paramCol.size();
        for (int i = 0; i < m; ++i) {
            String expressionID = paramCol.get(i).getString("expressionID");
            paramCol.get(i).setExpression((AbstractExpressionInfo)table.get(expressionID));
        }
    }

    private static void setExpressionsToExp(AbstractExpressionInfo expInfo, ExpressionCollection expCol, Hashtable table) {
        String id = expInfo.getString("id");
        if (expInfo instanceof GroupExpressionInfo) {
            GroupExpressionInfo geInfo = (GroupExpressionInfo)expInfo;
            geInfo.getExpressions().clear();
            int n = expCol.size();
            for (int i = 0; i < n; ++i) {
                String parentID = expCol.get(i).getString("parentID");
                if (!id.equals(parentID)) continue;
                geInfo.getExpressions().add(expCol.get(i));
            }
        } else if (expInfo instanceof SimpleExpressionInfo) {
            String ownerID;
            SimpleExpressionInfo seInfo = (SimpleExpressionInfo)expInfo;
            if (seInfo.getType() == ExpressionType.METHODINVOKE) {
                String ownerID2;
                if (seInfo.getMethod() != null && !StringUtils.isEmpty((String)(ownerID2 = seInfo.getMethod().getString("ownerID")))) {
                    seInfo.getMethod().setOwner((SimpleExpressionInfo)table.get(ownerID2));
                }
                RuleSetCtrl.setExpressionsToMethod(seInfo.getMethod(), expCol, table);
            } else if (seInfo.getType() == ExpressionType.PROPERTYACCESS && seInfo.getProperty() != null && !StringUtils.isEmpty((String)(ownerID = seInfo.getProperty().getString("ownerID")))) {
                seInfo.getProperty().setOwner((SimpleExpressionInfo)table.get(ownerID));
            }
        }
    }

    public static void beforeSave(RuleSetInfo rsInfo) {
        AbstractExpressionInfo exp;
        ActionInfo action;
        ConditionInfo condition;
        int i;
        ExpressionCollection expCol = new ExpressionCollection();
        ActionCollection actions = rsInfo.getActions();
        ConditionCollection conditions = rsInfo.getConditions();
        int n = rsInfo.getRules().size();
        for (i = 0; i < n; ++i) {
            ActionCollection actions2;
            ActionCollection actions1;
            AbstractRuleInfo rule = rsInfo.getRules().get(i);
            condition = (ConditionInfo)rule.get("condition");
            if (condition != null && !conditions.contains(condition)) {
                conditions.add(condition);
            }
            if ((actions1 = (ActionCollection)rule.get("actions")) != null) {
                int m = actions1.size();
                for (int j = 0; j < m; ++j) {
                    action = actions1.get(j);
                    if (actions.contains(action)) continue;
                    actions.add(action);
                }
            }
            if ((actions2 = (ActionCollection)rule.get("exceptionActions")) == null) continue;
            int m = actions2.size();
            for (int j = 0; j < m; ++j) {
                action = actions2.get(j);
                if (actions.contains(action)) continue;
                actions.add(action);
            }
        }
        n = actions.size();
        for (i = 0; i < n; ++i) {
            action = actions.get(i);
            exp = action.getExpression();
            if (exp == null) continue;
            actions.get(i).put("expressionID", RuleSetCtrl.getObjectID(exp));
            RuleSetCtrl.addExpressionsFromExp(exp, expCol);
        }
        n = conditions.size();
        for (i = 0; i < n; ++i) {
            condition = conditions.get(i);
            exp = condition.getExpression();
            if (exp == null) continue;
            condition.put("expressionID", RuleSetCtrl.getObjectID(exp));
            RuleSetCtrl.addExpressionsFromExp(condition.getExpression(), expCol);
        }
        rsInfo.put("expressions", expCol);
    }

    public static void afterLoad(RuleSetInfo rsInfo) {
        ConditionCollection conditions;
        String expressionID;
        if (rsInfo.getBoolean("_hasReConstruct")) {
            return;
        }
        ExpressionCollection expCol = (ExpressionCollection)rsInfo.get("expressions");
        if (expCol == null) {
            expCol = new ExpressionCollection();
        }
        Hashtable expTable = RuleSetCtrl.transToHashtable(expCol);
        int n = expCol.size();
        for (int i = 0; i < n; ++i) {
            RuleSetCtrl.setExpressionsToExp(expCol.get(i), expCol, expTable);
        }
        ActionCollection actions = (ActionCollection)rsInfo.get("actions");
        if (actions != null) {
            int n2 = actions.size();
            for (int i = 0; i < n2; ++i) {
                ActionInfo action = actions.get(i);
                expressionID = action.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                action.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        if ((conditions = (ConditionCollection)rsInfo.get("conditions")) != null) {
            int n3 = conditions.size();
            for (int i = 0; i < n3; ++i) {
                ConditionInfo condition = conditions.get(i);
                expressionID = condition.getString("expressionID");
                if (StringUtils.isEmpty((String)expressionID)) continue;
                condition.setExpression((AbstractExpressionInfo)expTable.get(expressionID));
            }
        }
        rsInfo.setBoolean("_hasReConstruct", true);
    }

    @Override
    public void deploy(IMetaDataPK pk, DeployOptionInfo options) throws BOSException {
        super.deploy(pk, options);
    }

    @Override
    public void store(IObjectValue ov, OutputStream os) throws DataAccessException {
        RuleSetCtrl.beforeSave((RuleSetInfo)ov);
        super.store(ov, os);
    }
}

