/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizrule;

import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.common.AbstractRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.ActionInfo;
import com.kingdee.bos.metadata.bizrule.common.ConditionCollection;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.RuleCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class RuleSetInfo
extends AbstractMetaDataValue
implements Serializable {
    private static final String RULES = "rules";
    private static final String ACTIONS = "actions";
    private static final String CONDITIONS = "conditions";

    public RuleSetInfo() {
        this.put(RULES, new RuleCollection());
        this.put(ACTIONS, new ActionCollection());
        this.put(CONDITIONS, new ConditionCollection());
    }

    protected RuleSetInfo(boolean init) {
        super(init);
        this.put(RULES, new RuleCollection());
        this.put(ACTIONS, new ActionCollection());
        this.put(CONDITIONS, new ConditionCollection());
    }

    @Override
    public BOSObjectType getBOSType() {
        return MetaDataTypeList.BIZRULESET;
    }

    public RuleCollection getRules() {
        if (this.get(RULES) == null) {
            this.put(RULES, new RuleCollection());
        }
        return (RuleCollection)this.get(RULES);
    }

    public ActionCollection getActions() {
        if (this.get(ACTIONS) == null) {
            this.put(ACTIONS, new ActionCollection());
        }
        return (ActionCollection)this.get(ACTIONS);
    }

    public ConditionCollection getConditions() {
        if (this.get(CONDITIONS) == null) {
            this.put(CONDITIONS, new ConditionCollection());
        }
        return (ConditionCollection)this.get(CONDITIONS);
    }

    public boolean isActionRef(String actionName) {
        if (StringUtils.isEmpty((String)actionName)) {
            return false;
        }
        RuleCollection rules = (RuleCollection)this.get(RULES);
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            AbstractRuleInfo rule = rules.get(i);
            ActionCollection actions = (ActionCollection)rule.get(ACTIONS);
            int m = actions.size();
            for (int j = 0; j < m; ++j) {
                ActionInfo action = actions.get(j);
                if (!actionName.equalsIgnoreCase(action.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConditionRef(String conditionName) {
        if (StringUtils.isEmpty((String)conditionName)) {
            return false;
        }
        RuleCollection rules = (RuleCollection)this.get(RULES);
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            AbstractRuleInfo rule = rules.get(i);
            ConditionInfo condition = (ConditionInfo)rule.get("condition");
            if (condition == null || !conditionName.equalsIgnoreCase(condition.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeRuleSet(AbstractRuleInfo rule) {
        ActionInfo action;
        RuleCollection rules = (RuleCollection)this.get(RULES);
        rules.remove(rule);
        ActionCollection actionList = (ActionCollection)this.get(ACTIONS);
        ConditionInfo condition = (ConditionInfo)rule.get("condition");
        if (condition != null && !StringUtils.isEmpty((String)condition.getName())) {
            ConditionCollection conditions = (ConditionCollection)this.get(CONDITIONS);
            conditions.remove(condition);
            ActionCollection exceptionActions = (ActionCollection)rule.get("exceptionActions");
            int n = exceptionActions.size();
            for (int i = 0; i < n; ++i) {
                action = exceptionActions.get(i);
                actionList.remove(action);
            }
        }
        ActionCollection actions = (ActionCollection)rule.get(ACTIONS);
        int n = actions.size();
        for (int i = 0; i < n; ++i) {
            action = actions.get(i);
            actionList.remove(action);
        }
    }

    public void addRuleExt(AbstractRuleInfo rule) {
        ActionInfo action;
        RuleCollection rules = (RuleCollection)this.get(RULES);
        rules.add(rule);
        ActionCollection actionList = (ActionCollection)this.get(ACTIONS);
        ConditionInfo condition = (ConditionInfo)rule.get("condition");
        if (condition != null && !StringUtils.isEmpty((String)condition.getName())) {
            ConditionCollection conditions = (ConditionCollection)this.get(CONDITIONS);
            if (!conditions.contains(condition)) {
                conditions.add(condition);
            }
            ActionCollection exceptionActions = (ActionCollection)rule.get("exceptionActions");
            int n = exceptionActions.size();
            for (int i = 0; i < n; ++i) {
                action = exceptionActions.get(i);
                if (actionList.contains(action)) continue;
                actionList.add(action);
            }
        }
        ActionCollection actions = (ActionCollection)rule.get(ACTIONS);
        int n = actions.size();
        for (int i = 0; i < n; ++i) {
            action = actions.get(i);
            if (actionList.contains(action)) continue;
            actionList.add(action);
        }
    }
}

