/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizrule.util;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizrule.ComputationRuleInfo;
import com.kingdee.bos.metadata.bizrule.ConditionRuleInfo;
import com.kingdee.bos.metadata.bizrule.ConstraintRuleInfo;
import com.kingdee.bos.metadata.bizrule.ConstraintType;
import com.kingdee.bos.metadata.bizrule.common.AbstractExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.AbstractRuleInfo;
import com.kingdee.bos.metadata.bizrule.common.ActionCollection;
import com.kingdee.bos.metadata.bizrule.common.ConditionInfo;
import com.kingdee.bos.metadata.bizrule.common.ExpressionType;
import com.kingdee.bos.metadata.bizrule.common.GroupExpressionInfo;
import com.kingdee.bos.metadata.bizrule.common.MethodInfo;
import com.kingdee.bos.metadata.bizrule.common.PropertyInfo;
import com.kingdee.bos.metadata.bizrule.common.SimpleExpressionInfo;
import com.kingdee.bos.metadata.bizrule.util.UIRuleCodeHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.metadata.ui.ActionExtendPropertyHelper;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingCollection;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdlayout.KDLayoutConstraint;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;

public class RuleJCodeWriter {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.bizrule.util.RuleJCodeWriter");
    protected static final char CLF = '\n';
    protected static String tab = "";
    protected static StringBuffer writer;
    private AbstractRuleInfo lnkAbstractRuleInfo;

    protected static void initial() {
        tab = "";
        writer = new StringBuffer();
    }

    protected static void writeBegin() {
        writer.append(tab + "{" + '\n');
        tab = tab + "    ";
    }

    protected static void writeEnd() {
        tab = tab.substring(0, tab.length() - 4);
        writer.append(tab + "}" + '\n');
    }

    public static synchronized String writeMethod(AbstractRuleInfo rule, String methodName) {
        RuleJCodeWriter.initial();
        RuleJCodeWriter.writeMethodHead(rule, methodName);
        RuleJCodeWriter.writeBegin();
        RuleJCodeWriter.writeMethodBody(rule);
        RuleJCodeWriter.writeEnd();
        return writer.toString();
    }

    public static synchronized String writeBody(AbstractRuleInfo rule) {
        RuleJCodeWriter.initial();
        RuleJCodeWriter.writeMethodBody(rule);
        return writer.toString();
    }

    private static void writeMethodHead(AbstractRuleInfo rule, String methodName) {
        String returnType = "void";
        String parameters = "";
        if (rule instanceof ConstraintRuleInfo) {
            ConstraintRuleInfo constraint = (ConstraintRuleInfo)rule;
            if (constraint.getType() == ConstraintType.INITIALVALUE) {
                returnType = "Object";
                parameters = "";
            } else if (constraint.getType() == ConstraintType.PRECONDITION || constraint.getType() == ConstraintType.POSTCONDITION) {
                returnType = "boolean";
                parameters = "";
            } else {
                returnType = "boolean";
                parameters = "Object value";
            }
        } else if (rule instanceof ComputationRuleInfo) {
            returnType = "Object";
            parameters = "";
        } else if (rule instanceof ConditionRuleInfo) {
            returnType = "void";
            parameters = "";
        }
        writer.append(tab + "protected " + returnType + " " + methodName + "(" + parameters + ") throws Exception " + '\n');
    }

    private static String formatExpression(String exp) {
        if (StringUtils.isEmpty((String)exp)) {
            return "";
        }
        String formatExp = exp;
        if (exp.indexOf("UIRuleUtil.throwException(") >= 0) {
            formatExp = StringUtils.replace((String)exp, (String)"UIRuleUtil.throwException(", (String)"com.kingdee.eas.util.client.MsgBox.showInfo(this,");
            formatExp = formatExp + "com.kingdee.eas.util.SysUtil.abort();";
        }
        return formatExp;
    }

    private static void writeMethodBody(AbstractRuleInfo rule) {
        String temp;
        int i;
        int n;
        ConditionRuleInfo cdRule;
        ActionCollection actions;
        String condition = RuleJCodeWriter.removeBracket(RuleJCodeWriter.getCondition(rule));
        if (!StringUtils.isEmpty((String)condition)) {
            writer.append(tab + "if (" + condition + ") " + '\n');
            RuleJCodeWriter.writeBegin();
        }
        if (!(rule instanceof ConstraintRuleInfo) && !(rule instanceof ComputationRuleInfo) && rule instanceof ConditionRuleInfo && (actions = (cdRule = (ConditionRuleInfo)rule).getActions()) != null) {
            n = actions.size();
            for (i = 0; i < n; ++i) {
                if (actions.get(i).getExpression() == null) continue;
                temp = RuleJCodeWriter.removeBracket(RuleJCodeWriter.getExpression(actions.get(i).getExpression(), null)) + ";";
                writer.append(tab + RuleJCodeWriter.formatExpression(temp) + '\n');
            }
        }
        if (!StringUtils.isEmpty((String)condition)) {
            RuleJCodeWriter.writeEnd();
            if (rule instanceof ConditionRuleInfo && (actions = (cdRule = (ConditionRuleInfo)rule).getExceptionActions()) != null && actions.size() > 0) {
                writer.append(tab + "else" + '\n');
                RuleJCodeWriter.writeBegin();
                n = actions.size();
                for (i = 0; i < n; ++i) {
                    if (actions.get(i).getExpression() == null) continue;
                    temp = RuleJCodeWriter.removeBracket(RuleJCodeWriter.getExpression(actions.get(i).getExpression(), null)) + ";";
                    writer.append(tab + RuleJCodeWriter.formatExpression(temp) + '\n');
                }
                RuleJCodeWriter.writeEnd();
            }
        }
    }

    private static String removeBracket(String expression) {
        if (StringUtils.isEmpty((String)expression)) {
            return "";
        }
        int len = expression.length();
        if (len >= 2 && expression.substring(0, 1).equals("(") && expression.substring(len - 1).equals(")")) {
            return expression.substring(1, len - 1);
        }
        return expression;
    }

    private static String getCondition(AbstractRuleInfo rule) {
        if (rule.get("condition") == null) {
            return null;
        }
        ConditionInfo condition = (ConditionInfo)rule.get("condition");
        AbstractExpressionInfo expression = null;
        if (condition == null || condition.getExpression() == null) {
            return null;
        }
        expression = condition.getExpression();
        return RuleJCodeWriter.getExpression(expression, null);
    }

    private static String getMethod(MethodInfo method) {
        StringBuffer sb = new StringBuffer();
        if (method != null) {
            if (method.getOwner() == null) {
                sb.append(method.getName() + "(");
            } else {
                sb.append(RuleJCodeWriter.getExpression(method.getOwner(), null) + "." + method.getName() + "(");
            }
            int n = method.getParameters().size();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    sb.append(RuleJCodeWriter.getExpression(method.getParameters().get(i).getExpression(), null));
                    continue;
                }
                sb.append("," + RuleJCodeWriter.getExpression(method.getParameters().get(i).getExpression(), null));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getMethod(PropertyInfo property, boolean isSetMethod) {
        StringBuffer sb = new StringBuffer();
        if (property != null) {
            if (isSetMethod) {
                sb.append(RuleJCodeWriter.getExpression(property.getOwner(), null) + ".set" + RuleJCodeWriter.upcastName(property.getName()) + "");
            } else if ("boolean".equals(property.getType())) {
                sb.append(RuleJCodeWriter.getExpression(property.getOwner(), null) + ".is" + RuleJCodeWriter.upcastName(property.getName()) + "()");
            } else {
                sb.append(RuleJCodeWriter.getExpression(property.getOwner(), null) + ".get" + RuleJCodeWriter.upcastName(property.getName()) + "()");
            }
        }
        return sb.toString();
    }

    private static boolean isCompareOperator(String operator) {
        if (operator.compareToIgnoreCase("==") == 0) {
            return true;
        }
        if (operator.compareToIgnoreCase("!=") == 0) {
            return true;
        }
        if (operator.compareToIgnoreCase(">") == 0) {
            return true;
        }
        if (operator.compareToIgnoreCase("<") == 0) {
            return true;
        }
        if (operator.compareToIgnoreCase(">=") == 0) {
            return true;
        }
        return operator.compareToIgnoreCase("<=") == 0;
    }

    private static String getExpression(AbstractExpressionInfo expression, String desType) {
        StringBuffer sb = new StringBuffer();
        if (expression instanceof GroupExpressionInfo) {
            GroupExpressionInfo groupExp = (GroupExpressionInfo)expression;
            if (groupExp.getOperator().compareToIgnoreCase("=") == 0) {
                if (groupExp.getExpressions().size() > 1) {
                    SimpleExpressionInfo simpleExp = (SimpleExpressionInfo)groupExp.getExpressions().get(0);
                    if (ExpressionType.PROPERTYACCESS.equals((Object)simpleExp.getType())) {
                        if ("Object".equalsIgnoreCase(simpleExp.getProperty().getType()) || "java.lang.Object".equalsIgnoreCase(simpleExp.getProperty().getType())) {
                            sb.append(RuleJCodeWriter.getMethod(simpleExp.getProperty(), true) + "(" + RuleJCodeWriter.removeBracket(RuleJCodeWriter.getExpression(groupExp.getExpressions().get(1), UIRuleCodeHelper.getObjectType(simpleExp.getValueType()))) + ")");
                        } else {
                            sb.append(RuleJCodeWriter.getMethod(simpleExp.getProperty(), true) + "(" + RuleJCodeWriter.removeBracket(RuleJCodeWriter.getExpression(groupExp.getExpressions().get(1), simpleExp.getProperty().getType())) + ")");
                        }
                    } else {
                        sb.append(simpleExp.getValue() + " = " + RuleJCodeWriter.removeBracket(RuleJCodeWriter.getExpression(groupExp.getExpressions().get(1), "Unkown")));
                    }
                }
            } else if (groupExp.getOperator().compareToIgnoreCase("==") == 0) {
                if (groupExp.getExpressions().size() > 1) {
                    AbstractExpressionInfo exp1 = groupExp.getExpressions().get(0);
                    AbstractExpressionInfo exp2 = groupExp.getExpressions().get(1);
                    if ("Object".equalsIgnoreCase(exp1.getValueType()) || "Integer".equalsIgnoreCase(exp1.getValueType())) {
                        exp1 = groupExp.getExpressions().get(1);
                        exp2 = groupExp.getExpressions().get(0);
                    }
                    sb.append(RuleJCodeWriter.getExpression(exp1, null));
                    sb.append(groupExp.getOperator() + " ");
                    try {
                        sb.append(UIRuleCodeHelper.convertType(RuleJCodeWriter.getExpression(exp2, null), exp2.getValueType(), exp1.getValueType()));
                    }
                    catch (Exception e) {
                        log.error((Object)"error", (Throwable)e);
                    }
                }
            } else {
                sb.append("(");
                String temp = "";
                int n = groupExp.getExpressions().size();
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        temp = temp + RuleJCodeWriter.getExpression(groupExp.getExpressions().get(i), UIRuleCodeHelper.getSimpleType(groupExp.getExpressions().get(i).getValueType()));
                        continue;
                    }
                    AbstractExpressionInfo expInfo = groupExp.getExpressions().get(i);
                    if (expInfo instanceof SimpleExpressionInfo) {
                        ExpressionType expType = ((SimpleExpressionInfo)expInfo).getType();
                        if (expType == ExpressionType.CONST || expType == ExpressionType.VARIANT) {
                            temp = temp + groupExp.getOperator() + " " + RuleJCodeWriter.getExpression(groupExp.getExpressions().get(i), null);
                            continue;
                        }
                        temp = temp + groupExp.getOperator() + " " + RuleJCodeWriter.getExpression(groupExp.getExpressions().get(i), UIRuleCodeHelper.getSimpleType(groupExp.getExpressions().get(i).getValueType()));
                        continue;
                    }
                    temp = temp + groupExp.getOperator() + " " + RuleJCodeWriter.getExpression(groupExp.getExpressions().get(i), UIRuleCodeHelper.getSimpleType(groupExp.getExpressions().get(i).getValueType()));
                }
                try {
                    temp = UIRuleCodeHelper.convertType(temp, groupExp.getValueType(), desType);
                }
                catch (Exception e) {
                    log.error((Object)"error", (Throwable)e);
                }
                sb.append(temp);
                sb.append(")");
            }
        } else if (expression instanceof SimpleExpressionInfo) {
            SimpleExpressionInfo simpleExp = (SimpleExpressionInfo)expression;
            if (simpleExp.getType() == ExpressionType.METHODINVOKE) {
                MethodInfo method = simpleExp.getMethod();
                if (method != null) {
                    String temp = RuleJCodeWriter.getMethod(method);
                    try {
                        temp = UIRuleCodeHelper.convertType(temp, method.getType(), desType);
                    }
                    catch (Exception e) {
                        log.error((Object)"error", (Throwable)e);
                    }
                    sb.append(temp);
                }
            } else if (simpleExp.getType() == ExpressionType.PROPERTYACCESS) {
                PropertyInfo property = simpleExp.getProperty();
                if (property != null) {
                    String temp = RuleJCodeWriter.getMethod(property, false);
                    try {
                        temp = UIRuleCodeHelper.convertType(temp, property.getType(), desType);
                    }
                    catch (Exception e) {
                        log.error((Object)"error", (Throwable)e);
                    }
                    sb.append(temp);
                }
            } else {
                if (simpleExp.getValueType() == null) {
                    return null;
                }
                String expValue = simpleExp.getValue();
                if (simpleExp.getValueType().equalsIgnoreCase("String") || simpleExp.getValueType().equalsIgnoreCase("java.lang.String")) {
                    expValue = StringUtils.isEmpty((String)simpleExp.getValue()) ? "\"\"" : "\"" + simpleExp.getValue() + "\"";
                }
                if (simpleExp.getType() == ExpressionType.CONST) {
                    if (StringUtils.isEmpty((String)desType)) {
                        sb.append(expValue);
                    } else {
                        try {
                            sb.append(UIRuleCodeHelper.convertType(expValue, simpleExp.getValueType(), desType));
                        }
                        catch (Exception e) {
                            log.error((Object)"error", (Throwable)e);
                        }
                    }
                } else {
                    sb.append(expValue);
                }
            }
        }
        return sb.toString();
    }

    private static String upcastName(String name) {
        if (name.length() == 0) {
            return "";
        }
        name = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        return name;
    }

    public static String getAddDataChangedListenerCode(ComponentInfo control, String controlName, String methodName) {
        if (control == null) {
            return null;
        }
        String classType = control.getClassType();
        StringBuffer sb = new StringBuffer();
        boolean isFind = false;
        if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(classType)) {
            sb.append(controlName + ".addDataChangeListener(new DataChangeListener() {" + '\n');
            sb.append("\t\tpublic void dataChanged(DataChangeEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t});\n");
        } else if ("com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDPasswordField".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDCurrencyTextField".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDMaskTextField".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDFilterTextField".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDTextPane".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDEditorPane".equalsIgnoreCase(classType)) {
            sb.append(controlName + ".getDocument().addDocumentListener(new DocumentListener() {" + '\n');
            sb.append("\t\tpublic void insertUpdate(DocumentEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t\tpublic void removeUpdate(DocumentEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t\tpublic void changedUpdate(DocumentEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t});\n");
        } else if ("com.kingdee.bos.ctrl.swing.KDList".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDMultiLangBox".equalsIgnoreCase(classType)) {
            sb.append(controlName + ".addActionListener(new ActionListener() {" + '\n');
            sb.append("\t\tpublic void actionPerformed(ActionEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t});\n");
        } else if ("com.kingdee.bos.ctrl.swing.KDSlider".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDSpinner".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDRadioButton".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDCheckBox".equalsIgnoreCase(classType)) {
            sb.append(controlName + ".addChangeListener(new ChangeListener() {" + '\n');
            sb.append("\t\tpublic void stateChanged(ChangeEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t});\n");
        } else if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDTimePicker".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.swing.KDPromptBox".equalsIgnoreCase(classType) || "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(classType)) {
            sb.append(controlName + ".addDataChangeListener(new DataChangeListener() {" + '\n');
            sb.append("\t\tpublic void dataChanged(DataChangeEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t});\n");
        } else if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType)) {
            sb.append(controlName + ".addKDTEditListener(new KDTEditAdapter() {" + '\n');
            sb.append("\t\tpublic void editStopped(KDTEditEvent e) {\n");
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t" + methodName + "(e.getRowIndex(),e.getColIndex());" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t});\n");
        }
        return sb.toString();
    }

    public static String getAddActiveCellListenerCode(ComponentInfo control, String columnName) {
        if (control == null) {
            return null;
        }
        String classType = control.getClassType();
        StringBuffer sb = new StringBuffer();
        if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType)) {
            sb.append(control.getName() + ".addKDTActiveCellListener(new com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener() {" + '\n');
            sb.append("     public void activeCellChanged(com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent e) {\n");
            sb.append("     \tif (e.getRowIndex() >=0 && e.getRowIndex() != e.getPrevRowIndex()) {\n");
            sb.append("\t\t\t\ttry {\n");
            sb.append("         \t\t\t" + control.getName() + "_Changed(e.getRowIndex()," + control.getName() + ".getColumn(\"" + columnName + "\").getColumnIndex());" + '\n');
            sb.append("\t\t\t\t}\n");
            sb.append("\t\t\t\tcatch (Exception exc) {\n");
            sb.append("\t\t\t\t\thandUIException(exc);\n");
            sb.append("\t\t\t\t}\n");
            sb.append("     \t}\n");
            sb.append("     }\n");
            sb.append("});\n");
            return sb.toString();
        }
        return null;
    }

    public static String genTreeDetail4DetailEditUICode(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.genTreeDetail4DetailEditUICode(ConvertUtils.getBizUnitInfo(bizUnitPK));
    }

    public static String genTreeDetail4DetailEditUICode(BizUnitInfo bizUnit) {
        if (bizUnit == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String fieldName = bizUnit.getExtendedProperty("beAttachToFieldName");
        String mainEntityPK = bizUnit.getExtendedProperty("beAttachToEntityPK");
        if (StringUtils.isEmpty((String)mainEntityPK) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        EntityObjectInfo mainEntity = null;
        EntityObjectInfo subEntity = null;
        try {
            EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
            mainEntity = entityCtrl.getValue(MetaDataPK.create(mainEntityPK));
            if (!bizUnit.isAllLoaded()) {
                String subEntityPK = bizUnit.getString("entityPK");
                subEntity = entityCtrl.getValue(MetaDataPK.create(subEntityPK));
            } else {
                subEntity = bizUnit.getEntity();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (mainEntity == null || subEntity == null) {
            return null;
        }
        sb.append("\t\tprotected IObjectValue getValue(com.kingdee.bos.dao.IObjectPK pk) throws Exception {\n");
        sb.append("\t        String recordId = null;\n");
        sb.append("\t        if(this.getUIContext().get(com.kingdee.eas.hr.base.client.GroupListEditUI.CUR_OBJ_ID) != null) {\n");
        sb.append("\t            recordId = this.getUIContext().get(com.kingdee.eas.hr.base.client.GroupListEditUI.CUR_OBJ_ID).toString();\n");
        sb.append("\t        }\n");
        sb.append("\t        if (recordId != null) {\n");
        sb.append("\t            com.kingdee.bos.metadata.entity.EntityViewInfo view = new com.kingdee.bos.metadata.entity.EntityViewInfo();\n");
        sb.append("\t            com.kingdee.bos.metadata.entity.FilterInfo filter = new com.kingdee.bos.metadata.entity.FilterInfo();\n");
        sb.append("\t            filter.getFilterItems().add(new com.kingdee.bos.metadata.entity.FilterItemInfo(\"" + fieldName + ".id\",recordId));" + '\n');
        sb.append("\t            view.put(\"selector\", getSelectors());\n");
        sb.append("\t            view.setFilter(filter);\n");
        sb.append("\t            " + subEntity.getBusinessImplName() + "Collection subCol = " + subEntity.getBusinessImplFactory() + ".getRemoteInstance().get" + StringUtils.headCharUpperCase((String)subEntity.getName()) + "Collection(view);" + '\n');
        sb.append("\t            if(subCol.size() <= 0)\t{\n");
        sb.append("\t                this.editData = (" + subEntity.getBusinessImplName() + "Info) this.createNewData();" + '\n');
        sb.append("\t                " + mainEntity.getBusinessImplName() + "Info recordInfo = new " + mainEntity.getBusinessImplName() + "Info();" + '\n');
        sb.append("\t                recordInfo.setId(com.kingdee.bos.util.BOSUuid.read(recordId));\n");
        sb.append("\t                this.editData.set" + StringUtils.headCharUpperCase((String)fieldName) + "(recordInfo);" + '\n');
        sb.append("\t            }\n");
        sb.append("\t            else {\n");
        sb.append("\t                this.editData = subCol.get(0);\n");
        sb.append("\t            }\n");
        sb.append("\t            this.setDataObject(this.editData);\n");
        sb.append("\t        }\n");
        sb.append("\t         return this.editData;\n");
        sb.append("\t\t}\n");
        sb.append("\t\tpublic void loadFields() {\n");
        sb.append("\t        try {\n");
        sb.append("\t            this.getValue(null);\n");
        sb.append("\t        } \n");
        sb.append("\t        catch (Exception e) {\n");
        sb.append("\t            com.kingdee.eas.util.client.ExceptionHandler.handle(e);\n");
        sb.append("\t        } \n");
        sb.append("\t        super.loadFields();\n");
        sb.append("\t\t}\n");
        return sb.toString();
    }

    public static String genSelectorsCode(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.genSelectorsCode(ConvertUtils.getBizUnitInfo(bizUnitPK));
    }

    public static String genBOTPSelectorsCode(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.genBOTPSelectorsCode(ConvertUtils.getBizUnitInfo(bizUnitPK));
    }

    private static String getSubEntitySelectors(String prefix, EntityObjectInfo entity) {
        StringBuffer sb = new StringBuffer();
        PropertyCollection props = entity.getInheritedProperties();
        if (StringUtils.isEmpty((String)prefix)) {
            sb.append("\t\t\tsic.add(new SelectorItemInfo(\"*\"));\n");
        } else {
            sb.append("\t\t\tsic.add(new SelectorItemInfo(\"" + prefix + "." + "*\"));" + '\n');
        }
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo subEntity;
            RelationshipInfo relation;
            if (!(props.get(i) instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)props.get(i)).getRelationship()) == null) continue;
            if (relation.getSupplierCardinality() == CardinalityType.ONE || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_ONE) {
                if (StringUtils.isEmpty((String)prefix)) {
                    sb.append("\t\t\tsic.add(new SelectorItemInfo(\"" + props.get(i).getName() + ".*\"));" + '\n');
                    continue;
                }
                sb.append("\t\t\tsic.add(new SelectorItemInfo(\"" + prefix + "." + props.get(i).getName() + ".*\"));" + '\n');
                continue;
            }
            if (relation.getSupplierCardinality() != CardinalityType.ZERO_TO_UNBOUNDED && relation.getSupplierCardinality() != CardinalityType.ONE_TO_UNBOUNDED || (subEntity = relation.getSupplierObject()) == null || subEntity.equals(entity)) continue;
            String subItems = null;
            subItems = StringUtils.isEmpty((String)prefix) ? RuleJCodeWriter.getSubEntitySelectors(props.get(i).getName(), subEntity) : RuleJCodeWriter.getSubEntitySelectors(prefix + "." + props.get(i).getName(), subEntity);
            sb.append(subItems);
        }
        return sb.toString();
    }

    public static String genSelectorsCode(BizUnitInfo bizUnit) {
        if (bizUnit == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entity == null) {
            return null;
        }
        sb.append("\t\tpublic SelectorItemCollection getSelectors() {\n");
        sb.append("\t\t\tSelectorItemCollection sic = new SelectorItemCollection();\n");
        sb.append(RuleJCodeWriter.getSubEntitySelectors(null, entity));
        sb.append("\t\t\treturn sic;\n");
        sb.append("\t\t}\n");
        return sb.toString();
    }

    public static String genBOTPSelectorsCode(BizUnitInfo bizUnit) {
        if (bizUnit == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entity == null) {
            return null;
        }
        sb.append("public SelectorItemCollection getBOTPSelectors() {\n");
        sb.append("\t\t\tSelectorItemCollection sic = new SelectorItemCollection();\n");
        sb.append("\t\t\treturn sic;\n");
        sb.append("\t}\n");
        return sb.toString();
    }

    public static String genDefaultFilterForQuery(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.genDefaultFilterForQuery(ConvertUtils.getBizUnitInfo(bizUnitPK));
    }

    public static String genDefaultFilterForQuery(BizUnitInfo bizUnit) {
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (entity == null) {
            return null;
        }
        String fieldName = entity.getExtendedProperty("MainOrgFieldName");
        String orgType = entity.getExtendedProperty("OrgType");
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)orgType) || "NONE".equals(orgType)) {
            return null;
        }
        fieldName = StringUtils.trim((String)fieldName) + ".id";
        sb.append("protected FilterInfo getDefaultFilterForQuery() {\n");
        sb.append("\t\t\tFilterInfo filter = super.getDefaultFilterForQuery();\n");
        sb.append("\t\t\tif (filter == null)\n");
        sb.append("\t\t\t\tfilter = new FilterInfo();\n");
        sb.append("\t\t\tFilterInfo otherFilter = com.kingdee.eas.framework.FrameWorkUtils.getF7FilterInfoByAuthorizedOrg(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\"),\"" + fieldName + "\",true);" + '\n');
        sb.append("\t\t\tif (otherFilter != null) {\n");
        sb.append("\t\t\t\tfor(int i=0,n=otherFilter.getFilterItems().size();i<n;i++){\n");
        sb.append("\t\t\t\t\tFilterItemInfo curFilterItem =otherFilter.getFilterItems().get(i);\n");
        sb.append("\t\t\t\t\tif(curFilterItem.getCompareValue()!=null && (curFilterItem.getCompareValue() instanceof String)){\n");
        sb.append("\t\t\t\t\t\tif(\"*\".equalsIgnoreCase((String)(curFilterItem.getCompareValue()))){\n");
        sb.append("\t\t\t\t\t\t\tBOSUuid nullUuid=BOSUuid.create(\"nullnull\");\n");
        sb.append("\t\t\t\t\t\t\tcurFilterItem.setCompareValue(nullUuid.toString());\n");
        sb.append("\t\t\t\t\t\t}\n");
        sb.append("\t\t\t\t\t}\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t\ttry {\t\n");
        sb.append("\t\t\t\t\tif (com.kingdee.eas.framework.util.FilterUtility.hasFilterItem(filter))\n");
        sb.append("\t\t\t\t\t\tfilter.mergeFilter(otherFilter, \"AND\");\n");
        sb.append("\t\t\t\t\telse\n");
        sb.append("\t\t\t\t\t\tfilter = otherFilter;\n");
        sb.append("\t\t\t\t} catch (Exception e) {\n");
        sb.append("\t\t\t\t\tthis.handUIException(e);\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\treturn filter;\n");
        sb.append("\t}\n");
        if (!StringUtils.isEmpty((String)bizUnit.getBimTemplateType()) && (bizUnit.getBimTemplateType().equalsIgnoreCase("TreeDetail") || bizUnit.getBimTemplateType().equalsIgnoreCase("TreeDetail4Detail"))) {
            sb.append("protected FilterInfo getDefaultFilterForTree() {\n");
            sb.append("\t        FilterInfo filter = new FilterInfo();\n");
            sb.append("\t        filter = super.getDefaultFilterForQuery();\n");
            sb.append("\t        return filter;\n");
            sb.append("\t}\n");
        }
        return sb.toString();
    }

    private static EntityObjectInfo getMainEntityByQuery(String queryPK) {
        if (StringUtils.isEmpty((String)queryPK)) {
            return null;
        }
        try {
            SubObjectInfo subObj;
            JoinQueryInfo queryInfo = new JoinQueryCtrl(ContextManager.getContext()).getValue(MetaDataPK.create(queryPK));
            if (queryInfo != null && (subObj = queryInfo.getMainObject()) != null && subObj instanceof SubEntityInfo && ((SubEntityInfo)subObj).getEntityRef() != null) {
                return ((SubEntityInfo)subObj).getEntityRef();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static String genF7FilterForQuery(String f7ControlName, String f7QueryPK) {
        if (StringUtils.isEmpty((String)f7ControlName) || StringUtils.isEmpty((String)f7QueryPK)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = RuleJCodeWriter.getMainEntityByQuery(f7QueryPK);
        if (entity != null) {
            String fieldName = entity.getExtendedProperty("MainOrgFieldName");
            String orgType = entity.getExtendedProperty("OrgType");
            if (StringUtils.isEmpty((String)orgType) || StringUtils.isEmpty((String)fieldName) || "NONE".equals(orgType)) {
                return null;
            }
            fieldName = StringUtils.trim((String)fieldName) + ".id";
            sb.append("\t\tEntityViewInfo evi" + f7ControlName + " = new EntityViewInfo ();" + '\n');
            sb.append("\t\tevi" + f7ControlName + ".setFilter(com.kingdee.eas.framework.FrameWorkUtils.getF7FilterInfoByAuthorizedOrg(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\"),\"" + fieldName + "\"));" + '\n');
            sb.append("\t\t" + f7ControlName + ".setEntityViewInfo(evi" + f7ControlName + ");" + '\n');
        }
        return sb.toString();
    }

    public static String genF7FilterForQuery(ComponentInfo f7Control) {
        if (f7Control == null || !"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(f7Control.getClassType())) {
            return null;
        }
        com.kingdee.bos.metadata.ui.PropertyInfo queryPKProp = f7Control.getPropertyByName("queryInfo");
        if (queryPKProp != null) {
            String f7QueryPK = queryPKProp.getValue();
            return RuleJCodeWriter.genF7FilterForQuery(f7Control.getName(), f7QueryPK);
        }
        return null;
    }

    public static String genSetOrgF7Method() {
        StringBuffer sb = new StringBuffer();
        sb.append("protected void setOrgF7(KDBizPromptBox f7,com.kingdee.eas.basedata.org.OrgType orgType) throws Exception\n");
        sb.append("\t\t{\n");
        sb.append("\t\t\tcom.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer oufip = new com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer(orgType);\n");
        sb.append("\t\t\toufip.getModel().setIsCUFilter(true);\n");
        sb.append("\t\t\tf7.setFilterInfoProducer(oufip);\n");
        sb.append("\t\t}\n");
        return sb.toString();
    }

    public static String genSetOrgF7(String bizUnitPK, ComponentInfo f7Control) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.genSetOrgF7(ConvertUtils.getBizUnitInfo(bizUnitPK), f7Control);
    }

    public static String genSetOrgF7(BizUnitInfo bizUnit, ComponentInfo f7Control) {
        if (bizUnit == null || f7Control == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = ConvertUtils.getEntityObjectInfo(bizUnit);
        if (entity == null) {
            return null;
        }
        String fieldName = entity.getExtendedProperty("MainOrgFieldName");
        String orgType = entity.getExtendedProperty("OrgType");
        if (StringUtils.isEmpty((String)orgType) || StringUtils.isEmpty((String)fieldName) || "NONE".equals(orgType)) {
            return null;
        }
        PropertyBindingCollection pbCol = f7Control.getPropertyBindings();
        PropertyBindingInfo pbInfo = null;
        int n = pbCol.size();
        for (int i = 0; i < n; ++i) {
            pbInfo = pbCol.get(i);
            if (!fieldName.equalsIgnoreCase(pbInfo.getBingdingField())) continue;
            sb.append("\t\tsetOrgF7(" + f7Control.getName() + ",com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\"));" + '\n');
        }
        return sb.toString();
    }

    public static String genSetOrgInfo(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.genSetOrgInfo(ConvertUtils.getBizUnitInfo(bizUnitPK));
    }

    public static String genSetOrgInfo(BizUnitInfo bizUnit) {
        EntityObjectInfo subEntity;
        if (bizUnit == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (entity == null) {
            return null;
        }
        String fieldName = entity.getExtendedProperty("MainOrgFieldName");
        String orgType = entity.getExtendedProperty("OrgType");
        if (StringUtils.isEmpty((String)orgType) || StringUtils.isEmpty((String)fieldName) || "NONE".equals(orgType)) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = entity.getPropertyByName(fieldName, true);
        if (prop != null && prop instanceof LinkPropertyInfo && (subEntity = ((LinkPropertyInfo)prop).getRelationship().getSupplierObject()) != null) {
            if (!"Admin".equalsIgnoreCase(orgType)) {
                sb.append("\t\tif (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")) != null && com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")).getBoolean(\"isBizUnit\"))" + '\n');
            } else {
                sb.append("\t\tif (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")) != null)" + '\n');
            }
            sb.append("\t\t\tobjectValue.put(\"" + fieldName + "\",com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")));" + '\n');
        }
        return sb.toString();
    }

    public static String getOrgType(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.getOrgType(ConvertUtils.getBizUnitInfo(bizUnitPK));
    }

    public static String getOrgType(BizUnitInfo bizUnit) {
        if (bizUnit == null) {
            return null;
        }
        EntityObjectInfo entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entity == null) {
            return null;
        }
        return entity.getExtendedProperty("OrgType");
    }

    public static String genApplyDefaultValue(UIObjectInfo model, ComponentInfo kdTable, String detailPanelName) {
        com.kingdee.bos.metadata.ui.PropertyInfo prop;
        if (model == null || kdTable == null || StringUtils.isEmpty((String)detailPanelName)) {
            return null;
        }
        boolean isFound = false;
        StringBuffer sb = new StringBuffer();
        sb.append("\t\t" + detailPanelName + ".addAddListener(new com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener() {\n");
        sb.append("\t\t\tpublic void beforeEvent(com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent event) throws Exception {\n");
        sb.append("\t\t\t\tIObjectValue vo = event.getObjectValue();\n");
        String classType = kdTable.getClassType();
        if (!StringUtils.isEmpty((String)classType) && "com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType) && (prop = kdTable.getProperties().get("formatXml")) != null) {
            TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(prop.getValue());
            List columns = tableInfo.getColumns();
            int m = columns.size();
            block0: for (int j = 0; j < m; ++j) {
                String defaultValue;
                ColumnInfo column = (ColumnInfo)columns.get(j);
                com.kingdee.bos.metadata.entity.PropertyInfo property = EditUIProxyHelper.getColumnBindProperty(model, kdTable, column.getName());
                if (property == null) continue;
                if (property instanceof LinkPropertyInfo) {
                    LinkPropertyInfo lnkProp = (LinkPropertyInfo)property;
                    RelationshipInfo relation = lnkProp.getRelationship();
                    String defaultValue2 = property.getExtendedProperty("defaultValue");
                    if (StringUtils.isEmpty((String)defaultValue2)) continue;
                    sb.append("vo.put(\"" + lnkProp.getName() + "\",com.kingdee.bos.ui.face.UIRuleUtil.getObjectValue(com.kingdee.bos.util.BOSObjectType.create(\"" + relation.getSupplierObject().getType().toString() + "\"),\"" + defaultValue2 + "\"));");
                    isFound = true;
                    continue;
                }
                if (!(property instanceof OwnPropertyInfo)) continue;
                OwnPropertyInfo ownProp = (OwnPropertyInfo)property;
                if (DataType.ENUM.equals(ownProp.getDataType())) {
                    BizEnumInfo enumInfo;
                    defaultValue = property.getExtendedProperty("defaultValue");
                    if (StringUtils.isEmpty((String)defaultValue) || (enumInfo = ownProp.getEnumType()) == null) continue;
                    int n = enumInfo.getEnumValue().size();
                    for (int i = 0; i < n; ++i) {
                        if (!defaultValue.equalsIgnoreCase(enumInfo.getEnumValue().get(i).getName())) continue;
                        Object value = enumInfo.getEnumValue().get(i).getValue();
                        if (BizEnumValueType.DOUBLE.equals((Object)enumInfo.getDataType())) {
                            sb.append("vo.put(\"" + ownProp.getName() + "\",new Double(" + String.valueOf(value) + "));" + '\n');
                        } else if (BizEnumValueType.FLOAT.equals((Object)enumInfo.getDataType())) {
                            sb.append("vo.put(\"" + ownProp.getName() + "\",new Float(" + String.valueOf(value) + "));" + '\n');
                        } else if (BizEnumValueType.INTEGER.equals((Object)enumInfo.getDataType())) {
                            sb.append("vo.put(\"" + ownProp.getName() + "\",new Integer(" + String.valueOf(value) + "));" + '\n');
                        } else if (BizEnumValueType.LONG.equals((Object)enumInfo.getDataType())) {
                            sb.append("vo.put(\"" + ownProp.getName() + "\",new Long(" + String.valueOf(value) + "));" + '\n');
                        } else if (BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) {
                            sb.append("vo.put(\"" + ownProp.getName() + "\",\"" + String.valueOf(value) + "\");" + '\n');
                        }
                        isFound = true;
                        continue block0;
                    }
                    continue;
                }
                defaultValue = ((OwnPropertyInfo)property).getDefaultValue();
                if (StringUtils.isEmpty((String)defaultValue)) continue;
                if (DataType.STRING.equals(ownProp.getDataType())) {
                    sb.append("\t\tvo.put(\"" + ownProp.getName() + "\",\"" + defaultValue + "\");\n");
                    isFound = true;
                    continue;
                }
                if (DataType.INTEGER.equals(ownProp.getDataType())) {
                    sb.append("\t\tvo.put(\"" + ownProp.getName() + "\",new Integer(" + defaultValue + "));\n");
                    isFound = true;
                    continue;
                }
                if (DataType.DOUBLE.equals(ownProp.getDataType()) || DataType.DECIMAL.equals(ownProp.getDataType())) {
                    sb.append("\t\tvo.put(\"" + ownProp.getName() + "\",new java.math.BigDecimal(" + defaultValue + "));\n");
                    isFound = true;
                    continue;
                }
                if (!DataType.DATE.equals(ownProp.getDataType())) continue;
                sb.append("\t\ttry {vo.put(\"" + ownProp.getName() + "\",java.text.DateFormat.getDateInstance().parse(\"" + defaultValue + "\"));} catch (Exception " + column.getName() + "_exception) {}\n");
                isFound = true;
            }
        }
        sb.append("\t\t\t}\n");
        sb.append("\t\t\tpublic void afterEvent(com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent event) throws Exception {\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t});\n");
        if (isFound) {
            return sb.toString();
        }
        return null;
    }

    public static String genApplyDefaultValue(UIObjectInfo model, ComponentCollection components) {
        StringBuffer sb = new StringBuffer();
        int n = components.size();
        block2: for (int i = 0; i < n; ++i) {
            String evalue;
            String defaultValue;
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            ComponentInfo cInfo = components.get(i);
            PropertyBindingInfo pbInfo = null;
            com.kingdee.bos.metadata.ui.PropertyInfo pInfo = null;
            if ("com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(cInfo.getClassType())) {
                String fieldName;
                pInfo = cInfo.getPropertyByName("text");
                pbInfo = cInfo.getPropertyBindings().get("text");
                if (pInfo == null || pbInfo == null || StringUtils.isEmpty((String)(fieldName = pbInfo.getBingdingField())) || StringUtils.isEmpty((String)pInfo.getValue())) continue;
                sb.append("\t\tvo.setString(\"" + fieldName + "\",\"" + pInfo.getValue() + "\");\n");
                continue;
            }
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(cInfo.getClassType()) || (prop = EditUIProxyHelper.getBindingProperty(model, cInfo)) == null) continue;
            if (prop instanceof LinkPropertyInfo) {
                LinkPropertyInfo lnkProp = (LinkPropertyInfo)prop;
                RelationshipInfo relation = lnkProp.getRelationship();
                String defaultValue2 = prop.getExtendedProperty("defaultValue");
                if (StringUtils.isEmpty((String)defaultValue2)) continue;
                sb.append("vo.put(\"" + lnkProp.getName() + "\",com.kingdee.bos.ui.face.UIRuleUtil.getObjectValue(com.kingdee.bos.util.BOSObjectType.create(\"" + relation.getSupplierObject().getType().toString() + "\"),\"" + defaultValue2 + "\"));");
                continue;
            }
            if (!(prop instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            if (DataType.ENUM.equals(ownProp.getDataType())) {
                BizEnumInfo enumInfo;
                defaultValue = prop.getExtendedProperty("defaultValue");
                if (StringUtils.isEmpty((String)defaultValue) || (enumInfo = ownProp.getEnumType()) == null) continue;
                int m = enumInfo.getEnumValue().size();
                for (int j = 0; j < m; ++j) {
                    if (!defaultValue.equalsIgnoreCase(enumInfo.getEnumValue().get(j).getName())) continue;
                    Object value = enumInfo.getEnumValue().get(j).getValue();
                    if (BizEnumValueType.DOUBLE.equals((Object)enumInfo.getDataType())) {
                        sb.append("vo.put(\"" + prop.getName() + "\",new Double(" + String.valueOf(value) + "));" + '\n');
                        continue block2;
                    }
                    if (BizEnumValueType.FLOAT.equals((Object)enumInfo.getDataType())) {
                        sb.append("vo.put(\"" + prop.getName() + "\",new Float(" + String.valueOf(value) + "));" + '\n');
                        continue block2;
                    }
                    if (BizEnumValueType.INTEGER.equals((Object)enumInfo.getDataType())) {
                        sb.append("vo.put(\"" + prop.getName() + "\",new Integer(" + String.valueOf(value) + "));" + '\n');
                        continue block2;
                    }
                    if (BizEnumValueType.LONG.equals((Object)enumInfo.getDataType())) {
                        sb.append("vo.put(\"" + prop.getName() + "\",new Long(" + String.valueOf(value) + "));" + '\n');
                        continue block2;
                    }
                    if (!BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) continue block2;
                    sb.append("vo.put(\"" + prop.getName() + "\",\"" + String.valueOf(value) + "\");" + '\n');
                    continue block2;
                }
                continue;
            }
            if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equalsIgnoreCase(cInfo.getClassType()) && Boolean.valueOf(evalue = cInfo.getExtendedProperty("isUseCurDateAsDef")).booleanValue()) {
                sb.append("\t\tvo.put(\"" + prop.getName() + "\", new java.util.Date());\n");
            }
            if (StringUtils.isEmpty((String)(defaultValue = ((OwnPropertyInfo)prop).getDefaultValue()))) continue;
            if ("com.kingdee.bos.ctrl.swing.KDMultiLangBox".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equalsIgnoreCase(cInfo.getClassType()) || "com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(cInfo.getClassType())) {
                sb.append("\t\tvo.setString(\"" + prop.getName() + "\",\"" + defaultValue + "\");\n");
                continue;
            }
            if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(cInfo.getClassType())) {
                try {
                    Double.parseDouble(defaultValue);
                    if (DataType.INTEGER.equals(ownProp.getDataType())) {
                        sb.append("\t\tvo.put(\"" + prop.getName() + "\",new Integer(" + defaultValue + "));\n");
                        continue;
                    }
                    sb.append("\t\tvo.put(\"" + prop.getName() + "\",new java.math.BigDecimal(" + defaultValue + "));\n");
                }
                catch (Exception e) {}
                continue;
            }
            if (!"com.kingdee.bos.ctrl.swing.KDDatePicker".equalsIgnoreCase(cInfo.getClassType())) continue;
            sb.append("\t\ttry {vo.put(\"" + prop.getName() + "\",java.text.DateFormat.getDateInstance().parse(\"" + defaultValue + "\"));} catch (Exception " + cInfo.getName() + "_exception) {}\n");
        }
        return sb.toString();
    }

    public static String genF7UsedListUICode(String className) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tprivate boolean isF7Use;\n");
        sb.append("\t\tprivate com.kingdee.eas.framework.client.F7Render f7Delegate;\n");
        sb.append("\t\tpublic Abstract" + className + "(HashMap ctx) throws Exception {" + '\n');
        sb.append("\t\t\tsuper();\n");
        sb.append("\t\t\tisF7Use = true;\n");
        sb.append("\t\t\tf7Delegate = new com.kingdee.eas.framework.client.F7Render(this, ctx);\n");
        sb.append("\t\t\tf7Delegate.init();\n");
        sb.append("\t\t}\n");
        sb.append("\t\tpublic void show() {\n");
        sb.append("\t\t\tif (isF7Use) {\n");
        sb.append("\t\t\t\tf7Delegate.show();\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\telse {\n");
        sb.append("\t\t\t\tsuper.show();\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\tprotected boolean initDefaultFilter() {\n");
        sb.append("\t\t\tif (isF7Use) {\n");
        sb.append("\t\t\t\treturn true;\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\telse {\n");
        sb.append("\t\t\t\treturn super.initDefaultFilter();\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\tprotected boolean isIgnoreCUFilter() {\n");
        sb.append("\t\t\tif (isF7Use) {\n");
        sb.append("\t\t\t\treturn !(f7Delegate.isF7HasCuDefaultFilter());\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\telse {\n");
        sb.append("\t\t\t\treturn super.isIgnoreCUFilter();\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\tprotected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {\n");
        sb.append("\t\t\tif (isF7Use && mainQueryPK.equals(queryPK)) {\n");
        sb.append("\t\t\t\tIQueryExecutor f7QueryExecutor = f7Delegate.getF7QueryExecutor(queryPK, viewInfo);\n");
        sb.append("\t\t\t\tif(f7QueryExecutor != null){\n");
        sb.append("\t\t\t\t\treturn f7QueryExecutor;\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\treturn super.getQueryExecutor(queryPK, viewInfo);\n");
        sb.append("\t\t}\n");
        sb.append("\t\tprotected void beforeExcutQuery(EntityViewInfo queryFilter) {\n");
        sb.append("\t\t\tsuper.beforeExcutQuery(queryFilter);\n");
        sb.append("\t\t\tif (isF7Use) {\n");
        sb.append("\t\t\t\tf7Delegate.mergeF7Filter(queryFilter);\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\tprotected void tblMain_tableClicked(com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent e) throws Exception {\n");
        sb.append("\t\t\tif (e.getClickCount() == 2 && isF7Use) {\n");
        sb.append("\t\t\t\tf7Delegate.actionConfirm();\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\telse {\n");
        sb.append("\t\t\t\tsuper.tblMain_tableClicked(e);\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\tpublic boolean isCanceled() {\n");
        sb.append("\t\t\treturn f7Delegate.isF7Cancel();\n");
        sb.append("\t\t}\n");
        sb.append("\t\tpublic Object getData() {\n");
        sb.append("\t\t\treturn f7Delegate.getF7Data();\n");
        sb.append("\t\t}\n");
        sb.append("\t\tpublic void setF7Use(boolean isF7Use,HashMap ctx) {\n");
        sb.append("\t\t\tthis.isF7Use = isF7Use;\n");
        sb.append("\t\t\tif(isF7Use){\n");
        sb.append("\t\t\t\ttry{\n");
        sb.append("\t\t\t\t\tthis.setPreferredSize(new Dimension(800,600));\n");
        sb.append("\t\t\t\t\tif (ctx == null) {\n");
        sb.append("\t\t\t\t\t\tctx = new HashMap();\n");
        sb.append("\t\t\t\t\t}\n");
        sb.append("\t\t\t\t\tf7Delegate = new com.kingdee.eas.framework.client.F7Render(this, ctx);\n");
        sb.append("\t\t\t\t\tf7Delegate.init();\n");
        sb.append("\t\t\t\t\tthis.initLayout();\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t\tcatch(Exception e) {\n");
        sb.append("\t\t\t\t\thandUIException(e);\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        return sb.toString();
    }

    public static String genF7SetSelectorCode(UIObjectInfo model, ComponentInfo f7Control) {
        if (f7Control == null || !"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(f7Control.getClassType())) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = RuleJCodeWriter.getBindingProperty(model, f7Control);
        if (prop != null && !StringUtils.isEmpty((String)prop.getExtendedProperty("f7ListUIClassName"))) {
            return RuleJCodeWriter.genF7SetSelectorCode(f7Control.getName(), prop);
        }
        com.kingdee.bos.metadata.ui.PropertyInfo queryPKProp = f7Control.getPropertyByName("queryInfo");
        if (queryPKProp != null) {
            String f7QueryPK = queryPKProp.getValue();
            return RuleJCodeWriter.genF7SetSelectorCode(f7Control.getName(), f7QueryPK);
        }
        return null;
    }

    private static boolean useSCMF7Adapter(String listUIClassName) {
        return "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI".equals(listUIClassName) || "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI".equals(listUIClassName) || "com.kingdee.eas.basedata.master.cssp.client.F7SupplierTreeDetailListUI".equals(listUIClassName);
    }

    public static String genF7SetSelectorCode(String f7ControlName, com.kingdee.bos.metadata.entity.PropertyInfo property) {
        if (StringUtils.isEmpty((String)f7ControlName) || property == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isEmpty((String)property.getExtendedProperty("f7ListUIClassName"))) {
            String listUIClassName = property.getExtendedProperty("f7ListUIClassName");
            sb.append("\t\t" + listUIClassName + " " + f7ControlName + "_F7ListUI = new " + listUIClassName + "();" + '\n');
            if (RuleJCodeWriter.useSCMF7Adapter(listUIClassName)) {
                sb.append("\t\t" + f7ControlName + ".setSelector(new com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor(" + f7ControlName + "," + f7ControlName + "_F7ListUI,this));" + '\n');
            } else {
                sb.append("\t\t" + f7ControlName + ".setSelector(new com.kingdee.eas.framework.client.f7.GeneralKDPromptSelectorAdaptor(" + f7ControlName + "," + f7ControlName + "_F7ListUI,this));" + '\n');
            }
            return sb.toString();
        }
        return null;
    }

    public static String genF7SetSelectorCode(String f7ControlName, String f7QueryPK) {
        if (StringUtils.isEmpty((String)f7ControlName) || StringUtils.isEmpty((String)f7QueryPK)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            JoinQueryInfo queryInfo = new JoinQueryCtrl(ContextManager.getContext()).getValue(MetaDataPK.create(f7QueryPK));
            if (queryInfo != null && !StringUtils.isEmpty((String)queryInfo.getBizUnitPK())) {
                String listUIClassName = ConvertUtils.getF7UsedListUIClassName(queryInfo.getBizUnitPK());
                if (!StringUtils.isEmpty((String)listUIClassName)) {
                    sb.append("\t\t" + listUIClassName + " " + f7ControlName + "_F7ListUI = new " + listUIClassName + "();" + '\n');
                    if (RuleJCodeWriter.useSCMF7Adapter(listUIClassName)) {
                        sb.append("\t\t" + f7ControlName + ".setSelector(new com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor(" + f7ControlName + "," + f7ControlName + "_F7ListUI,this));" + '\n');
                    } else {
                        sb.append("\t\t" + f7ControlName + ".setSelector(new com.kingdee.eas.framework.client.f7.GeneralKDPromptSelectorAdaptor(" + f7ControlName + "," + f7ControlName + "_F7ListUI,this));" + '\n');
                    }
                } else {
                    listUIClassName = ConvertUtils.getBimTreeListUIClassName(queryInfo.getBizUnitPK());
                    if (!StringUtils.isEmpty((String)listUIClassName)) {
                        sb.append("\t\t" + f7ControlName + ".addSelectorListener(new SelectorListener() {" + '\n');
                        sb.append("\t\t\t" + listUIClassName + " " + f7ControlName + "_F7ListUI = null;" + '\n');
                        sb.append("\t\t\tpublic void willShow(SelectorEvent e) {\n");
                        sb.append("\t\t\t\tif (" + f7ControlName + "_F7ListUI == null) {" + '\n');
                        sb.append("\t\t\t\t\ttry {\n");
                        sb.append("\t\t\t\t\t\t" + f7ControlName + "_F7ListUI = new " + listUIClassName + "();" + '\n');
                        sb.append("\t\t\t\t\t} catch (Exception e1) {\n");
                        sb.append("\t\t\t\t\t\te1.printStackTrace();\n");
                        sb.append("\t\t\t\t\t}\n");
                        sb.append("\t\t\t\t\tHashMap ctx = new HashMap();\n");
                        sb.append("\t\t\t\t\tctx.put(\"bizUIOwner\",javax.swing.SwingUtilities.getWindowAncestor(" + f7ControlName + "_F7ListUI));" + '\n');
                        sb.append("\t\t\t\t\t" + f7ControlName + "_F7ListUI.setF7Use(true,ctx);" + '\n');
                        sb.append("\t\t\t\t\t" + f7ControlName + ".setSelector(" + f7ControlName + "_F7ListUI);" + '\n');
                        sb.append("\t\t\t\t}\n");
                        sb.append("\t\t\t}\n");
                        sb.append("\t\t});\n");
                    }
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    public static String genSetAutoNumberInServer(IObjectValue entity) {
        if (entity != null && entity instanceof EntityObjectInfo && !StringUtils.isEmpty((String)((EntityObjectInfo)entity).getBizUnitPK())) {
            if (ConvertUtils.getExtendedPropertyBooelanValue(entity, "isUseCodeRule")) {
                String orgType = entity.getExtendedProperty("OrgType");
                if (StringUtils.isEmpty((String)orgType)) {
                    return RuleJCodeWriter.genSetAutoNumberInServer("NONE");
                }
                return RuleJCodeWriter.genSetAutoNumberInServer(orgType);
            }
            return null;
        }
        return null;
    }

    public static String genSetAutoNumberInServer(String orgType) {
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tprotected IObjectPK _addnew(Context ctx , IObjectValue model) throws BOSException , EASBizException {\n");
        sb.append("\t\t\tif (model instanceof com.kingdee.eas.framework.ObjectBaseInfo) {\n");
        sb.append("\t\t\t\tsetAutoNumberByOrg(ctx,(com.kingdee.eas.framework.ObjectBaseInfo)model,\"" + orgType + "\");" + '\n');
        sb.append("\t\t\t}\n");
        sb.append("\t\t\treturn super._addnew(ctx,model);\n");
        sb.append("\t\t}\n");
        sb.append("\t\tprotected void setAutoNumberByOrg(Context ctx,com.kingdee.eas.framework.ObjectBaseInfo model,String orgType) {\n");
        sb.append("\t\t\t\tString sysNumber = null;\n");
        sb.append("\t\t\t\ttry {\n");
        sb.append("\t\t\t\t\tif (!com.kingdee.util.StringUtils.isEmpty(orgType) && !\"NONE\".equalsIgnoreCase(orgType) && com.kingdee.eas.util.app.ContextUtil.getCurrentOrgUnit(ctx,com.kingdee.eas.basedata.org.OrgType.getEnum(orgType))!=null) {\n");
        sb.append("\t\t\t\t\t\tsysNumber = com.kingdee.eas.framework.FrameWorkUtils.getCodeRuleServer(ctx,model,com.kingdee.eas.util.app.ContextUtil.getCurrentOrgUnit(ctx,com.kingdee.eas.basedata.org.OrgType.getEnum(orgType)).getString(\"id\"));\n");
        sb.append("\t\t\t\t\t}\n");
        sb.append("\t\t\t\t\telse if (com.kingdee.eas.util.app.ContextUtil.getCurrentOrgUnit(ctx) != null) {\n");
        sb.append("\t\t\t\t\t\tsysNumber = com.kingdee.eas.framework.FrameWorkUtils.getCodeRuleServer(ctx,model,com.kingdee.eas.util.app.ContextUtil.getCurrentOrgUnit(ctx).getString(\"id\"));\n");
        sb.append("\t\t\t\t\t}\n");
        sb.append("\t\t\t\t\tif (!com.kingdee.util.StringUtils.isEmpty(sysNumber)) {\n");
        sb.append("\t\t\t\t\t\tmodel.setString(\"number\",sysNumber);\n");
        sb.append("\t\t\t\t\t}\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t\tcatch (Exception e) {\n");
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t}\n");
        return sb.toString();
    }

    private static String getBindFieldName(PropertyBindingCollection propBindings, String propertyName) {
        int n = propBindings.size();
        for (int i = 0; i < n; ++i) {
            if (!propertyName.equalsIgnoreCase(propBindings.get(i).getPropertyName())) continue;
            return propBindings.get(i).getBingdingField();
        }
        return null;
    }

    public static com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        int n = propertys.length;
        for (int i = 0; i < n; ++i) {
            prop = subEntity.getPropertyByName(propertys[i], true);
            if (i == n - 1) {
                return prop;
            }
            if (prop == null) {
                return null;
            }
            if (prop instanceof OwnPropertyInfo) {
                return null;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            return null;
        }
        return null;
    }

    private static com.kingdee.bos.metadata.entity.PropertyInfo getBindingProperty(UIObjectInfo model, ComponentInfo f7Control) {
        EntityObjectInfo entity;
        if (f7Control == null || !"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(f7Control.getClassType())) {
            return null;
        }
        String propertyName = RuleJCodeWriter.getBindFieldName(f7Control.getPropertyBindings(), "data");
        if (!StringUtils.isEmpty((String)propertyName) && model.getDataObjects() != null && model.getDataObjects().size() > 0 && model.getDataObjects().get(0).getObjectType().equals(MetaDataTypeList.ENTITY.toString()) && (entity = (EntityObjectInfo)model.getDataObjects().get(0).getInstance()) != null) {
            return RuleJCodeWriter.getPropertyByName(entity, propertyName);
        }
        return null;
    }

    public static String genF7FilterItemsCode(String f7ControlName, com.kingdee.bos.metadata.entity.PropertyInfo prop) {
        if (StringUtils.isEmpty((String)f7ControlName)) {
            return null;
        }
        if (prop != null) {
            String f7FilterString = prop.getExtendedProperty("f7FilterItems");
            return RuleJCodeWriter.genF7FilterItemsCode(f7ControlName, f7FilterString);
        }
        return null;
    }

    public static String genF7FilterItemsCode(ComponentInfo f7Control, UIObjectInfo model) {
        if (f7Control == null || !"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(f7Control.getClassType())) {
            return null;
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = RuleJCodeWriter.getBindingProperty(model, f7Control);
        return RuleJCodeWriter.genF7FilterItemsCode(f7Control.getName(), prop);
    }

    public static String genF7FilterItemsCode(String f7ControlName, String f7FilterString) {
        if (StringUtils.isEmpty((String)f7FilterString)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        FilterInfo fInfo = BizUnitHelper.convertStringToF7Filter(f7FilterString);
        if (fInfo != null || fInfo.getFilterItems() != null && fInfo.getFilterItems().size() > 0) {
            sb.append("\t\t" + f7ControlName + ".addSelectorListener(new SelectorListener() {" + '\n');
            sb.append("\t\tprivate FilterInfo oldFilter = null;\n");
            sb.append("\t\tpublic void willShow(SelectorEvent e) {\n");
            sb.append("\t\tif (" + f7ControlName + ".getEntityViewInfo() == null)" + '\n');
            sb.append("\t\t\t" + f7ControlName + ".setEntityViewInfo(new EntityViewInfo());" + '\n');
            sb.append("\t\tif (oldFilter == null)\n");
            sb.append("\t\t\toldFilter = " + f7ControlName + ".getEntityViewInfo().getFilter();" + '\n');
            sb.append("\t\tFilterInfo " + f7ControlName + "_FilterInfo = new FilterInfo();" + '\n');
            int n = fInfo.getFilterItems().size();
            for (int i = 0; i < n; ++i) {
                FilterItemInfo fItem = fInfo.getFilterItems().get(i);
                String propertyName = "\"" + fItem.getPropertyName() + "\"";
                String compareType = "com.kingdee.bos.metadata.query.util.CompareType.getEnum(\"" + fItem.getCompareType().toString() + "\")";
                String compareValue = "dataBinder.getUIVoProperty(\"" + (String)fItem.getCompareValue() + "\")";
                sb.append("\t\t" + f7ControlName + "_FilterInfo.getFilterItems().add(new FilterItemInfo(" + propertyName + "," + compareValue + "," + compareType + "));" + '\n');
            }
            if (!StringUtils.isEmpty((String)fInfo.getMaskString())) {
                sb.append("\t\t" + f7ControlName + "_FilterInfo.setMaskString(\"" + fInfo.getMaskString() + "\");" + '\n');
            }
            sb.append("\t\tif (com.kingdee.eas.framework.util.FilterUtility.hasFilterItem(oldFilter)) {\n");
            sb.append("\t\t\ttry{\n");
            sb.append("\t\t\t\t" + f7ControlName + "_FilterInfo.mergeFilter(oldFilter,\"AND\");" + '\n');
            sb.append("\t\t\t}catch(Exception e1){\n");
            sb.append("\t\t\t\tlogger.error(e1);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t\tif (" + f7ControlName + ".getSelector() != null && " + f7ControlName + ".getSelector() instanceof com.kingdee.eas.framework.client.ListUI) {" + '\n');
            sb.append("\t\t\t((com.kingdee.eas.framework.client.ListUI)" + f7ControlName + ".getSelector()).setFilterForQuery(" + f7ControlName + "_FilterInfo);" + '\n');
            sb.append("\t\t\ttry {\n");
            sb.append("\t\t\t\t((com.kingdee.eas.framework.client.ListUI)" + f7ControlName + ".getSelector()).onLoad();" + '\n');
            sb.append("\t\t\t}\n");
            sb.append("\t\t\tcatch(Exception e1){\n");
            sb.append("\t\t\t\tlogger.error(e1);\n");
            sb.append("\t\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t\telse {\n");
            sb.append("\t\t\t" + f7ControlName + ".getEntityViewInfo().setFilter(" + f7ControlName + "_FilterInfo);" + '\n');
            sb.append("\t\t\t" + f7ControlName + ".getQueryAgent().resetRuntimeEntityView();" + '\n');
            sb.append("\t\t\t" + f7ControlName + ".setRefresh(true);" + '\n');
            sb.append("\t\t}\n");
            sb.append("\t\t}\n");
            sb.append("\t\t});\n");
        }
        return sb.toString();
    }

    public static String getConsignOrgUnitCode(String bizUnitPK, ComponentInfo f7Control, UIObjectInfo model) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        return RuleJCodeWriter.getConsignOrgUnitCode(ConvertUtils.getBizUnitInfo(bizUnitPK), f7Control, model);
    }

    private static String getConsignOrgUnitCode(BizUnitInfo bizUnit, ComponentInfo f7Control, UIObjectInfo model) {
        String consignType;
        com.kingdee.bos.metadata.entity.PropertyInfo prop;
        if (bizUnit == null || f7Control == null || !"com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(f7Control.getClassType())) {
            return null;
        }
        AbstractMDValue entity = null;
        try {
            if (!bizUnit.isAllLoaded()) {
                EntityObjectCtrl entityCtrl = new EntityObjectCtrl(ContextManager.getContext());
                String entityPK = bizUnit.getString("entityPK");
                entity = entityCtrl.getValue(MetaDataPK.create(entityPK));
            } else {
                entity = bizUnit.getEntity();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String orgType = entity.getExtendedProperty("OrgType");
        String fieldName = entity.getExtendedProperty("MainOrgFieldName");
        if (!StringUtils.isEmpty((String)orgType) && !StringUtils.isEmpty((String)fieldName) && (prop = RuleJCodeWriter.getBindingProperty(model, f7Control)) != null && prop instanceof LinkPropertyInfo && !StringUtils.isEmpty((String)(consignType = prop.getExtendedProperty("consignType")))) {
            int toType;
            int fromOrToType = 0;
            if ("consigner".equalsIgnoreCase(consignType)) {
                fromOrToType = 1;
            }
            if ((toType = RuleJCodeWriter.getOrgTypeValue(((LinkPropertyInfo)prop).getRelationship().getSupplierObject())) != -1) {
                return RuleJCodeWriter.getConsignOrgUnitCode(f7Control.getName(), fieldName, orgType, fromOrToType, toType);
            }
        }
        return null;
    }

    private static int getOrgTypeValue(EntityObjectInfo entity) {
        if (entity == null) {
            return -1;
        }
        String pk = entity.getFullName();
        if ("com.kingdee.eas.basedata.org.app.adminOrgUnit".equalsIgnoreCase(pk)) {
            return 0;
        }
        if ("com.kingdee.eas.basedata.org.app.CompanyOrgUnit".equalsIgnoreCase(pk)) {
            return 1;
        }
        if ("com.kingdee.eas.basedata.org.app.SaleOrgUnit".equalsIgnoreCase(pk)) {
            return 2;
        }
        if ("com.kingdee.eas.basedata.org.app.PurchaseOrgUnit".equalsIgnoreCase(pk)) {
            return 3;
        }
        if ("com.kingdee.eas.basedata.org.app.StorageOrgUnit".equalsIgnoreCase(pk)) {
            return 4;
        }
        if ("com.kingdee.eas.basedata.org.app.HROrgUnit".equalsIgnoreCase(pk)) {
            return 16;
        }
        if ("com.kingdee.eas.basedata.org.app.CtrlUnit".equalsIgnoreCase(pk)) {
            return 10;
        }
        return -1;
    }

    private static String getConsignOrgUnitCode(String f7ControlName, String fieldName, String fromOrgType, int fromOrToType, int toType) {
        if (StringUtils.isEmpty((String)f7ControlName) || StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\t\t" + f7ControlName + ".addSelectorListener(new SelectorListener() {" + '\n');
        sb.append("\t\tprivate FilterInfo oldFilter = null;\n");
        sb.append("\t\tpublic void willShow(SelectorEvent e) {\n");
        sb.append("\t\tif (" + f7ControlName + ".getEntityViewInfo() == null)" + '\n');
        sb.append("\t\t\t" + f7ControlName + ".setEntityViewInfo(new EntityViewInfo());" + '\n');
        sb.append("\t\tif (oldFilter == null)\n");
        sb.append("\t\t\toldFilter = " + f7ControlName + ".getEntityViewInfo().getFilter();" + '\n');
        sb.append("\t\tFilterInfo " + f7ControlName + "_FilterInfo = new FilterInfo();" + '\n');
        sb.append("\t\tcom.kingdee.eas.basedata.org.OrgUnitInfo " + f7ControlName + "_OrgUnit = (com.kingdee.eas.basedata.org.OrgUnitInfo)dataBinder.getUIVoProperty(\"" + fieldName + "\");" + '\n');
        sb.append("\t\ttry{\n");
        sb.append("\t\t\tif (" + f7ControlName + "_OrgUnit != null) {" + '\n');
        if (fromOrToType == 0) {
            sb.append("\t\t\tcom.kingdee.eas.basedata.org.OrgUnitCollection orgUnitCol = com.kingdee.eas.basedata.org.OrgUnitRelationFactory.getRemoteInstance().getToUnit(" + f7ControlName + "_OrgUnit.getId().toString(),com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + fromOrgType + "\").getValue()," + toType + ");" + '\n');
        } else {
            sb.append("\t\t\tcom.kingdee.eas.basedata.org.OrgUnitCollection orgUnitCol = com.kingdee.eas.basedata.org.OrgUnitRelationFactory.getRemoteInstance().getFromUnit(" + f7ControlName + "_OrgUnit.getId().toString(),com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + fromOrgType + "\").getValue()," + toType + ");" + '\n');
        }
        sb.append("\t\t\t\tif (orgUnitCol != null && orgUnitCol.size() > 0) {\n");
        sb.append("\t\t\t\t\tStringBuffer maskString = new StringBuffer();\n");
        sb.append("\t\t\t\t\tfor (int i=0,n=orgUnitCol.size();i<n;i++) {\n");
        sb.append("\t\t\t\t\t\t" + f7ControlName + "_FilterInfo.getFilterItems().add(new FilterItemInfo(\"id\",orgUnitCol.get(i).getId().toString(),com.kingdee.bos.metadata.query.util.CompareType.EQUALS));" + '\n');
        sb.append("\t\t\t\t\t\tif (i == 0)\n");
        sb.append("\t\t\t\t\t\t\tmaskString.append(\"#0\");\n");
        sb.append("\t\t\t\t\t\telse\n");
        sb.append("\t\t\t\t\t\t\tmaskString.append(\" or #\" + i) ;\n");
        sb.append("\t\t\t\t\t}\n");
        sb.append("\t\t\t\t\t" + f7ControlName + "_FilterInfo.setMaskString(maskString.toString());" + '\n');
        sb.append("\t\t\t\t}\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t\tif (com.kingdee.eas.framework.util.FilterUtility.hasFilterItem(oldFilter)) {\n");
        sb.append("\t\t\t\t" + f7ControlName + "_FilterInfo.mergeFilter(oldFilter,\"AND\");" + '\n');
        sb.append("\t\t\t}\n");
        sb.append("\t\t}catch(Exception e1){\n");
        sb.append("\t\t\tlogger.error(e1);\n");
        sb.append("\t\t}\n");
        sb.append("\t\tif (" + f7ControlName + ".getSelector() != null && " + f7ControlName + ".getSelector() instanceof com.kingdee.eas.framework.client.ListUI) {" + '\n');
        sb.append("\t\t\t((com.kingdee.eas.framework.client.ListUI)" + f7ControlName + ".getSelector()).setFilterForQuery(" + f7ControlName + "_FilterInfo);" + '\n');
        sb.append("\t\t\ttry {\n");
        sb.append("\t\t\t\t((com.kingdee.eas.framework.client.ListUI)" + f7ControlName + ".getSelector()).onLoad();" + '\n');
        sb.append("\t\t\t}\n");
        sb.append("\t\t\tcatch(Exception e1){\n");
        sb.append("\t\t\t\tlogger.error(e1);\n");
        sb.append("\t\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\telse {\n");
        sb.append("\t\t\t" + f7ControlName + ".getEntityViewInfo().setFilter(" + f7ControlName + "_FilterInfo);" + '\n');
        sb.append("\t\t\t" + f7ControlName + ".getQueryAgent().resetRuntimeEntityView();" + '\n');
        sb.append("\t\t\t" + f7ControlName + ".setRefresh(true);" + '\n');
        sb.append("\t\t}\n");
        sb.append("\t\t}\n");
        sb.append("\t\t});\n");
        return sb.toString();
    }

    public static String getMainBizOrgTypeCode(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return RuleJCodeWriter.getMainBizOrgTypeCode((String)obj);
        }
        if (obj instanceof EntityObjectInfo) {
            return RuleJCodeWriter.getMainBizOrgTypeCode((EntityObjectInfo)obj);
        }
        return null;
    }

    public static String getMainBizOrgCode(UIObjectInfo model, String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        if (bizUnit == null || ConvertUtils.getExtendedPropertyBooelanValue(bizUnit, "isCopyFromSCMBill")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        EntityObjectInfo entity = ConvertUtils.getEntityObjectInfo(bizUnit);
        if (entity == null) {
            return null;
        }
        String fieldName = entity.getExtendedProperty("MainOrgFieldName");
        String orgType = entity.getExtendedProperty("OrgType");
        if (StringUtils.isEmpty((String)orgType) || StringUtils.isEmpty((String)fieldName) || "NONE".equals(orgType)) {
            return null;
        }
        ComponentInfo f7Control = UIProxyHelper.findComponentByBindingField(model, fieldName);
        if (f7Control != null) {
            sb.append("protected KDBizPromptBox getMainBizOrg() {\n");
            sb.append("\t\treturn " + f7Control.getName() + ";" + '\n');
            sb.append("}\n");
        }
        return sb.toString();
    }

    public static String getMainBizOrgTypeCode(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(bizUnitPK);
        if (ConvertUtils.getExtendedPropertyBooelanValue(bizUnit, "isCopyFromSCMBill")) {
            return null;
        }
        String orgType = RuleJCodeWriter.getOrgType(bizUnit);
        if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType)) {
            StringBuffer sb = new StringBuffer();
            sb.append("\t\tprotected com.kingdee.eas.basedata.org.OrgType getMainBizOrgType() {\n");
            sb.append("\t\t\treturn com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\");" + '\n');
            sb.append("\t\t}\n");
            return sb.toString();
        }
        return null;
    }

    public static String getMainBizOrgTypeCode(EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        String orgType = entity.getExtendedProperty("OrgType");
        String fieldName = entity.getExtendedProperty("MainOrgFieldName");
        String bizUnitPK = entity.getBizUnitPK();
        if (!(StringUtils.isEmpty((String)orgType) || "NONE".equalsIgnoreCase(orgType) || StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)bizUnitPK))) {
            StringBuffer sb = new StringBuffer();
            sb.append("\t\tprotected com.kingdee.eas.basedata.org.OrgUnitInfo getMainBizOrgUnit(Context ctx,com.kingdee.eas.framework.CoreBillBaseInfo model) {\n");
            sb.append("\t\t\tObject obj = model.get(\"" + fieldName + "\");" + '\n');
            sb.append("\t\t\tif (obj != null && obj instanceof com.kingdee.eas.basedata.org.OrgUnitInfo)\n");
            sb.append("\t\t\t\treturn (com.kingdee.eas.basedata.org.OrgUnitInfo)obj;\n");
            sb.append("\t\t\telse\n");
            sb.append("\t\t\t\treturn null;\n");
            sb.append("\t\t}\n");
            return sb.toString();
        }
        return null;
    }

    public static String getMainOrgInfo(UIObjectInfo uiObject) {
        EntityObjectInfo entity;
        if (uiObject == null || StringUtils.isEmpty((String)uiObject.getBizUnitPK())) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(uiObject.getBizUnitPK());
        if (bizUnit != null && ConvertUtils.getExtendedPropertyBooelanValue(bizUnit, "isCopyFromSCMBill") && (entity = ConvertUtils.getEntityObjectInfo(bizUnit)) != null) {
            String orgType = entity.getExtendedProperty("OrgType");
            String fieldName = entity.getExtendedProperty("MainOrgFieldName");
            if (!(StringUtils.isEmpty((String)orgType) || "NONE".equalsIgnoreCase(orgType) || StringUtils.isEmpty((String)fieldName))) {
                StringBuffer sb = new StringBuffer();
                sb.append("\t\tpublic com.kingdee.eas.basedata.org.OrgUnitInfo getMainOrgInfo() {\n");
                if (!"Admin".equalsIgnoreCase(orgType)) {
                    sb.append("\t\tif (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")) != null && com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")).getBoolean(\"isBizUnit\"))" + '\n');
                } else {
                    sb.append("\t\tif (com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\")) != null)" + '\n');
                }
                sb.append("\t\t\t\treturn com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentOrgUnit(com.kingdee.eas.basedata.org.OrgType.getEnum(\"" + orgType + "\"));" + '\n');
                sb.append("\t\t\telse\n");
                sb.append("\t\t\t\treturn null;\n");
                sb.append("\t\t}\n");
                return sb.toString();
            }
        }
        return null;
    }

    public static String genBeforeStoreFieldsCode(UIObjectInfo editUI, ComponentCollection components) {
        if (components == null || components.size() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFound = false;
        sb.append("\t\tprotected void beforeStoreFields(ActionEvent arg0) throws Exception {\n");
        int n = components.size();
        for (int i = 0; i < n; ++i) {
            boolean isRequired;
            String requiredPrompt;
            com.kingdee.bos.metadata.ui.PropertyInfo prop;
            ComponentInfo component = components.get(i);
            String classType = component.getClassType();
            if (StringUtils.isEmpty((String)classType)) continue;
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType)) {
                prop = component.getProperties().get("formatXml");
                if (prop == null) continue;
                TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(prop.getValue());
                List columns = tableInfo.getColumns();
                int m = columns.size();
                for (int j = 0; j < m; ++j) {
                    ColumnInfo column = (ColumnInfo)columns.get(j);
                    com.kingdee.bos.metadata.entity.PropertyInfo property = EditUIProxyHelper.getColumnBindProperty(editUI, component, column.getName());
                    if (property == null || !column.isRequired() || StringUtils.isEmpty((String)(requiredPrompt = property.getExtendedProperty("requiredPrompt")))) continue;
                    sb.append("\t\tfor (int i=0,n=" + component.getName() + ".getRowCount();i<n;i++) {" + '\n');
                    sb.append("\t\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getCell(i,\"" + column.getName() + "\").getValue())) {" + '\n');
                    sb.append("\t\t\t\tthrow new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {\"" + requiredPrompt + "\"});" + '\n');
                    sb.append("\t\t\t}\n");
                    sb.append("\t\t}\n");
                    isFound = true;
                }
                continue;
            }
            requiredPrompt = component.getExtendedProperty("requiredPrompt");
            if (StringUtils.isEmpty((String)requiredPrompt) || (prop = component.getPropertyByName("required")) == null || !(isRequired = new Boolean(prop.getValue()).booleanValue())) continue;
            if ("com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getData())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.swing.KDFormattedTextField".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getValue())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.swing.KDTextArea".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getText())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.swing.KDTextField".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getText())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.swing.KDDatePicker".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getValue())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.swing.KDTimePicker".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getValue())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + ".getSelectedItem())) {" + '\n');
            } else if ("com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox".equalsIgnoreCase(classType)) {
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + RuleJCodeWriter.getMultiBoxItemData() + ")) {" + '\n');
            } else {
                if (!"com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea".equalsIgnoreCase(classType)) continue;
                sb.append("\t\tif (com.kingdee.bos.ui.face.UIRuleUtil.isNull(" + component.getName() + RuleJCodeWriter.getMultiBoxItemData() + ")) {" + '\n');
            }
            sb.append("\t\t\tthrow new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {\"" + requiredPrompt + "\"});" + '\n');
            sb.append("\t\t}\n");
            isFound = true;
        }
        sb.append("\t\t\tsuper.beforeStoreFields(arg0);\n");
        sb.append("\t\t}\n");
        if (isFound) {
            return sb.toString();
        }
        return null;
    }

    private static String getMultiBoxItemData() {
        return ".getItemDataByLang(new LanguageInfo(com.kingdee.eas.common.client.SysContext.getSysContext().getLocale()))";
    }

    public static String getSetBizStatusFieldValueCode(BusinessObjectInfo bo, com.kingdee.bos.metadata.bo.MethodInfo method) {
        if (bo == null || method == null) {
            return null;
        }
        if (bo instanceof EntityObjectInfo) {
            BizEnumInfo enumInfo;
            com.kingdee.bos.metadata.entity.PropertyInfo prop;
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String statusFieldName = entity.getExtendedProperty("BizStatusFieldName");
            String statusFieldValue = method.getExtendedProperty("BizStatusFieldValue");
            if (!StringUtils.isEmpty((String)statusFieldName) && !StringUtils.isEmpty((String)statusFieldValue) && (prop = entity.getPropertyByName(statusFieldName, true)) != null && prop instanceof OwnPropertyInfo && (enumInfo = ((OwnPropertyInfo)prop).getEnumType()) != null) {
                int n = enumInfo.getEnumValue().size();
                for (int i = 0; i < n; ++i) {
                    if (!statusFieldValue.equalsIgnoreCase(enumInfo.getEnumValue().get(i).getName())) continue;
                    StringBuffer sb = new StringBuffer();
                    Object value = enumInfo.getEnumValue().get(i).getValue();
                    if (BizEnumValueType.DOUBLE.equals((Object)enumInfo.getDataType())) {
                        sb.append("model.put(\"" + statusFieldName + "\",new Double(" + String.valueOf(value) + "));" + '\n');
                    } else if (BizEnumValueType.FLOAT.equals((Object)enumInfo.getDataType())) {
                        sb.append("model.put(\"" + statusFieldName + "\",new Float(" + String.valueOf(value) + "));" + '\n');
                    } else if (BizEnumValueType.INTEGER.equals((Object)enumInfo.getDataType())) {
                        sb.append("model.put(\"" + statusFieldName + "\",new Integer(" + String.valueOf(value) + "));" + '\n');
                    } else if (BizEnumValueType.LONG.equals((Object)enumInfo.getDataType())) {
                        sb.append("model.put(\"" + statusFieldName + "\",new Long(" + String.valueOf(value) + "));" + '\n');
                    } else if (BizEnumValueType.STRING.equals((Object)enumInfo.getDataType())) {
                        sb.append("model.put(\"" + statusFieldName + "\",\"" + String.valueOf(value) + "\");" + '\n');
                    }
                    sb.append("\t\ttry {\n");
                    sb.append("\t\t\tsuper._update(ctx,new com.kingdee.bos.dao.ormapping.ObjectUuidPK(model.getString(\"id\")),model);\n");
                    sb.append("\t\t}\n");
                    sb.append("\t\tcatch (Exception e) {\n");
                    sb.append("\t\t}\n");
                    return sb.toString();
                }
            }
        }
        return null;
    }

    public static String getSetBizStatusFieldValueCode(UIObjectInfo uiObject, ActionInfo action) {
        BizEnumInfo enumInfo;
        com.kingdee.bos.metadata.entity.PropertyInfo prop;
        ComponentInfo component;
        String statusFieldName;
        EntityObjectInfo entity;
        String uiType;
        if (uiObject == null || action == null || StringUtils.isEmpty((String)uiObject.getBizUnitPK())) {
            return null;
        }
        ActionExtendPropertyHelper actionHelper = new ActionExtendPropertyHelper(action.getActionExtendProperty());
        String statusFieldValue = actionHelper.getValue("BizStatusFieldValue");
        if (!StringUtils.isEmpty((String)statusFieldValue) && "EditUI".equalsIgnoreCase(uiType = ConvertUtils.getBimUIType(uiObject.getBizUnitPK(), uiObject.getFullName())) && uiObject.getDataObjects() != null && uiObject.getDataObjects().size() > 0 && (entity = (EntityObjectInfo)uiObject.getDataObjects().get(0).getInstance()) != null && !StringUtils.isEmpty((String)(statusFieldName = entity.getExtendedProperty("BizStatusFieldName"))) && (component = UIProxyHelper.findComponentByBindingField(uiObject, statusFieldName)) != null && "com.kingdee.bos.ctrl.swing.KDComboBox".equalsIgnoreCase(component.getClassType()) && (prop = entity.getPropertyByName(statusFieldName, true)) != null && prop instanceof OwnPropertyInfo && (enumInfo = ((OwnPropertyInfo)prop).getEnumType()) != null) {
            int n = enumInfo.getEnumValue().size();
            for (int i = 0; i < n; ++i) {
                if (!statusFieldValue.equalsIgnoreCase(enumInfo.getEnumValue().get(i).getName())) continue;
                StringBuffer sb = new StringBuffer();
                String enumItemName = enumInfo.getFullName() + "." + enumInfo.getEnumValue().get(i).getName();
                sb.append("this." + component.getName() + ".setSelectedItem(" + enumItemName + ");" + '\n');
                return sb.toString();
            }
        }
        return null;
    }

    public static String getTableSumFieldCode(UIObjectInfo uiObject, ComponentCollection components) {
        JoinQueryInfo query;
        if (uiObject == null || components == null || StringUtils.isEmpty((String)uiObject.getBizUnitPK())) {
            return null;
        }
        boolean isFound = false;
        String uiType = ConvertUtils.getBimUIType(uiObject.getBizUnitPK(), uiObject.getFullName());
        StringBuffer sb = new StringBuffer();
        if ("EditUI".equalsIgnoreCase(uiType)) {
            sb.append("\t\tprotected void setTableToSumField() {\n");
            int n = components.size();
            for (int i = 0; i < n; ++i) {
                com.kingdee.bos.metadata.ui.PropertyInfo prop;
                ComponentInfo component = components.get(i);
                String classType = component.getClassType();
                if (StringUtils.isEmpty((String)classType) || !"com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(classType) || (prop = component.getProperties().get("formatXml")) == null) continue;
                TableInfo tableInfo = KDTableDesignerHelper.getTableInfoFrom(prop.getValue());
                List columns = tableInfo.getColumns();
                boolean isFoundInCurrentKDTable = false;
                int m = columns.size();
                for (int j = 0; j < m; ++j) {
                    ColumnInfo column = (ColumnInfo)columns.get(j);
                    com.kingdee.bos.metadata.entity.PropertyInfo property = EditUIProxyHelper.getColumnBindProperty(uiObject, component, column.getName());
                    if (!ConvertUtils.getExtendedPropertyBooelanValue(property, "needSum")) continue;
                    if (!isFoundInCurrentKDTable) {
                        sb.append("\t\t\tsetTableToSumField(" + component.getName() + ",new String[] {");
                        sb.append("\"" + column.getName() + "\"");
                    } else {
                        sb.append(",\"" + column.getName() + "\"");
                    }
                    isFoundInCurrentKDTable = true;
                    isFound = true;
                }
                if (!isFoundInCurrentKDTable) continue;
                sb.append("});\n");
            }
            sb.append("\t\t}\n");
        } else if ("ListUI".equalsIgnoreCase(uiType) && uiObject.getDataObjects() != null && uiObject.getDataObjects().size() > 0 && uiObject.getDataObjects().get(0).getObjectType().equals(MetaDataTypeList.JOINQUERY.toString()) && (query = (JoinQueryInfo)uiObject.getDataObjects().get(0).getInstanceOfQueryForBim()) != null) {
            PropertyUnitCollection propCol = query.getUnits();
            int n = propCol.size();
            for (int i = 0; i < n; ++i) {
                PropertyUnitInfo propUnit = propCol.get(i);
                if (!ConvertUtils.getExtendedPropertyBooelanValue(propUnit, "isSumField")) continue;
                sb.append("\t\tprotected boolean isFootVisible() {\n");
                sb.append("\t\t\treturn true;\n");
                sb.append("\t\t}\n");
                isFound = true;
                break;
            }
        }
        if (isFound) {
            return sb.toString();
        }
        return null;
    }

    public static String getSCMBillCode(UIObjectInfo uiObject) {
        if (uiObject == null || StringUtils.isEmpty((String)uiObject.getBizUnitPK())) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(uiObject.getBizUnitPK());
        if (ConvertUtils.getExtendedPropertyBooelanValue(bizUnit, "isCopyFromSCMBill")) {
            StringBuffer sb = new StringBuffer();
            EntityObjectInfo entity = ConvertUtils.getEntityObjectInfo(bizUnit);
            if (entity != null) {
                String fieldName = entity.getExtendedProperty("MainOrgFieldName");
                String orgType = entity.getExtendedProperty("OrgType");
                if (!(StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)orgType) || "NONE".equals(orgType))) {
                    sb.append("protected com.kingdee.eas.basedata.org.OrgType getMainBizOrgType() {\n");
                    sb.append("\t\treturn com.kingdee.eas.basedata.org.OrgType." + orgType + ";" + '\n');
                    sb.append("}\n");
                    return sb.toString();
                }
            }
        }
        return null;
    }

    public static String getSCMBillCode(UIObjectInfo uiObject, ComponentInfo kdTable, EntityObjectInfo entryEntity, ComponentInfo txtNumberControl) {
        if (uiObject == null || StringUtils.isEmpty((String)uiObject.getBizUnitPK()) || kdTable == null || entryEntity == null || txtNumberControl == null) {
            return null;
        }
        BizUnitInfo bizUnit = ConvertUtils.getBizUnitInfo(uiObject.getBizUnitPK());
        if (ConvertUtils.getExtendedPropertyBooelanValue(bizUnit, "isCopyFromSCMBill")) {
            StringBuffer sb = new StringBuffer();
            EntityObjectInfo entity = ConvertUtils.getEntityObjectInfo(bizUnit);
            if (entity != null) {
                String fieldName = entity.getExtendedProperty("MainOrgFieldName");
                String orgType = entity.getExtendedProperty("OrgType");
                if (!(StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)orgType) || "NONE".equals(orgType))) {
                    ComponentInfo f7Control = UIProxyHelper.findComponentByBindingField(uiObject, fieldName);
                    sb.append("public KDBizPromptBox getMainOrgUnit() {\n");
                    sb.append("\t\treturn " + f7Control.getName() + ";" + '\n');
                    sb.append("}\n");
                    sb.append("public KDTextField getNumTextField() {\n");
                    sb.append("\t\treturn " + txtNumberControl.getName() + ";" + '\n');
                    sb.append("}\n");
                    sb.append("protected KDTable getDetailTable() {\n");
                    sb.append("\t\treturn " + kdTable.getName() + ";" + '\n');
                    sb.append("}  \n");
                    sb.append("protected IObjectValue createNewDetailData(KDTable table) {\n");
                    sb.append("\t\treturn new " + entryEntity.getBusinessImplName() + "Info();" + '\n');
                    sb.append("}\n");
                    sb.append("protected KDBizPromptBox getMainBizOrg() {\n");
                    sb.append("\t\treturn " + f7Control.getName() + ";" + '\n');
                    sb.append("}\n");
                    sb.append("protected com.kingdee.eas.basedata.org.OrgType getMainBizOrgType() {\n");
                    sb.append("\t\treturn com.kingdee.eas.basedata.org.OrgType." + orgType + ";" + '\n');
                    sb.append("}\n");
                    return sb.toString();
                }
            }
        }
        return null;
    }

    public static String parseExpression2Java(AbstractExpressionInfo expression, String desType) {
        return RuleJCodeWriter.removeBracket(RuleJCodeWriter.getExpression(expression, desType));
    }

    public static String getEditUIModalCode(UIObjectInfo listUI) {
        BizUnitInfo bizUnit;
        if (listUI == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)listUI.getBizUnitPK()) && (bizUnit = ConvertUtils.getBizUnitInfo(listUI.getBizUnitPK())) != null && !StringUtils.isEmpty((String)bizUnit.getTableEditUIPK()) && bizUnit.isUseTableEditUI()) {
            StringBuffer sb = new StringBuffer();
            sb.append("protected String getEditUIModal() {\n");
            sb.append("\t\treturn com.kingdee.eas.common.client.UIFactoryName.NEWWIN;\n");
            sb.append("}\n");
            return sb.toString();
        }
        return null;
    }

    public static Rectangle getComponentOriginalBounds(ComponentInfo component) {
        Rectangle rect = new Rectangle(0, 0, 1, 1);
        if (component != null) {
            Object constraint = component.getConstraint();
            if (constraint != null && (constraint instanceof Rectangle || constraint instanceof KDLayoutConstraint)) {
                if (constraint instanceof Rectangle) {
                    rect.x = ((Rectangle)constraint).x;
                    rect.y = ((Rectangle)constraint).y;
                    rect.width = ((Rectangle)constraint).width;
                    rect.height = ((Rectangle)constraint).height;
                } else if (constraint instanceof KDLayoutConstraint) {
                    rect.x = ((KDLayoutConstraint)constraint).x;
                    rect.y = ((KDLayoutConstraint)constraint).y;
                    rect.width = ((KDLayoutConstraint)constraint).width;
                    rect.height = ((KDLayoutConstraint)constraint).height;
                }
            } else if (component.getParent() != null) {
                Rectangle parentBounds = RuleJCodeWriter.getComponentOriginalBounds(component.getParent());
                if ("com.kingdee.bos.ctrl.swing.KDTabbedPane".equals(component.getParent().getClassType())) {
                    rect.width = parentBounds.width - 1;
                    rect.height = parentBounds.height - 33;
                    if (rect.width < 1) {
                        rect.width = 1;
                    }
                    if (rect.height < 1) {
                        rect.height = 1;
                    }
                } else if ("com.kingdee.bos.ctrl.swing.KDSplitPane".equals(component.getParent().getClassType())) {
                    int dividerLocation = -1;
                    com.kingdee.bos.metadata.ui.PropertyInfo prop = component.getParent().getPropertyByName("dividerLocation");
                    if (prop != null && !StringUtils.isEmpty((String)prop.getValue())) {
                        dividerLocation = Integer.parseInt(prop.getValue());
                    }
                    if ("left".equals(constraint)) {
                        rect.width = dividerLocation == -1 ? (parentBounds.width - 10) / 2 - 1 : dividerLocation - 1;
                        rect.height = parentBounds.height - 1;
                    } else if ("right".equals(constraint)) {
                        rect.width = dividerLocation == -1 ? (parentBounds.width - 10) / 2 - 1 : parentBounds.width - dividerLocation - 10 - 1;
                        rect.height = parentBounds.height - 1;
                    } else if ("top".equals(constraint)) {
                        rect.height = dividerLocation == -1 ? (parentBounds.height - 10) / 2 - 1 : dividerLocation - 1;
                        rect.width = parentBounds.width - 1;
                    } else if ("bottom".equals(constraint)) {
                        rect.height = dividerLocation == -1 ? (parentBounds.height - 10) / 2 - 1 : parentBounds.height - dividerLocation - 10 - 1;
                        rect.width = parentBounds.width - 1;
                    }
                    if (rect.width < 1) {
                        rect.width = 1;
                    }
                    if (rect.height < 1) {
                        rect.height = 1;
                    }
                } else {
                    rect.x = parentBounds.x;
                    rect.y = parentBounds.y;
                    rect.width = parentBounds.width;
                    rect.height = parentBounds.height;
                }
            }
        }
        return rect;
    }
}

