/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizrule.util;

import com.kingdee.util.StringUtils;

public class UIRuleCodeHelper {
    public static final String STRING = "String";
    public static final String JAVA_LANG_STRING = "java.lang.String";
    public static final String SIMPLEINT = "int";
    public static final String INTEGER = "Integer";
    public static final String JAVA_LANG_INTEGER = "java.lang.Integer";
    public static final String SIMPLEDOUBLE = "double";
    public static final String DOUBLE = "Double";
    public static final String JAVA_LANG_DOUBLE = "java.lang.Double";
    public static final String SIMPLEBIGDECIMAL = "double";
    public static final String BIGDECIMAL = "BigDecimal";
    public static final String JAVA_LANG_BIGDECIMAL = "java.lang.BigDecimal";
    public static final String OBJECT = "Object";
    public static final String JAVA_LANG_OBJECT = "java.lang.Object";
    public static final String DATE = "Date";
    public static final String JAVA_UTIL_DATE = "java.util.Date";
    public static final String SIMPLEBOOLEAN = "boolean";
    public static final String BOOLEAN = "Boolean";
    public static final String JAVA_LANG_BOOLEAN = "java.lang.Boolean";

    public static String getObjectType(String srcType) {
        if (StringUtils.isEmpty((String)srcType)) {
            return null;
        }
        if (SIMPLEINT.equalsIgnoreCase(srcType)) {
            return JAVA_LANG_INTEGER;
        }
        if (INTEGER.equalsIgnoreCase(srcType) || JAVA_LANG_INTEGER.equalsIgnoreCase(srcType)) {
            return JAVA_LANG_INTEGER;
        }
        if ("double".equalsIgnoreCase(srcType)) {
            return JAVA_LANG_BIGDECIMAL;
        }
        if (BIGDECIMAL.equalsIgnoreCase(srcType) || JAVA_LANG_BIGDECIMAL.equalsIgnoreCase(srcType)) {
            return JAVA_LANG_BIGDECIMAL;
        }
        if ("double".equalsIgnoreCase(srcType)) {
            return JAVA_LANG_DOUBLE;
        }
        if (DOUBLE.equalsIgnoreCase(srcType) || JAVA_LANG_DOUBLE.equalsIgnoreCase(srcType)) {
            return JAVA_LANG_DOUBLE;
        }
        if (STRING.equalsIgnoreCase(srcType) || JAVA_LANG_STRING.equalsIgnoreCase(srcType)) {
            return JAVA_LANG_STRING;
        }
        if (OBJECT.equalsIgnoreCase(srcType) || JAVA_LANG_OBJECT.equalsIgnoreCase(srcType)) {
            return JAVA_LANG_OBJECT;
        }
        return srcType;
    }

    public static String getSimpleType(String srcType) {
        if (BIGDECIMAL.equalsIgnoreCase(srcType) || JAVA_LANG_BIGDECIMAL.equalsIgnoreCase(srcType)) {
            return "double";
        }
        if (DOUBLE.equalsIgnoreCase(srcType) || JAVA_LANG_DOUBLE.equalsIgnoreCase(srcType)) {
            return "double";
        }
        if (INTEGER.equalsIgnoreCase(srcType) || JAVA_LANG_INTEGER.equalsIgnoreCase(srcType)) {
            return SIMPLEINT;
        }
        return srcType;
    }

    public static boolean equalsType(String srcType, String desType) throws Exception {
        if (StringUtils.isEmpty((String)srcType) && StringUtils.isEmpty((String)desType)) {
            return true;
        }
        if (StringUtils.isEmpty((String)srcType) || StringUtils.isEmpty((String)desType)) {
            return false;
        }
        if (srcType.equalsIgnoreCase(desType)) {
            return true;
        }
        if (SIMPLEINT.equalsIgnoreCase(desType)) {
            return SIMPLEINT.equalsIgnoreCase(srcType);
        }
        if (INTEGER.equalsIgnoreCase(desType) || JAVA_LANG_INTEGER.equalsIgnoreCase(desType)) {
            return INTEGER.equalsIgnoreCase(srcType) || JAVA_LANG_INTEGER.equalsIgnoreCase(srcType);
        }
        if ("double".equalsIgnoreCase(desType)) {
            return "double".equalsIgnoreCase(srcType);
        }
        if (BIGDECIMAL.equalsIgnoreCase(desType) || JAVA_LANG_BIGDECIMAL.equalsIgnoreCase(desType)) {
            return BIGDECIMAL.equalsIgnoreCase(srcType) || JAVA_LANG_BIGDECIMAL.equalsIgnoreCase(srcType);
        }
        if ("double".equalsIgnoreCase(desType)) {
            return "double".equalsIgnoreCase(srcType);
        }
        if (DOUBLE.equalsIgnoreCase(desType) || JAVA_LANG_DOUBLE.equalsIgnoreCase(desType)) {
            return DOUBLE.equalsIgnoreCase(srcType) || JAVA_LANG_DOUBLE.equalsIgnoreCase(srcType);
        }
        if (STRING.equalsIgnoreCase(desType) || JAVA_LANG_STRING.equalsIgnoreCase(desType)) {
            return STRING.equalsIgnoreCase(srcType) || JAVA_LANG_STRING.equalsIgnoreCase(srcType);
        }
        if (OBJECT.equalsIgnoreCase(desType) || JAVA_LANG_OBJECT.equalsIgnoreCase(desType)) {
            return OBJECT.equalsIgnoreCase(srcType) || JAVA_LANG_OBJECT.equalsIgnoreCase(srcType);
        }
        if (DATE.equalsIgnoreCase(desType) || JAVA_UTIL_DATE.equalsIgnoreCase(desType)) {
            return DATE.equalsIgnoreCase(srcType) || JAVA_UTIL_DATE.equalsIgnoreCase(srcType);
        }
        if (SIMPLEBOOLEAN.equalsIgnoreCase(desType)) {
            return SIMPLEBOOLEAN.equalsIgnoreCase(srcType);
        }
        if (BOOLEAN.equalsIgnoreCase(desType) || JAVA_LANG_BOOLEAN.equalsIgnoreCase(desType)) {
            return BOOLEAN.equalsIgnoreCase(srcType) || JAVA_LANG_BOOLEAN.equalsIgnoreCase(srcType);
        }
        return false;
    }

    public static String convertType(String value, String srcType, String desType) throws Exception {
        String getMethodName = "get";
        if (desType == null || UIRuleCodeHelper.equalsType(srcType, desType)) {
            return value;
        }
        if (SIMPLEINT.equalsIgnoreCase(desType)) {
            getMethodName = "getIntValue";
        } else if (INTEGER.equalsIgnoreCase(desType) || JAVA_LANG_INTEGER.equalsIgnoreCase(desType)) {
            getMethodName = "getInt";
        } else if ("double".equalsIgnoreCase(desType)) {
            getMethodName = "getBigDecimalValue";
        } else if (BIGDECIMAL.equalsIgnoreCase(desType) || JAVA_LANG_BIGDECIMAL.equalsIgnoreCase(desType)) {
            getMethodName = "getBigDecimal";
        } else if ("double".equalsIgnoreCase(desType)) {
            getMethodName = "getDoubleValue";
        } else if (DOUBLE.equalsIgnoreCase(desType) || JAVA_LANG_DOUBLE.equalsIgnoreCase(desType)) {
            getMethodName = "getDouble";
        } else if (STRING.equalsIgnoreCase(desType) || JAVA_LANG_STRING.equalsIgnoreCase(desType)) {
            getMethodName = "getString";
        } else if (OBJECT.equalsIgnoreCase(desType) || JAVA_LANG_OBJECT.equalsIgnoreCase(desType)) {
            getMethodName = "getObject";
        } else if (DATE.equalsIgnoreCase(desType) || JAVA_UTIL_DATE.equalsIgnoreCase(desType)) {
            getMethodName = "getDateValue";
        } else if (SIMPLEBOOLEAN.equalsIgnoreCase(desType)) {
            getMethodName = "getBooleanValue";
        } else if (BOOLEAN.equalsIgnoreCase(desType) || JAVA_LANG_BOOLEAN.equalsIgnoreCase(desType)) {
            getMethodName = "getBoolean";
        } else {
            return value;
        }
        return "com.kingdee.bos.ui.face.UIRuleUtil." + getMethodName + "(" + value + ")";
    }
}

