/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit;

import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.management.IPackageCtrl;
import com.kingdee.bos.metadata.management.PackageInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.util.StringUtils;

public class BIMNameFactory {
    private static String BIM_UNIT_DEFINEPREFIX = "UDF";
    private static String BIM_FIELD_DEFINEPREFIX = "BIMUDF";

    public static String createTableName(String bizUnitPackage, String bizUnitName) {
        assert (bizUnitName != null);
        String packageCode = BIMNameFactory.getPackageCodeByPackage(bizUnitPackage);
        String sPreFix = (MetaDataOptions.isDevelopVersion() ? "T_" : "CT_") + packageCode + "_";
        String tName = sPreFix + StringUtils.headCharUpperCase((String)bizUnitName);
        if (tName.length() > 30) {
            tName = sPreFix + StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)bizUnitName), (int)(30 - sPreFix.length()));
        }
        return tName;
    }

    public static String createTreeTableName(String bizUnitPackage, String bizUnitName) {
        assert (bizUnitName != null);
        String packageCode = BIMNameFactory.getPackageCodeByPackage(bizUnitPackage);
        String sPreFix = "T_" + packageCode + "_";
        String tName = sPreFix + StringUtils.headCharUpperCase((String)bizUnitName);
        if (tName.length() > 22) {
            tName = sPreFix + StringUtils.abbreviate((String)bizUnitName.toUpperCase(), (int)(22 - sPreFix.length()));
        }
        return tName + "TREE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPackageCodeByPackage(String bizUnitPackage) {
        IPackageCtrl packageCtrl = null;
        String packageName = bizUnitPackage == null ? "" : bizUnitPackage;
        String packageCode = "";
        String oldPageCode = "";
        try {
            packageCtrl = (IPackageCtrl)((Object)BOSObjectFactory.createBOSObject(ContextManager.getContext(), MetaDataTypeList.PACKAGE));
            String lastToken = packageName;
            int lastDotPosition = packageName.lastIndexOf(46);
            if (lastDotPosition != -1) {
                lastToken = packageName.substring(lastDotPosition + 1);
            }
            if (("app".equalsIgnoreCase(lastToken) || "client".equalsIgnoreCase(lastToken)) && (lastDotPosition = (packageName = packageName.substring(0, lastDotPosition)).lastIndexOf(46)) != -1) {
                lastToken = packageName.substring(lastDotPosition + 1);
            }
            oldPageCode = lastToken;
            PackageInfo packageInfo = packageCtrl.getValue(MetaDataPK.create(packageName, lastToken));
            packageCode = packageInfo.getBasicCode();
            while (StringUtils.isEmpty((String)packageCode) && lastDotPosition != -1 && lastDotPosition != packageName.indexOf(46)) {
                if ((lastDotPosition = (packageName = packageName.substring(0, lastDotPosition)).lastIndexOf(46)) != -1) {
                    lastToken = packageName.substring(lastDotPosition + 1);
                }
                if (("app".equalsIgnoreCase(lastToken) || "client".equalsIgnoreCase(lastToken)) && (lastDotPosition = (packageName = packageName.substring(0, lastDotPosition)).lastIndexOf(46)) != -1) {
                    lastToken = packageName.substring(lastDotPosition + 1);
                }
                packageInfo = packageCtrl.getValue(MetaDataPK.create(packageName, lastToken));
                packageCode = packageInfo.getBasicCode();
            }
            if (StringUtils.isEmpty((String)packageCode)) {
                packageCode = oldPageCode;
            }
            packageCode = packageCode.replace('.', '-');
        }
        catch (Exception ex) {
        }
        finally {
            if (StringUtils.isEmpty((String)packageCode)) {
                packageCode = oldPageCode;
            }
        }
        if (packageCode.length() > 3) {
            packageCode = packageCode.substring(0, 3);
        }
        packageCode = packageCode.toUpperCase();
        return packageCode;
    }

    public static String createTablePKName(String bizUnitPackage, String ltableName, String fieldName) {
        String sPkName = "";
        assert (bizUnitPackage != null && ltableName != null);
        String packageCode = BIMNameFactory.getPackageCodeByPackage(bizUnitPackage);
        int lTableLen = 8;
        int lFixLen = 18 - (packageCode.length() + 3) - lTableLen - fieldName.length();
        if (lFixLen < 0) {
            lFixLen = 0;
        }
        lTableLen += lFixLen;
        if (ltableName.length() > 1) {
            int lpos = (ltableName = BIMNameFactory.getNameNoDec(ltableName)).indexOf("_", MetaDataOptions.isDevelopVersion() ? 2 : 3);
            if (lpos >= 0) {
                if ((ltableName = ltableName.substring(lpos + 1)).indexOf(BIM_UNIT_DEFINEPREFIX) >= 0) {
                    ltableName = ltableName.substring(BIM_UNIT_DEFINEPREFIX.length());
                }
                if (ltableName.length() > lTableLen) {
                    ltableName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)ltableName), (int)lTableLen);
                }
            } else if (ltableName.length() > lTableLen) {
                if (ltableName.indexOf(BIM_UNIT_DEFINEPREFIX) >= 0) {
                    ltableName = ltableName.substring(BIM_UNIT_DEFINEPREFIX.length());
                }
                ltableName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)ltableName), (int)lTableLen);
            }
        }
        sPkName = (MetaDataOptions.isDevelopVersion() ? "PK_" : "CPK_") + packageCode + "_" + StringUtils.headCharUpperCase((String)ltableName);
        if (fieldName.length() > 2 && (fieldName = fieldName.substring(1, fieldName.length())).length() > 18 - sPkName.length()) {
            fieldName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)fieldName), (int)(18 - sPkName.length()));
        }
        sPkName = sPkName + StringUtils.headCharUpperCase((String)fieldName);
        assert (sPkName.length() <= 18);
        return sPkName;
    }

    public static String createTablePKName(String bizUnitPackage, String ltableName, String fieldName, boolean generateRandom) {
        String s;
        s = s.substring(0, (s = BIMNameFactory.createTablePKName(bizUnitPackage, ltableName, fieldName)).length() > 15 ? 15 : s.length());
        if (generateRandom) {
            s = s + BIMNameFactory.generateRandomNumber();
        }
        s = s.substring(0, s.length() > 18 ? 18 : s.length());
        return s;
    }

    public static String getNameNoDec(String sName) {
        String strStr = "";
        String strDec = "";
        int strCount = 0;
        int decCount = 0;
        char[] chars = sName.toCharArray();
        char[] charStr = new char[chars.length];
        char[] charDec = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            char temp = chars[i];
            if (temp >= '0' && temp <= '9') {
                charDec[decCount] = temp;
                ++decCount;
                continue;
            }
            charStr[strCount] = temp;
            ++strCount;
        }
        strStr = String.valueOf(charStr);
        strStr = strStr.trim();
        strDec = String.valueOf(charDec);
        if ((strDec = strDec.trim()).length() > String.valueOf(Long.MAX_VALUE).length()) {
            strDec = strDec.substring(0, String.valueOf(Long.MAX_VALUE).length());
        }
        if (!StringUtils.isEmpty((String)strDec)) {
            strDec = Long.toString(new Long(strDec), 32);
        }
        return strStr + strDec;
    }

    public static String generateRandomNumber() {
        String s = Long.toString(System.currentTimeMillis(), 32);
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length / 2 + 1; ++i) {
            char temp = chars[chars.length - 1 - i];
            chars[chars.length - 1 - i] = chars[i];
            chars[i] = temp;
        }
        s = String.valueOf(chars);
        return s;
    }

    public static String createTableFKName(String bizUnitPackage, String ltableName, String ftableName, String fieldName) {
        String sFKName = "";
        assert (bizUnitPackage != null && ltableName != null);
        String packageCode = BIMNameFactory.getPackageCodeByPackage(bizUnitPackage);
        int lTableLen = 8;
        int lFixLen = lTableLen + 1 - fieldName.length();
        if (lFixLen < 0) {
            lFixLen = 0;
        }
        lTableLen += lFixLen;
        if (ltableName.length() > 1) {
            int lpos = ltableName.indexOf("_", 2);
            if (lpos >= 0) {
                if ((ltableName = ltableName.substring(lpos + 1)).indexOf(BIM_UNIT_DEFINEPREFIX) >= 0) {
                    ltableName = ltableName.substring(BIM_UNIT_DEFINEPREFIX.length());
                }
                if (ltableName.length() > lTableLen) {
                    ltableName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)ltableName), (int)lTableLen);
                }
            } else if (ltableName.length() > lTableLen + lFixLen) {
                if (ltableName.indexOf(BIM_UNIT_DEFINEPREFIX) >= 0) {
                    ltableName = ltableName.substring(BIM_UNIT_DEFINEPREFIX.length());
                }
                ltableName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)ltableName), (int)lTableLen);
            }
        }
        sFKName = (MetaDataOptions.isDevelopVersion() ? "FK_" : "CFK_") + packageCode + "_" + StringUtils.headCharUpperCase((String)ltableName);
        if (fieldName.length() > 2 && (fieldName = fieldName.substring(1, fieldName.length())).length() > 18 - sFKName.length()) {
            fieldName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)fieldName), (int)(18 - sFKName.length()));
        }
        sFKName = sFKName + StringUtils.headCharUpperCase((String)fieldName);
        assert (sFKName.length() <= 18);
        return sFKName;
    }

    public static String createTableFKName(String bizUnitPackage, String ltableName, String ftableName, String fieldName, boolean generateRandom) {
        String s;
        s = s.substring(0, (s = BIMNameFactory.createTableFKName(bizUnitPackage, ltableName, ftableName, fieldName)).length() > 16 ? 16 : s.length());
        if (generateRandom) {
            s = s + BIMNameFactory.generateRandomNumber();
        }
        s = s.substring(0, s.length() > 18 ? 18 : s.length());
        return s;
    }

    public static boolean setBizFieldMaxIndex(BizUnitInfo bizUnitInfo) {
        String maxFieldIndex = "";
        int maxFieldNumber = 0;
        assert (bizUnitInfo != null);
        maxFieldIndex = bizUnitInfo.getExtendedProperty("maxFieldIndex");
        if (maxFieldIndex != null) {
            maxFieldNumber = Integer.parseInt(maxFieldIndex);
        }
        bizUnitInfo.setExtendedProperty("maxFieldIndex", String.valueOf(++maxFieldNumber));
        return true;
    }

    public static String CreateRuleInfoName(BizUnitInfo bizUnitInfo) {
        String ruleName = "";
        String maxRuleIndex = null;
        int maxRuleNumber = 0;
        assert (bizUnitInfo != null);
        maxRuleIndex = bizUnitInfo.getExtendedProperty("maxRuleIndex");
        if (!StringUtils.isEmpty((String)maxRuleIndex)) {
            try {
                maxRuleNumber = Integer.parseInt(maxRuleIndex);
            }
            catch (NumberFormatException e) {
                maxRuleNumber = 0;
            }
        }
        ruleName = StringUtils.fixNumber((int)(++maxRuleNumber), (int)4);
        return ruleName;
    }

    public static String CreateBizFieldName(BizUnitInfo bizUnitInfo) {
        String fieldName = "";
        String maxFieldIndex = null;
        int maxFieldNumber = 0;
        assert (bizUnitInfo != null);
        maxFieldIndex = bizUnitInfo.getExtendedProperty("maxFieldIndex");
        if (maxFieldIndex != null) {
            maxFieldNumber = Integer.parseInt(maxFieldIndex);
        }
        fieldName = BIM_FIELD_DEFINEPREFIX + StringUtils.fixNumber((int)(++maxFieldNumber), (int)4);
        BizFieldCollection bizfields = bizUnitInfo.getFields();
        boolean bexists = BIMNameFactory.bHasSampleName(bizfields, fieldName);
        int imaxcount = 0;
        while (bexists) {
            fieldName = BIM_FIELD_DEFINEPREFIX + StringUtils.fixNumber((int)(++maxFieldNumber), (int)4);
            bexists = BIMNameFactory.bHasSampleName(bizfields, fieldName);
            if (++imaxcount <= 1024) continue;
            break;
        }
        return fieldName;
    }

    private static boolean bHasSampleName(BizFieldCollection bizfields, String sFieldName) {
        BizFieldInfo bizfieldTemp = null;
        BizFieldCollection bizfields2 = null;
        boolean bexists = false;
        if (null != bizfields) {
            int n = bizfields.size();
            for (int i = 0; i < n; ++i) {
                bizfieldTemp = bizfields.get(i);
                if (bizfieldTemp == null) continue;
                if (sFieldName.equalsIgnoreCase(bizfieldTemp.getName())) {
                    bexists = true;
                    break;
                }
                if (!(bizfieldTemp instanceof BizGroupFieldInfo) || (bizfields2 = ((BizGroupFieldInfo)bizfieldTemp).getFields()) == null) continue;
                bexists = BIMNameFactory.bHasSampleName(bizfields2, sFieldName);
            }
        }
        return bexists;
    }

    public static String createEntryTableName(String bizUnitPackage, String bizUnitName, String entryName) {
        assert (bizUnitName != null && entryName != null);
        String packageCode = BIMNameFactory.getPackageCodeByPackage(bizUnitPackage);
        String sPreFix = (MetaDataOptions.isDevelopVersion() ? "T_" : "CT_") + packageCode + "_";
        String tName = "";
        int l = entryName.length();
        if (l > 30 - sPreFix.length()) {
            entryName = StringUtils.abbreviate((String)StringUtils.headCharUpperCase((String)entryName), (int)24);
            l = entryName.length();
        }
        tName = sPreFix + StringUtils.headCharUpperCase((String)entryName);
        return tName;
    }
}

