/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bizrule.util.RuleJCodeWriter;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.code.CodeFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableCollection;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyBindingInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectAssembler;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webpage.WebPageObjectCollection;
import com.kingdee.bos.metadata.webpage.WebPageObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.EditUIProxyHelper;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class BizUnitHelper {
    private static final Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.bizunit.BizUnitHelper");
    public static final String IS_CONFIGURE_EXTENDED_TABLE = "isConfigureExtendedTable";

    public static com.kingdee.bos.metadata.entity.PropertyInfo getPropertyByName(EntityObjectInfo entity, String propertyName) {
        if (entity == null || StringUtils.isEmpty((String)propertyName)) {
            return null;
        }
        String[] propertys = StringUtils.split((String)propertyName, (String)".");
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        EntityObjectInfo subEntity = entity;
        if (propertys.length == 1) {
            return subEntity.getPropertyByName(propertyName, true);
        }
        int n = propertys.length;
        for (int i = 0; i < n; ++i) {
            prop = subEntity.getPropertyByName(propertys[i], true);
            if (i == n - 1) break;
            if (prop == null || prop instanceof OwnPropertyInfo) {
                return null;
            }
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            subEntity = relation.getSupplierObject();
            if (subEntity != null) continue;
            return null;
        }
        return prop;
    }

    public static List getDeployedMetadataFiles(String bizUnitPK) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        try {
            BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
            BizUnitInfo bizUnit = bizUnitCtrl.getValueNoClone(MetaDataPK.create(bizUnitPK));
            if (bizUnit != null) {
                bizUnitCtrl.loadAll(bizUnit);
                return BizUnitHelper.getDeployedMetadataFiles(bizUnit);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private static String getMetadataFileName(AbstractMetaDataValue metadata) {
        return StringUtils.replace((String)metadata.getFullName(), (String)".", (String)"\\") + Utils.getMetaDataSuffix(metadata.getBOSType());
    }

    public static List getDeployedMetadataFiles(BizGroupFieldInfo groupField) {
        if (groupField == null || groupField.getEntityObject() == null) {
            return null;
        }
        ArrayList allFiles = new ArrayList();
        List allMetas = BizUnitHelper.getRelatedMetadatas(groupField);
        if (allMetas != null && allMetas.size() > 0) {
            int n = allMetas.size();
            for (int i = 0; i < n; ++i) {
                if (!(allMetas.get(i) instanceof AbstractMetaDataValue)) continue;
                BizUnitHelper.addFiles(allFiles, BizUnitHelper.getMetadataFileName((AbstractMetaDataValue)allMetas.get(i)));
            }
        }
        return allFiles;
    }

    public static List getRelatedMetadatas(BizGroupFieldInfo groupField) {
        JoinQueryInfo query;
        if (groupField == null || groupField.getEntityObject() == null) {
            return null;
        }
        ArrayList<AbstractMetaDataValue> allMetas = new ArrayList<AbstractMetaDataValue>();
        EntityObjectInfo entity = groupField.getEntityObject();
        if (entity != null) {
            allMetas.add(entity);
            DataTableInfo table = groupField.getTableObject();
            if (table != null) {
                allMetas.add(table);
            }
            BizFieldCollection fields = groupField.getFields();
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                List subMetas;
                LinkPropertyInfo lnkProperty;
                BizFieldInfo field = fields.get(i);
                if (!(field instanceof BizGroupFieldInfo) && field.getDataSource() == null) continue;
                String propertyName = field.getPropertyName();
                if (!StringUtils.isEmpty((String)propertyName) && (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propertyName, false)) != null && lnkProperty.getRelationship() != null) {
                    RelationshipInfo relation = lnkProperty.getRelationship();
                    allMetas.add(relation);
                }
                if (!(field instanceof BizGroupFieldInfo) || (subMetas = BizUnitHelper.getRelatedMetadatas((BizGroupFieldInfo)field)) == null) continue;
                allMetas.addAll(subMetas);
            }
        }
        if ((query = groupField.getQuery()) != null) {
            allMetas.add(query);
        }
        if (groupField.getParent() != null && groupField.getParent().getUIObject() != null) {
            allMetas.add(groupField.getParent().getUIObject());
        }
        return allMetas;
    }

    public static List getRelatedMetadatas(BizUnitInfo bizUnit) {
        return BizUnitHelper.getRelatedMetadatas(bizUnit, true);
    }

    public static List getRelatedMetadatas(BizUnitInfo bizUnit, boolean includeBizUnit) {
        WebPageObjectInfo relateWebEditPage;
        WebPageObjectInfo webBriefPage;
        WebPageObjectInfo webViewPage;
        WebPageObjectInfo webListPage;
        WebPageObjectInfo webEditPage;
        UIObjectInfo tableEditUI;
        WebUIObjectInfo relateWebTreeUI;
        UIObjectInfo relatedTreeUI;
        EntityObjectInfo relatedEntity;
        WebUIObjectInfo webListUI;
        WebUIObjectInfo webEditUI;
        UIObjectInfo listUI;
        UIObjectInfo editUI;
        EntityObjectInfo entity;
        if (bizUnit == null) {
            return null;
        }
        ArrayList<AbstractMetaDataValue> allMetas = new ArrayList<AbstractMetaDataValue>();
        if (includeBizUnit) {
            allMetas.add(bizUnit);
        }
        if ((entity = bizUnit.getEntity()) != null) {
            int i;
            allMetas.add(entity);
            DataTableInfo table = entity.getTable();
            if (table != null) {
                allMetas.add(table);
                ExtendedTableCollection tableCol = entity.getTable().getExtendedTables();
                int size = tableCol.size();
                for (i = 0; i < size; ++i) {
                    ExtendedTableInfo extTable = tableCol.get(i);
                    String isConfigure = extTable.getExtendedProperty(IS_CONFIGURE_EXTENDED_TABLE);
                    if (!"true".equals(isConfigure)) continue;
                    allMetas.add(extTable);
                }
            }
            BizFieldCollection fields = bizUnit.getFields();
            int n = fields.size();
            for (i = 0; i < n; ++i) {
                List subMetas;
                LinkPropertyInfo lnkProperty;
                BizFieldInfo field = fields.get(i);
                if (!(field instanceof BizGroupFieldInfo) && field.getDataSource() == null) continue;
                String propertyName = field.getPropertyName();
                if (!StringUtils.isEmpty((String)propertyName) && (lnkProperty = (LinkPropertyInfo)entity.getPropertyByName(propertyName, false)) != null && lnkProperty.getRelationship() != null) {
                    RelationshipInfo relation = lnkProperty.getRelationship();
                    allMetas.add(relation);
                }
                if (!(field instanceof BizGroupFieldInfo) || (subMetas = BizUnitHelper.getRelatedMetadatas((BizGroupFieldInfo)field)) == null) continue;
                allMetas.addAll(subMetas);
            }
        }
        if (bizUnit.getQuery() != null) {
            allMetas.add(bizUnit.getQuery());
        }
        if ((editUI = bizUnit.getEditUI()) != null) {
            allMetas.add(editUI);
            if (editUI.getRuleSet() != null) {
                allMetas.add(editUI.getRuleSet());
            }
        }
        if (bizUnit.getEntityFunction() != null) {
            allMetas.add(bizUnit.getEntityFunction());
        }
        if (bizUnit.getEditUIFunction() != null) {
            allMetas.add(bizUnit.getEditUIFunction());
        }
        if (bizUnit.getListUIFunction() != null) {
            allMetas.add(bizUnit.getListUIFunction());
        }
        if ((listUI = bizUnit.getListUI()) != null) {
            allMetas.add(listUI);
        }
        if ((webEditUI = bizUnit.getWebEditUI()) != null) {
            allMetas.add(webEditUI);
            if (webEditUI.getRuleSet() != null) {
                allMetas.add(webEditUI.getRuleSet());
            }
        }
        if ((webListUI = bizUnit.getWebListUI()) != null) {
            allMetas.add(webListUI);
        }
        if ((relatedEntity = bizUnit.getRelatedEntity()) != null) {
            allMetas.add(relatedEntity);
            PropertyCollection props = relatedEntity.getProperties();
            int n = props.size();
            for (int i = 0; i < n; ++i) {
                RelationshipInfo relation;
                LinkPropertyInfo lnkProp;
                com.kingdee.bos.metadata.entity.PropertyInfo prop = props.get(i);
                if (!(prop instanceof LinkPropertyInfo) || (lnkProp = (LinkPropertyInfo)prop).getRelationship() == null || (relation = lnkProp.getRelationship()).getSupplierCardinality() != CardinalityType.ZERO_TO_ONE && relation.getSupplierCardinality() != CardinalityType.ONE) continue;
                allMetas.add(relation);
            }
        }
        if (bizUnit.getRelatedTable() != null) {
            allMetas.add(bizUnit.getRelatedTable());
        }
        if ((relatedTreeUI = bizUnit.getRelatedTreeUI()) != null) {
            allMetas.add(relatedTreeUI);
        }
        if ((relateWebTreeUI = bizUnit.getRelatedWebTreeUI()) != null) {
            allMetas.add(relateWebTreeUI);
        }
        if ((tableEditUI = bizUnit.getTableEditUI()) != null) {
            allMetas.add(tableEditUI);
        }
        if ((webEditPage = bizUnit.getWebEditPage()) != null) {
            allMetas.add(webEditPage);
        }
        if ((webListPage = bizUnit.getWebListPage()) != null) {
            allMetas.add(webListPage);
        }
        if ((webViewPage = bizUnit.getWebViewPage()) != null) {
            allMetas.add(webViewPage);
        }
        if ((webBriefPage = bizUnit.getWebBriefPage()) != null) {
            allMetas.add(webBriefPage);
        }
        if ((relateWebEditPage = bizUnit.getRelatedWebEditPage()) != null) {
            allMetas.add(relateWebEditPage);
        }
        WebPageObjectCollection pages = bizUnit.getWebPages();
        for (int i = 0; i < pages.size(); ++i) {
            allMetas.add(pages.get(i));
        }
        if (bizUnit.getRelatedQuery() != null) {
            allMetas.add(bizUnit.getRelatedQuery());
        }
        return allMetas;
    }

    public static List getDeployedMetadataFiles(BizUnitInfo bizUnit) {
        if (bizUnit == null) {
            return null;
        }
        ArrayList allFiles = new ArrayList();
        List allMetas = BizUnitHelper.getRelatedMetadatas(bizUnit);
        if (allMetas != null && allMetas.size() > 0) {
            int n = allMetas.size();
            for (int i = 0; i < n; ++i) {
                if (!(allMetas.get(i) instanceof AbstractMetaDataValue)) continue;
                BizUnitHelper.addFiles(allFiles, BizUnitHelper.getMetadataFileName((AbstractMetaDataValue)allMetas.get(i)));
            }
        }
        return allFiles;
    }

    public static List getGeneratedCodeFiles(String bizUnitPK, SolutionInfo solution) {
        if (StringUtils.isEmpty((String)bizUnitPK)) {
            return null;
        }
        try {
            BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(ContextManager.getContext());
            BizUnitInfo bizUnit = bizUnitCtrl.getValueNoClone(MetaDataPK.create(bizUnitPK));
            if (bizUnit != null) {
                bizUnitCtrl.loadAll(bizUnit);
                return BizUnitHelper.getGeneratedCodeFiles(bizUnit, solution);
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public static List getGeneratedCodeFiles(BizUnitInfo bizUnit, SolutionInfo solution) {
        WebUIObjectInfo webListUI;
        WebUIObjectInfo webEditUI;
        UIObjectInfo tableEditUI;
        UIObjectInfo relatedTreeUI;
        EntityObjectInfo relatedEntity;
        UIObjectInfo listUI;
        UIObjectInfo editUI;
        List files;
        if (bizUnit == null) {
            return null;
        }
        ArrayList allFiles = new ArrayList();
        EntityObjectInfo entity = bizUnit.getEntity();
        if (entity != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(entity);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((editUI = bizUnit.getEditUI()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(editUI, solution);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((listUI = bizUnit.getListUI()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(listUI, solution);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((relatedEntity = bizUnit.getRelatedEntity()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(relatedEntity);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((relatedTreeUI = bizUnit.getRelatedTreeUI()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(relatedTreeUI, solution);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((tableEditUI = bizUnit.getTableEditUI()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(tableEditUI, solution);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((webEditUI = bizUnit.getWebEditUI()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(webEditUI, solution, entity);
            BizUnitHelper.addFiles(allFiles, files);
        }
        if ((webListUI = bizUnit.getWebListUI()) != null) {
            files = BizUnitHelper.getGeneratedCodeFiles(webListUI, solution, entity);
            BizUnitHelper.addFiles(allFiles, files);
        }
        BizFieldCollection fields = bizUnit.getFields();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
            files = BizUnitHelper.getGeneratedCodeFiles((BizGroupFieldInfo)fields.get(i));
            BizUnitHelper.addFiles(allFiles, files);
        }
        return allFiles;
    }

    private static void addFiles(List allFiles, String fileName) {
        if (!allFiles.contains(fileName)) {
            allFiles.add(fileName);
        }
    }

    private static void addFiles(List allFiles, List subFiles) {
        if (allFiles == null || subFiles == null) {
            return;
        }
        int n = subFiles.size();
        for (int i = 0; i < n; ++i) {
            if (allFiles.contains(subFiles.get(i))) continue;
            allFiles.add(subFiles.get(i));
        }
    }

    private static List getGeneratedCodeFiles(BizGroupFieldInfo groupField) {
        if (groupField == null || groupField.getEntityObject() == null) {
            return null;
        }
        List allFiles = BizUnitHelper.getGeneratedCodeFiles(groupField.getEntityObject());
        BizFieldCollection fields = groupField.getFields();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            if (!(fields.get(i) instanceof BizGroupFieldInfo)) continue;
            List files = BizUnitHelper.getGeneratedCodeFiles((BizGroupFieldInfo)fields.get(i));
            BizUnitHelper.addFiles(allFiles, files);
        }
        return allFiles;
    }

    public static List getGeneratedCodeFiles(EntityObjectInfo entity) {
        if (entity == null) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        String bizImplName = entity.getBusinessImplName();
        String bizControllerName = entity.getBusinessControllerName();
        if (!StringUtils.isEmpty((String)bizImplName) && !StringUtils.isEmpty((String)bizControllerName)) {
            String packageName = MetaDataUtils.getPackageName(bizImplName);
            String className = MetaDataUtils.getClassName(bizImplName);
            if (StringUtils.isEmpty((String)packageName)) {
                files.add("Abstract" + className + "Info.java");
                files.add("" + className + "Info.java");
                files.add("I" + className + ".java");
                files.add("" + className + ".java");
                files.add("" + className + "Agent.java");
                files.add("" + className + "Collection.java");
                files.add("" + className + "CollectionAgent.java");
                files.add("" + className + "Factory.java");
            } else {
                packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
                files.add(packageName + "\\Abstract" + className + "Info.java");
                files.add(packageName + "\\" + className + "Info.java");
                files.add(packageName + "\\I" + className + ".java");
                files.add(packageName + "\\" + className + ".java");
                files.add(packageName + "\\" + className + "Agent.java");
                files.add(packageName + "\\" + className + "Collection.java");
                files.add(packageName + "\\" + className + "CollectionAgent.java");
                files.add(packageName + "\\" + className + "Factory.java");
            }
            packageName = MetaDataUtils.getPackageName(bizControllerName);
            className = MetaDataUtils.getClassName(bizControllerName);
            if (StringUtils.isEmpty((String)packageName)) {
                files.add("Abstract" + className + "Bean.java");
                files.add("" + className + "Bean.java");
                files.add("" + className + ".java");
                files.add("" + className + "Local.java");
                files.add("" + className + "LocalHome.java");
                files.add("" + className + "Remote.java");
                files.add("" + className + "RemoteHome.java");
            } else {
                packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
                files.add(packageName + "\\Abstract" + className + "Bean.java");
                files.add(packageName + "\\" + className + "Bean.java");
                files.add(packageName + "\\" + className + ".java");
                files.add(packageName + "\\" + className + "Local.java");
                files.add(packageName + "\\" + className + "LocalHome.java");
                files.add(packageName + "\\" + className + "Remote.java");
                files.add(packageName + "\\" + className + "RemoteHome.java");
            }
        }
        return files;
    }

    public static List getGeneratedCodeFiles(UIObjectInfo model, SolutionInfo solution) {
        ArrayList<String> files;
        block4: {
            List languageList;
            String className;
            String packageName;
            block5: {
                if (model == null) {
                    return null;
                }
                files = new ArrayList<String>();
                packageName = model.getReleasePackage();
                className = model.getReleaseClass();
                if (StringUtils.isEmpty((String)className)) break block4;
                className = StringUtils.headCharUpperCase((String)className);
                languageList = BizUnitHelper.getlanguageList(solution);
                if (!StringUtils.isEmpty((String)packageName)) break block5;
                files.add("Abstract" + className + ".java");
                files.add("" + className + ".java");
                files.add("Abstract" + className + ".properties");
                if (languageList == null) break block4;
                int n = languageList.size();
                for (int i = 0; i < n; ++i) {
                    files.add("Abstract" + className + "_" + languageList.get(i) + ".properties");
                    files.add("" + className + "_" + languageList.get(i) + ".properties");
                }
                break block4;
            }
            packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
            files.add(packageName + "\\Abstract" + className + ".java");
            files.add(packageName + "\\" + className + ".java");
            files.add(packageName + "\\Abstract" + className + ".properties");
            if (languageList != null) {
                int n = languageList.size();
                for (int i = 0; i < n; ++i) {
                    files.add(packageName + "\\Abstract" + className + "_" + languageList.get(i) + ".properties");
                    files.add(packageName + "\\" + className + "_" + languageList.get(i) + ".properties");
                }
            }
        }
        return files;
    }

    public static EntityObjectCollection getOneTOMultiSubEntity(EntityObjectInfo entity, boolean deepSearch) {
        EntityObjectCollection col = new EntityObjectCollection();
        PropertyCollection properties = BizUnitHelper.getOneTOMultiProperties(entity);
        int n = properties.size();
        for (int i = 0; i < n; ++i) {
            EntityObjectInfo subEntity = ((LinkPropertyInfo)properties.get(i)).getRelationship().getSupplierObject();
            col.add(subEntity);
            if (!deepSearch) continue;
            EntityObjectCollection subCol = BizUnitHelper.getOneTOMultiSubEntity(subEntity, true);
            int m = subCol.size();
            for (int j = 0; j < m; ++j) {
                col.add(subCol.get(j));
            }
        }
        return col;
    }

    public static PropertyCollection getOneTOMultiProperties(EntityObjectInfo entity) {
        PropertyCollection col = new PropertyCollection();
        PropertyCollection properties = entity.getInheritedNoDuplicatedProperties();
        int n = properties.size();
        for (int i = 0; i < n; ++i) {
            LinkPropertyInfo lnkProp;
            if (!(properties.get(i) instanceof LinkPropertyInfo) || !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)(lnkProp = (LinkPropertyInfo)properties.get(i)).getRelationship().getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)lnkProp.getRelationship().getSupplierCardinality()) || entity.equals(lnkProp.getRelationship().getSupplierObject())) continue;
            col.add(lnkProp);
        }
        return col;
    }

    public static List getGeneratedCodeFiles(String packageName, String webBeanClassName, SolutionInfo solution) {
        ArrayList<String> files;
        block3: {
            List languageList;
            String className;
            block4: {
                files = new ArrayList<String>();
                className = webBeanClassName;
                if (StringUtils.isEmpty((String)className)) break block3;
                className = StringUtils.headCharUpperCase((String)className);
                languageList = BizUnitHelper.getlanguageList(solution);
                if (!StringUtils.isEmpty((String)packageName)) break block4;
                files.add("Abstract" + className + ".java");
                files.add("" + className + ".java");
                files.add("Abstract" + className + ".properties");
                if (languageList == null) break block3;
                int n = languageList.size();
                for (int i = 0; i < n; ++i) {
                    files.add("Abstract" + className + "_" + languageList.get(i) + ".properties");
                    files.add("" + className + "_" + languageList.get(i) + ".properties");
                    files.add("" + className + "_User_" + languageList.get(i) + ".properties");
                }
                break block3;
            }
            packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
            files.add(packageName + "\\Abstract" + className + ".java");
            files.add(packageName + "\\" + className + ".java");
            files.add(packageName + "\\Abstract" + className + ".properties");
            if (languageList != null) {
                int n = languageList.size();
                for (int i = 0; i < n; ++i) {
                    files.add(packageName + "\\Abstract" + className + "_" + languageList.get(i) + ".properties");
                    files.add(packageName + "\\" + className + "_" + languageList.get(i) + ".properties");
                    files.add(packageName + "\\" + className + "_User_" + languageList.get(i) + ".properties");
                }
            }
        }
        return files;
    }

    public static List getGeneratedXHTMLFiles(WebUIObjectInfo model, SolutionInfo solution) {
        if (model == null) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        String packageName = model.getReleasePackage();
        String fileName = StringUtils.headCharLowerCase((String)model.getReleaseClass()) + ".xhtml";
        if (StringUtils.isEmpty((String)(packageName = CodeFactory.getWebUIShortPackage(packageName)))) {
            files.add(fileName);
        } else {
            packageName = StringUtils.replace((String)packageName, (String)".", (String)"\\");
            files.add(packageName + "\\" + fileName);
        }
        return files;
    }

    public static List getGeneratedCodeFiles(WebUIObjectInfo model, SolutionInfo solution, EntityObjectInfo entity) {
        if (model == null) {
            return null;
        }
        ArrayList files = new ArrayList();
        String packageName = model.getReleasePackage();
        String className = model.getReleaseClass() + "Bean";
        BizUnitHelper.addFiles(files, BizUnitHelper.getGeneratedCodeFiles(packageName, className, solution));
        if (entity != null) {
            EntityObjectCollection entityCol = BizUnitHelper.getOneTOMultiSubEntity(entity, true);
            int n = entityCol.size();
            for (int i = 0; i < n; ++i) {
                className = entityCol.get(i).getName() + "Bean";
                BizUnitHelper.addFiles(files, BizUnitHelper.getGeneratedCodeFiles(packageName, className, solution));
            }
        }
        return files;
    }

    private static List getlanguageList(SolutionInfo solution) {
        if (solution == null) {
            return null;
        }
        ArrayList<String> languageList = new ArrayList<String>();
        LanguageCollection lanCol = solution.getLanguages();
        if (lanCol != null) {
            int n = lanCol.size();
            for (int i = 0; i < n; ++i) {
                languageList.add(StringUtils.headCharLowerCase((String)lanCol.get(i).getPostfix()));
            }
        }
        return languageList;
    }

    public static String convertF7FilterToString(FilterItemCollection collection) {
        Document doc = new Document();
        Element root = new Element("filters");
        doc.setRootElement(root);
        for (int i = 0; i < collection.size(); ++i) {
            FilterItemInfo itemInfo = collection.get(i);
            Element filter = new Element("filterItem");
            filter.setAttribute("propertyName", itemInfo.getPropertyName());
            filter.setAttribute("compareType", itemInfo.getCompareType().toString());
            filter.setAttribute("compareValue", itemInfo.getCompareValue().toString());
            if (itemInfo.getString("key") != null && i < collection.size() - 1) {
                filter.setAttribute("key", itemInfo.getString("key"));
            }
            root.addContent(filter);
        }
        XMLOutputter out = new XMLOutputter("   ", true, "UTF-8");
        return out.outputString(doc);
    }

    public static FilterInfo convertStringToF7Filter(String f7String) {
        FilterInfo filterInfo = new FilterInfo();
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        String maskString = "";
        int i = 0;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(f7String.getBytes());
            doc = builder.build((InputStream)inputStream);
        }
        catch (JDOMException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        if (doc == null) {
            return filterInfo;
        }
        Element filters = doc.getRootElement();
        List list = filters.getChildren();
        for (i = 0; i < list.size(); ++i) {
            Element filterItem = (Element)list.get(i);
            FilterItemInfo itemInfo = new FilterItemInfo();
            itemInfo.setPropertyName(filterItem.getAttributeValue("propertyName"));
            itemInfo.setCompareType(CompareType.getEnum(filterItem.getAttributeValue("compareType")));
            itemInfo.setCompareValue(filterItem.getAttributeValue("compareValue"));
            if (filterItem.getAttributeValue("key") != null) {
                maskString = maskString + " #" + i + " " + filterItem.getAttributeValue("key");
                itemInfo.setString("key", filterItem.getAttributeValue("key"));
            }
            filterInfo.getFilterItems().add(itemInfo);
        }
        maskString = maskString + " #" + (i - 1);
        filterInfo.setMaskString(maskString);
        return filterInfo;
    }

    public static UIObjectInfo createTableEditUI(Context ctx, BizUnitInfo bizUnit) throws BOSException {
        if (ctx == null || bizUnit == null || bizUnit.getEntity() == null || bizUnit.getEditUI() == null) {
            return null;
        }
        return BizUnitHelper.createTableEditUI(ctx, bizUnit.getEntity(), MetaDataPK.create(bizUnit.getEditUI().getPackage(), bizUnit.getEntity().getName() + "TableEditUI"));
    }

    public static UIObjectInfo createTableEditUI(Context ctx, EntityObjectInfo entity, MetaDataPK pk) throws BOSException {
        if (ctx == null || entity == null || pk == null) {
            return null;
        }
        UIObjectInfo model = new UIObjectInfo();
        model.setPackage(pk.getPackage());
        model.setName(pk.getName());
        model.setAlias(entity.getAlias() + "\u8868\u683c\u7f16\u8f91\u754c\u9762");
        model.setDescription(entity.getAlias() + "\u8868\u683c\u7f16\u8f91\u754c\u9762");
        model.setParentFullName("com.kingdee.eas.framework.client.TableEditUI");
        model.setParent(new UIObjectCtrl(ctx).getValue(MetaDataPK.create("com.kingdee.eas.framework.client.TableEditUI")));
        model.setTitle(model.getAlias());
        model.setUserDefined(true);
        model.setReleasePackage(model.getPackage());
        model.setReleaseClass(model.getName());
        UIObjectInfo tempInfo = UIObjectAssembler.assembleUI(ctx, model, true);
        BizUnitHelper.generateTableUIFromBO(tempInfo, entity);
        return UIObjectAssembler.parseUI(ctx, tempInfo);
    }

    private static PropertyControlPair[] genPropertyControlPairs(EntityObjectInfo entity, List filter) {
        PropertyCollection collection = entity.getInheritedNoDuplicatedProperties();
        if (collection == null || collection.size() == 0) {
            return new PropertyControlPair[0];
        }
        Vector<PropertyControlPair> pairs = new Vector<PropertyControlPair>();
        com.kingdee.bos.metadata.entity.PropertyInfo prop = null;
        OwnPropertyInfo ownProp = null;
        DataType dataType = null;
        String defaultControType = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            prop = (com.kingdee.bos.metadata.entity.PropertyInfo)iter.next();
            if (filter.contains(prop.getName())) continue;
            if (prop instanceof OwnPropertyInfo) {
                ownProp = (OwnPropertyInfo)prop;
                dataType = ownProp.getDataType();
                if (DataType.BOOLEAN.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDCheckBox";
                } else if (DataType.STRING.equals(dataType) || DataType.BOSUUID.equals(dataType) || DataType.UUID.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDTextField";
                } else if (DataType.FLOAT.equals(dataType) || DataType.DOUBLE.equals(dataType) || DataType.DECIMAL.equals(dataType) || DataType.INTEGER.equals(dataType) || DataType.SHORT.equals(dataType) || DataType.LONG.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDFormattedTextField";
                } else if (DataType.ENUM.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDComboBox";
                } else if (DataType.DATE.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDDatePicker";
                } else if (DataType.TIME.equals(dataType) || DataType.TIMESTAMP.equals(dataType)) {
                    defaultControType = "com.kingdee.bos.ctrl.swing.KDTimePicker";
                }
            } else if (prop instanceof LinkPropertyInfo) {
                CardinalityType cardinalType = ((LinkPropertyInfo)prop).getRelationship().getSupplierCardinality();
                defaultControType = CardinalityType.ONE_TO_UNBOUNDED.equals((Object)cardinalType) || CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)cardinalType) ? "com.kingdee.bos.ctrl.kdf.table.KDTable" : "com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox";
            }
            PropertyControlPair pair = new PropertyControlPair();
            pair.property = prop;
            pair.controlType = defaultControType;
            pairs.add(pair);
        }
        pairs.trimToSize();
        PropertyControlPair[] retPairs = new PropertyControlPair[pairs.size()];
        System.arraycopy(pairs.toArray(), 0, retPairs, 0, pairs.size());
        return retPairs;
    }

    private static List createDataBasePropertyFilter() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("id");
        list.add("CU");
        list.add("creator");
        list.add("createTime");
        list.add("lastUpdateUser");
        list.add("lastUpdateTime");
        list.add("parent");
        list.add("treeid");
        list.add("isLeaf");
        list.add("level");
        list.add("longNumber");
        list.add("displayName");
        return list;
    }

    private static void generateTableUIFromBO(UIObjectInfo model, EntityObjectInfo entity) {
        PropertyBindingInfo propertyBindingInfo;
        DataObjectInfo dataObj = model.getDataObjects().get(0);
        dataObj.setType(entity.getFullName());
        dataObj.setOverride(true);
        dataObj.setWriteCode(true);
        ComponentInfo kdtControl = UIProxyHelper.findControlByName(model, "tblMain");
        PropertyControlPair[] pairs = BizUnitHelper.genPropertyControlPairs(entity, BizUnitHelper.createDataBasePropertyFilter());
        int size = pairs.length;
        TableInfo table = new TableInfo();
        HeaderInfo header = new HeaderInfo();
        for (int i = 0; i < size; ++i) {
            String name;
            if ("com.kingdee.bos.ctrl.kdf.table.KDTable".equalsIgnoreCase(pairs[i].controlType)) continue;
            com.kingdee.bos.metadata.entity.PropertyInfo prop = pairs[i].property;
            String colName = name = prop.getName();
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            if (prop instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                if (DataType.DECIMAL.equals(ownProp.getDataType()) || DataType.DOUBLE.equals(ownProp.getDataType())) {
                    if (ownProp.getDecimalDigits() > 0) {
                        column.setFormatString(EditUIProxyHelper.getNumberFormat(ownProp.getDecimalDigits()));
                    } else {
                        column.setFormatString(EditUIProxyHelper.getNumberFormat(ownProp.getLength()));
                    }
                } else if (DataType.INTEGER.equals(ownProp.getDataType())) {
                    column.setFormatString("%r{0}f");
                } else if (DataType.DATE.equals(ownProp.getDataType()) || DataType.TIMESTAMP.equals(ownProp.getDataType())) {
                    column.setFormatString("%r{yyyy-M-d}t");
                } else if (DataType.TIME.equals(ownProp.getDataType())) {
                    column.setFormatString("h:mm:ss");
                }
            }
            table.addColumn(column);
            CellInfo cell = new CellInfo();
            String cellName = prop.getAlias();
            if (StringUtils.isEmpty((String)cellName)) {
                cell.setName(prop.getName());
            } else {
                cell.setName(cellName);
            }
            cell.setColSpan(0);
            cell.setRowSpan(0);
            header.addCell(cell);
            propertyBindingInfo = new PropertyBindingInfo();
            propertyBindingInfo.setPropertyName(colName + ".text");
            propertyBindingInfo.setPropertyType(Object.class.getName());
            propertyBindingInfo.setAccessType(2);
            propertyBindingInfo.setAutoMode(false);
            propertyBindingInfo.setBindingObject(dataObj.getName());
            propertyBindingInfo.setBingdingField(prop.getName());
            if (prop instanceof OwnPropertyInfo) {
                propertyBindingInfo.setFieldType(((OwnPropertyInfo)prop).getJavaType());
            } else {
                propertyBindingInfo.setFieldType(Object.class.getName());
            }
            kdtControl.getPropertyBindings().add(propertyBindingInfo);
        }
        propertyBindingInfo = new PropertyBindingInfo();
        propertyBindingInfo.setPropertyName("userObject");
        propertyBindingInfo.setPropertyType(Object.class.getName());
        propertyBindingInfo.setAccessType(2);
        propertyBindingInfo.setAutoMode(false);
        propertyBindingInfo.setBindingObject(dataObj.getName());
        propertyBindingInfo.setBingdingField("collection");
        propertyBindingInfo.setFieldType(entity.getObjectCollectionClass());
        kdtControl.getPropertyBindings().add(propertyBindingInfo);
        table.addHeader(header);
        kdtControl.getProperties().remove("formatXml");
        PropertyInfo propInfo = new PropertyInfo();
        propInfo.setName("formatXml");
        propInfo.setType(String.class.getName());
        propInfo.setMultiLanguage(true);
        propInfo.setOverride(true);
        propInfo.setValue(KDTableDesignerHelper.getXmlFrom(table));
        kdtControl.getProperties().add(propInfo);
    }

    public static String getAliasExpression(BizUnitInfo bizUnit, String srcExp) {
        if (bizUnit == null || StringUtils.isEmpty((String)srcExp)) {
            return srcExp;
        }
        int beginIndex = 0;
        int endIndex = 0;
        String desExp = srcExp;
        while (beginIndex != -1) {
            if ((beginIndex = desExp.indexOf("[", beginIndex)) < 0) continue;
            endIndex = desExp.indexOf("]", beginIndex);
            if (endIndex >= 0) {
                String propertyName = desExp.substring(beginIndex + 1, endIndex);
                desExp = desExp.substring(0, beginIndex + 1) + BizUnitHelper.getPropertyAlias(bizUnit, StringUtils.split((String)propertyName, (String)".")) + desExp.substring(endIndex);
                ++beginIndex;
                continue;
            }
            beginIndex = -1;
        }
        return desExp;
    }

    public static String getPropertyAlias(BizUnitInfo bizUnit, String[] propertyNames) {
        if (bizUnit == null || propertyNames == null || propertyNames.length == 0) {
            return "";
        }
        String alias = "";
        String propertyName = "";
        int n = propertyNames.length;
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                propertyName = propertyNames[i];
                alias = BizUnitHelper.getPropertyAlias(bizUnit, propertyName);
                continue;
            }
            propertyName = propertyName + "." + propertyNames[i];
            alias = alias + "." + BizUnitHelper.getPropertyAlias(bizUnit, propertyName);
        }
        return alias;
    }

    private static String getPropertyAlias(BizUnitInfo bizUnit, String propertyName) {
        BizFieldInfo bizField = bizUnit.getFieldByName(propertyName);
        if (bizField != null) {
            if (!StringUtils.isEmpty((String)bizField.getAlias())) {
                return bizField.getAlias();
            }
            return bizField.getName();
        }
        com.kingdee.bos.metadata.entity.PropertyInfo prop = RuleJCodeWriter.getPropertyByName(bizUnit.getEntity(), propertyName);
        if (prop != null) {
            if (!StringUtils.isEmpty((String)prop.getAlias())) {
                return prop.getAlias();
            }
            return prop.getName();
        }
        return propertyName;
    }

    private static class PropertyControlPair {
        protected com.kingdee.bos.metadata.entity.PropertyInfo property;
        protected String controlType = null;

        public String getControlType() {
            return this.controlType;
        }

        public void setControlType(String controlType) {
            this.controlType = controlType;
        }

        public com.kingdee.bos.metadata.entity.PropertyInfo getProperty() {
            return this.property;
        }

        public void setProperty(com.kingdee.bos.metadata.entity.PropertyInfo property) {
            this.property = property;
        }
    }
}

