/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizFieldCollection;
import com.kingdee.bos.metadata.bizunit.BizFieldInfo;
import com.kingdee.bos.metadata.bizunit.BizGroupFieldInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.UIProxyHelper;
import java.io.Serializable;
import java.util.Vector;

public class EditUIProxy
extends AbstractProxy
implements Serializable {
    private UIObjectInfo uiObject;

    public EditUIProxy(Context ctx, UIObjectInfo uiObject) {
        this.uiObject = uiObject;
    }

    @Override
    public void update() throws BIMException {
        if (this.uiObject == null) {
            return;
        }
        UIProxyHelper uiProxyHelper = UIProxyHelper.getInstance();
        String dataObjName = uiProxyHelper.findDataObjectName(this.uiObject, this.bizUnit, false);
        if (dataObjName == null && (dataObjName = uiProxyHelper.bindingDataObject(this.uiObject, this.bizUnit, false)) == null) {
            throw new BIMException("No EntityInfo in this BizUnit");
        }
        uiProxyHelper.updateEditUI(this.uiObject, this.bizUnit, dataObjName);
        uiProxyHelper.updateBizMethod(this.uiObject, this.bizUnit, true);
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.uiObject == null) {
            return;
        }
        BizFieldCollection fields = this.bizUnit.getFields();
        if (fields == null || fields.size() == 0) {
            return;
        }
        UIProxyHelper uiProxyHelper = UIProxyHelper.getInstance();
        Vector<BizFieldInfo> groupBizFields = new Vector<BizFieldInfo>();
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            BizFieldInfo bizField = fields.get(i);
            if (bizField instanceof BizGroupFieldInfo) {
                groupBizFields.add(bizField);
                continue;
            }
            if (ObjectStateType.CHANGED.equals((Object)bizField.getObjectState()) || !ObjectStateType.DELETING.equals((Object)bizField.getObjectState())) continue;
            ComponentInfo control = UIProxyHelper.findControlByName(this.uiObject, bizField.getControlName());
            if (control == null || !control.isHerited()) continue;
            throw new BIMException("The specified control is herited, cann't be deleted");
        }
    }
}

