/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bizunit.proxy;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.bizunit.BIMException;
import com.kingdee.bos.metadata.bizunit.BizTemplateInfo;
import com.kingdee.bos.metadata.bizunit.ObjectStateType;
import com.kingdee.bos.metadata.bizunit.proxy.AbstractProxy;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.metadata.webui.WebUIObjectAssembler;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.bizunitproxy.WebUIProxyHelper;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class WebListUIProxy
extends AbstractProxy
implements Serializable {
    private static Logger logger = Logger.getLogger(WebListUIProxy.class);
    private static final long serialVersionUID = 1L;
    private WebUIObjectInfo uiObject;

    public WebListUIProxy(Context ctx, WebUIObjectInfo uiObject) {
        this.uiObject = uiObject;
    }

    @Override
    public void update() throws BIMException {
        WebUIProxyHelper uiProxyHelper = WebUIProxyHelper.getInstance();
        if (this.uiObject == null) {
            return;
        }
        String nameExt = "ListUI";
        if (this.bizUnit.getObjectState() == ObjectStateType.NEW) {
            this.uiObject.setName(this.bizUnit.getName() + nameExt);
            this.uiObject.setReleasePackage(this.bizUnit.getPackage() + ".client");
            this.uiObject.setReleaseClass(this.bizUnit.getName() + nameExt);
            this.uiObject.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
            BizTemplateInfo template = this.bizUnit.getTemplate();
            if (template != null) {
                WebUIObjectInfo ui = template.getWebEditUI();
                if (ui != null) {
                    this.uiObject.setParent(ui);
                    this.uiObject = WebUIObjectAssembler.assembleUI(ContextManager.getContext(), this.uiObject);
                    DataObjectInfo dataObj = uiProxyHelper.findDataObject(this.uiObject, template, true);
                    if (dataObj != null) {
                        uiProxyHelper.overrideDataObject(dataObj, this.bizUnit, true);
                    }
                } else {
                    String dataObjName = uiProxyHelper.findDataObjectName(this.uiObject, this.bizUnit, true);
                    if (dataObjName == null) {
                        dataObjName = uiProxyHelper.bindingDataObject(this.uiObject, this.bizUnit, true);
                    }
                    if (dataObjName == null) {
                        throw new BIMException("No EntityInfo in this BizUnit");
                    }
                    uiProxyHelper.initWebUIObjectInfo(this.uiObject);
                    uiProxyHelper.createListTemplateUI(this.uiObject, template, dataObjName);
                }
            } else {
                uiProxyHelper.initWebUIObjectInfo(this.uiObject);
            }
        } else if (this.bizUnit.getObjectState() == ObjectStateType.CHANGED) {
            // empty if block
        }
        this.uiObject.setTitle(this.bizUnit.getAlias());
        String dataObjName = "";
        if (this.uiObject.getDataObjects() == null || this.uiObject.getDataObjects().size() <= 0) {
            return;
        }
        dataObjName = this.uiObject.getDataObjects().get(0).getName();
        uiProxyHelper.updateKDTableForQuery(this.uiObject, this.bizUnit, dataObjName, true);
        uiProxyHelper.updateBizMethod(this.uiObject, this.bizUnit, false);
    }

    @Override
    public void checkValid() throws BIMException {
        if (this.uiObject == null) {
            return;
        }
    }
}

