/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bo;

import com.kingdee.bos.dao.xml.impl.AbstractMDElement;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.StrategyInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import com.kingdee.bos.metadata.validate.ValidateList;
import com.kingdee.bos.metadata.validate.ValidateMetaData;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

public class MethodInfo
extends AbstractMDElement
implements Serializable {
    public static final BOSObjectType BOS_TYPE = BOSObjectType.create((String)"metd");

    public MethodInfo() {
        this.put("parameters", new ParameterCollection());
        this.put("exceptions", new BizExceptionCollection());
        this.setAccessLevel(AccessLevel.PUBLIC);
        this.setSubClassingMode(SubClassingMode.NORMAL);
        this.setTransactionAttribute(TransactionAttribute.SUPPORTS);
        this.setPKField("innerID");
        if (this.getString("innerID") == null) {
            this.setString("innerID", Uuid.create().toString());
        }
    }

    public boolean getIsListenerMethod() {
        return this.getBoolean("isListenerMethod");
    }

    public void setIsListenerMethod(boolean isLisenterMethod) {
        this.setBoolean("isListenerMethod", isLisenterMethod);
    }

    public String getUserDefinedLogic() {
        return this.getString("userDefinedLogic");
    }

    public void setUserDefinedLogic(String userDefinedLogic) {
        this.setString("userDefinedLogic", userDefinedLogic);
    }

    public boolean isUserDefined() {
        return this.getBoolean("userDefined");
    }

    public void setUserDefined(boolean userDefined) {
        this.setBoolean("userDefined", userDefined);
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public String getAlias() {
        return this.getAlias(null);
    }

    public void setAlias(String alias) {
        this.setAlias(alias, null);
    }

    public String getAlias(Locale locale) {
        return (String)this.get("alias", locale);
    }

    public void setAlias(String alias, Locale locale) {
        this.put("alias", alias, locale);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public void setDescription(String description) {
        this.setDescription(description, null);
    }

    public String getDescription(Locale locale) {
        return (String)this.get("description", locale);
    }

    public void setDescription(String description, Locale locale) {
        this.put("description", description, locale);
    }

    public String getInnerID() {
        return this.getString("innerID");
    }

    public AccessLevel getAccessLevel() {
        return AccessLevel.PUBLIC;
    }

    public void setAccessLevel(AccessLevel accessLevel) {
        this.setString("accessLevel", AccessLevel.PUBLIC.getName());
    }

    public SubClassingMode getSubClassingMode() {
        String strScm = this.getString("subClassingMode");
        if (strScm == null) {
            return SubClassingMode.NORMAL;
        }
        SubClassingMode scm = SubClassingMode.getEnum(strScm);
        if (scm != null) {
            return scm;
        }
        return SubClassingMode.NORMAL;
    }

    public void setSubClassingMode(SubClassingMode subClassingMode) {
        this.setString("subClassingMode", SubClassingMode.NORMAL.getName());
    }

    public TypeReference getReturnValueType() {
        return new TypeReference(this.getDataType(), this.getMetaDataRef());
    }

    public TypeReference getReturnValueType(BusinessObjectInfo bo) {
        return TypeReference.getReturnType(bo, this);
    }

    public String getDataType() {
        String dataType = this.getString("returnValueType");
        if (dataType == null) {
            return "";
        }
        return dataType;
    }

    public void setDataType(String dataType) {
        this.setString("returnValueType", dataType);
    }

    public String getMetaDataRef() {
        String mdRef = this.getString("metadataRef");
        if (mdRef == null) {
            return "";
        }
        return mdRef;
    }

    public void setMetadataRef(String metadataRef) {
        this.setString("metadataRef", metadataRef);
    }

    public ParameterCollection getParameters() {
        return (ParameterCollection)this.get("parameters");
    }

    public StrategyInfo getStrategy() {
        return (StrategyInfo)this.get("strategy");
    }

    public void setStrategy(StrategyInfo strategy) {
        this.put("strategy", strategy);
    }

    public TransactionAttribute getTransactionAttribute() {
        TransactionAttribute txAttr = TransactionAttribute.getEnum(this.getString("transactionAttribute"));
        if (txAttr != null) {
            return txAttr;
        }
        return TransactionAttribute.SUPPORTS;
    }

    public void setTransactionAttribute(TransactionAttribute txAttr) {
        if (txAttr != null) {
            this.setString("transactionAttribute", txAttr.getName());
        }
    }

    public BizExceptionCollection getBizExceptions() {
        return (BizExceptionCollection)this.get("exceptions");
    }

    @Override
    public BOSObjectType getBOSType() {
        return BOS_TYPE;
    }

    public boolean isSameDefine(MethodInfo method) {
        if (this == method) {
            return true;
        }
        if (method == null) {
            return false;
        }
        if (this.getName() != null && method.getName() != null && !this.getName().equals(method.getName())) {
            return false;
        }
        if (this.getParameters() != null && method.getParameters() != null && !this.getParameters().equals4st(method.getParameters())) {
            return false;
        }
        return false;
    }

    public boolean matchSTMethod(MethodInfo stMethod) {
        if (this == stMethod) {
            return true;
        }
        if (stMethod == null) {
            return false;
        }
        if (this.getName() != null && stMethod.getName() != null && !this.getName().equals(stMethod.getName())) {
            return false;
        }
        return this.getParameters() == null || stMethod.getParameters() == null || this.getParameters().isSubFrom(stMethod.getParameters());
    }

    public boolean isPIMethod() {
        return this.getExtendedProperty("PI_Extend") != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo method = (MethodInfo)o;
        if (this.getName() != null && method.getName() != null && !this.getName().equals(method.getName())) {
            return false;
        }
        if (!(this.getDataType() == null || method.getDataType() == null || this.getDataType().equals(method.getDataType()) || "boolean".equalsIgnoreCase(this.getDataType()) && "boolean".equalsIgnoreCase(method.getDataType()))) {
            return false;
        }
        if (this.getMetaDataRef() != null && method.getMetaDataRef() != null && !this.getMetaDataRef().equals(method.getMetaDataRef())) {
            return false;
        }
        return this.getParameters() == null || method.getParameters() == null || this.getParameters().equals(method.getParameters());
    }

    public boolean equals2(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo method = (MethodInfo)o;
        if (this.getName() != null && method.getName() != null && !this.getName().equals(method.getName())) {
            return false;
        }
        if (!(this.getDataType() == null || method.getDataType() == null || this.getDataType().equals(method.getDataType()) || "boolean".equalsIgnoreCase(this.getDataType()) && "boolean".equalsIgnoreCase(method.getDataType()))) {
            return false;
        }
        return this.getParameters() == null || method.getParameters() == null || this.getParameters().equals2(method.getParameters());
    }

    @Override
    public String toString() {
        String method = this.getDataType() + " " + this.getName() + "(";
        ParameterCollection parmas = this.getParameters();
        for (int i = 0; i < parmas.size(); ++i) {
            method = i > 0 ? method + ", " + parmas.get(i).getDataType() + " arg" + (i + 1) : method + parmas.get(i).getDataType() + " arg" + (i + 1);
        }
        method = method + ")";
        return method;
    }

    public ValidateList validate(boolean isAbstract) {
        ValidateMetaData vld = new ValidateMetaData();
        vld.validateJavaIdentifier("method name", this.getName());
        if (this.getIsListenerMethod() && !this.getReturnValueType().isVoidType()) {
            vld.addError("ListenerMethod[" + this.getName() + "] can only return void DataType.");
        }
        if (this.getSubClassingMode() == SubClassingMode.ABSTRACT && !isAbstract) {
            vld.addError("The method[" + this.toString() + "] subclassingmode cannot be abstract, because the bo's subclassingmode is not abstract");
        }
        if (this.getParameters() != null && this.getParameters().size() > 0) {
            HashMap<String, ParameterInfo> map = new HashMap<String, ParameterInfo>();
            for (int i = 0; i < this.getParameters().size(); ++i) {
                ParameterInfo param = this.getParameters().get(i);
                if (map.containsKey(param.getName())) {
                    vld.addError("Duplicated parameter: " + param.getName());
                    continue;
                }
                map.put(param.getName(), param);
                vld.validateJavaIdentifier("Parameter Name", param.getName());
            }
        }
        if (this.getStrategy() != null) {
            vld.addValidateList(this.getStrategy().validate());
        }
        return vld.getValidateList();
    }

    public boolean isConfigured() {
        return super.getBoolean("configured");
    }

    public void setConfigured(boolean configured) {
        this.put("configured", configured);
    }
}

