/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.clientprefetch;

import com.kingdee.bos.dao.xml.impl.MDLoader;
import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.clientprefetch.Collector;
import com.kingdee.bos.metadata.clientprefetch.PreLoader;
import com.kingdee.bos.metadata.clientprefetch.Prefetcher;
import com.kingdee.bos.metadata.clientprefetch.PreloadList;
import com.kingdee.bos.metadata.clientprefetch.Queue;
import com.kingdee.bos.metadata.clientprefetch.Reader;
import com.kingdee.bos.metadata.clientprefetch.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class PrefetchManager
extends TimerTask {
    private static final Logger logger = Logger.getLogger(PrefetchManager.class);
    private Prefetcher prefetcher;
    private Writer writer;
    private Collector collector;
    private String root;
    private String user;
    private int outputInterval = 60000;
    private int fetcherThreadCount = 1;
    private int queueCapacity = 1000;
    private int queueLimit = 500;
    private static volatile PrefetchManager instance = null;
    private static final List<PreloadList> preloadList = new ArrayList<PreloadList>(1);

    private PrefetchManager(String user) {
        this.user = user;
        this.init();
    }

    private void init() {
        this.root = System.getProperty("user.dir");
        this.root = this.root + "/cache/";
    }

    @Override
    public void run() {
        MetaDataLoaderFactory.getRemoteMetaDataLoader();
        long t1 = System.currentTimeMillis();
        Reader reader = new Reader(this.root, this.user, PrefetchManager.getPreloadList());
        PreLoader preLoader = new PreLoader();
        this.prefetcher = new Prefetcher(reader, preLoader, this.fetcherThreadCount);
        this.prefetcher.start();
        long t2 = System.currentTimeMillis();
        logger.debug((Object)("Prefetch cost " + (t2 - t1) + "ms."));
        Queue queue = new Queue(this.queueLimit, this.queueCapacity);
        this.collector = new Collector(queue);
        MDLoader.getInstance().setMetaDataVistor(this.collector);
        this.writer = new Writer(this.root, this.user, this.outputInterval, queue, this.prefetcher.getMessages());
        this.writer.start();
    }

    private void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public static void switchUser(String user) {
        if (user == null) {
            return;
        }
        PrefetchManager inst = instance;
        if (inst != null) {
            if (user.equals(inst.user)) {
                return;
            }
            inst.close();
        }
        inst = new PrefetchManager(user);
        new Timer("Metadata preload", true).schedule((TimerTask)inst, 10000L);
        instance = inst;
    }

    public static void addPreloadList(PreloadList list) {
        if (list != null) {
            preloadList.add(list);
        }
    }

    private static PreloadList getPreloadList() {
        return new PreloadList(){

            @Override
            public List<MetaDataPK2> getMetaDataPKs() {
                ArrayList<MetaDataPK2> pks = new ArrayList<MetaDataPK2>();
                for (PreloadList p : preloadList) {
                    pks.addAll(p.getMetaDataPKs());
                }
                return pks;
            }
        };
    }
}

