/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.clientprefetch;

import com.kingdee.bos.dao.xml.impl.MetaDataPK2;
import com.kingdee.bos.metadata.clientprefetch.Constants;
import com.kingdee.bos.metadata.clientprefetch.Message;
import com.kingdee.bos.metadata.clientprefetch.PreloadList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class Reader
implements Constants {
    private static final Logger logger = Logger.getLogger(Reader.class);
    private String fileName;
    private boolean initialized;
    private final PreloadList list;

    Reader(String root, String user, PreloadList list) {
        this.fileName = this.getFile(root, user);
        if (this.fileName != null) {
            this.initialized = true;
        }
        this.list = list;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages() {
        FileReader reader;
        long t1 = System.currentTimeMillis();
        try {
            reader = new FileReader(this.fileName);
        }
        catch (FileNotFoundException e) {
            return Collections.emptyList();
        }
        BufferedReader br = new BufferedReader(reader);
        String line = null;
        ArrayList<Message> result = new ArrayList<Message>();
        try {
            while ((line = br.readLine()) != null) {
                result.add(Message.parse(line));
            }
            long t2 = System.currentTimeMillis();
            logger.debug((Object)("Prefetch.Reader cost " + (t2 - t1) + "ms."));
            if (this.list != null) {
                List<MetaDataPK2> pks = this.list.getMetaDataPKs();
                for (MetaDataPK2 pk : pks) {
                    result.add(Message.parse(pk.toString()));
                }
            }
            ArrayList<Message> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return Collections.emptyList();
    }

    private String getFile(String root, String user) {
        File file = new File(root);
        if (!file.exists()) {
            return null;
        }
        String uri = root + "mdprefetch";
        file = new File(uri);
        if (!file.exists()) {
            return null;
        }
        file = new File(uri = uri + "/" + user);
        if (!file.exists()) {
            return null;
        }
        return uri;
    }
}

