/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.ExecuteMode;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.code.CodeUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import com.kingdee.bos.metadata.rule.RuleUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class AbstractBeanCodeWriter
extends CodeWriterBase {
    protected BusinessObjectInfo bo;
    private static final String imp1 = "import java.rmi.RemoteException";
    private static final String imp2 = "import javax.ejb.*";
    private static final String imp3 = "import com.kingdee.bos.*";
    private static final String imp4 = "import com.kingdee.bos.metadata.IMetaDataPK";
    private static final String imp5 = "import com.kingdee.bos.util.BOSObjectType";
    private static final String imp6 = "import com.kingdee.bos.framework.ejb.AbstractEntityControllerBean";
    private static final String imp7 = "import com.kingdee.bos.metadata.rule.RuleExecutor";
    private static final String imp8 = "import com.kingdee.bos.metadata.MetaDataPK";
    private static final String imp9 = "import com.kingdee.bos.service.ServiceContext";
    private static final String imp10 = "import com.kingdee.bos.metadata.entity.EntityViewInfo";
    private static final String imp11 = "import com.kingdee.bos.dao.IObjectPK";
    private static final String imp12 = "import com.kingdee.bos.framework.ejb.AbstractBizControllerBean";
    private static final String imp13 = "import com.kingdee.bos.dao.IObjectValue";
    private static final String imp14 = "import com.kingdee.bos.dao.IObjectCollection";
    private static final String imp15 = "import com.kingdee.bos.service.IServiceContext";
    private static final String prev = "Abstract";
    private static final String param = "context";
    private static final String session = "SessionContext";
    private static final String getDao = "_";
    private static final String CC_BOS = "BOSObjectType";
    private static final String CC_GBOS = "getBOSType";
    private static final String retValue = "retValue";
    private static final String inner = "inner";
    protected static final String suffix = "Bean";
    protected static final String TRY = "try";
    protected static final String CATCH = "catch";
    protected static final String FINALLY = "finally";
    protected static final String exceptionName = "ex";
    protected HashMap impMap;
    protected EntityObjectInfo superEn = null;
    protected MethodCollection superMethods = null;
    protected MethodCollection collectionMethods = null;
    protected Vector collectionEntities = null;

    public AbstractBeanCodeWriter(BusinessObjectInfo bo) {
        this.bo = bo;
    }

    protected void init() {
        FacadeInfo en;
        FacadeInfo superFac;
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en2 = (EntityObjectInfo)this.bo;
            this.superEn = en2.getBaseEntity();
            if (this.superEn != null) {
                if (this.superMethods == null) {
                    this.superMethods = new MethodCollection();
                }
                this.collectionMethods = new MethodCollection();
                this.collectionEntities = new Vector();
                for (EntityObjectInfo superEnTmp = this.superEn; superEnTmp != null; superEnTmp = superEnTmp.getBaseEntity()) {
                    this.superMethods.addObjectCollection(superEnTmp.getMethods());
                }
                CodeUtil.getSuperCollectionMethod(this.superEn, this.collectionMethods, this.collectionEntities);
            }
        } else if (this.bo instanceof FacadeInfo && (superFac = (en = (FacadeInfo)this.bo).getBaseFacade()) != null) {
            if (this.superMethods == null) {
                this.superMethods = new MethodCollection();
            }
            while (superFac != null) {
                this.superMethods.addObjectCollection(superFac.getMethods());
                superFac = superFac.getBaseFacade();
            }
        }
    }

    protected void initImpMap() {
        this.impMap = new HashMap();
        this.impMap.put(imp1, null);
        this.impMap.put(imp2, null);
        this.impMap.put(imp3, null);
        this.impMap.put(imp4, null);
        this.impMap.put(imp5, null);
        this.impMap.put(imp6, null);
        this.impMap.put(imp7, null);
        this.impMap.put(imp8, null);
        this.impMap.put(imp9, null);
        this.impMap.put(imp10, null);
        this.impMap.put(imp11, null);
        this.impMap.put(imp12, null);
        this.impMap.put(imp13, null);
        this.impMap.put(imp14, null);
        this.impMap.put(imp15, null);
        MethodCollection methods = this.bo.getMethods();
        this.addMethodImport(methods);
        this.addMethodImport(this.collectionMethods);
        this.addInheritPackageName();
        Vector vec = CodeUtil.getAddedExceptionsName(this.bo);
        if (vec != null) {
            int n = vec.size();
            for (int i = 0; i < n; ++i) {
                this.impMap.put("import " + vec.elementAt(i), null);
            }
        }
        if (this.bo instanceof EntityObjectInfo) {
            Vector vec1;
            EntityObjectInfo en = (EntityObjectInfo)this.bo;
            this.superEn = en.getBaseEntity();
            if (this.superEn != null && (vec1 = CodeUtil.getSuperCollectionMethodException(this.superEn)) != null) {
                int n = vec1.size();
                for (int i = 0; i < n; ++i) {
                    this.impMap.put("import " + vec1.elementAt(i), null);
                }
            }
        }
    }

    protected void addMethodImport(MethodCollection methods) {
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                TypeReference tp;
                if (methods.get(i) == null) continue;
                String fullName = "";
                ParameterCollection params = methods.get(i).getParameters();
                for (int j = 0; j < params.size(); ++j) {
                    if (params.get(j) == null || !this.needAddNew(this.getPackageName(fullName = this.getTypeName(tp = params.get(j).getParameterType(this.bo))), fullName)) continue;
                    this.impMap.put("import " + fullName, null);
                }
                BizExceptionCollection exps = methods.get(i).getBizExceptions();
                for (int j = 0; j < exps.size(); ++j) {
                    if (exps.get(j) == null || !this.needAddNew(this.getPackageName(fullName = exps.get(j).getClassName()), fullName)) continue;
                    this.impMap.put("import " + fullName, null);
                }
                tp = methods.get(i).getReturnValueType(this.bo);
                fullName = this.getTypeName(tp);
                if (!this.needAddNew(this.getPackageName(fullName), fullName)) continue;
                this.impMap.put("import " + fullName, null);
            }
        }
    }

    protected void addInheritPackageName() {
        String fullName;
        if (this.getBaseFullName().length() != 0 && this.needAddNew(this.getPackageName(fullName = this.getBaseFullName()), fullName)) {
            this.impMap.put("import " + fullName, null);
        }
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)this.bo;
            String info = en.getObjectValueClass();
            if (en.getRootEntity() != null) {
                if (this.needAddNew(this.getPackageName(info), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getRootEntity().getObjectCollectionClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getRootEntity().getObjectValueClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getObjectCollectionClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
            }
            this.impMap.put("import " + en.getObjectValueClass(), null);
            this.impMap.put("import " + en.getObjectCollectionClass(), null);
            if (en.getBaseEntity() != null) {
                String superEntityName = en.getBaseEntity().getObjectCollectionClass();
                this.impMap.put("import " + superEntityName, null);
            }
        }
    }

    protected String getTypeName(TypeReference tp) {
        if (tp.getArrayDimension() == 0) {
            return tp.toString();
        }
        return tp.getArrayElementType().toString();
    }

    protected boolean needAddNew(String packageName, String fullName) {
        if (packageName.length() == 0) {
            return false;
        }
        if (packageName.equals(this.getPackageName(this.getFullName()))) {
            return false;
        }
        return !this.impMap.containsKey("import " + fullName);
    }

    protected String getBaseFullName() {
        FacadeInfo en;
        String name = "";
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en2 = (EntityObjectInfo)this.bo;
            if (en2.getBaseEntity() != null) {
                name = en2.getBaseEntity().getBusinessControllerBean() == null ? "" : en2.getBaseEntity().getBusinessControllerBean();
            }
        } else if (this.bo instanceof FacadeInfo && (en = (FacadeInfo)this.bo).getBaseFacade() != null) {
            name = en.getBaseFacade().getBusinessControllerBean() == null ? "" : en.getBaseFacade().getBusinessControllerBean();
        }
        return name;
    }

    @Override
    public void write(StringBuffer in) {
        this.init();
        this.initImpMap();
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeNormalMethods();
        this.writeMethods();
        if (this.bo instanceof EntityObjectInfo && this.superEn != null) {
            this.reloadCollectionMethods();
        }
        this.tabSub();
        this.writeEnd();
    }

    protected void writePackage() {
        String pa = this.getPackageName(this.getFullName());
        if (pa.length() != 0) {
            this.out.append("package");
            this.out.append(this.addBlank(pa) + ';' + '\n');
            this.out.append("\n");
        }
        Iterator it = this.impMap.keySet().iterator();
        while (it.hasNext()) {
            this.out.append((String)it.next() + ';' + '\n');
        }
        this.out.append("\n");
    }

    protected void writeClass() {
        this.out.append("public ");
        this.out.append("abstract ");
        this.out.append("class");
        this.out.append(this.addBlank(this.getClassName()));
        String baseEnName = this.getClassName(this.getBaseFullName());
        if (baseEnName.length() != 0) {
            this.out.append("extends" + this.addBlank(baseEnName) + '\n');
        } else if (this.bo instanceof FacadeInfo) {
            this.out.append("extends" + this.addBlank("AbstractBizControllerBean") + '\n');
        } else if (this.bo instanceof EntityObjectInfo) {
            this.out.append("extends" + this.addBlank("AbstractEntityControllerBean") + '\n');
        }
        this.out.append(this.getExtendName() + '\n');
    }

    protected void writeNormalMethods() {
        this.out.append(this.tab + "protected" + this.addBlank(CC_BOS) + CC_GBOS + '(' + ')' + '\n');
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "return" + this.addBlank("new") + CC_BOS + '(' + '\"' + this.bo.getType().toString() + '\"' + ')' + ';' + '\n');
        this.tabSub();
        this.writeEnd();
    }

    protected void writeMethods() {
        MethodCollection methods = CodeUtil.addExceptionToMethods(this.bo);
        CodeUtil.addCollectionMethod(this.bo, methods, this.collectionMethods);
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo method = methods.get(i);
            this.writeMethod(method);
        }
    }

    protected void writeMethod(MethodInfo method) {
        boolean isNeedSvc = false;
        String subClassMode = this.getSubClassMode(method);
        this.out.append(this.tab + "");
        TypeReference tp = method.getReturnValueType(this.bo);
        String tpName = this.getClassName(tp.toString());
        if (method.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT) && this.bo.isSystemMethod(method)) {
            this.out.append("protected ");
            this.out.append(subClassMode + ' ');
            if (method.getDataType().equalsIgnoreCase("ObjectValue")) {
                this.out.append("IObjectValue");
            } else if (method.getDataType().equalsIgnoreCase("ObjectCollection")) {
                isNeedSvc = true;
                this.out.append("IObjectCollection");
            } else {
                this.out.append(this.getClassName(tp.toString()));
            }
            this.out.append(" _");
        } else {
            this.out.append("public ");
            this.out.append(this.getClassName(tp.toString()));
            this.out.append(" ");
        }
        this.out.append(this.getMethodName(method, this.bo));
        this.out.append("(");
        if (method.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT) && this.bo.isSystemMethod(method)) {
            this.writeSuperParams(method.getParameters(), isNeedSvc);
        } else {
            this.writeParams(method.getParameters());
        }
        this.out.append(")");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(method.getBizExceptions());
        if (method.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT) && this.bo.isSystemMethod(method)) {
            this.out.append(";");
            this.out.append("\n");
            this.out.append(this.tab + "");
            this.out.append("public ");
            this.out.append(this.addBlank(tpName));
            this.out.append(this.getMethodName(method, this.bo));
            this.out.append("(");
            this.writeParams(method.getParameters());
            this.out.append(")");
            this.out.append("throws" + this.addBlank("BOSException"));
            this.writeExceptions(method.getBizExceptions());
            this.writeSysMethodBody(method, tp);
        } else if (this.bo.isSystemMethod(method)) {
            this.out.append("\n");
            this.writeSysMethodBody(method, tp);
        } else {
            this.out.append("\n");
            this.writeUserMethodBody(method, tp);
        }
    }

    private void writeRule(MethodInfo method) {
        String[] ruleCode = RuleUtils.generateInvokeRuleCode(method);
        for (int i = 0; i < ruleCode.length; ++i) {
            this.out.append(this.tab + ruleCode[i] + '\n');
        }
    }

    private void writeSetRetVal(String retType, String retValue) {
        String newValue = retValue;
        if ("int".equals(retType)) {
            newValue = "new Integer(" + retValue + ")";
        } else if ("long".equals(retType)) {
            newValue = "new Long(" + retValue + ")";
        } else if ("byte".equals(retType)) {
            newValue = "new Byte(" + retValue + ")";
        } else if ("short".equals(retType)) {
            newValue = "new Short(" + retValue + ")";
        } else if ("char".equals(retType)) {
            newValue = "new Character(" + retValue + ")";
        } else if ("float".equals(retType)) {
            newValue = "new Float(" + retValue + ")";
        } else if ("double".equals(retType)) {
            newValue = "new Double(" + retValue + ")";
        } else if ("boolean".equals(retType)) {
            newValue = "new Boolean(" + retValue + ")";
        }
        this.out.append("" + this.tab);
        this.out.append("svcCtx.setMethodReturnValue(" + newValue + ")");
        this.out.append(";\n");
    }

    protected void writeUserMethodBody(MethodInfo method, TypeReference tp) {
        boolean isNeedReturn = !tp.toString().equals("void");
        this.writeBegin();
        this.tabAdd();
        this.writeTryBefore();
        this.tabAdd();
        this.writeServiceBefore(method);
        if (method.getStrategy() != null && (method.getStrategy().getExecuteMode().equals((Object)ExecuteMode.BEGININVOKE) || isNeedReturn) && !method.getStrategy().getExecuteMode().equals((Object)ExecuteMode.MANUAL)) {
            this.writeRule(method);
        }
        this.out.append(this.tab + "");
        if (isNeedReturn) {
            String retType = tp.toString();
            this.out.append(retType + "" + ' ' + retValue);
            this.out.append(" = ");
            this.out.append("(" + retType + ')');
        }
        this.out.append('_' + method.getName());
        this.out.append("(");
        this.writeMethodParams(method.getParameters(), true, false);
        this.out.append(")");
        this.out.append(";\n");
        if (method.getStrategy() != null && method.getStrategy().getExecuteMode().equals((Object)ExecuteMode.ENDINVOKE) && !isNeedReturn) {
            this.writeRule(method);
        }
        if (isNeedReturn) {
            this.writeSetRetVal(tp.toString(), retValue);
        }
        this.writeServiceAfter();
        if (isNeedReturn) {
            this.out.append(this.tab + "");
            this.out.append("return ");
            this.out.append("retValue;\n");
        }
        this.tabSub();
        this.writeTryAfter(method);
        this.tabSub();
        this.writeEnd();
        if (!CodeUtil.containMethodForNormal(this.superMethods, method)) {
            this.out.append(this.tab + "protected");
            if (!method.isUserDefined()) {
                this.out.append(this.addBlank("abstract"));
            } else {
                this.out.append(" ");
            }
            if (method.getDataType().equalsIgnoreCase("ObjectValue")) {
                this.out.append("IObjectValue");
            } else if (method.getDataType().equalsIgnoreCase("ObjectCollection")) {
                this.out.append("IObjectCollection");
            } else {
                this.out.append(this.getClassName(tp.toString()));
            }
            this.out.append(" _");
            this.out.append(method.getName());
            this.out.append("(");
            this.writeSuperParams(method.getParameters(), false);
            this.out.append(")");
            this.out.append("throws" + this.addBlank("BOSException"));
            this.writeExceptions(method.getBizExceptions());
            if (!method.isUserDefined()) {
                this.out.append(";\n");
            } else {
                this.out.append('\n');
                this.writeBegin();
                this.tabAdd();
                String type = "" + method.getReturnValueType().toString();
                if (!type.equals("void")) {
                    String retValStr = "null";
                    if (type.equalsIgnoreCase("boolean")) {
                        retValStr = "false";
                    } else if (type.equalsIgnoreCase("char") || type.equalsIgnoreCase("byte") || type.equalsIgnoreCase("short") || type.equalsIgnoreCase("int") || type.equalsIgnoreCase("long") || type.equalsIgnoreCase("float") || type.equalsIgnoreCase("double")) {
                        retValStr = "0";
                    }
                    this.out.append(this.tab + "return " + retValStr + ";" + '\n');
                }
                this.tabSub();
                this.writeEnd();
            }
        }
    }

    protected void writeSysMethodBody(MethodInfo method, TypeReference tp) {
        String methodName = method.getName();
        this.writeBegin();
        this.tabAdd();
        boolean isNeedReturn = !tp.isVoidType();
        boolean isNeedSvc = false;
        this.writeTryBefore();
        this.tabAdd();
        this.writeServiceBefore(method);
        this.out.append(this.tab + "");
        if (isNeedReturn) {
            String retType = "";
            if (this.bo instanceof EntityObjectInfo) {
                if (this.isCollection(methodName)) {
                    isNeedSvc = true;
                    retType = this.getClassName(((EntityObjectInfo)this.bo).getObjectCollectionClass());
                } else {
                    retType = this.isValue(methodName) ? this.getClassName(((EntityObjectInfo)this.bo).getObjectValueClass()) : this.getClassName(tp.toString());
                }
            } else {
                retType = this.getClassName(tp.toString());
            }
            this.out.append(retType + "" + ' ' + retValue);
            this.out.append(" = ");
            this.out.append("(" + retType + ')');
        }
        this.out.append(getDao + methodName);
        this.out.append("(");
        this.writeMethodParams(method.getParameters(), true, isNeedSvc);
        this.out.append(")");
        this.out.append(";\n");
        if (isNeedReturn) {
            this.writeSetRetVal(tp.toString(), retValue);
        }
        this.writeServiceAfter();
        if (isNeedReturn) {
            this.out.append(this.tab + "");
            this.out.append("return ");
            this.out.append("retValue;\n");
        }
        this.tabSub();
        this.writeTryAfter(method);
        this.tabSub();
        this.writeEnd();
        if (!method.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT)) {
            this.writeInnerSystemMethod(method, tp);
        }
    }

    protected void writeInnerSystemMethod(MethodInfo method, TypeReference tp) {
        boolean isNeedReturn = !tp.toString().equals("void");
        boolean haveSuperMethod = CodeUtil.containMethodForNormal(this.superMethods, method);
        boolean isNeedSvc = false;
        this.out.append(this.tab + "protected" + ' ');
        if (method.getDataType().equalsIgnoreCase("ObjectValue")) {
            this.out.append("IObjectValue");
        } else if (method.getDataType().equalsIgnoreCase("ObjectCollection")) {
            isNeedSvc = true;
            this.out.append("IObjectCollection");
        } else {
            this.out.append(this.getClassName(tp.toString()));
        }
        this.out.append(" _");
        this.out.append(method.getName());
        this.out.append("(");
        this.writeSuperParams(method.getParameters(), isNeedSvc);
        this.out.append(")");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(method.getBizExceptions());
        this.out.append("\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "");
        if (isNeedReturn) {
            String methodName = method.getName();
            String retType = "";
            retType = this.bo instanceof EntityObjectInfo ? (this.isCollection(methodName) ? this.getClassName(((EntityObjectInfo)this.bo).getObjectCollectionClass()) : (this.isValue(methodName) ? this.getClassName(((EntityObjectInfo)this.bo).getObjectValueClass()) : this.getClassName(tp.toString()))) : this.getClassName(tp.toString());
            this.out.append("return ");
        }
        if (haveSuperMethod) {
            this.out.append("super.");
            this.out.append('_' + method.getName());
        } else {
            this.out.append(inner + MetaDataUtils.upcastName(method.getName()));
        }
        this.out.append("(");
        this.writeMethodParams(method.getParameters(), true, isNeedSvc);
        this.out.append(")");
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
    }

    protected void writeServiceBefore(MethodInfo method) {
        String svcCtx = "ServiceContext svcCtx = createServiceContext(new MetaDataPK(\"";
        String objectArray = "new Object[]{";
        String invokeBefore = "invokeServiceBefore(svcCtx);";
        this.out.append(this.tab + "");
        this.out.append(svcCtx + "" + method.getString("innerID"));
        this.out.append("\"");
        this.out.append(")");
        this.out.append("," + objectArray);
        this.writeParameters(method.getParameters());
        this.out.append("}");
        this.out.append(")");
        this.out.append(";");
        this.out.append("\n");
        this.out.append(this.tab + "");
        this.out.append(invokeBefore + "" + '\n');
    }

    protected void writeServiceAfter() {
        String invokeAfter = "invokeServiceAfter(svcCtx);";
        this.out.append(this.tab + "");
        this.out.append(invokeAfter + "" + '\n');
    }

    protected void writeTryBefore() {
        this.out.append(this.tab + "");
        this.out.append("try{\n");
    }

    protected void writeTryAfter(MethodInfo method) {
        this.out.append(this.tab + "");
        this.out.append("} ");
        this.out.append("catch (");
        this.out.append("BOSException ");
        this.out.append("ex)");
        this.out.append(" {");
        this.out.append("\n");
        this.tabAdd();
        this.writeTryBody(method);
        this.tabSub();
        this.out.append(this.tab + "");
        this.out.append("}");
        BizExceptionCollection bizs = method.getBizExceptions();
        for (int i = 0; i < bizs.size(); ++i) {
            if (bizs.get(i) == null) continue;
            this.out.append(" ");
            this.out.append("catch (");
            this.out.append(this.getClassName(bizs.get(i).getClassName()) + "" + ' ');
            this.out.append("ex)");
            this.out.append(" {");
            this.out.append("\n");
            this.tabAdd();
            this.writeTryBody(method);
            this.tabSub();
            this.out.append(this.tab + "");
            this.out.append("}");
        }
        this.out.append(' ');
        this.out.append(FINALLY);
        this.out.append(" {");
        this.out.append("\n");
        this.tabAdd();
        this.writeFinallyBody();
        this.tabSub();
        this.out.append(this.tab + "");
        this.out.append("}");
        this.out.append("\n");
    }

    protected void writeTryBody(MethodInfo method) {
        TransactionAttribute ta = method.getTransactionAttribute();
        if (TransactionAttribute.MANDATORY.equals((Object)ta) || TransactionAttribute.REQUIRED.equals((Object)ta) || TransactionAttribute.REQUIRESNEW.equals((Object)ta)) {
            this.out.append(this.tab + "");
            this.out.append("this.setRollbackOnly();");
            this.out.append("\n");
        }
        this.out.append(this.tab + "");
        this.out.append("throw ex");
        this.out.append(";\n");
    }

    protected void writeFinallyBody() {
        this.out.append(this.tab + "");
        this.out.append("super.cleanUpServiceState()");
        this.out.append(";\n");
    }

    protected void writeParameters(ParameterCollection params) {
        this.out.append("ctx");
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo param = params.get(i);
            this.out.append(",");
            String paramName = null;
            String paramType = this.getClassName(param.getParameterType(this.bo).toString());
            if (paramType.equals("byte")) {
                paramName = "new Byte(";
            } else if (paramType.equals("char")) {
                paramName = "new Character(";
            } else if (paramType.equals("short")) {
                paramName = "new Short(";
            } else if (paramType.equals("int")) {
                paramName = "new Integer(";
            } else if (paramType.equals("float")) {
                paramName = "new Float(";
            } else if (paramType.equals("double")) {
                paramName = "new Double(";
            } else if (paramType.equals("long")) {
                paramName = "new Long(";
            } else if (paramType.equals("boolean")) {
                paramName = "new Boolean(";
            }
            paramName = paramName == null ? param.getName() : paramName + param.getName() + ')';
            this.out.append(paramName);
        }
    }

    protected void writeMethodParams(ParameterCollection params, boolean needCtx, boolean needSvc) {
        if (needCtx) {
            this.out.append("ctx");
            if (needSvc) {
                this.out.append(",");
            } else if (params.size() > 0) {
                this.out.append(",");
            }
        }
        if (needSvc) {
            this.out.append("svcCtx");
            if (params.size() > 0) {
                this.out.append(",");
            }
        }
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo param = params.get(i);
            if (i != 0) {
                this.out.append(",");
            }
            this.out.append(param.getName());
        }
    }

    protected void writeParams(ParameterCollection params) {
        this.out.append("Context ctx");
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo param = params.get(i);
            this.out.append(",");
            this.out.append(this.getClassName(param.getParameterType(this.bo).toString()) + this.addBlank(param.getName()));
        }
    }

    protected void writeSuperParams(ParameterCollection params, boolean needSvc) {
        this.out.append("Context ctx");
        if (needSvc) {
            this.out.append(",");
            this.out.append("IServiceContext svcCtx");
        }
        for (int i = 0; i < params.size(); ++i) {
            ParameterInfo param = params.get(i);
            this.out.append(",");
            if (param.getDataType().equalsIgnoreCase("ObjectValue")) {
                this.out.append("IObjectValue");
            } else if (param.getDataType().equalsIgnoreCase("ObjectCollection")) {
                this.out.append("IObjectCollection");
            } else {
                this.out.append(this.getClassName(param.getParameterType(this.bo).toString()));
            }
            this.out.append(this.addBlank(param.getName()));
        }
    }

    protected void writeExceptions(BizExceptionCollection bizs) {
        for (int i = 0; i < bizs.size(); ++i) {
            if (bizs.get(i) == null) continue;
            this.out.append(",");
            this.out.append(this.getClassName(bizs.get(i).getClassName()));
        }
    }

    protected String getExtendName() {
        return this.tab + "implements" + ' ' + this.getCtrlName();
    }

    public String getFullName() {
        return this.bo.getAbstractBusinessControllerBean() == null ? "" : this.bo.getAbstractBusinessControllerBean();
    }

    @Override
    public String getClassName() {
        return this.getClassName(this.getFullName());
    }

    protected String getCtrlName() {
        return this.bo.getBusinessControllerName() == null ? "" : this.getClassName(this.bo.getBusinessControllerName());
    }

    public String getInfoName() {
        if (!(this.bo instanceof EntityObjectInfo)) {
            return "";
        }
        EntityObjectInfo en = (EntityObjectInfo)this.bo;
        return en.getObjectValueClass() == null ? "" : this.getClassName(en.getObjectValueClass());
    }

    public String getCollectionName() {
        if (!(this.bo instanceof EntityObjectInfo)) {
            return "";
        }
        EntityObjectInfo en = (EntityObjectInfo)this.bo;
        return en.getObjectCollectionClass() == null ? "" : this.getClassName(en.getObjectCollectionClass());
    }

    protected void reloadCollectionMethods() {
        EntityObjectInfo en = (EntityObjectInfo)this.bo;
        String collectionName = this.getClassName(en.getObjectCollectionClass());
        if (this.collectionMethods != null) {
            for (int i = 0; i < this.collectionMethods.size(); ++i) {
                MethodInfo collectionMethod = this.collectionMethods.get(i);
                String superCollectionName = this.getClassName(((EntityObjectInfo)this.collectionEntities.get(i)).getObjectCollectionClass());
                this.writeCollectionMethod(collectionMethod, collectionName, superCollectionName);
            }
        }
    }

    protected void writeCollectionMethod(MethodInfo collectionMethod, String collectionName, String superCollectionName) {
        String methodName = "";
        methodName = this.superEn.getBaseEntity() == null ? "getCollection" : "get" + superCollectionName;
        this.out.append(this.tab + "");
        this.out.append("public " + superCollectionName);
        this.out.append(' ' + methodName);
        this.out.append("(");
        this.writeParams(collectionMethod.getParameters());
        this.out.append(") ");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(collectionMethod.getBizExceptions());
        this.out.append("\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "");
        this.out.append("return ");
        this.out.append("(" + superCollectionName);
        this.out.append(")");
        this.out.append("(get" + collectionName);
        this.out.append("(");
        this.writeMethodParams(collectionMethod.getParameters(), true, false);
        this.out.append(")");
        this.out.append(".cast(");
        this.out.append(superCollectionName + ".class");
        this.out.append("))");
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
    }

    protected void writeValueMethod(MethodInfo valueMethod, String valueName, String superValueName) {
        String methodName = "";
        methodName = this.superEn.getBaseEntity() == null ? "getValue" : "get" + superValueName;
        this.out.append(this.tab + "");
        this.out.append("public " + superValueName);
        this.out.append(' ' + methodName);
        this.out.append("(");
        this.writeParams(valueMethod.getParameters());
        this.out.append(") ");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(valueMethod.getBizExceptions());
        this.out.append("\n");
        this.writeBegin();
        this.tabAdd();
        this.out.append(this.tab + "");
        this.out.append("return ");
        this.out.append("(" + superValueName);
        this.out.append(")");
        this.out.append("get" + valueName + '(');
        this.writeMethodParams(valueMethod.getParameters(), true, false);
        this.out.append(")");
        this.out.append(";\n");
        this.tabSub();
        this.writeEnd();
    }

    public MethodCollection getAllClassMethods() {
        this.init();
        MethodCollection methods = (MethodCollection)this.bo.getMethods().clone();
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo method = methods.get(i);
            method.setName(this.getMethodName(method, this.bo));
        }
        if (!(this.bo instanceof EntityObjectInfo)) {
            return methods;
        }
        CodeUtil.addCollectionMethod(this.bo, methods, this.collectionMethods);
        EntityObjectInfo en = (EntityObjectInfo)this.bo;
        if (this.superEn == null) {
            return methods;
        }
        String superCollectionName = this.getClassName(this.superEn.getObjectCollectionClass());
        if (this.collectionMethods != null) {
            MethodCollection superCollectionMethods = (MethodCollection)this.collectionMethods.clone();
            for (int i = 0; i < superCollectionMethods.size(); ++i) {
                MethodInfo superCollectionMethod = superCollectionMethods.get(i);
                String methodName = "";
                methodName = this.superEn.getBaseEntity() == null ? "getCollection" : "get" + superCollectionName;
                superCollectionMethod.setName(methodName);
                methods.add(superCollectionMethod);
            }
        }
        return methods;
    }
}

