/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.code.AbstractBeanCodeWriter;
import com.kingdee.bos.metadata.code.CodeUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;

public class BeanCodeWriter
extends AbstractBeanCodeWriter {
    public BeanCodeWriter(BusinessObjectInfo bo) {
        super(bo);
    }

    @Override
    public String getClassName() {
        return this.bo.getBusinessControllerBean() == null ? "" : this.getClassName(this.bo.getBusinessControllerBean());
    }

    @Override
    protected void initImpMap() {
        super.initImpMap();
        MethodCollection methods = this.getSuperAbstrctMethod();
        this.addMethodImport(methods);
    }

    @Override
    public void write(StringBuffer in) {
        this.init();
        this.initImpMap();
        this.writePackage();
        this.writeClass();
        this.writeBegin();
        this.tabAdd();
        this.writeNormalMethods();
        this.writeMethods();
        this.tabSub();
        this.writeEnd();
    }

    @Override
    protected void writeClass() {
        String subClassMode;
        String string = subClassMode = this.bo.getSubClassingMode() == null ? "" : this.bo.getSubClassingMode().getName();
        if (subClassMode.equalsIgnoreCase("normal")) {
            subClassMode = "";
        }
        this.out.append("public ");
        if (subClassMode.length() > 0) {
            this.out.append(subClassMode + ' ');
        }
        this.out.append("class");
        this.out.append(this.addBlank(this.getClassName()));
        this.out.append("extends" + this.addBlank(super.getClassName()) + '\n');
    }

    @Override
    protected void writeNormalMethods() {
    }

    protected void writeConstructorMethods() {
    }

    @Override
    protected void writeMethods() {
        MethodCollection methods = CodeUtil.addExceptionToMethods(this.bo);
        for (int i = 0; i < methods.size(); ++i) {
            MethodInfo method = methods.get(i);
            if (method.getSubClassingMode().equals((Object)SubClassingMode.ABSTRACT) || this.bo.isSystemMethod(method) || !CodeUtil.isUserDefinedMethod(method)) continue;
            this.writeMethod(method);
        }
        this.writeSuperAbstrctMethod();
    }

    @Override
    protected void writeMethod(MethodInfo method) {
        TypeReference mt = method.getReturnValueType(this.bo);
        this.out.append(this.tab + "protected" + ' ');
        if (method.getDataType().equalsIgnoreCase("ObjectValue")) {
            this.out.append("IObjectValue");
        } else if (method.getDataType().equalsIgnoreCase("ObjectCollection")) {
            this.out.append("IObjectCollection");
        } else {
            this.out.append(this.getClassName(mt.toString()));
        }
        this.out.append(" _" + method.getName());
        this.out.append("(");
        this.writeSuperParams(method.getParameters(), false);
        this.out.append(")");
        this.out.append("throws" + this.addBlank("BOSException"));
        this.writeExceptions(method.getBizExceptions());
        this.out.append("\n");
        this.writeBegin();
        this.tabAdd();
        boolean haveSuperMethod = CodeUtil.containMethodForNormal(this.superMethods, method);
        if (haveSuperMethod) {
            this.out.append(this.tab + "");
            if (!mt.isVoidType()) {
                this.out.append("return ");
            }
            this.out.append("super.");
            this.out.append('_' + method.getName());
            this.out.append("(");
            this.writeMethodParams(method.getParameters(), true, false);
            this.out.append(")");
            this.out.append(";\n");
        } else if (!mt.isVoidType()) {
            this.out.append(this.tab + "");
            this.out.append("return ");
            if (!mt.isSimpleType() || mt.getArrayDimension() != 0) {
                this.out.append("null;\n");
            } else {
                if (mt.toString().equals("byte")) {
                    this.out.append("0");
                } else if (mt.toString().equals("char")) {
                    this.out.append("''");
                } else if (mt.toString().equals("double")) {
                    this.out.append("0.0d");
                } else if (mt.toString().equals("float")) {
                    this.out.append("0.0f");
                } else if (mt.toString().equals("int")) {
                    this.out.append("0");
                } else if (mt.toString().equals("long")) {
                    this.out.append("0");
                } else if (mt.toString().equals("short")) {
                    this.out.append("0");
                } else if (mt.toString().equals("boolean")) {
                    this.out.append("false");
                }
                this.out.append(";\n");
            }
        }
        this.tabSub();
        this.writeEnd();
    }

    private void writeSuperAbstrctMethod() {
        MethodCollection methods = this.getSuperAbstrctMethod();
        if (methods != null) {
            for (int i = 0; i < methods.size(); ++i) {
                MethodInfo method = methods.get(i);
                this.writeMethod(method);
            }
        }
    }

    protected MethodCollection getSuperAbstrctMethod() {
        MethodCollection superAbstrctMethodCollection;
        block7: {
            MethodCollection methods;
            block6: {
                methods = null;
                superAbstrctMethodCollection = new MethodCollection();
                if (!(this.bo instanceof EntityObjectInfo)) break block6;
                EntityObjectInfo en = (EntityObjectInfo)this.bo;
                EntityObjectInfo superEn = null;
                if (en.getBaseEntity() != null) {
                    superEn = en.getBaseEntity();
                    methods = superEn.getMethods();
                }
                if (methods == null) break block7;
                for (int i = 0; i < methods.size(); ++i) {
                    MethodInfo superMethod = methods.get(i);
                    if (superMethod.getSubClassingMode() != SubClassingMode.ABSTRACT || superEn.isSystemMethod(superMethod)) continue;
                    CodeUtil.addExceptionToMethod(superEn, superMethod);
                    superAbstrctMethodCollection.add(superMethod);
                }
                break block7;
            }
            if (this.bo instanceof FacadeInfo) {
                FacadeInfo en = (FacadeInfo)this.bo;
                FacadeInfo superFacade = null;
                if (en.getBaseFacade() != null) {
                    superFacade = en.getBaseFacade();
                    methods = superFacade.getMethods();
                }
                if (methods != null) {
                    for (int i = 0; i < methods.size(); ++i) {
                        MethodInfo superMethod = methods.get(i);
                        if (superMethod.getSubClassingMode() != SubClassingMode.ABSTRACT || superFacade.isSystemMethod(superMethod)) continue;
                        CodeUtil.addExceptionToMethod(this.superEn, superMethod);
                        superAbstrctMethodCollection.add(superMethod);
                    }
                }
            }
        }
        return superAbstrctMethodCollection;
    }
}

