/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IORWException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.code.GenerateFileRecoder;
import com.kingdee.bos.metadata.code.MyJETEmitter;
import com.kingdee.bos.metadata.code.webui.WebCodeFactory;
import com.kingdee.bos.metadata.code.webui.WebUICodeGeneratorHelper;
import com.kingdee.bos.metadata.code.webui.XHTMLGenerator;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectCtrl;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.management.DeployOptionInfo;
import com.kingdee.bos.metadata.management.ISolutionCtrl;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.JoinQueryCtrl;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizExceptionInfo;
import com.kingdee.bos.metadata.resource.ResourceInfo;
import com.kingdee.bos.metadata.ui.ComponentCollection;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.DataObjectCollection;
import com.kingdee.bos.metadata.ui.DataObjectInfo;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.metadata.webui.transfer.Component2XmlHelper;
import com.kingdee.bos.metadata.webui.transfer.WebUIModelMapper;
import com.kingdee.bos.service.netfile.InvalidateNetFileSourceException;
import com.kingdee.bos.service.netfile.NetFile;
import com.kingdee.bos.service.netfile.NetFileFactory;
import com.kingdee.bos.service.netfile.NetFileHelper;
import com.kingdee.bos.service.netfile.NetFileSource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.jet.JETException;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class CodeFactory {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.code.CodeFactory");
    private static NetFileSource fileSrc = null;
    private static NetFileFactory fileFactory = null;
    private static OutputStreamWriter ow = null;
    private static NetFile file = null;
    private static CodeWriterBase iw = null;
    public static boolean isGenRPCCode = false;
    public static boolean genImplementCode = true;
    public static boolean isMBeanDeploy4Webui = false;
    public static final GenerateFileRecoder recorder = new GenerateFileRecoder();

    private CodeFactory() {
    }

    private static void init(String repository, String packageName) throws InvalidateNetFileSourceException, MalformedURLException {
        if (packageName != null && !packageName.equals("")) {
            packageName = packageName.replace('.', File.separatorChar);
            repository = repository + File.separatorChar + packageName;
        }
        fileSrc = new NetFileSource(new File(repository).toURL().toString());
        fileFactory = NetFileHelper.getNetFileFactory((NetFileSource)fileSrc);
        ow = null;
        file = null;
        iw = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStreamToFile(NetFileFactory fileFactory, NetFile file, String fileName, String content, boolean needOverwrite) throws IOException {
        file = fileFactory.createNetFile(fileName);
        if (file.exists()) {
            if (!needOverwrite) {
                return;
            }
            file.delete();
        } else {
            NetFile parent = fileFactory.createNetFile("");
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        OutputStreamWriter ow = null;
        try {
            ow = new OutputStreamWriter(fileFactory.createNetFileOutputStream(file), Charset.forName("GBK"));
            ow.write(content);
            ow.close();
        }
        finally {
            if (ow != null) {
                ow.close();
                ow = null;
            }
        }
    }

    public static void generateCode(Object arg, String pkgName, String repository, String[][] files) throws Exception {
        CodeFactory.init(repository, pkgName);
        for (int i = 0; i < files.length; ++i) {
            try {
                if (files[i] == null || files[i][0] == null || files[i][1] == null) continue;
                if (files[i][2] == null) {
                }
            }
            catch (RuntimeException e) {}
            continue;
            String templateFilePath = files[i][0];
            String generatedText = CodeFactory.generateCodeStr(arg, templateFilePath);
            boolean needOverwrite = new Boolean(files[i][2]);
            CodeFactory.writeStreamToFile(fileFactory, file, files[i][1], generatedText, needOverwrite);
            String fileName = files[i][1];
            if (pkgName != null && !pkgName.equals("")) {
                pkgName = pkgName.replace('.', File.separatorChar);
                fileName = pkgName + File.separatorChar + fileName;
            }
            recorder.fileGenerated(fileName);
        }
    }

    public static String generateCodeStr(Object arg, String templateFilePath) {
        String className = templateFilePath;
        className = className.replaceAll(".javajet", "");
        className = className.replaceAll("_", "");
        className = className.replaceFirst("/", "");
        className = className.replaceAll("/", ".");
        className = className + "Generator";
        className = className.replaceAll(".templates.", ".templates.compiled.");
        Object codeObj = null;
        try {
            Class<?> clsObj = Class.forName(className);
            if (clsObj != null) {
                codeObj = clsObj.newInstance();
            }
        }
        catch (ClassNotFoundException e1) {
        }
        catch (InstantiationException e2) {
        }
        catch (IllegalAccessException e3) {
            // empty catch block
        }
        String generatedText = "no.";
        if (codeObj != null) {
            try {
                Class[] paraTypes = new Class[]{Object.class};
                Object[] paras = new Object[]{arg};
                Method mthd = codeObj.getClass().getMethod("generate", paraTypes);
                Object retObj = mthd.invoke(codeObj, paras);
                if (retObj instanceof String) {
                    generatedText = (String)retObj;
                }
            }
            catch (IllegalAccessException iae) {
                logger.error((Object)"generateCode error", (Throwable)iae);
            }
            catch (NoSuchMethodException nfe) {
                logger.error((Object)"generateCode error", (Throwable)nfe);
            }
            catch (InvocationTargetException ite) {
                logger.error((Object)"generateCode error", (Throwable)ite);
            }
            catch (Throwable t) {
                logger.error((Object)"generateCode error", t);
            }
        } else {
            try {
                String modelUri = CodeFactory.class.getResource(templateFilePath).toString();
                MyJETEmitter emitter = new MyJETEmitter(modelUri);
                emitter.addClasspathVariable("JET_VAR1", "com.kingdee.bos.metadata");
                emitter.addClasspathVariable("JET_VAR2", "com.kingdee.bos.common");
                emitter.addClasspathVariable("JET_VAR3", "com.kingdee.bos.orm");
                emitter.addClasspathVariable("JET_VAR4", "org.log4j");
                NullProgressMonitor moni = new NullProgressMonitor();
                Object[] args = new Object[]{arg};
                generatedText = emitter.generate((IProgressMonitor)moni, args);
            }
            catch (JETException e) {
                logger.error((Object)("generateCode error with " + className));
            }
            catch (Throwable t) {
                logger.error((Object)("generateCode error with " + className));
            }
        }
        return generatedText;
    }

    private static String[][] getEjbCommonFiles1(BusinessObjectInfo bo) {
        String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_ControllerBean.javajet", MetaDataUtils.getClassName(bo.getBusinessControllerBean()), "false"}, {"/com/kingdee/bos/metadata/code/templates/_AbstractControllerBean.javajet", MetaDataUtils.getClassName(bo.getAbstractBusinessControllerBean()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_Controller.javajet", MetaDataUtils.getClassName(bo.getBusinessControllerName()), "true"}};
        for (int i = 0; i < files.length; ++i) {
            String[] stringArray = files[i];
            stringArray[1] = stringArray[1] + ".java";
        }
        if (bo.isStereoType()) {
            return new String[][]{files[0], files[2], {"/com/kingdee/bos/metadata/code/templates/_AbstractControllerBeanST.javajet", MetaDataUtils.getClassName(bo.getAbstractBusinessControllerBean()) + ".java", "true"}};
        }
        if (bo instanceof EntityObjectInfo || bo instanceof FacadeInfo) {
            if (genImplementCode && ConvertUtils.isGenImplementCode(bo)) {
                return files;
            }
            return new String[][]{files[1], files[2]};
        }
        if (genImplementCode) {
            return files;
        }
        return new String[][]{files[1], files[2]};
    }

    private static String[][] getEjbCommonFiles2(BusinessObjectInfo bo) {
        String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_I.javajet", MetaDataUtils.getClassName(bo.getBusinessInterface()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_Proxy.javajet", MetaDataUtils.getClassName(bo.getBusinessImplName()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_Factory.javajet", MetaDataUtils.getClassName(bo.getBusinessImplFactory()), "true"}};
        for (int i = 0; i < files.length; ++i) {
            String[] stringArray = files[i];
            stringArray[1] = stringArray[1] + ".java";
        }
        if (bo.isStereoType()) {
            return new String[0][];
        }
        if (bo instanceof EntityObjectInfo && ((EntityObjectInfo)bo).isAbstract()) {
            if (bo.isGenBusinessImplCode()) {
                return new String[][]{files[0], files[1]};
            }
            return new String[][]{files[0]};
        }
        if (bo.isPIBO()) {
            if (bo.isGenBusinessImplCode()) {
                return new String[][]{files[0], files[1]};
            }
            return new String[][]{files[0]};
        }
        if (bo.isGenBusinessImplCode()) {
            return files;
        }
        return new String[][]{files[0], files[2]};
    }

    private static String[][] getEjbCommonFiles3(BusinessObjectInfo bo) {
        String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_ControllerBeanEx.javajet", MetaDataUtils.getClassName(bo.getBusinessControllerBean()) + "Ex", "false"}};
        for (int i = 0; i < files.length; ++i) {
            String[] stringArray = files[i];
            stringArray[1] = stringArray[1] + ".java";
        }
        return files;
    }

    private static String[][] getEjbCommonFiles4(BusinessObjectInfo bo) {
        String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_ControllerBeanPIEx.javajet", MetaDataUtils.getClassName(bo.getBusinessControllerBean()) + "PIEx", "false"}};
        for (int i = 0; i < files.length; ++i) {
            String[] stringArray = files[i];
            stringArray[1] = stringArray[1] + ".java";
        }
        return files;
    }

    private static String[][] getEntityEjbFiles(EntityObjectInfo entity, boolean isGenAgent) {
        String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_Collection.javajet", MetaDataUtils.getClassName(entity.getObjectCollectionClass()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_Info.javajet", MetaDataUtils.getClassName(entity.getObjectValueClass()), "false"}, {"/com/kingdee/bos/metadata/code/templates/_AbstractInfo.javajet", "Abstract" + MetaDataUtils.getClassName(entity.getObjectValueClass()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_Agent.javajet", MetaDataUtils.getClassName(entity.getBusinessAgent()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_IInfo.javajet", MetaDataUtils.getClassName(entity.getObjectValueClass()), "true"}, {"/com/kingdee/bos/metadata/code/templates/_CollectionAgent.javajet", MetaDataUtils.getClassName(entity.getObjectCollectionAgentClass()), "true"}};
        for (int i = 0; i < files.length; ++i) {
            String[] stringArray = files[i];
            stringArray[1] = stringArray[1] + ".java";
        }
        if (entity.isStereoType()) {
            return new String[][]{files[0], files[4]};
        }
        if (isGenAgent) {
            if (genImplementCode && ConvertUtils.isGenImplementCode(entity)) {
                if (entity.isPIBO()) {
                    return new String[][]{files[1], files[2]};
                }
                return new String[][]{files[0], files[1], files[2], files[3], files[5]};
            }
            if (entity.isPIBO()) {
                return new String[][]{files[2]};
            }
            return new String[][]{files[0], files[2], files[3], files[5]};
        }
        if (genImplementCode && ConvertUtils.isGenImplementCode(entity)) {
            if (entity.isPIBO()) {
                return new String[][]{files[1], files[2]};
            }
            return new String[][]{files[0], files[1], files[2]};
        }
        if (entity.isPIBO()) {
            return new String[][]{files[2]};
        }
        return new String[][]{files[0], files[2]};
    }

    public static void createFacadeCode(Context ctx, int devLevel, String repository, FacadeInfo facade) throws IORWException {
        boolean genBusinessImplCode = facade.isGenBusinessImplCode();
        try {
            DeployOptionInfo deployInfo;
            String fullName = facade.getBusinessImplName();
            String facade_file_name = facade.getFullName() + ".facade";
            DeployOptionInfo deployOptionInfo = deployInfo = ctx == null ? null : (DeployOptionInfo)ctx.get((Object)"deployOptionInfo");
            if (deployInfo == null || deployInfo.isDeployInterfaceCode(facade_file_name)) {
                if (deployInfo != null) {
                    facade.setGenBusinessImplCode(false);
                }
                CodeFactory.generateCode(facade, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles2(facade));
            }
            if (deployInfo != null && !deployInfo.isDeployAppImplCode(facade_file_name)) {
                return;
            }
            if (deployInfo != null) {
                facade.setGenBusinessImplCode(true);
                String[][] files = CodeFactory.getEjbCommonFiles2(facade);
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i][1].equals(MetaDataUtils.getClassName(facade.getBusinessImplName()) + ".java")) continue;
                    String[][] newfiles = new String[][]{files[i]};
                    CodeFactory.generateCode(facade, MetaDataUtils.getPackageName(fullName), repository, newfiles);
                    break;
                }
            }
            fullName = facade.getBusinessControllerName() != null && facade.getBusinessControllerName().length() != 0 ? facade.getBusinessControllerName() : facade.getBusinessImplName();
            CodeFactory.generateCode(facade, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles1(facade));
            if (genImplementCode && facade.isPIBO() && devLevel == 1) {
                CodeFactory.generateCode(facade, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles4(facade));
            }
            if (genImplementCode && !StringUtils.isEmpty((String)facade.getExtendedProperty("controllerBeanEx"))) {
                CodeFactory.generateCode(facade, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles3(facade));
            }
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
        finally {
            facade.setGenBusinessImplCode(genBusinessImplCode);
        }
    }

    public static void createEntityCode(Context ctx, int devLevel, String repository, EntityObjectInfo entity) throws IORWException {
        CodeFactory.createEntityCode(ctx, devLevel, repository, entity, false);
    }

    public static void createEntityCode(Context ctx, int devLevel, String repository, EntityObjectInfo entity, boolean isGenAgent) throws IORWException {
        boolean genBusinessImplCode = entity.isGenBusinessImplCode();
        try {
            DeployOptionInfo deployInfo;
            String fullName = entity.getBusinessImplName();
            String entity_file_name = entity.getFullName() + ".entity";
            DeployOptionInfo deployOptionInfo = deployInfo = ctx == null ? null : (DeployOptionInfo)ctx.get((Object)"deployOptionInfo");
            if (deployInfo == null || deployInfo.isDeployValueInfoCode(entity_file_name)) {
                CodeFactory.generateCode(entity, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEntityEjbFiles(entity, isGenAgent));
            }
            if (entity.getBusinessControllerName() != null && entity.getBusinessControllerName().length() > 0) {
                if (deployInfo == null || deployInfo.isDeployInterfaceCode(entity_file_name)) {
                    if (deployInfo != null) {
                        entity.setGenBusinessImplCode(false);
                    }
                    CodeFactory.generateCode(entity, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles2(entity));
                }
                if (deployInfo != null && !deployInfo.isDeployAppImplCode(entity_file_name)) {
                    return;
                }
                if (deployInfo != null) {
                    entity.setGenBusinessImplCode(genBusinessImplCode);
                    String[][] files = CodeFactory.getEjbCommonFiles2(entity);
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i][1].equals(MetaDataUtils.getClassName(entity.getBusinessImplName()) + ".java")) continue;
                        String[][] newfiles = new String[][]{files[i]};
                        CodeFactory.generateCode(entity, MetaDataUtils.getPackageName(fullName), repository, newfiles);
                        break;
                    }
                }
                fullName = entity.getBusinessControllerName() != null && entity.getBusinessControllerName().length() != 0 ? entity.getBusinessControllerName() : entity.getBusinessImplName();
                CodeFactory.generateCode(entity, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles1(entity));
                if (genImplementCode && entity.isPIBO() && devLevel == 1) {
                    CodeFactory.generateCode(entity, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles4(entity));
                }
                if (genImplementCode && !StringUtils.isEmpty((String)entity.getExtendedProperty("controllerBeanEx"))) {
                    CodeFactory.generateCode(entity, MetaDataUtils.getPackageName(fullName), repository, CodeFactory.getEjbCommonFiles3(entity));
                }
            }
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
        finally {
            entity.setGenBusinessImplCode(genBusinessImplCode);
        }
    }

    public static void createExceptionCode(Context ctx, String repository, BizExceptionInfo bizExceptionInfo) throws IORWException {
        try {
            String fullName = bizExceptionInfo.getClassName();
            String className = MetaDataUtils.getClassName(fullName);
            String packageName = MetaDataUtils.getPackageName(fullName);
            String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_ExceptionCode.javajet", className + ".java", "true"}};
            CodeFactory.generateCode(bizExceptionInfo, packageName, repository, files);
            SolutionInfo solution = CodeFactory.getSolution(ctx);
            LanguageCollection langs = solution.getLanguages();
            Locale defaultLocale = solution.getDefaultLanguage().getOriginalLocale();
            Object[] args = new Object[]{bizExceptionInfo, null, defaultLocale};
            files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_ExceptionResource.javajet", className + ".properties", "true"}};
            CodeFactory.generateCode(args, packageName, repository, files);
            int n = langs.size();
            for (int i = 0; i < n; ++i) {
                LanguageInfo lang = langs.get(i);
                lang.setDefaultLocale(defaultLocale);
                args[1] = lang.getOriginalLocale();
                files[0][1] = className + "_" + BOSLocaleUtil.getShortCode(lang.getOriginalLocale()) + ".properties";
                CodeFactory.generateCode(args, packageName, repository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
    }

    public static boolean generateSpecialResource(ComponentInfo component, PropertyInfo property, Properties p, Locale locale) {
        if ("items".equals(property.getName()) && ("com.kingdee.bos.ctrl.web.ComboBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.CheckBoxGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioGroup".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.ListBox".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.RadioMenuItem".equals(component.getClassType()))) {
            ArrayList list = new ArrayList();
            Properties props = new Properties();
            String v = property.getValue(locale);
            if (StringUtils.isEmpty((String)v)) {
                return true;
            }
            Component2XmlHelper.string2KeyPairs(v, list, props);
            for (String key : list) {
                String value = props.getProperty(key);
                String propKey = component.getName() + "." + property.getName() + "." + key;
                p.setProperty(propKey, value);
            }
            return true;
        }
        return "com.kingdee.bos.ctrl.web.UserTag".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.VisualUserTag".equals(component.getClassType());
    }

    public static void createCommonWebUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, boolean inherit) throws IORWException {
        try {
            String packageName = model.getReleasePackage();
            String className = model.getReleaseClass() + "Bean";
            String fullClassName = packageName + "." + className;
            String rootUrl = WebUICodeGeneratorHelper.rootUrl(packageName);
            String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractWebUI.javajet", "Abstract" + className + ".java", "true"}, {"/com/kingdee/bos/metadata/code/templates/_WebUI.javajet", className + ".java", "false"}};
            CodeFactory.generateCode(new Object[]{model, inherit}, packageName, javaRepository, files);
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            Properties[] langProperties = new Properties[locales.length];
            int n = locales.length;
            for (int k = 0; k < n; ++k) {
                langProperties[k] = new Properties();
            }
            ComponentCollection col = WebUICodeGeneratorHelper.allComponents(model);
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                ComponentInfo component = col.get(i);
                int size = component.getProperties().size();
                for (int j = 0; j < size; ++j) {
                    PropertyInfo p = component.getProperties().get(j);
                    if (!p.isMultiLanguage()) continue;
                    for (int k = 0; k < locales.length; ++k) {
                        if (CodeFactory.generateSpecialResource(component, p, langProperties[k], locales[k])) continue;
                        String key = component.getName() + "." + p.getName();
                        String value = p.getValue(locales[k]);
                        if (value == null) {
                            value = "";
                        }
                        langProperties[k].setProperty(key, value);
                    }
                }
            }
            int n2 = locales.length;
            for (int i = 0; i < n2; ++i) {
                String shortCode = BOSLocaleUtil.getShortCode(locales[i]);
                if (StringUtils.isEmpty((String)shortCode)) continue;
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", className + "_" + shortCode + ".properties", "true"}};
                CodeFactory.generateCode(new Object[]{langProperties[i]}, packageName, javaRepository, files);
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", className + "_User_" + shortCode + ".properties", "false"}};
                CodeFactory.generateCode(new Object[]{new Properties()}, packageName, javaRepository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e.getMessage(), e);
        }
    }

    public static void createWebEditUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, IMetaDataPK entityPK, boolean inherit) throws IORWException {
        EntityObjectInfo entityInfo = null;
        try {
            entityInfo = new EntityObjectCtrl(ctx).getValue(entityPK);
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
        PropertyCollection col = entityInfo.getInheritedProperties();
        ArrayList<String> list = new ArrayList<String>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            LinkPropertyInfo link;
            com.kingdee.bos.metadata.entity.PropertyInfo p = col.get(i);
            if (!(p instanceof LinkPropertyInfo) || !(link = (LinkPropertyInfo)p).getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_UNBOUNDED) && !link.getRelationship().getSupplierCardinality().equals((Object)CardinalityType.ONE_TO_UNBOUNDED)) continue;
            list.add(link.getName());
        }
        String[] strs = new String[list.size()];
        list.toArray(strs);
        CodeFactory.createWebEditUICode(ctx, javaRepository, pageRepository, model, entityPK, strs, inherit);
    }

    public static void createWebEditUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, IMetaDataPK entityPK, String[] entries, boolean inherit) throws IORWException {
        try {
            EntityObjectInfo entityInfo = null;
            try {
                entityInfo = new EntityObjectCtrl(ctx).getValue(entityPK);
            }
            catch (Exception e) {
                throw new IORWException(e);
            }
            String packageName = model.getReleasePackage();
            String className = model.getReleaseClass() + "Bean";
            String fullClassName = packageName + "." + className;
            String rootUrl = WebUICodeGeneratorHelper.rootUrl(packageName);
            List list = WebUICodeGeneratorHelper.getEntityPropertyList(ctx, entityInfo);
            String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractWebEditUI.javajet", "Abstract" + className + ".java", "true"}, {"/com/kingdee/bos/metadata/code/templates/_WebEditUI.javajet", className + ".java", "false"}};
            CodeFactory.generateCode(new Object[]{entityInfo, entries, list, model, inherit}, packageName, javaRepository, files);
            for (int i = 0; i < entries.length; ++i) {
                String entry = entries[i];
                EntityObjectInfo childInfo = WebUICodeGeneratorHelper.getOne2ManyEntryType(entityInfo, entry);
                if (childInfo == null) {
                    logger.info((Object)("can not found EntityObjectInfo named '" + entry + "'"));
                    continue;
                }
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractWebUIEntry.javajet", "Abstract" + childInfo.getName() + "Bean.java", "true"}, {"/com/kingdee/bos/metadata/code/templates/_WebUIEntry.javajet", childInfo.getName() + "Bean.java", "false"}};
                CodeFactory.generateCode(new Object[]{entityInfo, entry, model}, packageName, javaRepository, files);
            }
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            Properties[] langProperties = new Properties[locales.length];
            int n = locales.length;
            for (int k = 0; k < n; ++k) {
                langProperties[k] = new Properties();
            }
            ComponentCollection col = WebUICodeGeneratorHelper.allComponents(model);
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                ComponentInfo component = col.get(i);
                int size = component.getProperties().size();
                for (int j = 0; j < size; ++j) {
                    PropertyInfo p = component.getProperties().get(j);
                    if (!p.isMultiLanguage()) continue;
                    for (int k = 0; k < locales.length; ++k) {
                        if (CodeFactory.generateSpecialResource(component, p, langProperties[k], locales[k])) continue;
                        String key = component.getName() + "." + p.getName();
                        String value = p.getValue(locales[k]);
                        if (value == null) {
                            value = "";
                        }
                        langProperties[k].setProperty(key, value);
                    }
                }
            }
            int n2 = locales.length;
            for (int i = 0; i < n2; ++i) {
                String shortCode = BOSLocaleUtil.getShortCode(locales[i]);
                if (StringUtils.isEmpty((String)shortCode)) continue;
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", className + "_" + shortCode + ".properties", "true"}};
                CodeFactory.generateCode(new Object[]{langProperties[i]}, packageName, javaRepository, files);
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", className + "_User_" + shortCode + ".properties", "false"}};
                CodeFactory.generateCode(new Object[]{new Properties()}, packageName, javaRepository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e.getMessage(), e);
        }
    }

    public static void createWebListUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model, IMetaDataPK queryPK, boolean inherit) throws IORWException {
        try {
            JoinQueryInfo info = null;
            try {
                info = new JoinQueryCtrl(ctx).getValue(queryPK);
            }
            catch (Exception e) {
                throw new IORWException(e);
            }
            SubObjectInfo subObject = info.getMainObject();
            while (subObject instanceof SubQueryInfo) {
                SubQueryInfo subQuery = (SubQueryInfo)subObject;
                subObject = subQuery.getQueryRef().getMainObject();
            }
            SubEntityInfo subEntity = (SubEntityInfo)subObject;
            EntityObjectInfo entityInfo = subEntity.getEntityRef();
            String packageName = model.getReleasePackage();
            String className = model.getReleaseClass() + "Bean";
            JoinQueryInfo query = WebUICodeGeneratorHelper.getQueryFieldByPK(ctx, queryPK);
            String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractWebListUI.javajet", "Abstract" + className + ".java", "true"}, {"/com/kingdee/bos/metadata/code/templates/_WebListUI.javajet", className + ".java", "false"}};
            CodeFactory.generateCode(new Object[]{entityInfo, queryPK, model, inherit, query}, packageName, javaRepository, files);
            Locale[] locales = BOSLocaleUtil.getSupportedOriginLocales();
            Properties[] langProperties = new Properties[locales.length];
            int n = locales.length;
            for (int k = 0; k < n; ++k) {
                langProperties[k] = new Properties();
            }
            ComponentCollection col = WebUICodeGeneratorHelper.allComponents(model);
            int count = col.size();
            for (int i = 0; i < count; ++i) {
                ComponentInfo component = col.get(i);
                int size = component.getProperties().size();
                for (int j = 0; j < size; ++j) {
                    PropertyInfo p = component.getProperties().get(j);
                    if (!p.isMultiLanguage()) continue;
                    for (int k = 0; k < locales.length; ++k) {
                        if (CodeFactory.generateSpecialResource(component, p, langProperties[k], locales[k])) continue;
                        String key = component.getName() + "." + p.getName();
                        String value = p.getValue(locales[k]);
                        if (value == null) {
                            value = "";
                        }
                        langProperties[k].setProperty(key, value);
                    }
                }
            }
            int n2 = locales.length;
            for (int i = 0; i < n2; ++i) {
                String shortCode = BOSLocaleUtil.getShortCode(locales[i]);
                if (StringUtils.isEmpty((String)shortCode)) continue;
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", className + "_" + shortCode + ".properties", "true"}};
                CodeFactory.generateCode(new Object[]{langProperties[i]}, packageName, javaRepository, files);
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_WebUIResource.javajet", className + "_User_" + shortCode + ".properties", "false"}};
                CodeFactory.generateCode(new Object[]{new Properties()}, packageName, javaRepository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e.getMessage(), e);
        }
    }

    public static boolean isWebListUIGrid(WebUIObjectInfo model, ComponentInfo cInfo) {
        if (cInfo != null && CodeFactory.isInheritListUI(model) && "com.kingdee.bos.ctrl.web.DataGrid".equals(cInfo.getClassType())) {
            com.kingdee.bos.metadata.ui.PropertyCollection properties = cInfo.getProperties();
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                String value;
                if (!"binding".equals(properties.get(i).getName())) continue;
                if (!CodeFactory.isEL(properties.get(i).getValue()) || !(value = properties.get(i).getValue()).trim().endsWith(".grid}")) break;
                return true;
            }
        }
        return false;
    }

    private static boolean isInheritListUI(WebUIObjectInfo model) {
        if (model != null) {
            while (model.getParent() != null) {
                model = model.getParent();
            }
            if ("com.kingdee.eas.framework.web.ListUI".equals(model.getFullName())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isEL(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return str.startsWith("#{") && str.endsWith("}");
    }

    public static String toAppPackage(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return "";
        }
        if (packageName.indexOf(".client") >= 0) {
            return StringUtils.replace((String)packageName, (String)".client", (String)".app");
        }
        return packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateXHTML(Document doc, String pkgName, String repository, String fileName) throws Exception {
        CodeFactory.init(repository, pkgName);
        boolean needOverwrite = true;
        file = fileFactory.createNetFile(fileName);
        if (file.exists()) {
            if (!needOverwrite) {
                return;
            }
            file.delete();
        } else {
            NetFile parent = fileFactory.createNetFile("");
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        XMLOutputter output = new XMLOutputter();
        OutputStream os = null;
        try {
            os = fileFactory.createNetFileOutputStream(file);
            output.setOmitDeclaration(true);
            output.setNewlines(true);
            output.setIndent("\t");
            output.output(doc, os);
            os.close();
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
        }
        String fileName1 = fileName;
        if (pkgName != null && !pkgName.equals("")) {
            pkgName = pkgName.replace('.', File.separatorChar);
            fileName1 = pkgName + File.separatorChar + fileName1;
        }
        recorder.fileGenerated(fileName1);
    }

    public static String getWebUIShortPackage(String packageName) {
        if (StringUtils.isEmpty((String)packageName)) {
            return packageName;
        }
        String shortName = packageName;
        if (shortName.startsWith("com.kingdee.eas.")) {
            shortName = shortName.substring("com.kingdee.eas.".length());
        }
        if (shortName.endsWith(".web")) {
            shortName = shortName.substring(0, shortName.length() - ".web".length());
        }
        return shortName;
    }

    public static String getParentReleaseClass(WebUIObjectInfo model) {
        if (model != null && model.getParent() != null) {
            WebUIObjectInfo parent = model.getParent();
            if (!StringUtils.isEmpty((String)parent.getReleasePackage())) {
                return parent.getReleasePackage() + "." + parent.getReleaseClass() + "Bean";
            }
            return parent.getReleaseClass() + "Bean";
        }
        return null;
    }

    public static boolean isWebEditUI(WebUIObjectInfo model) {
        if (model == null) {
            return false;
        }
        for (WebUIObjectInfo temp = model; temp != null; temp = temp.getParent()) {
            if (!WebUIModelMapper.BaseEditUI.getFullName().equals(temp.getFullName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isWebListUI(WebUIObjectInfo model) {
        if (model == null) {
            return false;
        }
        for (WebUIObjectInfo temp = model; temp != null; temp = temp.getParent()) {
            if (!WebUIModelMapper.BaseListUI.getFullName().equals(temp.getFullName())) continue;
            return true;
        }
        return false;
    }

    public static void createWebUICode(Context ctx, String javaRepository, String pageRepository, WebUIObjectInfo model) throws IORWException {
        if (isMBeanDeploy4Webui) {
            WebCodeFactory.createWebUICode(ctx, javaRepository, pageRepository, model);
            return;
        }
        XHTMLGenerator generator = new XHTMLGenerator(model);
        Document doc = generator.generate();
        String fileName = StringUtils.headCharLowerCase((String)model.getReleaseClass()) + ".xhtml";
        String packageName = model.getReleasePackage();
        try {
            CodeFactory.generateXHTML(doc, CodeFactory.getWebUIShortPackage(packageName), pageRepository, fileName);
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
        DataObjectCollection dataCol = model.getDataObjects();
        if (dataCol.size() > 0) {
            DataObjectInfo dataObj = dataCol.get(0);
            boolean inherit = dataObj.isHerited();
            if ("enty".equals(dataObj.getObjectType())) {
                if (CodeFactory.isWebEditUI(model)) {
                    CodeFactory.createWebEditUICode(ctx, javaRepository, null, model, new MetaDataPK(dataObj.getType()), inherit);
                } else {
                    CodeFactory.createCommonWebUICode(ctx, javaRepository, null, model, inherit);
                }
            } else if ("jqye".equals(dataObj.getObjectType())) {
                if (CodeFactory.isWebListUI(model)) {
                    CodeFactory.createWebListUICode(ctx, javaRepository, null, model, new MetaDataPK(dataObj.getType()), inherit);
                } else {
                    CodeFactory.createCommonWebUICode(ctx, javaRepository, null, model, inherit);
                }
            }
        } else {
            CodeFactory.createCommonWebUICode(ctx, javaRepository, null, model, false);
        }
    }

    public static void createUICode(int devLevel, Context ctx, String repository, UIObjectInfo model) throws IORWException {
        try {
            String packageName = "";
            if (model.getReleasePackage() != null) {
                packageName = model.getReleasePackage();
            }
            String className = model.getReleaseClass();
            String[][] files = null;
            files = model.isUIPNavigable() ? new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractUICode.javajet", "Abstract" + className + ".java", "true"}, {"/com/kingdee/bos/metadata/code/templates/_AbstractUIController.javajet", "Abstract" + className + "Controller.java", "true"}} : new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractUICode.javajet", "Abstract" + className + ".java", "true"}};
            long startTime = System.currentTimeMillis();
            CodeFactory.generateCode(model, packageName, repository, files);
            if (isGenRPCCode) {
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_AbstractUIHandlerCode.javajet", "Abstract" + className + "Handler.java", "true"}};
                CodeFactory.generateCode(model, CodeFactory.toAppPackage(packageName), repository, files);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u751f\u6210UI\u62bd\u8c61\u7c7b" + className + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
                startTime = System.currentTimeMillis();
            }
            if (isGenRPCCode && genImplementCode && ConvertUtils.isGenImplementCode(model)) {
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_UIHandlerCode.javajet", className + "Handler.java", "false"}};
                CodeFactory.generateCode(model, CodeFactory.toAppPackage(packageName), repository, files);
            }
            Object[] args = new Object[]{model, null, null};
            files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_UIResource.javajet", "Abstract" + className + ".properties", "true"}};
            CodeFactory.generateCode(args, packageName, repository, files);
            SolutionInfo solution = CodeFactory.getSolution(ctx);
            LanguageCollection langs = solution.getLanguages();
            Locale defaultLocale = solution.getDefaultLanguage().getOriginalLocale();
            int length = langs.size();
            int n = length;
            for (int i = 0; i < n; ++i) {
                args[1] = langs.get(i).getOriginalLocale();
                args[2] = defaultLocale;
                files[0][1] = "Abstract" + className + "_" + BOSLocaleUtil.getShortCode(langs.get(i).getOriginalLocale()) + ".properties";
                CodeFactory.generateCode(args, packageName, repository, files);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u751f\u6210UI\u62bd\u8c61\u7c7b" + className + "\u7684property\u6587\u4ef6\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
                startTime = System.currentTimeMillis();
            }
            if (genImplementCode && ConvertUtils.isGenImplementCode(model)) {
                files = model.isUIPNavigable() ? new String[][]{{"/com/kingdee/bos/metadata/code/templates/_UICode.javajet", className + ".java", "false"}, {"/com/kingdee/bos/metadata/code/templates/_UIController.javajet", className + "Controller.java", "false"}} : new String[][]{{"/com/kingdee/bos/metadata/code/templates/_UICode.javajet", className + ".java", "false"}};
                CodeFactory.generateCode(model, packageName, repository, files);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u751f\u6210UI\u7684\u975e\u62bd\u8c61\u7c7b" + className + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
                    startTime = System.currentTimeMillis();
                }
            }
            if (genImplementCode && model.isPIUI() && devLevel == 1) {
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_UICodePIEx.javajet", className + "PIEx.java", "false"}};
                CodeFactory.generateCode(model, packageName, repository, files);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u4e3aBIM\u751f\u6210UI\u7684\u884c\u4e1a\u7248UI" + className + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
                    startTime = System.currentTimeMillis();
                }
            }
            if ("EditUI".equalsIgnoreCase(ConvertUtils.getBimUIType(model.getBizUnitPK(), model.getFullName())) && "MBillBase".equalsIgnoreCase(ConvertUtils.getBimTemplateType(model.getBizUnitPK()))) {
                files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_HMDUICode.javajet", StringUtils.replace((String)model.getReleaseClass(), (String)"EditUI", (String)"") + "HMD" + ".java", "true"}};
                CodeFactory.generateCode(model, packageName, repository, files);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u4e3aBIM\u751f\u6210UI\u7684HMD\u7c7b\u578bUI" + className + "\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime)));
                    startTime = System.currentTimeMillis();
                }
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (InvalidateNetFileSourceException e) {
            throw new IORWException(e);
        }
        catch (MalformedURLException e) {
            throw new IORWException(e);
        }
        catch (IOException e) {
            throw new IORWException(e);
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
    }

    public static void createEnumCode(Context ctx, String repository, BizEnumInfo bizEnumInfo) throws IORWException {
        try {
            String fullName = bizEnumInfo.getClassName();
            String className = MetaDataUtils.getClassName(fullName);
            String packageName = MetaDataUtils.getPackageName(fullName);
            String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_EnumCode.javajet", className + ".java", "true"}};
            CodeFactory.generateCode(bizEnumInfo, packageName, repository, files);
            SolutionInfo solution = CodeFactory.getSolution(ctx);
            LanguageCollection langs = solution.getLanguages();
            Locale defaultLocale = solution.getDefaultLanguage().getOriginalLocale();
            Object[] args = new Object[]{bizEnumInfo, null, defaultLocale};
            files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_EnumResource.javajet", className + ".properties", "true"}};
            CodeFactory.generateCode(args, packageName, repository, files);
            int length = langs.size();
            int n = length;
            for (int i = 0; i < n; ++i) {
                LanguageInfo lang = langs.get(i);
                lang.setDefaultLocale(defaultLocale);
                args[1] = lang.getOriginalLocale();
                files[0][1] = className + "_" + BOSLocaleUtil.getShortCode(lang.getOriginalLocale()) + ".properties";
                CodeFactory.generateCode(args, packageName, repository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
    }

    private static SolutionInfo getSolution(Context ctx) throws IORWException {
        ISolutionCtrl ctrl = null;
        try {
            ctrl = (ISolutionCtrl)BOSObjectFactory.createBOSObject(ctx, MetaDataTypeList.SOLUTION);
            if (ctrl != null) {
                return ctrl.getValue();
            }
            return null;
        }
        catch (BOSException bose) {
            throw new IORWException(bose);
        }
    }

    public static void createMultiLanguageResoure(Context ctx, String repository, ResourceInfo multiInfo) throws IORWException {
        try {
            SolutionInfo solution = CodeFactory.getSolution(ctx);
            LanguageCollection langs = solution.getLanguages();
            Locale defaultLocale = solution.getDefaultLanguage().getOriginalLocale();
            String fullName = multiInfo.getClassName();
            String className = MetaDataUtils.getClassName(fullName);
            String packageName = MetaDataUtils.getPackageName(fullName);
            Object[] args = new Object[]{multiInfo, null, defaultLocale};
            String[][] files = new String[][]{{"/com/kingdee/bos/metadata/code/templates/_MultiLanguage.javajet", className + ".properties", "true"}};
            CodeFactory.generateCode(args, packageName, repository, files);
            int length = langs.size();
            int n = length;
            for (int i = 0; i < n; ++i) {
                LanguageInfo lang = langs.get(i);
                lang.setDefaultLocale(defaultLocale);
                args[1] = lang.getOriginalLocale();
                files[0][1] = className + "_" + BOSLocaleUtil.getShortCode(lang.getOriginalLocale()) + ".properties";
                CodeFactory.generateCode(args, packageName, repository, files);
            }
        }
        catch (IORWException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IORWException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStream(NetFileFactory fileFactory, NetFile file, OutputStreamWriter ow, CodeWriterBase iw, boolean needOverwrite) throws IOException {
        file = fileFactory.createNetFile(fileSrc.getLocalFilePath());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (StringUtils.isEmpty((String)iw.getClassName())) {
            return;
        }
        file = fileFactory.createNetFile(iw.getClassName() + iw.getSuffix());
        if (file.exists()) {
            if (!needOverwrite) {
                return;
            }
            file.delete();
        }
        try {
            ow = iw.getSuffix().equalsIgnoreCase(".properties") ? new OutputStreamWriter(fileFactory.createNetFileOutputStream(file), "8859_1") : new OutputStreamWriter(fileFactory.createNetFileOutputStream(file), Charset.forName("GBK"));
            ow.write(iw.write().toString());
            ow.close();
        }
        finally {
            if (ow != null) {
                ow.close();
                ow = null;
            }
        }
    }

    public static GenerateFileRecoder getRecorder() {
        return recorder;
    }

    public static void setGenRPCCode(boolean isGenRPCCode) {
        CodeFactory.isGenRPCCode = isGenRPCCode;
    }

    public static boolean isGenImplementCode() {
        return genImplementCode;
    }

    public static void setGenImplementCode(boolean genImplementCode) {
        CodeFactory.genImplementCode = genImplementCode;
    }

    public static void setMBeanDeploy4Webui(boolean isMBeanDeploy4Webui) {
        CodeFactory.isMBeanDeploy4Webui = isMBeanDeploy4Webui;
    }
}

