/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.SubClassingMode;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.util.StringUtils;

public abstract class CodeWriterBase {
    protected static final char CLF = '\n';
    protected static final char SEI = ';';
    protected static final char QUT = '\"';
    protected static final char LBR = '{';
    protected static final char RBR = '}';
    protected static final char LCR = '(';
    protected static final char RCR = ')';
    protected static final char DOT = '.';
    protected static final char EQLS = '=';
    protected static final char COMMA = ',';
    protected static final char BLANK = ' ';
    protected static final char UNDERLINE = '_';
    protected static final String KEY_PACAKAGE = "package";
    protected static final String KEY_CLASS = "class";
    protected static final String KEY_INTERFACE = "interface";
    protected static final String KEY_ABSTRACT = "abstract";
    protected static final String KEY_VOID = "void";
    protected static final String KEY_IMPORT = "import";
    protected static final String KEY_EXTENDS = "extends";
    protected static final String KEY_IMPLEMENTS = "implements";
    protected static final String KEY_RETURN = "return";
    protected static final String KEY_NEW = "new";
    protected static final String KEY_THROW = "throw";
    protected static final String KEY_THROWS = "throws";
    protected static final String KEY_TRY = "try";
    protected static final String KEY_CATCH = "catch";
    protected static final String KEY_FINALLY = "finally";
    protected static final String KEY_NORMAL = "normal";
    protected static final String KEY_PUBLIC = "public";
    protected static final String KEY_PRIVATE = "private";
    protected static final String KEY_PROTECTED = "protected";
    protected static final String KEY_STATIC = "static";
    protected static final String KEY_FINAL = "final";
    protected static final String KEY_SUPER = "super";
    protected static final String KEY_THIS = "this";
    protected static final String KEY_INT = "int";
    protected static final String KEY_NUMERICEXCEPTIONSUBITEM = "NumericExceptionSubItem";
    protected String tab = "";
    protected StringBuffer out = null;
    public int tabLength = 4;
    protected static final String BASE_EXCEPTION = "BOSException";
    protected static final String REMOTE_EXCEPTION = "RemoteException";
    protected static final String EJB_EXCEPTION = "EJBRemoteException";
    protected static final String KEY_INFO = "info";
    protected static final String KEY_KEY = "key";
    protected static final String KEY_IOBJECTPK = "IObjectPK";
    protected static final String KEY_OBJECTPK = "IObjectPK";
    protected static final String KEY_IMETADATAPK = "IMetaDataPK";
    protected static final String KEY_METADATAPK = "MetaDataPK";
    protected static final String KEY_STRING = "String";
    protected static final String KEY_GET = "get";
    protected static final String KEY_SET = "set";
    protected static final String KEY_LOCAL = "Locale";
    protected static final String KEY_ADD = "add";
    protected static final String KEY_ADDCOLLECTION = "addCollection";
    protected static final String KEY_REMOVE = "remove";
    protected static final String KEY_CONTAINS = "contains";
    protected static final String KEY_INDEXOF = "indexOf";
    protected static final String KEY_ITEM = "item";
    protected static final String KEY_INDEX = "index";
    protected static final String KEY_IBIZCTRL = "IBizCtrl";
    protected static final String KEY_BIZCONTROLLER = "BizController";
    protected static final String KEY_IMETADATACTRL = "IMetaDataCtrl";
    protected static final String KEY_ABSTRACTBIZCTRL = "AbstractBizCtrl";
    protected static final String KEY_ABSTRACTBIZCONTROLLERBEAN = "AbstractBizControllerBean";
    protected static final String KEY_ABSTRACTENTITYCONTROLLERBEAN = "AbstractEntityControllerBean";
    private static final String ValueMethod = "getValue";
    private static final String CollectionMethod = "getCollection";
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    protected String suffix = ".java";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public CodeWriterBase() {
        this.out = new StringBuffer();
    }

    public String getProxyType() {
        return "Remote";
    }

    public CodeWriterBase(StringBuffer out) {
        this.out = out;
    }

    protected String upcastName(String name) {
        if (name.length() == 0) {
            return "";
        }
        name = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        return name;
    }

    protected String locastName(String name) {
        if (name == null || "".equals(name)) {
            return name;
        }
        String headChar = name.substring(0, 1).toLowerCase();
        if (name.length() == 1) {
            return headChar;
        }
        return headChar + name.substring(1, name.length());
    }

    protected String addBlank(String item) {
        if (item == null) {
            item = "";
        }
        item = " " + item + " ";
        return item;
    }

    protected String addMark(String item) {
        item = "\"" + item + "\"";
        return item;
    }

    protected String addBracket(String item, String param) {
        item = item + '(' + param + ')' + '\n';
        return item;
    }

    protected String addBracketMethod(String item, String param) {
        item = item + '(' + param + ')';
        return item;
    }

    protected void tabAdd() {
        char[] cs = new char[this.tabLength];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = 32;
        }
        this.tab = this.tab + new String(cs);
    }

    protected void tabSub() {
        int le = this.tab.length() - this.tabLength;
        this.tab = this.tab.substring(0, le < 0 ? 0 : le);
    }

    protected void writeBegin() {
        this.out.append(this.tab + '{' + '\n');
    }

    protected void writeEnd() {
        this.out.append(this.tab + '}' + '\n');
    }

    protected String writeNote(String des, String[] params, String ret) {
        StringBuffer note = new StringBuffer();
        note.append(this.tab + "/**" + '\n');
        note.append(this.tab + " * " + des + '\n');
        for (int i = 0; i < params.length; ++i) {
            note.append(this.tab + " * @param " + params[i] + '\n');
        }
        if (ret.length() != 0) {
            note.append(this.tab + " * @return " + ret);
        }
        note.append(this.tab + " */" + '\n');
        return note.toString();
    }

    protected String getClassName(String fullName) {
        return MetaDataUtils.getClassName(fullName);
    }

    protected abstract String getClassName();

    protected String getPackageName(String fullName) {
        return MetaDataUtils.getPackageName(fullName);
    }

    public abstract void write(StringBuffer var1);

    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }

    public String getSuffix() {
        return this.suffix;
    }

    protected String saveConvert(String theString, boolean escapeSpace) {
        if (StringUtils.isEmpty((String)theString)) {
            return "";
        }
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(CodeWriterBase.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(CodeWriterBase.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(CodeWriterBase.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(CodeWriterBase.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    protected boolean isValue(String methodName) {
        return methodName.equals(ValueMethod);
    }

    protected boolean isCollection(String methodName) {
        return methodName.equals(CollectionMethod);
    }

    protected String getMethodName(MethodInfo method, BusinessObjectInfo bo) {
        String name = method.getName();
        if (bo instanceof EntityObjectInfo && bo.isSystemMethod(method) && (this.isValue(name) || this.isCollection(name))) {
            EntityObjectInfo parent = (EntityObjectInfo)bo;
            if ((parent = parent.getBaseEntity()) != null) {
                if (this.isCollection(name)) {
                    return KEY_GET + this.getClassName(((EntityObjectInfo)bo).getObjectCollectionClass());
                }
                return KEY_GET + this.getClassName(((EntityObjectInfo)bo).getObjectValueClass());
            }
        }
        return name;
    }

    protected String getSubClassMode(MethodInfo method) {
        String subClassMode = "";
        if (method.getSubClassingMode() != null && !method.getSubClassingMode().equals((Object)SubClassingMode.NORMAL)) {
            subClassMode = method.getSubClassingMode().getName();
        }
        return subClassMode;
    }

    protected boolean isClass(String type) {
        boolean rv = !type.equalsIgnoreCase("boolean") && !type.equalsIgnoreCase("char") && !type.equalsIgnoreCase("byte") && !type.equalsIgnoreCase("short") && !type.equalsIgnoreCase(KEY_INT) && !type.equalsIgnoreCase("long") && !type.equalsIgnoreCase("float") && !type.equalsIgnoreCase("double") && !type.equalsIgnoreCase(KEY_VOID);
        return rv;
    }
}

