/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.code.CtrlCodeWriter;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.resource.BizExceptionCollection;
import com.kingdee.util.StringUtils;

public class ControllerCodeWriter
extends CtrlCodeWriter {
    private final String imp1 = "import java.rmi.RemoteException";
    private final String imp2 = "import com.kingdee.bos.framework.ejb.BizController";

    public ControllerCodeWriter(BusinessObjectInfo bo) {
        super(bo);
    }

    @Override
    protected void writePackage() {
        super.writePackage();
        this.out.append("import java.rmi.RemoteException;\n");
        this.out.append("import com.kingdee.bos.framework.ejb.BizController;\n\n");
    }

    @Override
    protected void writeClass() {
        this.out.append("public ");
        this.out.append("interface");
        this.out.append(this.addBlank(this.getClassName()));
        String baseEnName = this.getBaseCtrlfullName();
        this.out.append("extends ");
        if (!StringUtils.isEmpty((String)baseEnName)) {
            this.out.append(this.getClassName(baseEnName));
        } else {
            this.out.append("BizController");
        }
        this.out.append("\n");
    }

    @Override
    protected void addInheritPackageName() {
        if (this.getBaseCtrlfullName().length() != 0) {
            String fullName = this.getBaseCtrlfullName();
            if (fullName.length() == 0) {
                return;
            }
            if (this.needAddNew(this.getPackageName(fullName), fullName)) {
                this.impMap.put("import " + fullName, null);
            }
        }
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en = (EntityObjectInfo)this.bo;
            String info = en.getObjectValueClass();
            if (en.getRootEntity() != null) {
                if (this.needAddNew(this.getPackageName(info), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getRootEntity().getObjectCollectionClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getRootEntity().getObjectValueClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
                if (this.needAddNew(this.getPackageName(info = en.getObjectCollectionClass()), info)) {
                    this.impMap.put("import " + info, null);
                }
            }
        }
    }

    @Override
    protected String getBaseCtrlfullName() {
        FacadeInfo en;
        String name = "";
        if (this.bo instanceof EntityObjectInfo) {
            EntityObjectInfo en2 = (EntityObjectInfo)this.bo;
            if (en2.getBaseEntity() != null) {
                name = en2.getBaseEntity().getBusinessControllerName() == null ? "" : en2.getBaseEntity().getBusinessControllerName();
            }
        } else if (this.bo instanceof FacadeInfo && (en = (FacadeInfo)this.bo).getBaseFacade() != null) {
            name = en.getBaseFacade().getBusinessControllerName() == null ? "" : en.getBaseFacade().getBusinessControllerName();
        }
        return name;
    }

    @Override
    protected String getImpName() {
        return this.getCtrlName();
    }

    private String getCtrlName() {
        return this.bo.getBusinessControllerName() == null ? "" : this.bo.getBusinessControllerName();
    }

    @Override
    public String getClassName() {
        return this.getClassName(this.getCtrlName());
    }

    @Override
    protected void writeParams(ParameterCollection params) {
        this.out.append("Context ctx");
        if (params.size() != 0) {
            this.out.append(",");
        }
        super.writeParams(params);
    }

    @Override
    protected void writeExceptions(BizExceptionCollection bizs) {
        super.writeExceptions(bizs);
        this.out.append(",");
        this.out.append("RemoteException");
    }
}

