/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.code;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.metadata.code.CodeWriterBase;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.util.Assert;
import java.util.Locale;

public class EnumResourceWriter
extends CodeWriterBase {
    private BizEnumInfo bizEnumInfo;
    private Locale locale;
    private Locale defaultLocale;

    public EnumResourceWriter(BizEnumInfo bizEnInfo, Locale defaultLocale) {
        this(bizEnInfo, null, defaultLocale);
    }

    public EnumResourceWriter(BizEnumInfo bizEnInfo, Locale locale, Locale defaultLocale) {
        this.bizEnumInfo = bizEnInfo;
        this.locale = locale;
        Assert.that((defaultLocale != null ? 1 : 0) != 0);
        this.defaultLocale = defaultLocale;
        this.suffix = this.locale == null ? ".properties" : "_" + BOSLocaleUtil.getShortCode(locale) + ".properties";
    }

    @Override
    protected String getClassName() {
        return this.getClassName(this.bizEnumInfo.getClassName());
    }

    private void writeAlias() {
        BizEnumValueCollection enumCol = this.bizEnumInfo.getEnumValue();
        if (enumCol != null) {
            int length = enumCol.size();
            for (int i = 0; i < length; ++i) {
                this.out.append(this.saveConvert(enumCol.get(i).getName(), true));
                this.out.append('=');
                if (this.locale == null) {
                    this.out.append(this.saveConvert(enumCol.get(i).getAlias(), false));
                } else {
                    enumCol.get(i).setDefaultLocale(this.defaultLocale);
                    this.out.append(this.saveConvert(enumCol.get(i).getAlias(this.locale), false));
                }
                this.out.append('\n');
            }
        }
        this.out.append('\n');
    }

    @Override
    public void write(StringBuffer in) {
        this.writeAlias();
    }

    @Override
    public StringBuffer write() {
        this.write(this.out);
        return this.out;
    }
}

